/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int itemCount;
    ToolItem[] items;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = Integer.MAX_VALUE;
        }
        if (hHint == -1) {
            height = Integer.MAX_VALUE;
        }
        int[] result = this.layout(width, height, false);
        Point extent = new Point(result[1], result[2]);
        if (wHint != -1) {
            extent.x = wHint;
        }
        if (hHint != -1) {
            extent.y = hHint;
        }
        return extent;
    }

    void createHandle() {
        this.state |= 0x20;
        super.createHandle(this.parent.handle);
    }

    void createItem(ToolItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.createWidget();
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        if (this.parent.font != null) {
            item.setFontStyle(this.parent.font);
        }
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 108;
    }

    void destroyItem(ToolItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    void drawBackground(int control) {
        this.drawBackground(control, this.background);
    }

    void enableWidget(boolean enabled) {
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            return this.items[index];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point pt) {
        this.checkWidget();
        if (pt == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            Rectangle rect = this.items[i].getBounds();
            if (rect.contains(pt)) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] result = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, this.itemCount);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        return this.layout(rect.width, rect.height, false)[0];
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void invalidateChildrenVisibleRegion(int control) {
        super.invalidateChildrenVisibleRegion(control);
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            item.resetVisibleRegion(control);
            ++i;
        }
    }

    int[] layoutHorizontal(int width, int height, boolean resize) {
        int xSpacing = 0;
        int ySpacing = 2;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxHeight = 0;
        int maxX = 0;
        int rows = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemHeight = 0;
        int i = 0;
        while (i < this.itemCount) {
            Rectangle rect = this.items[i].getBounds();
            itemHeight = Math.max(itemHeight, rect.height);
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            Rectangle rect = item.getBounds();
            if (wrap && i != 0 && x + rect.width > width) {
                ++rows;
                x = marginWidth;
                y += ySpacing + maxHeight;
                maxHeight = 0;
            }
            maxHeight = Math.max(maxHeight, rect.height);
            if (resize) {
                item.setBounds(x, y, rect.width, itemHeight);
            }
            maxX = Math.max(maxX, x += xSpacing + rect.width);
            ++i;
        }
        return new int[]{rows, maxX, y + maxHeight};
    }

    int[] layoutVertical(int width, int height, boolean resize) {
        int xSpacing = 2;
        int ySpacing = 0;
        int marginWidth = 0;
        int marginHeight = 0;
        int x = marginWidth;
        int y = marginHeight;
        int maxWidth = 0;
        int maxY = 0;
        int cols = 1;
        boolean wrap = (this.style & 0x40) != 0;
        int itemWidth = 0;
        int i = 0;
        while (i < this.itemCount) {
            Rectangle rect = this.items[i].getBounds();
            itemWidth = Math.max(itemWidth, rect.width);
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            Rectangle rect = item.getBounds();
            if (wrap && i != 0 && y + rect.height > height) {
                ++cols;
                x += xSpacing + maxWidth;
                y = marginHeight;
                maxWidth = 0;
            }
            maxWidth = Math.max(maxWidth, rect.width);
            if (resize) {
                item.setBounds(x, y, itemWidth, rect.height);
            }
            maxY = Math.max(maxY, y += ySpacing + rect.height);
            ++i;
        }
        return new int[]{cols, x + maxWidth, maxY};
    }

    int[] layout(int nWidth, int nHeight, boolean resize) {
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(nWidth, nHeight, resize);
        }
        return this.layoutHorizontal(nWidth, nHeight, resize);
    }

    void relayout() {
        if (this.drawCount > 0) {
            return;
        }
        Rectangle rect = this.getClientArea();
        this.layout(rect.width, rect.height, true);
    }

    void relayout(int width, int height) {
        if (this.drawCount > 0) {
            return;
        }
        this.layout(width, height, true);
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.itemCount = 0;
        this.items = null;
        super.releaseWidget();
    }

    int setBounds(int control, int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(control, x, y, width, height, move, resize, events);
        if ((result & 0x80) != 0) {
            Rectangle rect = this.getClientArea();
            this.relayout(rect.width, rect.height);
        }
        return result;
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.itemCount) {
            ToolItem item = this.items[i];
            item.setFontStyle(font);
            Point size = item.computeSize();
            item.setSize(size.x, size.y, false);
            ++i;
        }
        this.relayout();
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            this.relayout();
        }
    }
}

