/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JMenuItem.java,v $
   Revision 1.11  2004/03/30 10:42:46  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.10  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.9  2004/01/23 08:05:10  bobintetley
   JComboBox fixes and better Action implementation

   Revision 1.8  2004/01/20 09:17:15  bobintetley
   Menu class overhaul for compatibility, Action support and thread safety

   Revision 1.7  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.6  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

public class JMenuItem extends JSWTMenuComponent implements ButtonModel {
    
    private Shell shell = null;
    
    public JMenuItem() {setModel(this);}
    public JMenuItem(Action a) { setAction(a); setModel(this); }
    public JMenuItem(Icon icon) { this("", icon); }
    public JMenuItem(String text) {this(text, null); }
    public JMenuItem(String text, Icon icon) { pText = text; pImage = icon; setModel(this);}
    public JMenuItem(String text, int mnemonic) { pText = text; setMnemonic(mnemonic); setModel(this);}
    
    public void setAction(Action a) {
        if (a.getValue(Action.ACCELERATOR_KEY) != null) {
            if (a.getValue(Action.ACCELERATOR_KEY) != null)         
                setAccelerator((KeyStroke) a.getValue(Action.ACCELERATOR_KEY));
        }
        super.setAction(a);
    }
    
    public void setSwingWTParent(Menu parent, Shell shell) throws Exception { 
        this.shell = shell;
        peer = new MenuItem(parent, SWT.PUSH);
    }
    
    public boolean isSelected() {
        return false;
    }
    
    public void setSelected(boolean b) {
    }
    
    public Object[] getSelectedObjects() {
        return null;
    }
    
    public boolean isArmed() {
        return false;
    }
    
    public boolean isPressed() {
        return isSelected();
    }
    
    public boolean isRollover() {
        return false;
    }
    
    public void setArmed(boolean b) {
    }
    
    public void setPressed(boolean b) {
    }
    
    public void setRollover(boolean b) {
    }
    
}
