/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JTableHeader.java,v $
   Revision 1.5  2004/04/27 13:44:39  bobintetley
   Fix to build from SwingWT source in makefile and fixes to JTableHeader to allow it

   Revision 1.4  2004/04/16 10:19:07  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.3  2004/01/26 08:11:14  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.2  2003/12/17 10:57:35  bobintetley
   JTableHeader implementation plus Table event/model fixes

   Revision 1.1  2003/12/15 16:40:05  bobintetley
   Core methods + skeleton JTableHeader/JScrollBar support

*/

package swingwtx.swing.table;

import swingwt.awt.Point;
import swingwtx.swing.JTable;

public class JTableHeader extends swingwtx.swing.JComponent {

    protected JTable table = null;
    protected TableColumn resizingColumn = null;

    public JTableHeader(JTable table) { this.table = table; }
    
    public TableColumnModel getColumnModel() { return table.getColumnModel(); }
    public void setColumnModel(TableColumnModel t) { table.setColumnModel(t); }
    public boolean isReorderingAllowed() { return false; }
    public void setReorderingAllowed(boolean b) {}
    public JTable getTable() { return table; }
    public int columnAtPoint(Point point) {
        int x = point.x;
        if (!getComponentOrientation().isLeftToRight()) {
            if (table != null && table.getAutoResizeMode() != swingwtx.swing.JTable.AUTO_RESIZE_OFF) {
                x = table.getWidth() - x;
            }
            else x = super.getWidth() - x;
        }

        return getColumnModel().getColumnIndexAtX(x);
    }
    public TableColumn getResizingColumn() { return resizingColumn; }
    public void setResizingColumn(TableColumn resizingColumn) { this.resizingColumn = resizingColumn; }
}
