/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "tree.h"
# include "abs.h"
# include "interfaces.h"

extern int nelvoip;
extern int nsp;

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | build_octree                                                         |
  |         Construction de l'octree                                     |
  |======================================================================| */
void build_octree (struct node *arbre, int ndim, int npoinr,int nelray,
		   int *nodray,double *cooray, double *size_min,double dim_boite[])

{

    struct element *f1,*f2;
    
  
    int i,npoinr2,nbface;
    double dx,dy,dz;
    double xmin,xmax,ymin,ymax,zmin,zmax;
    
    npoinr2 = 2*npoinr;
    
    

    xmin=dim_boite[0]; xmax=dim_boite[1]; 
    ymin=dim_boite[2]; ymax=dim_boite[3]; 
    zmin=dim_boite[4]; zmax=dim_boite[5]; 
    dx = xmax-xmin; dy=ymax-ymin; dz=zmax-zmin;

    /* arbre->name = 1; */
    arbre->xc = (xmin+xmax)*0.5;
    arbre->yc = (ymin+ymax)*0.5;
    arbre->zc = (zmin+zmax)*0.5;
    arbre->sizx = dx*0.5;    
    arbre->sizy = dy*0.5;    
    arbre->sizz = dz*0.5;    
    arbre->lelement = NULL;
    arbre->lfils = NULL;
    *size_min = min(dx,dy); *size_min = min(*size_min,dz);

    f1 = (struct element *)malloc(sizeof(struct element));
    if (f1==NULL) 
       {printf(" ERREUR build_octree : probleme d'allocation memoire\n");
        exit(0);}
    f1->num = 1;
    f1->suivant=NULL;
    arbre->lelement=f1;
    
    for (i=1;i<nelray;i++)
    {
	f2 = (struct element *)malloc(sizeof(struct element));
	if (f2==NULL) 
	  {printf(" ERREUR build_octree : probleme d'allocation memoire\n");
	   exit(0);}
	f2->num = i+1;
	f2->suivant=NULL;
	f1->suivant = f2;
	f1 = f2;
    }
    nbface = nelray;

    decoupe(arbre,nodray,cooray,nelray,npoinr,nbface,size_min);

    elague_tree(arbre,arbre,8);   

/*    printf("\n\n Arbre apres elaguage\n");
    affiche_tree(arbre,8);   */
      
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | decoupe                                                              |
  |         Construction de l'octree                                     |
  |======================================================================| */
void decoupe(struct node *noeud,int *nodray,double *cooray,
            int nelray,int npoinr,int nbface,double *size_min)
{

    double xmin[8],xmax[8],ymin[8],ymax[8],zmin[8],zmax[8];
    double x,y,z,dx,dy,dz ;
    int i,nbfac,nbelt_max;
    struct node *n1,*n2,*noeudi;
    struct child *f1,*f2;
    struct element *face1;
    
    nbelt_max=max(nelvoip*nsp+10,512);

    if (nbface>nbelt_max)
    {
      
      x = noeud->xc; y = noeud->yc; z = noeud->zc; 
      dx = noeud->sizx; dy = noeud->sizy; dz = noeud->sizz;

      xmax[0]=xmax[3]=xmax[4]=xmax[7]= x;
      xmin[1]=xmin[2]=xmin[5]=xmin[6]= x;
      xmin[0]=xmin[3]=xmin[4]=xmin[7]= x - dx;
      xmax[1]=xmax[2]=xmax[5]=xmax[6]= x + dx;

      ymax[0]=ymax[1]=ymax[2]=ymax[3]= y;
      ymin[4]=ymin[5]=ymin[6]=ymin[7]= y;
      ymin[0]=ymin[1]=ymin[2]=ymin[3]= y - dy;
      ymax[4]=ymax[5]=ymax[6]=ymax[7]= y + dy;

      zmax[2]=zmax[3]=zmax[6]=zmax[7]= z;
      zmin[0]=zmin[1]=zmin[4]=zmin[5]= z;
      zmin[2]=zmin[3]=zmin[6]=zmin[7]= z - dz;
      zmax[0]=zmax[1]=zmax[4]=zmax[5]= z + dz;


      f1= (struct child *)malloc(sizeof(struct child));
      n1= (struct node *) malloc(sizeof(struct node ));
      if (f1==NULL || n1==NULL) 
	{printf(" ERREUR decoupe : probleme d'allocation memoire\n");
	 exit(0);}

      noeud->lfils = f1;
/*      f1->name = (noeud->name)*10 + 1; */
      f1->fils = n1;
      f1->suivant = NULL;

      for (i=1;i<8;i++)
	  {
	      f2= (struct child *)malloc(sizeof(struct child));
	      n2= (struct node *) malloc(sizeof(struct node ));
	      if (f2==NULL || n2==NULL) 
		{printf(" ERREUR decoupe : probleme d'allocation memoire\n");
		 exit(0);}
	      f1->suivant = f2;
/*	      f2->name = (noeud->name)*10 + i+1; */
	      f2->fils = n2;
	      f2->suivant = NULL;
	      f1 = f2;
	  }


      f1 = noeud->lfils;

      for (i=0;i<8;i++)
	  {
	      noeudi = f1->fils;
/*	      noeudi->name =  (noeud->name)*10 + i+1; */
	      noeudi->xc = (xmin[i]+xmax[i])*0.5;
	      noeudi->yc = (ymin[i]+ymax[i])*0.5;
	      noeudi->zc = (zmin[i]+zmax[i])*0.5;
	      noeudi->sizx = (xmax[i]-xmin[i])*0.5;
	      noeudi->sizy = (ymax[i]-ymin[i])*0.5;
	      noeudi->sizz = (zmax[i]-zmin[i])*0.5;
	      *size_min = min(*size_min,noeudi->sizx);
	      *size_min = min(*size_min,noeudi->sizy);
	      *size_min = min(*size_min,noeudi->sizz);
	      noeudi->lfils = NULL;
	      face1= (struct element *)malloc(sizeof(struct element));
	      if (face1==NULL) 
		{printf(" ERREUR decoupe : probleme d'allocation memoire\n");
		 exit(0);}
	      noeudi->lelement = face1;

	      triface(noeud->lelement,noeudi->lelement,
                      &nbfac,nelray,npoinr,nodray,cooray,
		      noeudi->xc,noeudi->yc,noeudi->zc,
		      noeudi->sizx,noeudi->sizy,noeudi->sizz);

              if (nbfac != 0)
		  decoupe(noeudi,nodray,cooray,nelray,npoinr,nbfac,size_min);
	      else
		  {
		       noeudi->lelement = NULL;
		       free(face1);
		  }
	      
	      f1 = f1->suivant;
	  }
		  
    }

}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | triface                                                              |
  |         Tri des faces pour les placer dans l'octree                  |
  |======================================================================| */
void triface( struct element *face_pere, struct element *face_fils, 
              int *nbfac,int nelray,int npoinr,int *nodray,double *cooray,
              double xcc,double ycc,double zcc,double dx,double dy,double dz)
{

    int n,prem ;
    double xa,ya,za,xb,yb,zb,xc,yc,zc;
    struct element *fp1,*ff1,*ff2;

    prem = 1;
    fp1 = face_pere;
    ff1 = face_fils;
    *nbfac = 0;

   do
    {
	 n = *(nodray+fp1->num-1);
	xa = *(cooray+n-1);
	ya = *(cooray+n-1+npoinr);
	za = *(cooray+n-1+npoinr*2);

	 n = *(nodray+fp1->num-1+nelray);
	xb = *(cooray+n-1);
	yb = *(cooray+n-1+npoinr);
	zb = *(cooray+n-1+npoinr*2);

	 n = *(nodray+fp1->num-1+nelray*2);
	xc = *(cooray+n-1);
	yc = *(cooray+n-1+npoinr);
	zc = *(cooray+n-1+npoinr*2);

	if (tria_in_cube(xa,ya,za,xb,yb,zb,xc,yc,zc,xcc,ycc,zcc,dx,dy,dz))
	    {
                if (prem)
		    {
			prem = 0;
			ff1->num = fp1->num;
			ff1->suivant = NULL;
		    }
		else
		    {
			ff2= (struct element *)malloc(sizeof(struct element));
			if (ff2==NULL) 
			  {printf(" ERREUR triface : probleme d'allocation memoire\n");
			   exit(0);}
			ff2->num = fp1->num;
			ff2->suivant = NULL;
			ff1->suivant = ff2;
			ff1 = ff2;
		    }
		*nbfac += 1;

	    }

	fp1 = fp1->suivant;

    }while (fp1 != NULL);

   
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | tria_in_cube                                                         |
  |         Tri des faces pour les placer dans l'octree                  |
  |======================================================================| */
int tria_in_cube(double xa,double ya,double za,double xb,double yb,double zb,
		 double xc,double yc,double zc,
		 double xcc,double ycc,double zcc,double dx,double dy,double dz)
{

    double xmin,xmax,ymin,ymax,zmin,zmax;
    double ta,tb,tc,td,xab,yab,zab,xac,yac,zac,xp,yp,zp;
    double epsi,dxy,dxz,dyz,d3,t;

    epsi=1.E-5;
    dxy= dx+dy; dxz=dx+dz; dyz=dy+dz;
    d3=dxy+dz;

    xmin = xcc-dx-epsi; xmax = xcc+dx+epsi;
    ymin = ycc-dy-epsi; ymax = ycc+dy+epsi;
    zmin = zcc-dz-epsi; zmax = zcc+dz+epsi;


    if (in_boite (xa,ya,za,xmin,xmax,ymin,ymax,zmin,zmax))
	return(1);
    else if (in_boite (xb,yb,zb,xmin,xmax,ymin,ymax,zmin,zmax))
	return(1);
    else if (in_boite (xc,yc,zc,xmin,xmax,ymin,ymax,zmin,zmax))
	return(1);


    /* tous les points sont du meme cote d'un plan ==> pas intersection */
    else if (xa>xmax && xb>xmax && xc>xmax)
	return(0);
    else if (xa<xmin && xb<xmin && xc<xmin)
	return(0);
    else if (ya>ymax && yb>ymax && yc>ymax)
	return(0);
    else if (ya<ymin && yb<ymin && yc<ymin)
	return(0);
    else if (za>zmax && zb>zmax && zc>zmax)
	return(0);
    else if (za<zmin && zb<zmin && zc<zmin)
	return(0);

    else
      {
	xa -= xcc; ya -= ycc; za -= zcc;
	xb -= xcc; yb -= ycc; zb -= zcc;
	xc -= xcc; yc -= ycc; zc -= zcc;

	if (xa-za<-dxz && xb-zb<-dxz && xc-zc<-dxz)
	    return(0);
	else if (xa-za>dxz  && xb-zb>dxz  && xc-zc>dxz)
	    return(0);
	else if (xa+za<-dxz && xb+zb<-dxz && xc+zc<-dxz)
	    return(0);
	else if (xa+za>dxz  && xb+zb>dxz  && xc+zc>dxz)
	    return(0);
	else if (ya-za<-dyz && yb-zb<-dyz && yc-zc<-dyz)
	    return(0);
	else if (ya-za>dyz  && yb-zb>dyz  && yc-zc>dyz)
	    return(0);
	else if (ya+za<-dyz && yb+zb<-dyz && yc+zc<-dyz)
	    return(0);
	else if (ya+za>dyz  && yb+zb>dyz  && yc+zc>dyz)
	    return(0);
	else if (xa-ya<-dxy && xb-yb<-dxy && xc-yc<-dxy)
	    return(0);
	else if (xa-ya>dxy  && xb-yb>dxy  && xc-yc>dxy)
	    return(0);
	else if (xa+ya<-dxy && xb+yb<-dxy && xc+yc<-dxy)
	    return(0);
	else if (xa+ya>dxy  && xb+yb>dxy  && xc+yc>dxy)
	    return(0);


	else if ( xa+ya-za>d3 &&  xb+yb-zb>d3 &&  xc+yc-zc>d3)
	    return(0);
	else if (-xa+ya-za>d3 && -xb+yb-zb>d3 && -xc+yc-zc>d3)
	    return(0);
	else if (-xa+ya+za>d3 && -xb+yb+zb>d3 && -xc+yc+zc>d3)
	    return(0);
	else if ( xa+ya+za>d3 &&  xb+yb+zb>d3 &&  xc+yc+zc>d3)
	    return(0);
	else if ( xa-ya-za>d3 &&  xb-yb-zb>d3 &&  xc-yc-zc>d3)
	    return(0);
	else if (-xa-ya-za>d3 && -xb-yb-zb>d3 && -xc-yc-zc>d3)
	    return(0);
	else if (-xa-ya+za>d3 && -xb-yb+zb>d3 && -xc-yc+zc>d3)
	    return(0);
	else if ( xa-ya+za>d3 &&  xb-yb+zb>d3 &&  xc-yc+zc>d3)
	    return(0);


	else if (seg_cubex( dx,dy,dz,xa,xb,ya,yb,za,zb))
	    return(1);
	else if (seg_cubex(-dx,dy,dz,xa,xb,ya,yb,za,zb))
	    return(1);
	else if (seg_cubey(dx, dy,dz,xa,xb,ya,yb,za,zb))
 	    return(1);
	else if (seg_cubey(dx,-dy,dz,xa,xb,ya,yb,za,zb))
	    return(1);
	else if (seg_cubez(dx,dy, dz,xa,xb,ya,yb,za,zb))
	    return(1);
	else if (seg_cubez(dx,dy,-dz,xa,xb,ya,yb,za,zb))
	    return(1);
		 
	else if (seg_cubex( dx,dy,dz,xb,xc,yb,yc,zb,zc))
	    return(1);
	else if (seg_cubex(-dx,dy,dz,xb,xc,yb,yc,zb,zc))
	    return(1);
	else if (seg_cubey(dx, dy,dz,xb,xc,yb,yc,zb,zc))
	    return(1);
	else if (seg_cubey(dx,-dy,dz,xb,xc,yb,yc,zb,zc))
	    return(1);
	else if (seg_cubez(dx,dy, dz,xb,xc,yb,yc,zb,zc))
	    return(1);
	else if (seg_cubez(dx,dy,-dz,xb,xc,yb,yc,zb,zc))
	    return(1);

	else if (seg_cubex( dx,dy,dz,xa,xc,ya,yc,za,zc))
	    return(1);
	else if (seg_cubex(-dx,dy,dz,xa,xc,ya,yc,za,zc))
	    return(1);
	else if (seg_cubey(dx, dy,dz,xa,xc,ya,yc,za,zc))
	    return(1);
	else if (seg_cubey(dx,-dy,dz,xa,xc,ya,yc,za,zc))
	    return(1);
	else if (seg_cubez(dx,dy, dz,xa,xc,ya,yc,za,zc))
	    return(1);
	else if (seg_cubez(dx,dy,-dz,xa,xc,ya,yc,za,zc))
	    return(1);
	
	else
	  {
	    xab=xb-xa; yab=yb-ya; zab=zb-za;
	    xac=xc-xa; yac=yc-ya; zac=zc-za;
	    ta = yab*zac-zab*yac;
	    tb = zab*xac-xab*zac;
	    tc = xab*yac-yab*xac;
	    td = -(ta*xa+tb*ya+tc*za);

	    if (diag_tria(ta,tb,tc,td,dx,dy,dz,&t))
	      {
		xp=t*dx; yp=t*dy; zp=t*dz;
		if (in_triangle(ta,tb,tc,td,xa,ya,za,xab,yab,zab,xac,yac,zac,xp,yp,zp))
		  return(1);
	      }
	    if (diag_tria(ta,tb,tc,td,dx,dy,-dz,&t))
	      {
		xp=t*dx; yp=t*dy; zp=-t*dz;
		if (in_triangle(ta,tb,tc,td,xa,ya,za,xab,yab,zab,xac,yac,zac,xp,yp,zp))
		  return(1);
	      }
	    if (diag_tria(ta,tb,tc,td,-dx,dy,dz,&t))
	      {
		xp=-t*dx; yp=t*dy; zp=t*dz;
		if (in_triangle(ta,tb,tc,td,xa,ya,za,xab,yab,zab,xac,yac,zac,xp,yp,zp))
		  return(1);
	      }
	    if (diag_tria(ta,tb,tc,td,-dx,dy,-dz,&t))
	      {
		xp=-t*dx; yp=t*dy; zp=-t*dz;
		if (in_triangle(ta,tb,tc,td,xa,ya,za,xab,yab,zab,xac,yac,zac,xp,yp,zp))
		  return(1);
	      }
	  }
      }

      return(0);
}


