/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "tree.h"
# include "abs.h"
# include "interfaces.h"

                     
int ss_seg[2][2] = { {0,2},
	             {2,1} };
int nsp;
double taille_boite,taille_seg; 

/* extern int nsp; */ /* variable globale (non xterne) definie dans calfdf_3d.c */
/* extern double taille_boite,taille_seg; */ /* idem */


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | cfdf2d                                                               |
  |         Gestion du calcul des facteurs de forme en dimension 2       |
  |======================================================================| */

proc(void cfdf2d,void CFDF2D) 
             (int *ndim,int *nelray,int *npoinr,int *nodray,
              double *cooray,double *sufray,double *fdf,
              int *nplasy,double *plasym,
	      int *nperay,double *perray,int *ndecoup_max,
	      int *nrfray,double *pvinter,int *numgu,int *ngumax,int *nblblr)

{
      
    int i,n2;
    int faces_cachees ;
    double Pi ;
    int *nod2,nel2,npoin2;
    double *coo2,*xnf2,xmult,*xnfray;
    int *grconv, *grconv2;
    int imult;

    dimension_2d(*ndim,*nelray,*npoinr,nodray,cooray,
		 &taille_boite,&taille_seg);

    imult = 0;
    xmult = 1.;
    if(taille_seg < 0.01 || taille_seg > 10)
      {
        imult = 1;
	if (taille_seg < 0.01) xmult = 0.1/taille_seg;
	if (taille_seg > 10  ) xmult =   1/taille_seg;
        if(*nblblr >= 10) printf("Facteur multiplicatif interne xmult= %f \n",xmult);
	for (i=0;i< *npoinr* *ndim ;i++) *(cooray+i) *=  xmult ;
        taille_boite *= xmult;
        taille_seg   *= xmult;
        for(i=0;i<3**ngumax;i++) *(pvinter+i)*=xmult;
        for(i=0;i<3;i++) *(perray+i)*=xmult;
	for(i=0;i<*nplasy;i++) plasym[i*4+2]*=xmult;
      }




    grconv = (int *)malloc( *nelray * sizeof(int) );
    if (grconv==NULL) 
      {printf(" ERREUR cfdf2d : probleme d'allocation memoire\n");
       exit(0);}
    orie2d(nodray,*nelray,*npoinr,nrfray,cooray,pvinter,*numgu,*ndim,*nblblr,
	   grconv);
     
    Pi = 3.141592653589793;  
    
    surface_seg (*nelray,*npoinr,nodray,cooray,sufray);
    
    xnfray=(double*)malloc(*nelray * 2 * sizeof(double));
    if (xnfray==NULL) 
      {printf(" ERREUR cfdf2d : probleme d'allocation memoire\n");
       exit(0);}
    cnor_2d(*ndim,*nelray,*npoinr,nodray,cooray,xnfray);

     
    if (*nplasy != 0 && *nperay == 0) 
      {
	n2=1;
	if (*nplasy==1){n2=2;}
	else if (*nplasy==2){n2=4;}
        /* n2=(int)(pow(2.,*nplasy)+0.1);*/
	nod2=(int*)malloc(n2 * *nelray * 2 * sizeof(int));
	coo2=(double*)malloc(n2 * *npoinr * 2 * sizeof(double));
	xnf2=(double*)malloc(n2 * *nelray * 2 * sizeof(double));
	grconv2=(int*)malloc(n2 * *nelray * sizeof(int));
	if (n2==0 || nod2==NULL || coo2==NULL || xnf2==NULL || grconv2==NULL ) 
	  {printf(" ERREUR cfdf2d : probleme d'allocation memoire\n");
	   exit(0);}
        dupliq2d_sym(*nplasy,plasym,
		     *npoinr,*nelray,nodray,cooray,xnfray,
		     &nel2,&npoin2,nod2,coo2,xnf2,grconv,grconv2);    
        
      }
    else if (*nperay > 0)
      {
	n2=1;
	if (*nplasy==0){n2=*nperay;}
	else if (*nplasy==1){n2=*nperay*2;}
	else if (*nplasy==2){n2=*nperay*4;}
        /* n2=(int)(*nperay*pow(2.,*nplasy)+0.1); */
	nod2=(int*)malloc(n2 * *nelray * 2 * sizeof(int));
	coo2=(double*)malloc(n2 * *npoinr * 2 * sizeof(double));
	xnf2=(double*)malloc(n2 * *nelray * 2 * sizeof(double));
	grconv2=(int*)malloc(n2 * *nelray * sizeof(int));
	if (n2==0 || nod2==NULL || coo2==NULL || xnf2==NULL || grconv2==NULL ) 
	  {printf(" ERREUR cfdf2d : probleme d'allocation memoire\n");
	   exit(0);}
        dupliq2d_per(*nplasy,plasym,*nperay,perray,
		     *npoinr,*nelray,nodray,cooray,xnfray,
		     &nel2,&npoin2,nod2,coo2,xnf2,grconv,grconv2);    
      }

    if ( *nperay == 0 )
      {
	if (*nplasy==0) nsp=1; 
	else if (*nplasy==1) nsp=2;
	else if (*nplasy==2) nsp=4;
      }
    else
      {
	if (*nplasy==0) nsp=*nperay; 
	else if (*nplasy==1) nsp=*nperay*2;
	else if (*nplasy==2) nsp=*nperay*4;
      }

    if (*nplasy == 0 && *nperay == 0) 
      facecache_2d(*ndim,*npoinr,*nelray,*nelray,nodray,cooray,xnfray,&faces_cachees,
		   *nplasy,*nperay) ;
    else
      facecache_2d(*ndim,npoin2,nel2,*nelray,nod2,coo2,xnf2,&faces_cachees,
		   *nplasy,*nperay) ;


    if (*nplasy == 0 && *nperay == 0)
      {
	coo2=(double*)malloc(*npoinr * 2 * sizeof(double));
	if (coo2==NULL) 
	  {printf(" ERREUR cfdf2d : probleme d'allocation memoire\n");
	   exit(0);}
	for (i=0;i<*npoinr;i++)
	  {
	    *(coo2+i)           = *(cooray+i);
	    *(coo2+i+*npoinr)   = *(cooray+i+*npoinr);
	  }
      }
    
    if (faces_cachees)
      {
	if (*nplasy == 0 && *nperay == 0) 
	  {
	    box_2d(*npoinr,coo2); 
	    cnor_2d(*ndim,*nelray,*npoinr,nodray,coo2,xnfray); 
	  }
	else
	  {
	  box_2d(npoin2,coo2);  
	  cnor_2d(*ndim,nel2,npoin2,nod2,coo2,xnf2); 
	}
      }
	   

    if (*nplasy == 0 && *nperay == 0) 
      if (!faces_cachees)
	facforme_2d(*ndim,*npoinr,*nelray,*nelray,nodray,cooray,xnfray,fdf,sufray,
		    &faces_cachees,*nplasy,*nperay,*ndecoup_max,grconv,*nblblr);
      else
	facforme_2d(*ndim,*npoinr,*nelray,*nelray,nodray,coo2,xnfray,fdf,sufray,
		    &faces_cachees,*nplasy,*nperay,*ndecoup_max,grconv,*nblblr);
    else
        facforme_2d(*ndim,npoin2,nel2,*nelray,nod2,coo2,xnf2,fdf,sufray,
		    &faces_cachees,*nplasy,*nperay,*ndecoup_max,grconv2,*nblblr);
    
    
    free(xnfray);free(grconv);
    if (*nplasy != 0 || *nperay != 0) {free(coo2); free(nod2); free(xnf2);free(grconv2); }
    if (*nplasy == 0 && *nperay == 0 && faces_cachees) {free(coo2); }
    
    if(imult)
      {
	for (i=0;i< *npoinr* *ndim ;i++) *(cooray+i) /=  xmult ;
	for (i=0;i< *nelray ;i++) *(sufray+i) /=  xmult;
	for (i=0 ; i<*nelray*(*nelray+1)/2 ; i++ ) *(fdf+i) /=  xmult;
      }
    
}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | facforme_2d                                                          |
  |           calcul des facteurs de forme en dimension 2                |
  |======================================================================| */

void facforme_2d(int ndim, int npoin,int nel2,int nel,
		 int *nod,double *coord,double *xnf,double *fdf,double *sufray,
		 int *faces_cachees,int nplasy,int nperay,int ndecoup_max, 
		 int *grconv, int nblblr)
{
    
    int i,j,k,npoin2,ns,ideb;
    int noeud[6],prem,ndecoup;
    int *voir;
    int codem10,code0,code1,codem1,code2,codem2,codem6;
    int nbfcoplanaire,code_decoupe;
    double xi[4],yi[4],fforme,*pland;
    double xn1,yn1,x,y,size_min,dim_boite[4],dsign[4];
    double Pi;
    struct node *arbre;
    double titi1, titi2;
    int ncomplique;
    double total_fac,pourcent,pourcent_ecrit;


    /* Initialisations 
       --------------- */

    Pi = 3.141592653589793;  
    npoin2 = npoin*2;
    nbfcoplanaire = 0 ;
    codem10  = 0;    code0    = 0;
    code1    = 0;    codem1   = 0;
    code2    = 0;    codem2   = 0;
    codem6   = 0;
    ncomplique = 0;

    pland = (double*)malloc( nel2 * sizeof(double));
    if (pland==NULL) 
      {printf(" ERREUR facforme_2d : probleme d'allocation memoire\n");
       exit(0);}
    for (i=0 ; i<nel2 ; i++)
       {
          xn1 = xnf[i];
          yn1 = xnf[i+ nel2];
          x  = coord[nod[i]-1];
          y  = coord[nod[i]-1+npoin];
          pland[i]=-x*xn1-y*yn1;
        }

    for (i=0 ; i<nel*(nel+1)/2 ; i++ ) *(fdf+i) = 0.; 

    if (*faces_cachees)
	{ 
            voir = (int *)malloc((npoin+1)*npoin/2*(sizeof(int))); 
	    if (voir==NULL) 
	      {printf(" ERREUR facforme_2d : probleme d'allocation memoire\n");
	       exit(0);}
	    for (i=0 ; i<npoin*(npoin+1)/2 ; i++ ) *(voir+i) = -1 ; 
	    for (i=0 ; i<npoin ; i++) voir[i*npoin-i*(i+1)/2+i]=0; 

	    size_min = 1.E8;
	    arbre= (struct node *)malloc(sizeof(struct node));
	    if (arbre==NULL) 
	      {printf(" ERREUR facforme_2d : probleme d'allocation memoire\n");
	       exit(0);}
	    build_quadtree_1d (arbre,ndim,npoin,nel2,nod,coord,&size_min,dim_boite);
	}
	    
    titi1 =0;
    titi2 =0;
    ideb = -nel;
    total_fac=nsp*nel;
    pourcent_ecrit=0.1;

    for (ns=0 ; ns < nsp ; ns++ ) 
      {
	ideb += nel;

	for (i=0 ; i<nel ; i++ )
	
	  {
            if(nblblr >=10) printf(" *** FACFORME_2D : ns=%d   facette i=%d \n",ns+1,i+1);
            pourcent=(ns+1)*i/total_fac;
            if (pourcent>pourcent_ecrit)
	      {
		printf("                    %5.2f %% du calcul effectue\n",pourcent_ecrit*100);
		pourcent_ecrit += 0.1;
	      }
	    xn1 = xnf[i];
	    yn1 = xnf[i+ nel2];
	    noeud[0] = nod[i];
	    noeud[1] = nod[i+ nel2];

 	    for  (j=ideb+i ; j<ideb+nel ; j++ )  
 	      {
		if (grconv[i]!=grconv[j]) continue;

		fforme = coplanaire_2d(xn1,yn1,xnf[j],xnf[j+nel2]);
		if (fforme>-0.1)
		  {
		    nbfcoplanaire += 1;
		    /*   printf(" >>> calfdf : %d %d sont coplanaires fforme= %f \n",i+1,j+1,fforme);*/ 
		  }
	    if (fforme<-1.)  
		{
	         noeud[2] = nod[j];
	         noeud[3] = nod[j+ nel2];

	         for (k=0;k<4;k++)
		   { 
		     xi[k] = coord[noeud[k]-1];
		     yi[k] = coord[noeud[k]-1+ npoin];
		   }
		 fforme=0.;
		 
		 if (!*faces_cachees)	
		   proc(cont2d,CONT2D)(xi,yi,&fforme);

		 else
		   {
		     derriere_2d(nel2,i,j,xnf,pland,xi,yi,dsign,&code_decoupe) ;  
		     prem=1; fforme=0; ndecoup=0;
		     
		     if (code_decoupe == -10)    /* les faces sont derrieres */  
		       { 
			 codem10 += 1;
			 fforme = 0;
		       } 
		     else if (code_decoupe == 0)       /* les faces se voient potentiellement */  
		       { 
			 code0   += 1;
 			 segfdf (arbre,size_min,dim_boite,&prem,xi,yi,
		         	 noeud,voir,nel2,npoin,nod,coord,
				 &ndecoup,&fforme,&ncomplique,ndecoup_max); 
		       } 
		     
		     else if (abs(code_decoupe) == 1 || abs(code_decoupe)==2 ) 
		       { 
			 if (code_decoupe==1)       code1   += 1;
			 else if(code_decoupe==-1)  codem1  += 1;
			 else if(code_decoupe==2 )  code2   += 1;
			 else                       codem2  += 1;

			 decoupe_seg(nel2,i,j,xnf,pland,xi,yi,dsign,code_decoupe);
			 segfdf (arbre,size_min,dim_boite,&prem,xi,yi,
				 noeud,voir,nel2,npoin,nod,coord,
				 &ndecoup,&fforme,&ncomplique,ndecoup_max);  
		       } 
		     
		     else if ( code_decoupe == -6 )   { codem6  += 1;}

		   } /* else faces_cachees */

	       } /* if (fforme<-1.)  les faces ne sont pas coplanaires  */

		     
		if(fforme < 0.) 
		  {
		    if (nblblr >= 11)
		      printf(" fforme negatif ns%d i %d j %d  fdf= %f\n",ns,i+1,j+1,1e6*fforme);
		  }
		else
		  fdf[i*nel-(i+1)*i/2+j%nel] += fforme; 

		/*  printf("i+1,j+1 %d  %d fdf %f\n",i+1,j+1,fforme*1.e6); */
		titi1 += fforme;



	      }  /* for  (j=ideb+i ; j<ideb+nel ; j++ ) */
      
	  } /*  for (i=0 ; i<nel ; i++ )  */

      } /*  for (ns=0 ; ns<2^nplasy ; ns++ )  */


    /* liberation de l'espace memoire */  
    if (*faces_cachees) 
	{
	    free(voir);
	    tuer_tree(arbre,4);
	}
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | dupliq2d_sym                                                         |
  |          Dupliquer le maillage pour le traitement des symtries       |
  |======================================================================| */

void dupliq2d_sym(int nplasy,double *plasym,
		  int npoinr,int nelray,int *nodray,
		  double *cooray,double *xnfray,
		  int *nel2,int *npoin2,int *nod2,double *coo2,double *xnf2,
		  int *grconv, int *grconv2)


{
	
    int i,j,i1,i2,idebnel,idebnp,numsym,inverse;
    double a,b,c,d,t[3][3],t1[3][3],t2[3][3];


    if (nplasy==1)
      {
	*nel2=2*nelray;
	*npoin2=2*npoinr;
      }
    else if (nplasy==2)
      {
	*nel2=4*nelray;
	*npoin2=4*npoinr;     
      }
    else
      {
	printf("en 2D, 3 plans de symetrie sont impossibles\n");
	exit(0);
      }
	

    for (i=0;i<nelray;i++)
    {
        *(nod2+i)         = *(nodray+i);
        *(nod2+i+*nel2)   = *(nodray+i+nelray);
        *(xnf2+i)         = *(xnfray+i);
        *(xnf2+i+*nel2)   = *(xnfray+i+nelray);

	*(grconv2+i)      = *(grconv+i);
    }

    for (i=0;i<npoinr;i++)
    {
       *(coo2+i)           = *(cooray+i);
       *(coo2+i+*npoin2)   = *(cooray+i+npoinr);
    }

    
    numsym=0;

    for (i=0;i<nplasy;i++)
      {
        a=plasym[i*4];
	b=plasym[i*4+1];
        c=plasym[i*4+2];
	d=-2./(a*a+b*b);
	t[0][0] = 1.+ a*a*d;
	t[1][1] = 1.+ b*b*d;
	t[0][1] = t[1][0] = a*b*d;
	t[0][2] = a*c*d;
	t[1][2] = b*c*d;
	t[2][0]=t[2][1]=0; t[2][2]=1;
	
	for (j=i;j<nplasy;j++)
	  {
	    inverse = -1;
	    if (i!=j)
	      {
		inverse = 1;
		a=plasym[j*4];
		b=plasym[j*4+1];
		c=plasym[j*4+2];
		d=-2./(a*a+b*b);
		t1[0][0] = 1.+ a*a*d;
		t1[1][1] = 1.+ b*b*d;
		t1[0][1] = t1[1][0] = a*b*d;
		t1[0][2] = a*c*d;
		t1[1][2] = b*c*d;
		t1[2][0]=t1[2][1]=0; t1[2][2]=1;
		
		t2[0][0]= t[0][0]*t1[0][0]+t[0][1]*t1[1][0]+t[0][2]*t1[2][0];
		t2[0][1]= t[0][0]*t1[0][1]+t[0][1]*t1[1][1]+t[0][2]*t1[2][1];
		t2[0][2]= t[0][0]*t1[0][2]+t[0][1]*t1[1][2]+t[0][2]*t1[2][2];

		t2[1][1]= t[1][0]*t1[0][1]+t[1][1]*t1[1][1]+t[1][2]*t1[2][1];
		t2[1][2]= t[1][0]*t1[0][2]+t[1][1]*t1[1][2]+t[1][2]*t1[2][2];;

		t2[2][2]= t[2][0]*t1[0][2]+t[2][1]*t1[1][2]+t[2][2]*t1[2][2];

		t2[1][0]=t2[0][1];
		t2[2][0]=t2[0][2]; t2[2][1]=t2[1][2];
	      }
	    else
	      for (i1=0;i1<3;i1++)
		for (i2=0;i2<3;i2++)
		  t2[i1][i2]=t[i1][i2];

	    numsym +=1;
	    idebnel = numsym*nelray;	
	    idebnp  = numsym*npoinr;  
	    sym2d(t2,numsym,inverse,npoinr,nelray,nodray,cooray,xnfray,
		  *nel2,*npoin2,nod2,coo2,xnf2,idebnel,idebnp,grconv,grconv2);

	  }
      }


    
    /* impressions de controle */
    /* printf(" coordonnees\n ");	    
        for (n=0;n<*npoin2;n++) 
         printf(" point %d : %f %f %f \n",n,
		coo2[n],coo2[n+ *npoin2]);
    
        printf(" normale \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %f %f %f \n",n,
		xnf2[n],xnf2[n+ *nel2]);
    
        printf(" connectivite \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %d %d %d \n",n,
		nod2[n],nod2[n+ *nel2]);  */
	
}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | sym2d                                                                |
  |          Calculer le symetrique d'un maillage                        |
  |======================================================================| */
void sym2d(double t[3][3],int numsym,int inverse,
	   int npoinr,int nelray,int *nodray,double *cooray,double *xnfray,
	   int nel2,int npoin2,int *nod2,double *coo2,double *xnf2,
	   int idebnel,int idebnp, int *grconv, int *grconv2)
{
  int n;
  double x,y;
      

  for (n=0;n<nelray;n++)
    {
      x  = xnfray[n];
      y  = xnfray[n+ nelray];
      xnf2[idebnel+n]        = t[0][0]*x+t[0][1]*y;
      xnf2[idebnel+n+nel2]   = t[1][0]*x+t[1][1]*y;

      grconv2[idebnel+n]     = grconv[n];
    }  


  if (inverse==-1)
    for (n=0;n<nelray;n++)
      {
	nod2[idebnel+n]      = nodray[n+nelray]   + numsym*npoinr;
	nod2[idebnel+n+nel2] = nodray[n]          + numsym*npoinr; 
      }
  else
    for (n=0;n<nelray;n++)
      {
	nod2[idebnel+n]       = nodray[n] + numsym*npoinr; 
	nod2[idebnel+n+nel2]  = nodray[n+nelray]   + numsym*npoinr;
      }


  for (n=0;n<npoinr;n++)
    {	
      x  = cooray[n];
      y  = cooray[n+ npoinr];
      coo2[idebnp+n]           = t[0][0]*x+t[0][1]*y + t[0][2]; 
      coo2[idebnp+n+ npoin2]   = t[1][0]*x+t[1][1]*y + t[1][2]; 
    } 
}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | surface_seg                                                          |
  |           calcul de la longueur des segments                         |
  |======================================================================| */

void surface_seg (int nel,int npoin,int *nod,double *coord,double *sufray)

{
    int i,noeud[2];
    double x01,y01;
    double xi[2],yi[2];
    

    for (i=0 ; i<nel ; i++ )   
    {
       noeud[0] = nod[i];
       noeud[1] = nod[i+ nel];

       xi[0] = coord[noeud[0]-1];
       yi[0] = coord[noeud[0]-1+ npoin];
       xi[1] = coord[noeud[1]-1];
       yi[1] = coord[noeud[1]-1+ npoin];

       x01 = xi[1]-xi[0];
       y01 = yi[1]-yi[0];
       sufray[i] = sqrt (x01*x01+y01*y01 );
   }
}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | coplanaire_2d                                                        |
  |           retourne 0 si les faces sont coplanaires, -1000 sinon      |
  |======================================================================| */

double coplanaire_2d (double xn1,double yn1,double xn2,double yn2)
{
    double dnx,dny,xn,epscop;
    
    epscop = 1.E-3;
    dnx = xn1 - xn2;
    dny = yn1 - yn2;

    xn = sqrt(dnx*dnx + dny*dny);
	
    if (xn<epscop) 
	return(0);
    else if ( abs(dnx)<epscop && abs(dny)<epscop)
	return(0);
    else
	return(-1000);
}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | segfdf                                                               |
  |        organisation du calcul du facteur de forme entre 2 segments   |
  |======================================================================| */

void segfdf (struct node *arbre,double size_min,double dim_boite[],int *prem,
	      double xi[],double yi[],
	      int noeud[],int voir[],int nel2,int npoin,int *nod, double *coord,
	      int *ndecoup,double *fforme,int *ncomplique,int ndecoup_max)
 
{

    int i,ok,k,l,ik,il,ii,intersect,arrivee,nd;
    double xp[4],yp[4],xq[4],yq[4],ro[2],rd[2],pt_arr[2],fdf,epsff;
    struct node *noeud_dep,*noeud_arr;


    epsff=1.E-10;
    ok=0; 
    i=-1;

    /* 1- tester si tous les points se voient 
       -------------------------------------- */
    if (*prem)
      {
	*prem=0;
	for (k=0;k<2;k++)
	  for (l=2;l<4;l++)
	    {
	      ik = noeud[k]-1;  il = noeud[l]-1;
              if (il<ik) {ii=ik; ik=il; il=ii;}

	      if (voir[indvoir(ik,il,npoin)]<0)
		{
		  intersect=0;  
		  ro[0]=xi[k]; ro[1]=yi[k];
		  pt_arr[0]=xi[l];pt_arr[1]=yi[l];
		  rd[0]=pt_arr[0]-ro[0];  rd[1]=pt_arr[1]-ro[1];
		  noeud_dep=arbre; noeud_arr=arbre;
		  find_node_2d (&noeud_dep,ro[0],ro[1]);
		  find_node_2d (&noeud_arr,pt_arr[0],pt_arr[1]);
		  arrivee = 0;
		  ivoitj_2d(arbre,noeud_dep,noeud_arr,ro,rd,pt_arr,
			    &intersect,size_min,
			    nel2,npoin,nod,coord,&arrivee,dim_boite);
		  voir[indvoir(ik,il,npoin)] = intersect;
		}
	      else
		intersect=voir[indvoir(ik,il,npoin)];
	      if (!intersect) ok += 1;
	    }
      }
  
    
    else

      for (k=0;k<2;k++)
	for (l=2;l<4;l++) 
	  {
	    intersect=0;  
	    ro[0]=xi[k]; ro[1]=yi[k];
	    pt_arr[0]=xi[l];pt_arr[1]=yi[l]; 
	    rd[0]=pt_arr[0]-ro[0];  rd[1]=pt_arr[1]-ro[1];
	    noeud_dep=arbre; noeud_arr=arbre;
	    find_node_2d (&noeud_dep,ro[0],ro[1]);
	    find_node_2d (&noeud_arr,pt_arr[0],pt_arr[1]);
	    arrivee = 0;

	    /* printf(" \n noeud depart %d noeud arrivee %d\n",noeud_dep->name,noeud_arr->name); */
	    ivoitj_2d(arbre,noeud_dep,noeud_arr,ro,rd,pt_arr,
		      &intersect,size_min,
		      nel2,npoin,nod,coord,&arrivee,dim_boite);
	    /* printf(">>> calfdf k l %d %d inter %d\n",k,l,intersect); */
	    if (!intersect) ok += 1;
	  }
	  

    /* 2- En fonction du resultat 
       -------------------------- */

    /* si ok=0 => faces non visibles, on ne rajoute rien a fforme */
    if ( 0 < ok && ok < 4 ) *ncomplique += 1;
 
    /* printf(">> facforme_2d : ok final =%d\n",ok);  */
    if (ok!=0)
      {
	proc(cont2d,CONT2D)(xi,yi,&fdf); 
	/* printf(">> facforme_2d : estimation fdf =%f\n",fdf*1.E6);  */


	if (ok==4)
	  {*fforme += fdf; }

	else if (*ndecoup>=ndecoup_max)
	    {  *fforme = *fforme + (fdf*ok/4.);
	    }

	else
	  {
	    nd=*ndecoup+1;
	    xp[0]=xi[0]; yp[0]=yi[0];
	    xp[1]=xi[1]; yp[1]=yi[1];
	    xp[2]=(xi[0]+xi[1])/2 ; yp[2]=(yi[0]+yi[1])/2.;
	    
	    xq[0]=xi[2]; yq[0]=yi[2]; 
	    xq[1]=xi[3]; yq[1]=yi[3];
	    xq[2]=(xi[2]+xi[3])/2 ; yq[2]=(yi[2]+yi[3])/2.;
	    
	    for (k=0;k<2;k++)
	      for (l=0;l<2;l++)
		{
		  xi[0]=xp[ss_seg[k][0]]; yi[0]=yp[ss_seg[k][0]];
		  xi[1]=xp[ss_seg[k][1]]; yi[1]=yp[ss_seg[k][1]];
		  xi[2]=xq[ss_seg[l][0]]; yi[2]=yq[ss_seg[l][0]];
		  xi[3]=xq[ss_seg[l][1]]; yi[3]=yq[ss_seg[l][1]];
		  segfdf (arbre,size_min,dim_boite,prem,xi,yi,
			   noeud,voir,nel2,npoin,nod,coord,
			   &nd,fforme,ncomplique,ndecoup_max); 
		}
	    (*ndecoup)++;
	  }
      }        


	    

}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | dupliq2d_per                                                         |
  |          Dupliquer le maillage pour le traitement de la periodicite  |
  |          avec eventuellement un plan de symetrie orthogonal a l'axe  |
  |          definissant la periodicite de rotation                      |
  |======================================================================| */

void dupliq2d_per(int nplasy,double *plasym,int nperay,double *perray,
		  int npoinr,int nelray,int *nodray,
		  double *cooray,double *xnfray,
		  int *nel2,int *npoin2,int *nod2,double *coo2,double *xnf2,
		  int *grconv, int *grconv2)


{
	
    int i,n,idebnel,idebnp,numper,inverse;
    double t[3][3];
    double Pi;
    double px,py,alfa,angle,x,y;
    

    Pi = 3.141592653589793;  	
    if (nplasy==0)
      {
	*nel2=nperay*nelray;
	*npoin2=nperay*npoinr;
      }
    else if (nplasy==1)
      {
	*nel2=nperay*2*nelray;
	*npoin2=nperay*2*npoinr;
      }
    else if (nplasy==2)
      {
	*nel2=nperay*4*nelray;
	*npoin2=nperay*4*npoinr;     
      }
    else
      {
	printf("en 2D, 3 plans de symetrie sont impossibles\n");
	exit(0);
      }

    for (i=0;i<nelray;i++)
    {
        *(nod2+i)         = *(nodray+i);
        *(nod2+i+*nel2)   = *(nodray+i+nelray);
        *(xnf2+i)         = *(xnfray+i);
        *(xnf2+i+*nel2)   = *(xnfray+i+nelray);

	*(grconv2+i)      = *(grconv+i);
    }

    for (i=0;i<npoinr;i++)
    {
       *(coo2+i)           = *(cooray+i);
       *(coo2+i+*npoin2)   = *(cooray+i+npoinr);
    }


    numper=0;
    px = perray[0];
    py = perray[1];
    alfa = perray[2]*2*Pi/360.;

    for (i=0;i<nperay-1;i++)
      {
	/* calcul de la matrice */
        angle = alfa*(i+1);

	t[0][0] =  cos(angle);
	t[1][1] =  cos(angle);
	t[0][1] = -sin(angle);
	t[1][0] =  sin(angle);
	t[0][2] = px;
	t[1][2] = py;
	t[2][0] = t[2][1]=0; t[2][2]=1.;
	
	numper +=1;
	inverse = 1 ;
	idebnel = (numper)*nelray;	
	idebnp  = (numper)*npoinr;  

	for (n=0;n<nelray;n++)
	  {
	    x  = xnfray[n];
	    y  = xnfray[n+ nelray];
	    xnf2[idebnel+n]        = t[0][0]*x+t[0][1]*y;
	    xnf2[idebnel+n+*nel2]  = t[1][0]*x+t[1][1]*y;
	    nod2[idebnel+n]        = nodray[n] + numper*npoinr; 
	    nod2[idebnel+n+*nel2]  = nodray[n+nelray]   + numper*npoinr;

	    *(grconv2+n+idebnel)      = *(grconv+n);
	  }  

	for (n=0;n<npoinr;n++)
	  {	
	    x  = cooray[n];
	    y  = cooray[n+ npoinr];
	    coo2[idebnp+n]            = t[0][0]*x+t[0][1]*y+t[0][2]; 
	    coo2[idebnp+n+ *npoin2]   = t[1][0]*x+t[1][1]*y+t[1][2]; 
        
	  } 


      }                     


   
    /* impressions de controle */
    /* printf(" coordonnees\n ");	    
        for (n=0;n<*npoin2;n++) 
         printf(" point %d : %f %f %f \n",n,
		coo2[n],coo2[n+ *npoin2]);
    
        printf(" normale \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %f %f %f \n",n,
		xnf2[n],xnf2[n+ *nel2]);
    
        printf(" connectivite \n");	    
        for (n=0;n<*nel2;n++) 
         printf(" face %d : %d %d %d \n",n,
		nod2[n],nod2[n+ *nel2]);  
*/
	
}






/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | facecache_2d                                                         |
  |          Algorithme de detection rapide de faces cachees             |
  |======================================================================| */
void facecache_2d(int ndim, int npoin,int nel2,int nel,
		  int *nod,double *coord,double *xnf,
		  int *faces_cachees,int nplasy,int nperay)

{

  int i,j,k,ns;
  int noeud[4];
  int nbfcoplanaire,code_decoupe,nbfca;
  int ideb,npoin2;
  double xi[4],yi[4],*pland,dsign[4];
  double xn1,yn1,x,y,fforme;


  pland = (double*)malloc( nel2 * sizeof(double));
  if (pland==NULL) 
    {printf(" ERREUR facecache_2d : probleme d'allocation memoire\n");
     exit(0);}

  nbfca = 0 ;
  nbfcoplanaire = 0 ;
  npoin2 = 2*npoin ;

  for (i=0 ; i<nel2 ; i++)
    {
      xn1 = xnf[i];
      yn1 = xnf[i+ nel2];
      x  = coord[nod[i]-1];
      y  = coord[nod[i]-1+npoin];
      pland[i]=-x*xn1-y*yn1;
    }


  ideb = -nel;
  for (ns=0 ; ns < nsp ; ns++ ) 
    {
      ideb += nel;
      for (i=0 ; i<nel ; i++ )  
	{
	  xn1 = xnf[i];
	  yn1 = xnf[i+ nel2];
	  noeud[0] = nod[i];
	  noeud[1] = nod[i+ nel2];

 	  for  (j=ideb+i ; j<ideb+nel ; j++ )   
	    {
	      fforme = coplanaire_2d(xn1,yn1,xnf[j],xnf[j+nel2]);
	      if (fforme<-1.)  /* les faces ne sont pas coplanaires */
		{
		  noeud[2] = nod[j];
		  noeud[3] = nod[j+ nel2];
		    
		  for (k=0;k<4;k++)
		    { 
		      xi[k] = coord[noeud[k]-1];
		      yi[k] = coord[noeud[k]-1+ npoin];
		    }

		  derriere_2d(nel2,i,j,xnf,pland,xi,yi,dsign,&code_decoupe) ;  
		  if ( code_decoupe != 0 ) nbfca += 1 ;
		}
	    }
	}

    }
  if (nbfca != 0 ) 
    {
      *faces_cachees = 1 ;
      printf( "\n *** FACECACHE_2D : Le maillage comporte des faces cachees (nbre=%d) \n",nbfca ) ;
    }
  else
    {
      *faces_cachees = 0 ;
      printf( "\n ***  FACECACHE_2D : Le maillage ne comporte a priori pas de faces cachees \n" ) ;
    }

}
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | dimension_2d                                                         |
  |           dimensions caracteristiques du probleme                    |
  |======================================================================| */
void dimension_2d(int ndim,int nelray,int npoinr,int *nodray,double *cooray,
		  double *taille_boite,double *taille_seg)
{

    int i,npoin2,nelray2,na,nb;
    double xmin,xmax,ymin,ymax,xa,ya,xb,yb,ds;

    npoin2=2*npoinr;
    nelray2=2*nelray;

    xmin =  1.E10; ymin=  1.E6;
    xmax = -1.E10; ymax= -1.E6; 

    for (i=0;i<npoinr;i++)
    {
       xmin = min(*(cooray+i),xmin);
       ymin = min(*(cooray+i+npoinr),ymin);
       xmax = max(*(cooray+i),xmax);
       ymax = max(*(cooray+i+npoinr),ymax);
    }

    *taille_boite=0.;
    *taille_boite=max(*taille_boite,(xmax-xmin));
    *taille_boite=max(*taille_boite,(ymax-ymin));


    *taille_seg=1.E8;

    for (i=0;i<nelray;i++)
    {
      na=nodray[i]-1; nb=nodray[i+nelray]-1;
      xa=*(cooray+na); ya=*(cooray+na+npoinr);
      xb=*(cooray+nb); yb=*(cooray+nb+npoinr);
      ds=sqrt((xb-xa)*(xb-xa)+(yb-ya)*(yb-ya));
      *taille_seg=min(*taille_seg,ds);
    }

    printf("\n *** DIMENSION_2D : Dimensions caracteristiques :\n"); 
    printf("                      encombrement    = %f \n",*taille_boite); 
    printf("                      + petit segment = %f \n",*taille_seg); 
  }



