C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=COCOIN,SSI=0
                        SUBROUTINE COCOIN
C                       *****************
C
C      -------------------------------------------------------
     * (NDIM,NPOINS,NBCOUS,NBCOUF,NBICOR,COORDS,COORDF,
     *  NCBORF,NCBORS,NCOUPS)
C      -------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA TABLE DE CORRESPONDANCE ENTRE LES     *
C            NOEUDS COUPLES DES MAILLAGES FLUIDE ET SOLIDE             *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE VOL SOLIDE      !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  COORDF   ! TR ! D  ! COORDONNEES DES NOEUDS FLUIDES COUPLES       !
C !  NCBORF   ! TE ! R  ! NUMERO DU NOEUD SOLIDE CORRESPONDANT         !
C !  NCBORS   ! TE ! R  ! NUMERO DU NOEUD FLUIDE CORRESPONDANT         !
C !  NCOUPS   ! TE ! D  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES   !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ----
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON 
C***********************************************************************
C
#include "mobil.h"
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS
      INTEGER NBCOUS,NBCOUF,NBICOR
      INTEGER NCBORF(NBCOUF,NBICOR),NCBORS(NBCOUS,NBICOR)
      INTEGER NCOUPS(NBCOUS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),COORDF(NBCOUF,NDIM)
C
C.. Variables internes
      INTEGER N,NS,NF,NGS,NLMIN
      DOUBLE PRECISION XF,YF,ZF,XS,YS,ZS,D2,DMIN,DMAX
C
C***********************************************************************
C
C     0.1- INITIALISATIONS
C     ====================
C
      DO 1 N=1,NBCOUS*NBICOR
        NCBORS(N,1) = -1
    1 CONTINUE
C
      DMAX = 0
C
C     0.2- VERIFICATION DE BASE
C     =========================
C
      IF (NBCOUS.NE.NBCOUF) THEN
        WRITE(NFECRA,999) NBCOUS,NBCOUF
        STOP
      ENDIF
C
C     1- CORRESPONDANCE FLUIDE-->SOLIDE ET SOLIDE-->FLUIDE EN 2D
C     ==========================================================
C
      IF (NDIM .EQ. 2) THEN
C
C
       IF (NBLBLA.GE.3) WRITE(NFECRA,1000)
C
C      1.1- Pour chaque point du maillage fluide...
C      --------------------------------------------
       DO 100 NF=1,NBCOUF
C
         DMIN = 1.D6
         NLMIN = 0
C
         XF = COORDF(NF,1)
         YF = COORDF(NF,2)
C    
C
         DO 110 NS=1,NBCOUS
C
            NGS = NCOUPS(NS)
C
            XS = COORDS(NGS,1)
            YS = COORDS(NGS,2)
C
            D2 = (XS-XF)*(XS-XF) + (YS-YF)*(YS-YF)
C 
            IF (D2.LT.DMIN) THEN
              DMIN = D2
              NLMIN = NS
            ENDIF
C
  110    CONTINUE
C
C       1.2- Mise a jour des correspondants
C       -----------------------------------
        IF (NLMIN.NE.0) THEN
          NCBORF(NF,1) = NLMIN 
          NCBORS(NLMIN,1) = NF
          IF (DMIN.GT.DMAX) DMAX = DMIN
        ELSE
          WRITE(NFECRA,1200) NF
        ENDIF
C
  100 CONTINUE     
C
C
C     2- CORRESPONDANCE FLUIDE-->SOLIDE EN DIMENSION 3
C     ================================================
C
      ELSEIF (NDIM .EQ. 3) THEN
C
C
       IF (NBLBLA.GE.3) WRITE(NFECRA,1000)
C
C      2.1- Pour chaque point du maillage fluide...
C      --------------------------------------------
       DO 200 NF=1,NBCOUF
C
         DMIN = 1.D6
         NLMIN = 0
C
C        Coordonnees du noeud fluide
         XF = COORDF(NF,1)
         YF = COORDF(NF,2)
         ZF = COORDF(NF,3)
C    
C
         DO 210 NS=1,NBCOUS
C
            NGS = NCOUPS(NS)
C
            XS = COORDS(NGS,1)
            YS = COORDS(NGS,2)
            ZS = COORDS(NGS,3)
C
            D2 = (XS-XF)*(XS-XF) + (YS-YF)*(YS-YF) + (ZS-ZF)*(ZS-ZF)
C 
            IF (D2.LT.DMIN) THEN
              DMIN = D2
              NLMIN = NS
            ENDIF
C
  210    CONTINUE
C
C       2.2- Mise a jour des correspondants
C       -----------------------------------
        IF (NLMIN.NE.0) THEN
          NCBORF(NF,1) = NLMIN 
          NCBORS(NLMIN,1) = NF
          IF (DMIN.GT.DMAX) DMAX = DMIN
        ELSE
          WRITE(NFECRA,1200) NF
        ENDIF
C
  200 CONTINUE     
C
C 
      ENDIF
C
C     3- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.GT.0) WRITE(NFECRA,3200) DMAX
C
      IF (NBLBLA.GE.10) THEN
        WRITE (NFECRA,3000)
        DO 300 N=1,NBCOUF
          WRITE(NFECRA,3010) N,NCBORF(N,1)
  300   CONTINUE
        WRITE (NFECRA,3100)
        DO 310 N=1,NBCOUS
          WRITE(NFECRA,3110) N,NCBORS(N,1)
  310   CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
C
  999 FORMAT(/,' %% ERREUR COCOIN : les maillages sont dits ',
     &         'coincidents alors que ',/,
     &         '    le nombre de noeuds couples fluides (',I5,') ',/,
     &         '    n''est pas egal au nombre de noeuds solides',
     &         ' couples (',I5,') ')
 1000 FORMAT(/,' *** COCOIN :',
     &         ' Elaboration de la table de correspondance entre',
     &         ' fluide et solide')
 1200 FORMAT(' %% ERREUR COCOIN : LA RECHERCHE DU CORRESPONDANT DU ',
     &       ' NOEUD FLUIDE ',I6,' A ECHOUEE')
C
 3000 FORMAT(/,' *** COCOIN : correspondant des noeuds fluides :',/)
 3010 FORMAT(4X,' Noeud fluide :',I6,'  Correspondant solide : ',I6)
 3100 FORMAT(/,' *** COCOIN : correspondant des noeuds solides :',/)
 3110 FORMAT(4X,' Noeud solide :',I6,'  Correspondant fluide : ',I6)
 3200 FORMAT(' *** COCOIN : Distance maximale entre 2 noeuds ',
     &         'coincidents : ',E12.5)
C----
C FIN
C----
      END
               
