C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE ICONDU
C                       *****************
C
     * (VV,NVV,NDIM,NPE,NREF,IREF,NB,NPOUE,NPPEL,NBPHYS,PHYSOL)
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------  INITIALISATION DE LA CONDUCTIVITE DANS LE CAS            *
C             OU ELLE EST ANISOTROPE                                   *
C                                                                      *
C             L'utilisateur donne la transformation du repere          *
C             d'origine vers le repere propre du solide (translation   *
C             + rotation) et les valeurs de la conductivite dans       *
C             chacune des directions du repere propre du solide        *
C             (Kxx,Kyy,Kzz)                                            *
C             On transforme alors ces donnees dans le repere d'origine *
C             et on obtient une matrice de conductivite (symetrique)   *
C                                                                      *
C         en 2D :                                                      *
C                ( K11 K12 )                           ( 3 5 )         *
C                (     K22 )  -- dans PHYSOL -->       (   4 )         *
C                                                                      *
C         en 3D :                                                      *
C              ( K11 K12 K13 )                        ( 3 6 7 )        *
C              (     K22 K23 )  -- dans PHYSOL -->    (   4 8 )        *
C              (         K33 )                        (     5 )        *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! VV     !  TR  ! D  ! DONNEES DE LA TRANSFORMATION GEOMETRIQUE    !
C   !        !      !    ! ET DE LA CONDUCTIVITE DANS LE REPERE PROPRE !
C   ! NVV    !   E  ! D  ! TAILLE DU TABLEAU VV (IE : NBRE DE DONNEES) !
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME                       !
C   ! NPOINS !   E  ! D  ! NOMBRE DE NOEUDS SOLIDES                    !
C   ! IREF   !  TE  ! D  ! REFERENCES IMPLIQUEES                       !
C   ! NB     !   E  ! D  ! NOMBRE DE REFERENCES IMPLIQUEES             !
C   ! NBPHYS !   E  ! D  ! NOMBRE DE PROPRIETES PHYSIQUES DU SOLIDE    !
C   ! PHYSOL !  TR  ! M  ! PROPRIETES PHYSIQUES DU SOLIDE              !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !/XREFER/!      ! D  !                                             !
C   !__________________________________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : LECLIM
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "xrefer.h"
C
C**********************************************************************
C
C..Variables externes
      INTEGER NVV,NDIM,NPE,NBPHYS,NB,NPOUE,NPPEL
      INTEGER IREF(NRFMAX),NREF(NPE)
      DOUBLE PRECISION VV(NVV),PHYSOL(NPOUE,NPPEL,NBPHYS)
C
C..Variables internes
      LOGICAL LVERIF
      INTEGER N,NR,N1,NBRE,M
      DOUBLE PRECISION PI,XK,YK,ZK,RX,RY,RZ,CRX,SRX,CRY,SRY,CRZ,SRZ
      DOUBLE PRECISION R(3,3),RM1(3,3),TR(3,3)
C
C**********************************************************************
C
C     0- Initialisations
C     ==================
      LVERIF = .FALSE.
C
      PI = 3.141592654
C
      RX = VV(4) * PI / 180.
      RY = VV(5) * PI / 180.
      RZ = VV(6) * PI / 180.
C
      CRX = COS(RX)
      SRX = SIN(RX)
      CRY = COS(RY)
      SRY = SIN(RY)
      CRZ = COS(RZ)
      SRZ = SIN(RZ)
C
      XK = VV(1)
      YK = VV(2)
      ZK = VV(3)
C
C
      R(1,1) = CRZ*CRY
      R(1,3) = SRZ*SRX-CRZ*SRY*CRX
      R(3,1) = SRY
      R(1,2) = -SRZ*CRX-CRZ*SRY*SRX
      R(2,3) = -CRZ*SRX-SRZ*SRY*CRX
      R(3,2) = CRY*SRX
      R(3,3) = CRY*CRX
      R(2,1) = SRZ*CRY
      R(2,2) = CRZ*CRX-SRZ*SRY*SRX
C
C
      RM1(1,1) = CRZ*CRY/(CRZ**2*CRY**2+SRZ**2*CRY**2+SRZ**2*SRY**2+CRZ*
     &*2*SRY**2)
      RM1(1,3) = SRY/(CRY**2+SRY**2)
      RM1(3,1) = -(-SRZ*CRY**2*SRX+CRZ*SRY*CRX-SRZ*SRY**2*SRX)/(CRZ**2*C
     &RY**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY*
     &*2*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+SRZ**2*SRX**2*
     &SRY**2+CRZ**2*SRY**2*CRX**2)
      RM1(1,2) = SRZ*CRY/(CRZ**2*CRY**2+SRZ**2*CRY**2+SRZ**2*SRY**2+CRZ*
     &*2*SRY**2)
      RM1(2,3) = CRY*SRX/(CRY**2*SRX**2+CRY**2*CRX**2+SRY**2*SRX**2+SRY*
     &*2*CRX**2)
      RM1(3,2) = -(CRZ*CRY**2*SRX+SRZ*SRY*CRX+CRZ*SRY**2*SRX)/(CRZ**2*CR
     &Y**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY**
     &2*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+SRZ**2*SRX**2*S
     &RY**2+CRZ**2*SRY**2*CRX**2)
      RM1(3,3) = CRY*CRX/(CRY**2*SRX**2+CRY**2*CRX**2+SRY**2*SRX**2+SRY*
     &*2*CRX**2)
      RM1(2,1) = -(SRZ*CRY**2*CRX+CRZ*SRY*SRX+SRZ*SRY**2*CRX)/(CRZ**2*CR
     &Y**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY**
     &2*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+SRZ**2*SRX**2*S
     &RY**2+CRZ**2*SRY**2*CRX**2)
      RM1(2,2) = (CRZ*CRY**2*CRX-SRZ*SRY*SRX+CRZ*SRY**2*CRX)/(CRZ**2*CRY
     &**2*CRX**2+CRZ**2*CRY**2*SRX**2+SRZ**2*CRY**2*CRX**2+SRZ**2*CRY**2
     &*SRX**2+SRZ**2*CRX**2*SRY**2+CRZ**2*SRY**2*SRX**2+SRZ**2*SRX**2*SR
     &Y**2+CRZ**2*SRY**2*CRX**2)
C
C
C
      TR(1,1) = R(1,1)*XK*RM1(1,1)+R(1,2)*YK*RM1(2,1)+R(1,3)*ZK*RM1(3,1)
      TR(1,2) = R(1,1)*XK*RM1(1,2)+R(1,2)*YK*RM1(2,2)+R(1,3)*ZK*RM1(3,2)
      TR(1,3) = R(1,1)*XK*RM1(1,3)+R(1,2)*YK*RM1(2,3)+R(1,3)*ZK*RM1(3,3)
      TR(2,2) = R(2,1)*XK*RM1(1,2)+R(2,2)*YK*RM1(2,2)+R(2,3)*ZK*RM1(3,2)
      TR(2,3) = R(2,1)*XK*RM1(1,3)+R(2,2)*YK*RM1(2,3)+R(2,3)*ZK*RM1(3,3)
      TR(3,3) = R(3,1)*XK*RM1(1,3)+R(3,2)*YK*RM1(2,3)+R(3,3)*ZK*RM1(3,3)
C
C
      NBRE = 0
C
C
      IF (IREF(1) .EQ. -1 ) THEN
C
       IF (NDIM.EQ.2) THEN
        DO 510 M=1,NPPEL
         DO 511 N=1,NPOUE
           PHYSOL(N,M,3) = TR(1,1)
           PHYSOL(N,M,4) = TR(2,2)
           PHYSOL(N,M,5) = TR(1,2)
           NBRE = NBRE + 1
  511    CONTINUE
  510   CONTINUE
       ELSE
        DO 512 M=1,NPPEL
         DO 513 N=1,NPOUE
           PHYSOL(N,M,3) = TR(1,1)
           PHYSOL(N,M,4) = TR(2,2)
           PHYSOL(N,M,5) = TR(3,3)
           PHYSOL(N,M,6) = TR(1,2)
           PHYSOL(N,M,7) = TR(1,3)
           PHYSOL(N,M,8) = TR(2,3)
           NBRE = NBRE + 1
  513    CONTINUE
  512   CONTINUE
       ENDIF
C
      ELSE
C
C
         DO 520 N1=1,NB
C
           NR = IREF(N1)
C
           IF (NDIM.EQ.2) THEN
             DO 521 M=1,NPPEL
              DO 522 N=1,NPOUE
               IF (NREF(N) .EQ. NR) THEN
                  PHYSOL(N,M,3) = TR(1,1)
                  PHYSOL(N,M,4) = TR(2,2)
                  PHYSOL(N,M,5) = TR(1,2)
                  NBRE = NBRE + 1
               ENDIF
  522         CONTINUE
  521        CONTINUE
C
           ELSE
             DO 523 M=1,NPPEL
              DO 524 N=1,NPOUE
                IF (NREF(N) .EQ. NR) THEN
                  PHYSOL(N,M,3) = TR(1,1)
                  PHYSOL(N,M,4) = TR(2,2)
                  PHYSOL(N,M,5) = TR(3,3)
                  PHYSOL(N,M,6) = TR(1,2)
                  PHYSOL(N,M,7) = TR(1,3)
                  PHYSOL(N,M,8) = TR(2,3)
                  NBRE = NBRE + 1
               ENDIF
  524        CONTINUE
  523       CONTINUE
          ENDIF
C
  520  CONTINUE 
C
      ENDIF
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      RETURN
      END
