C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE INISF1
C                       *****************
C
C     -------------------------------------------------------------
     *(NDIM,NPOINF,NELEBF,XYZF,NBCOUF,NELESF,NDMASF,NBRAF,NELRAF,
     * NREFF,COORDF,NODEBF,NODESF,NCOUPF,COORAF,NRAPF,NODRAF,
     * NBFILS,NWMAIL,NWDN,NWDRN,NWDE,NWDRE,
     * NWNCF1,NWNRF1,NWECF1,NWERF1,NWDMA1)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C     INITIALISATIONS POUR LA PRISE EN COMPTE DU COUPLAGE
C     THERMIQUE FLUIDE/SOLIDE 
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NPOINF   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE FLUIDE          !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NELESF   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF COUPLE FLUIDE !
C !  NBRAF    !  E ! D  ! NOMBRE DE NOEUDS FLUIDE NON COUPLE AVEC RAYT !
C !  NELRAF   !  E ! D  ! NBRE D'ELTS SURF FLUIDE NON COUPLE AVEC RAYT !
C !  NDMASF   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS FLUIDES SURF       !
C !  NREFF    ! TE ! R  ! REFERENCES DES NOEUDS FLUIDES                !
C !  COORDF   ! TR ! R  ! COORDONNEES DES NOEUDS DU MAILLAGE FLUIDE    !
C !  NODESF   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF FLUIDE !
C !  NCOUPF   ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS FLUIDES COUPLES   !
C !  NODRAF   ! TE ! R  ! CONNECTIVITE NOEUDS FLUIDE NON COUPLE + RAYT !
C !  COORAY   ! TR ! R  ! COORD MAILLAGE EXT RAYONNEMENT               !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /OPTCT/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) :
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON 
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINF,NBCOUF,NELESF,NDMASF,NELEBF
      INTEGER NBRAF,NELRAF
      INTEGER NREFF(NPOINF),NCOUPF(NBCOUF,2),NRAPF(NBRAF,2)
      INTEGER NODESF(NELESF,NDMASF),NODEBF(NELEBF,NDMASF)
      INTEGER NODRAF(NELRAF,NDMASF)
      INTEGER NBFILS,NWMAIL,NWDN,NWDRN,NWDE,NWDRE
      INTEGER NWNCF1,NWNRF1,NWECF1,NWERF1,NWDMA1
C
      DOUBLE PRECISION XYZF(NPOINF,NDIM)
      DOUBLE PRECISION COORDF(NBCOUF,NDIM)
      DOUBLE PRECISION COORAF(NBRAF,NDIM)
C
C.. Variables internes
C
C
C     2- INITIALISATIONS GEOMETRIQUES ET PHYSIQUES
C     ============================================
C
      CALL COORFL (NDIM,NBCOUF,NBRAF,NPOINF,NREFF,XYZF,
     *             COORDF,COORAF,NBFILS,NWMAIL,NWDN,NWDRN)
C
      CALL LIMNUF(NCOUPF,NBCOUF,NRAPF,NBRAF,NREFF,NPOINF,
     *            NBFILS,NWMAIL,NWDN,NWDRN,NWNCF1,NWNRF1)
C
C
C     3- Generation du maillage surfacique fluide couple   
C     ==================================================
C 
      IF (.NOT.LCOIN ) THEN
         CALL XMFLUI (NDIM,NPOINF,NBCOUF,NELEBF,NELESF,NDMASF,
     *                NODEBF,NREFF,NODESF,NELRAF,NODRAF,
     *                NBFILS,NWMAIL,NWDE,NWDRE,NWDMA1)
C
         CALL NDLOCF (NELESF,NDMASF,NBCOUF,NPOINF,NODESF,NCOUPF,
     *                NRAPF,NBRAF,NELRAF,NODRAF,NREFF,
     *                NBFILS,NWMAIL,NWDN,NWDRN,NWDE,NWDRE,
     *                NWNCF1,NWNRF1,NWECF1,NWERF1,NWDMA1)
      ENDIF
C
C           
C--------
C FORMATS
C--------
C
C----
C FIN
C----
C
      END


