C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE INISO1
C                       *****************
C
C     -------------------------------------------------------------
     *(NDIM,NPOINS,NELEMS,NFBIDA,NELESS,NELEUS,NELEPR,NELERC,NELERA,
     * NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL, NBRESS,
     * NBRAYS,NBRAIS,NBPRIO,NBMOBS,NBCOPR,
     * NDIELE,NDMATS,NDMASS,NBFACE,NCOEMA,NBPHYS,NPPEL,NPOUE,NBICOR,
     * NBFFLU,NBFECH,NBFRAI,NPOINR,NELRAY,NNSRAY,NNFRAY,NNERAY,
     * NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C     INITIALISATIONS POUR LA PRISE EN COMPTE DU COUPLAGE
C     THERMIQUE FLUIDE/SOLIDE 
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  MOTCLE   !  E ! D  ! TYPE DE COUPLAGE CHOISI                      !
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NPOINS   !  E ! R  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NELESS   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE SURF SOLIDE        !
C !  NELEUS   !  E ! R  ! NBRE D'ELTS DU MAILLAGE SURF SOLIDE AVEC FLUX!
C !  NELEPR   !  E ! R  ! NBRE D'ELTS DU MAIL VOL SOLIDE PERIODIQUE    !
C !  NBCOUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NELERA   !  E ! R  ! NBRE D'ELTS DU MAIL SURF SOLIDE AVEC RAYONNT !
C !  NBFLUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DE TYPE FLUX!
C !  NBDIRS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DIRICHLET   !
C !  NBECHS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL COEF ECH    !
C !  NBFLVS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC FLUX VOLUMIQUE !
C !  NBRESS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL RESI CONTACT!
C !  NBRAYS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT    !
C !  NBRAIS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC RAYONNEMENT INF!
C !  NBFRAI   !  E ! R  ! NOMBRE DE FACES SOLIDES AVEC RAYONNEMENT INF !
C !  NBPRIO   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES PERIODIQUES         !
C !  NBMOBS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES EN MOUVEMENT        !
C !  NBCOPR   !  E ! R  ! NBRE DE CORRESPONDANTS POUR LES NOEUDS PERIOD!
C !  NDIELE   !  E ! R  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NDMATS   !  E ! R  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NDMASS   !  E ! R  ! NOMBRE DE NOEUDS DES ELTS SURF SOLIDES       !
C !  NBFACE   !  E ! R  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NCOEMA   !  E ! R  ! NOMBRE DE COEF EXTRA DIAG DES MATRICES ELEM  !
C !  NBPHYS   !  E ! R  ! NOMBRE DE VARIABLES PHYSIQUES SUR LE SOLIDE  !
C !  NBICOR   !  E ! R  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  NPOINR   !  E ! R  ! NOMBRE DE NOEUDS DU MAILLAGE RAYONNEMENT     !
C !  NELRAY   !  E ! R  ! NOMBRE D'ELEMENTS DU MAILLAGE RAYONNEMENT    !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! R  !                                              !
C ! /OPTCT/   !    ! R  !                                              !
C ! /FICHCT/  !    ! R  !                                              !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) : IFICCT,INOMCT,OPENCT,LECMCL,EVADIM
C
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "fichct.h"
#include "syrth.h"
#include "bilan.h"
C
C **********************************************************************
C
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NBCOPR,NBFRAI,NBFACE
      INTEGER NPOINS,NELEMS,NELEPR,NELESS,NELEUS,NELERC,NELERA
      INTEGER NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL
      INTEGER NBRESS,NBRAYS,NBPRIO
      INTEGER NBMOBS,NBRAIS
      INTEGER NDMATS,NDMASS,NCOEMA,NBPHYS,NPPEL,NPOUE,NBICOR
      INTEGER NBFFLU,NBFECH
      INTEGER NPOINR,NELRAY,NNSRAY,NNFRAY,NNERAY
      INTEGER NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE
C
C.. Variables internes
      INTEGER NFBIDA
C
C***********************************************************************
C     -1- INITIALISATIONS
C     ===================
      CALL TOUTA0 (NPOINS,NELEMS,NELESS,NELEUS,NELEPR,NELERC,NELERA,
     *             NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NBRESS,
     *             NBRAYS,NBRAIS,NBPRIO,NBMOBS,NBCOPR,
     *             NDIELE,NDMATS,NDMASS,NBFACE,NCOEMA,NBPHYS,NBICOR,
     *             NBFFLU,NBFECH,NBFRAI,NPOINR,
     *             NELRAY,NNSRAY,NNFRAY,NNERAY,
     *             NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE)

C
C     1- NUMEROS LOGIQUES DES FICHIERS
C     ================================
      CALL IFICCT 
C
C
C     2- NOMS DES FICHIERS
C     ====================
      CALL INOMCT
C
C     3- OUVERTURES DES FICHIERS OBLIGATOIRES POUR LE COUPLAGE THERMIQUE
C     ==================================================================
      CALL OPENCT('OBLIG')

C     4- VERIFICATION OTHOGRAPHIQUE DU FICHIER DE DONNEES
C     ===================================================
      CALL DICOCT
C
C     5- LECTURE DES MOTS-CLES DU COUPLAGE THERMIQUE
C     ==============================================
      CALL LECMCL(NDIM)
C
      IF (LRAY) THEN
        CALL OPENCT('RAYOB')
        CALL DICORA
        CALL LECMCR
      ENDIF
C
C     6- OUVERTURE DES FICHIERS OPTIONNELS
C     ====================================
      CALL OPENCT('AUTRE')
      IF (LRAY) CALL OPENCT('RAYTT')
C
C
C     7- EVALUATION DES DIMENSIONS DES TABLEAUX
C     =========================================
C
      CALL EVADIM 
     *      (NDIM,NPOINS,NELEMS,NFBIDA,
     *       NELESS,NELEUS,NELEPR,NELERC,NELERA,
     *       NBCOUS,NBFLUS,NBDIRS,NBECHS,NBFLVS,NPFEL, NBRESS,
     *       NBRAYS,NBRAIS,NBPRIO,NBMOBS,
     *       NDIELE,NDMATS,NDMASS,NBFACE,NCOEMA,NBPHYS,NPPEL,NPOUE,
     *       NBICOR,NBCOPR,NBFFLU,NBFECH,NBFRAI,
     *       NPOINR,NELRAY,NNSRAY,NNFRAY,NNERAY,
     *       NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE)
C
      IF (NBMOBS.GT.0) THEN
        LSROTA = .TRUE.
      ELSE
        LSROTA = .FALSE.
      ENDIF
C
C     8- OUVERTURE DES FICHIERS DE RESULTATS
C     ======================================
      IF (.NOT. LSROTA .AND. .NOT.LSDEPL) THEN
        CALL OPENCT ('RGEOM')
        CALL OPENCT ('RESUL')
        IF (NCHROS.GE.1) CALL OPENCT ('RCHRO')
        IF (NFMST.GT.0) CALL OPENCT ('FMSTS')
      ENDIF
C 
C     9- DONNEES ISSUES DU FLUIDE
C     ===========================
C
C     9.1 Prise en compte des calculs axisymetriques
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      IF (IAXISY.GT.0) THEN
        WRITE(NFECRA,9100)
      ENDIF
C
C     9.2 Bilan de flux vol
C     ~~~~~~~~~~~~~~~~~~~~~
      IF (NBILAV.GT.0 .AND. NDFLUV.EQ.1) THEN
        WRITE (NFECRA,9310)
        STOP
      ENDIF
C
C
C     10- MAILLAGE EN TRANSLATION 
C     ===========================
C
      IF (LSDEPL) THEN
C
        NPOINS = NPOINS * 2
        NELEMS = NELEMS * 2
        NELEUS = NELEUS * 2
        NELEPR = NELEPR * 2
C
        NBCOUS = NBCOUS * 2
        NELESS = NELESS * 2
        NBFLUS = NBFLUS * 2
        NBFFLU = NBFFLU * 2
        NBDIRS = NBDIRS * 2
        NBECHS = NBECHS * 2
        NBFECH = NBFECH * 2
        NBFLVS = NBFLVS * 2
        NBRESS = NBRESS * 2
        NELERC = NELERC * 2
        NBRAYS = NBRAYS * 2
        NELERA = NELERA * 2 
        NBPRIO = NBPRIO * 2
        NBMOBS = NBMOBS * 2
C
      ENDIF        
C
C
C--------
C FORMATS
C--------
C
 9100 FORMAT(/,' *** INISO1 : LE CALCUL SOLIDE EST FAIT',
     &         ' EN AXISYMETRIQUE')
 9310 FORMAT(/,' %% ERREUR INISO1 : Les bilans de flux volumiques ',
     &         'ne peuvent etre faits',/,
     & 20X,'que si les flux volumiques sont imposes par "element"',/,
     & 20X,'ou par "noeud par element"',/ )
C----
C FIN
C----
C
      END
