C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MADIF2,SSI=0
C
                     SUBROUTINE MADIF2
C                    *****************
C
C     ------------------------------------------------------
     *( XMAT,COEFMA,PHYSOL,NODES,COORDS,VOLUME,
     *  NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *  NPOUE,NPPEL,NBPHYS,
     *  WCT )
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DES MATRICES ELEMENTAIRES POUR             *
C                    PROBLEMES BIDIMENSIONNELS ET TRIDIMENSIONNEL      *
C                    POUR LES CAS ORTHOTROPES                          *
C                                                                      *
C        la matrice de conductivite dans le repere globale             *
C        s exprime donc de la facon suivante :                         *
C                                                                      *
C              | AKXX    0   |                                         *
C              | 0     AKYY  |                                         *
C                                                                      *
C        Les AKXX sont toujours variables en temps et en espace        *
C        il seront donc discretise en iso-P2                           *
C                                                                      *
C      Ce sous programme constitue une extension de travaux effectuees *
C      par F. JAUBERTEAU et J.P. GREGOIRE, portant sur l'integration   *
C      analytique des matrices elementaires par les formules de        *
C      Zienkiewicz                                                     *
C                                                                      *
C-----------------------------------------------------------------------
C	          (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   XMAT    !  TR  ! R  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   COEFMA  !  TR  ! D  ! COEFFICIENTS DES MATRICES                !
C   !           !      !    !  coefma(n) = rho Cp / dt pour masse      !
C   !   PHYSOL  !  TR  ! D  ! Tableau contenant les propri physiques   !
C   !           !  TR  ! D  !   On utilise uniquement PHYSOL(n,>=3)    !
C   !           !      !    !   contient les valeurs des kii sui isotro!
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !   W1...W10!  TR  ! M  ! TABLEAUX DE TRAVAIL (TAILLE: NELMXS )    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEMB,OV
C                                     
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : MATELE
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C    
C***********************************************************************
C
C..Variables externes
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NCOEMA
      INTEGER NPOUE,NPPEL,NBPHYS
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)   
      DOUBLE PRECISION COEFMA(NPOINS),XMAT(NELEMS,NCOEMA)      
      DOUBLE PRECISION WCT(NELEMS,NDMATS),VOLUME(NELEMS)    
      DOUBLE PRECISION PHYSOL(NPOUE,NPPEL,NBPHYS)
C
C..Variables internes
      DOUBLE PRECISION ZERO,COEFF,S3,S18,S24
      INTEGER I,NCA
      INTEGER N1,N2,N3,N4,N5,N6,N7,N8,N9,N10      
      DOUBLE PRECISION R1,R2,R3
      DOUBLE PRECISION X75,Y75,Z75,X78,Y78,Z78
      DOUBLE PRECISION X69,Y69,Z69,X65,Y65,Z65
      DOUBLE PRECISION X710,Y710,Z710,X76,Y76,Z76
      DOUBLE PRECISION X810,Y810,Z810,X89,Y89,Z89
C
      DOUBLE PRECISION AKXX1,AKXX2,AKXX3,AKXX4,AKXX5,AKXX6
      DOUBLE PRECISION AKXX7,AKXX8,AKXX9,AKXX10
      DOUBLE PRECISION AKYY1,AKYY2,AKYY3,AKYY4,AKYY5,AKYY6
      DOUBLE PRECISION AKYY7,AKYY8,AKYY9,AKYY10
      DOUBLE PRECISION AKZZ1,AKZZ2,AKZZ3,AKZZ4,AKZZ5,AKZZ6
      DOUBLE PRECISION AKZZ7,AKZZ8,AKZZ9,AKZZ10
      DOUBLE PRECISION XK1,XK2,XK3,XK4,XK5,XK6,XK7,XK8 
      DOUBLE PRECISION YK1,YK2,YK3,YK4,YK5,YK6,YK7,YK8 
      DOUBLE PRECISION ZK1,ZK2,ZK3,ZK4,ZK5,ZK6,ZK7,ZK8 
      DOUBLE PRECISION DX1,DX2,DX3,DX4,DY1,DY2,DY3,DY4
      DOUBLE PRECISION DZ1,DZ2,DZ3,DZ4
      DOUBLE PRECISION AKXXE,AKYYE,AKZZE
C    
      LOGICAL LVERIF
C***********************************************************************
C
C     INITIALISATIONS
C     ================
C
      LVERIF = .FALSE.
      ZERO   = 0.D0
      S3 = 1.D0 / 3.D0
      S18 = 1.D0 / 18.D0
      S24 = 1.D0 / 24.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
C     
C     1- CAS BIDIMENSIONNEL
C     ======================
C        
      IF ( NDIM . EQ . 2 ) THEN
C
C      1.1- CAS CARTESIEN
C      ------------------
       IF (IAXISY.EQ.0) THEN
C
         DO 110 I=1,NELEMS
C
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
C
C
           IF(NDPROP.EQ.1) THEN
             AKXX1 = PHYSOL(N1,1,3)   
             AKXX2 = PHYSOL(N2,1,3)   
             AKXX3 = PHYSOL(N3,1,3)   
             AKXX4 = PHYSOL(N4,1,3)   
             AKXX5 = PHYSOL(N5,1,3)   
             AKXX6 = PHYSOL(N6,1,3)   
C
             AKYY1 = PHYSOL(N1,1,4)   
             AKYY2 = PHYSOL(N2,1,4)   
             AKYY3 = PHYSOL(N3,1,4)   
             AKYY4 = PHYSOL(N4,1,4)   
             AKYY5 = PHYSOL(N5,1,4)   
             AKYY6 = PHYSOL(N6,1,4) 
C  
           ELSEIF(NDPROP.EQ.2) THEN
             AKXXE = PHYSOL(I,1,3) 
             AKYYE = PHYSOL(I,1,4) 
C
             AKXX1 = AKXXE
             AKXX2 = AKXXE
             AKXX3 = AKXXE
             AKXX4 = AKXXE
             AKXX5 = AKXXE
             AKXX6 = AKXXE
C
             AKYY1 = AKYYE
             AKYY2 = AKYYE
             AKYY3 = AKYYE
             AKYY4 = AKYYE
             AKYY5 = AKYYE
             AKYY6 = AKYYE
C
           ELSE
             AKXX1 = PHYSOL(I,1,3)   
             AKXX2 = PHYSOL(I,2,3)   
             AKXX3 = PHYSOL(I,3,3)   
             AKXX4 = PHYSOL(I,4,3)   
             AKXX5 = PHYSOL(I,5,3)   
             AKXX6 = PHYSOL(I,6,3)   
C
             AKYY1 = PHYSOL(I,1,4)   
             AKYY2 = PHYSOL(I,2,4)   
             AKYY3 = PHYSOL(I,3,4)   
             AKYY4 = PHYSOL(I,4,4)   
             AKYY5 = PHYSOL(I,5,4)   
             AKYY6 = PHYSOL(I,6,4) 
           ENDIF
C
           XK1 = AKXX1 + AKXX4 + AKXX6
           YK1 = AKYY1 + AKYY4 + AKYY6
           XK2 = AKXX2 + AKXX4 + AKXX5
           YK2 = AKYY2 + AKYY4 + AKYY5
           XK3 = AKXX3 + AKXX5 + AKXX6
           YK3 = AKYY3 + AKYY5 + AKYY6
           XK4 = AKXX4 + AKXX5 + AKXX6
           YK4 = AKYY4 + AKYY5 + AKYY6
C
C
          DX1 = - (COORDS(N6,2)-COORDS(N4,2))
          DY1 =   (COORDS(N6,1)-COORDS(N4,1))
C
          DX2 = - (COORDS(N4,2)-COORDS(N5,2))
          DY2 =   (COORDS(N4,1)-COORDS(N5,1))
C
          DX3 = - (COORDS(N5,2)-COORDS(N6,2)) 
          DY3 =   (COORDS(N5,1)-COORDS(N6,1))
C
C         Calcul des termes diagonaux
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~
          COEFF = S3 / VOLUME(I) 
C
      WCT(I,1) = COEFF*(DX1**2*XK1+DY1**2*YK1) 
      WCT(I,2) = COEFF*(DX2**2*XK2+DY2**2*YK2)
      WCT(I,3) = COEFF*(DX3**2*XK3+DY3**2*YK3)
      WCT(I,4) = COEFF*(DX2**2*XK1+DY2**2*YK1+DX1**2*XK2+DY1**2*YK2+DX3
     &**2*XK4+DY3**2*YK4) 
      WCT(I,5) = COEFF*(DX3**2*XK2+DY3**2*YK2+DX2**2*XK3+DY2**2*YK3+DX1
     &**2*XK4+DY1**2*YK4) 
      WCT(I,6) = COEFF*(DX3**2*XK1+DY3**2*YK1+DX1**2*XK3+DY1**2*YK3+DX2
     &**2*XK4+DY2**2*YK4) 
C
C         Calcul des termes extra-diagonaux
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
       XMAT(I,1) = COEFF*(DX1*DX2*XK1+DY1*DY2*YK1) 
       XMAT(I,2) = COEFF*(DX1*DX3*XK1+DY1*DY3*YK1) 
C
       XMAT(I,3) = COEFF*(DX2*DX1*XK2+DY2*DY1*YK2)  
       XMAT(I,4) = COEFF*(DX2*DX3*XK2+DY2*DY3*YK2)
C
       XMAT(I,5) = COEFF*(DX3*DX2*XK3+DY3*DY2*YK3) 
       XMAT(I,6) = COEFF*(DX3*DX1*XK3+DY3*DY1*YK3)
C
       XMAT(I,7)=COEFF*(DX1*DX3*XK2+DY1*DY3*YK2+DX3*DX1*XK4+DY3*DY1*YK4) 
       XMAT(I,8)=COEFF*(DX2*DX3*XK1+DY2*DY3*YK1+DX3*DX2*XK4+DY3*DY2*YK4)  
C
       XMAT(I,9)=COEFF*(DX2*DX1*XK3+DY2*DY1*YK3+DX1*DX2*XK4+DY1*DY2*YK4)  
C
  110     CONTINUE
C
C
C       1.2- CAS AXISYMETRIQUE (DONC 2D) 
C       --------------------------------
        ELSE    
C
C
         DO 120 I=1,NELEMS
C
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
C
          COEFF = S24 / VOLUME(I) 
C
           R1 = COEFF * ABS(COORDS(N1,NCA))
           R2 = COEFF * ABS(COORDS(N2,NCA))
           R3 = COEFF * ABS(COORDS(N3,NCA))
C
           IF(NDPROP.EQ.1) THEN
             AKXX1 = PHYSOL(N1,1,3)   
             AKXX2 = PHYSOL(N2,1,3)   
             AKXX3 = PHYSOL(N3,1,3)   
             AKXX4 = PHYSOL(N4,1,3)   
             AKXX5 = PHYSOL(N5,1,3)   
             AKXX6 = PHYSOL(N6,1,3)   
C
             AKYY1 = PHYSOL(N1,1,4)   
             AKYY2 = PHYSOL(N2,1,4)   
             AKYY3 = PHYSOL(N3,1,4)   
             AKYY4 = PHYSOL(N4,1,4)   
             AKYY5 = PHYSOL(N5,1,4)   
             AKYY6 = PHYSOL(N6,1,4) 
C  
           ELSEIF(NDPROP.EQ.2) THEN
             AKXXE = PHYSOL(I,1,3) 
             AKYYE = PHYSOL(I,1,4) 
C
             AKXX1 = AKXXE
             AKXX2 = AKXXE
             AKXX3 = AKXXE
             AKXX4 = AKXXE
             AKXX5 = AKXXE
             AKXX6 = AKXXE
C
             AKYY1 = AKYYE
             AKYY2 = AKYYE
             AKYY3 = AKYYE
             AKYY4 = AKYYE
             AKYY5 = AKYYE
             AKYY6 = AKYYE
C
           ELSE
             AKXX1 = PHYSOL(I,1,3)   
             AKXX2 = PHYSOL(I,2,3)   
             AKXX3 = PHYSOL(I,3,3)   
             AKXX4 = PHYSOL(I,4,3)   
             AKXX5 = PHYSOL(I,5,3)   
             AKXX6 = PHYSOL(I,6,3)   
C
             AKYY1 = PHYSOL(I,1,4)   
             AKYY2 = PHYSOL(I,2,4)   
             AKYY3 = PHYSOL(I,3,4)   
             AKYY4 = PHYSOL(I,4,4)   
             AKYY5 = PHYSOL(I,5,4)   
             AKYY6 = PHYSOL(I,6,4) 
           ENDIF
C
           XK1 =   AKXX1*(6*R1+R2+R3) + AKXX4*(5*R1+2*R2+R3) 
     &           + AKXX6*(5*R1+R2+2*R3)
           YK1 =   AKYY1*(6*R1+R2+R3) + AKYY4*(5*R1+2*R2+R3)
     &           + AKYY6*(5*R1+R2+2*R3)
           XK2 =   AKXX2*(R1+6*R2+R3) + AKXX4*(2*R1+5*R2+R3) 
     &           + AKXX5*(R1+5*R2+2*R3)
           YK2 =   AKYY2*(R1+6*R2+R3) + AKYY4*(2*R1+5*R2+R3)  
     &           + AKYY5*(R1+5*R2+2*R3)
           XK3 =   AKXX3*(R1+R2+6*R3) + AKXX5*(R1+2*R2+5*R3) 
     &           + AKXX6*(2*R1+R2+5*R3)
           YK3 =   AKYY3*(R1+R2+6*R3) + AKYY5*(R1+2*R2+5*R3)  
     &           + AKYY6*(2*R1+R2+5*R3)
           XK4 =   AKXX4*(3*R1+3*R2+2*R3) + AKXX5*(2*R1+3*R2+3*R3) 
     &           + AKXX6*(3*R1+2*R2+3*R3)
           YK4 =   AKYY4*(3*R1+3*R2+2*R3) + AKYY5*(2*R1+3*R2+3*R3) 
     &           + AKYY6*(3*R1+2*R2+3*R3)
C
C
C         -> grad(Ph1) = (DX1,DY1)
          DX1 = - (COORDS(N6,2)-COORDS(N4,2))
          DY1 =   (COORDS(N6,1)-COORDS(N4,1))
C
C         -> grad(Ph2) = (DX2,DY2)
          DX2 = - (COORDS(N4,2)-COORDS(N5,2))
          DY2 =   (COORDS(N4,1)-COORDS(N5,1))
C
C         -> grad(Ph3) = (DX3,DY3)
          DX3 = - (COORDS(N5,2)-COORDS(N6,2)) 
          DY3 =   (COORDS(N5,1)-COORDS(N6,1))
C
C         Calcul des termes diagonaux
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
      WCT(I,1) = (DX1**2*XK1+DY1**2*YK1) 
      WCT(I,2) = (DX2**2*XK2+DY2**2*YK2)
      WCT(I,3) = (DX3**2*XK3+DY3**2*YK3)
      WCT(I,4) = (DX2**2*XK1+DY2**2*YK1+DX1**2*XK2+DY1**2*YK2+DX3
     &**2*XK4+DY3**2*YK4) 
      WCT(I,5) = (DX3**2*XK2+DY3**2*YK2+DX2**2*XK3+DY2**2*YK3+DX1
     &**2*XK4+DY1**2*YK4) 
      WCT(I,6) = (DX3**2*XK1+DY3**2*YK1+DX1**2*XK3+DY1**2*YK3+DX2
     &**2*XK4+DY2**2*YK4) 
C
C         Calcul des termes extra-diagonaux
C         ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
       XMAT(I,1) = (DX1*DX2*XK1+DY1*DY2*YK1) 
       XMAT(I,2) = (DX1*DX3*XK1+DY1*DY3*YK1) 
C
       XMAT(I,3) = (DX2*DX1*XK2+DY2*DY1*YK2)  
       XMAT(I,4) = (DX2*DX3*XK2+DY2*DY3*YK2)
C
       XMAT(I,5) = (DX3*DX2*XK3+DY3*DY2*YK3) 
       XMAT(I,6) = (DX3*DX1*XK3+DY3*DY1*YK3)
C
       XMAT(I,7)= (DX1*DX3*XK2+DY1*DY3*YK2+DX3*DX1*XK4+DY3*DY1*YK4) 
       XMAT(I,8)= (DX2*DX3*XK1+DY2*DY3*YK1+DX3*DX2*XK4+DY3*DY2*YK4)  
C
       XMAT(I,9)= (DX2*DX1*XK3+DY2*DY1*YK3+DX1*DX2*XK4+DY1*DY2*YK4)  
C
  120   CONTINUE
C
C
C
        ENDIF
C
C
C
C     2- CAS TRIDIMENSIONNEL
C     ======================
      ELSE
C     
C
         DO 200 I=1,NELEMS
C
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
           N7 = NODES(I,7)
           N8 = NODES(I,8)
           N9 = NODES(I,9)
           N10 = NODES(I,10)
C
C   
           IF(NDPROP.EQ.1) THEN
             AKXX1  =  PHYSOL(N1,1,3)
             AKXX2  =  PHYSOL(N2,1,3)
             AKXX3  =  PHYSOL(N3,1,3)
             AKXX4  =  PHYSOL(N4,1,3)
             AKXX5  =  PHYSOL(N5,1,3)
             AKXX6  =  PHYSOL(N6,1,3)
             AKXX7  =  PHYSOL(N7,1,3)
             AKXX8  =  PHYSOL(N8,1,3)
             AKXX9  =  PHYSOL(N9,1,3)
             AKXX10 =  PHYSOL(N10,1,3)
C
             AKYY1  =  PHYSOL(N1,1,4)
             AKYY2  =  PHYSOL(N2,1,4)
             AKYY3  =  PHYSOL(N3,1,4)
             AKYY4  =  PHYSOL(N4,1,4)
             AKYY5  =  PHYSOL(N5,1,4)
             AKYY6  =  PHYSOL(N6,1,4)
             AKYY7  =  PHYSOL(N7,1,4)
             AKYY8  =  PHYSOL(N8,1,4)
             AKYY9  =  PHYSOL(N9,1,4)
             AKYY10 =  PHYSOL(N10,1,4)
C
             AKZZ1  =  PHYSOL(N1,1,5)
             AKZZ2  =  PHYSOL(N2,1,5)
             AKZZ3  =  PHYSOL(N3,1,5)
             AKZZ4  =  PHYSOL(N4,1,5)
             AKZZ5  =  PHYSOL(N5,1,5)
             AKZZ6  =  PHYSOL(N6,1,5)
             AKZZ7  =  PHYSOL(N7,1,5)
             AKZZ8  =  PHYSOL(N8,1,5)
             AKZZ9  =  PHYSOL(N9,1,5)
             AKZZ10 =  PHYSOL(N10,1,5)
C
          ELSEIF(NDPROP.EQ.2) THEN
             AKXXE  =  PHYSOL(I,1,3)
             AKYYE  =  PHYSOL(I,1,4)
             AKZZE  =  PHYSOL(I,1,5)
C
             AKXX1  =  AKXXE
             AKXX2  =  AKXXE
             AKXX3  =  AKXXE
             AKXX4  =  AKXXE
             AKXX5  =  AKXXE
             AKXX6  =  AKXXE
             AKXX7  =  AKXXE
             AKXX8  =  AKXXE
             AKXX9  =  AKXXE
             AKXX10 =  AKXXE
C
             AKYY1  =  AKYYE
             AKYY2  =  AKYYE
             AKYY3  =  AKYYE
             AKYY4  =  AKYYE
             AKYY5  =  AKYYE
             AKYY6  =  AKYYE
             AKYY7  =  AKYYE
             AKYY8  =  AKYYE
             AKYY9  =  AKYYE
             AKYY10 =  AKYYE
C
             AKZZ1  =  AKZZE
             AKZZ2  =  AKZZE
             AKZZ3  =  AKZZE
             AKZZ4  =  AKZZE
             AKZZ5  =  AKZZE
             AKZZ6  =  AKZZE
             AKZZ7  =  AKZZE
             AKZZ8  =  AKZZE
             AKZZ9  =  AKZZE
             AKZZ10 =  AKZZE
          ELSE
             AKXX1  =  PHYSOL(I,1,3)
             AKXX2  =  PHYSOL(I,2,3)
             AKXX3  =  PHYSOL(I,3,3)
             AKXX4  =  PHYSOL(I,4,3)
             AKXX5  =  PHYSOL(I,5,3)
             AKXX6  =  PHYSOL(I,6,3)
             AKXX7  =  PHYSOL(I,7,3)
             AKXX8  =  PHYSOL(I,8,3)
             AKXX9  =  PHYSOL(I,9,3)
             AKXX10 =  PHYSOL(I,10,3)
C
             AKYY1  =  PHYSOL(I,1,4)
             AKYY2  =  PHYSOL(I,2,4)
             AKYY3  =  PHYSOL(I,3,4)
             AKYY4  =  PHYSOL(I,4,4)
             AKYY5  =  PHYSOL(I,5,4)
             AKYY6  =  PHYSOL(I,6,4)
             AKYY7  =  PHYSOL(I,7,4)
             AKYY8  =  PHYSOL(I,8,4)
             AKYY9  =  PHYSOL(I,9,4)
             AKYY10 =  PHYSOL(I,10,4)
C
             AKZZ1  =  PHYSOL(I,1,5)
             AKZZ2  =  PHYSOL(I,2,5)
             AKZZ3  =  PHYSOL(I,3,5)
             AKZZ4  =  PHYSOL(I,4,5)
             AKZZ5  =  PHYSOL(I,5,5)
             AKZZ6  =  PHYSOL(I,6,5)
             AKZZ7  =  PHYSOL(I,7,5)
             AKZZ8  =  PHYSOL(I,8,5)
             AKZZ9  =  PHYSOL(I,9,5)
             AKZZ10 =  PHYSOL(I,10,5)
          ENDIF
C
           XK1 = AKXX1 + AKXX5 + AKXX7 + AKXX8
           YK1 = AKYY1 + AKYY5 + AKYY7 + AKYY8
           ZK1 = AKZZ1 + AKZZ5 + AKZZ7 + AKZZ8
C
           XK2 = AKXX2 + AKXX5 + AKXX6 + AKXX9
           YK2 = AKYY2 + AKYY5 + AKYY6 + AKYY9
           ZK2 = AKZZ2 + AKZZ5 + AKZZ6 + AKZZ9
C
           XK3 = AKXX3 + AKXX6 + AKXX7 + AKXX10
           YK3 = AKYY3 + AKYY6 + AKYY7 + AKYY10
           ZK3 = AKZZ3 + AKZZ6 + AKZZ7 + AKZZ10
C
           XK4 = AKXX4 + AKXX8 + AKXX9 + AKXX10
           YK4 = AKYY4 + AKYY8 + AKYY9 + AKYY10
           ZK4 = AKZZ4 + AKZZ8 + AKZZ9 + AKZZ10
C
           XK5 = AKXX5 + AKXX6 + AKXX7 + AKXX8
           YK5 = AKYY5 + AKYY6 + AKYY7 + AKYY8
           ZK5 = AKZZ5 + AKZZ6 + AKZZ7 + AKZZ8
C
           XK6 = AKXX5 + AKXX6 + AKXX8 + AKXX9
           YK6 = AKYY5 + AKYY6 + AKYY8 + AKYY9
           ZK6 = AKZZ5 + AKZZ6 + AKZZ8 + AKZZ9
C
           XK7 = AKXX6 + AKXX7 + AKXX8 + AKXX10
           YK7 = AKYY6 + AKYY7 + AKYY8 + AKYY10
           ZK7 = AKZZ6 + AKZZ7 + AKZZ8 + AKZZ10
C
           XK8 = AKXX6 + AKXX8 + AKXX9 + AKXX10
           YK8 = AKYY6 + AKYY8 + AKYY9 + AKYY10
           ZK8 = AKZZ6 + AKZZ8 + AKZZ9 + AKZZ10
C
          COEFF = S18 / VOLUME(I)
C
          X75 = COORDS(N5,1) - COORDS(N7,1)
          Y75 = COORDS(N5,2) - COORDS(N7,2)
          Z75 = COORDS(N5,3) - COORDS(N7,3)
C
          X78 = COORDS(N8,1) - COORDS(N7,1)
          Y78 = COORDS(N8,2) - COORDS(N7,2)
          Z78 = COORDS(N8,3) - COORDS(N7,3)
C
          X69 = COORDS(N9,1) - COORDS(N6,1)
          Y69 = COORDS(N9,2) - COORDS(N6,2)
          Z69 = COORDS(N9,3) - COORDS(N6,3)
C
          X65 = COORDS(N5,1) - COORDS(N6,1)
          Y65 = COORDS(N5,2) - COORDS(N6,2)
          Z65 = COORDS(N5,3) - COORDS(N6,3)
C
          X710= COORDS(N10,1) - COORDS(N7,1)
          Y710= COORDS(N10,2) - COORDS(N7,2)
          Z710= COORDS(N10,3) - COORDS(N7,3)
C
          X76 = COORDS(N6,1) - COORDS(N7,1)
          Y76 = COORDS(N6,2) - COORDS(N7,2)
          Z76 = COORDS(N6,3) - COORDS(N7,3)
C
          X89 = COORDS(N9,1) - COORDS(N8,1)
          Y89 = COORDS(N9,2) - COORDS(N8,2)
          Z89 = COORDS(N9,3) - COORDS(N8,3)
C
          X810= COORDS(N10,1) - COORDS(N8,1)
          Y810= COORDS(N10,2) - COORDS(N8,2)
          Z810= COORDS(N10,3) - COORDS(N8,3)
C
          DX1 =   (Y75*Z78 - Z75*Y78)
          DY1 = - (X75*Z78 - Z75*X78)
          DZ1 =   (X75*Y78 - Y75*X78)
C
          DX2 =   (Y69*Z65 - Z69*Y65)
          DY2 = - (X69*Z65 - Z69*X65)
          DZ2 =   (X69*Y65 - Y69*X65)
C
          DX3 =   (Y710*Z76 - Z710*Y76)
          DY3 = - (X710*Z76 - Z710*X76)
          DZ3 =   (X710*Y76 - Y710*X76)
C
          DX4 =   (Y89*Z810 - Z89*Y810)
          DY4 = - (X89*Z810 - Z89*X810)
          DZ4 =   (X89*Y810 - Y89*X810)
C
C
C          Calcul des termes diagonaux
C          ---------------------------
C
      WCT(I,1) = COEFF*(DX1**2*XK1+DY1**2*YK1+DZ1**2*ZK1)                       
      WCT(I,2) = COEFF*(DX2**2*XK2+DY2**2*YK2+DZ2**2*ZK2)                      
      WCT(I,3) = COEFF*(DX3**2*XK3+DY3**2*YK3+DZ3**2*ZK3)                  
      WCT(I,4) = COEFF*(DX4**2*XK4+DY4**2*YK4+DZ4**2*ZK4)              
      WCT(I,5) = COEFF*(DX2**2*XK1+DY2**2*YK1+DZ2**2*ZK1+DX1**2*XK2+DY1
     &**2*YK2+DZ1**2*ZK2+(DX1+DX2)**2*XK5+(DY1+DY2)**2*YK5+(DZ1+DZ2)**2*
     &ZK5+(DX1+DX2)**2*XK6+(DY1+DY2)**2*YK6+(DZ1+DZ2)**2*ZK6)      
      WCT(I,6) = COEFF*(DX3**2*XK2+DY3**2*YK2+DZ3**2*ZK2+DX2**2*XK3+DY2
     &**2*YK3+DZ2**2*ZK3+DX1**2*XK5+DY1**2*YK5+DZ1**2*ZK5+DX3**2*XK6+DY3
     &**2*YK6+DZ3**2*ZK6+DX2**2*XK7+DY2**2*YK7+DZ2**2*ZK7+DX4**2*XK8+DY4
     &**2*YK8+DZ4**2*ZK8)
      WCT(I,7) = COEFF*(DX3**2*XK1+DY3**2*YK1+DZ3**2*ZK1+DX1**2*XK3+DY1
     &**2*YK3+DZ1**2*ZK3+(-DX2-DX4)**2*XK5+(-DY2-DY4)**2*YK5+(-DZ2-DZ4)*
     &*2*ZK5+(-DX2-DX4)**2*XK7+(-DY2-DY4)**2*YK7+(-DZ2-DZ4)**2*ZK7)               
      WCT(I,8) = COEFF*(DX4**2*XK1+DY4**2*YK1+DZ4**2*ZK1+DX1**2*XK4+DY1
     &**2*YK4+DZ1**2*ZK4+DX4**2*XK5+DY4**2*YK5+DZ4**2*ZK5+DX2**2*XK6+DY2
     &**2*YK6+DZ2**2*ZK6+DX3**2*XK7+DY3**2*YK7+DZ3**2*ZK7+DX1**2*XK8+DY1
     &**2*YK8+DZ1**2*ZK8)
      WCT(I,9) = COEFF*(DX4**2*XK2+DY4**2*YK2+DZ4**2*ZK2+DX2**2*XK4+DY2
     &**2*YK4+DZ2**2*ZK4+(-DX1-DX3)**2*XK6+(-DY1-DY3)**2*YK6+(-DZ1-DZ3)*
     &*2*ZK6+(-DX1-DX3)**2*XK8+(-DY1-DY3)**2*YK8+(-DZ1-DZ3)**2*ZK8)           
      WCT(I,10) = COEFF*(DX4**2*XK3+DY4**2*YK3+DZ4**2*ZK3+DX3**2*XK4+D
     &Y3**2*YK4+DZ3**2*ZK4+(DX3+DX4)**2*XK7+(DY3+DY4)**2*YK7+(DZ3+DZ4)**
     &2*ZK7+(DX3+DX4)**2*XK8+(DY3+DY4)**2*YK8+(DZ3+DZ4)**2*ZK8)
C
C          Calcul des termes extra-diagonaux
C          ---------------------------------
C  
      XMAT(I,1) = COEFF*(DX1*DX2*XK1+DY1*DY2*YK1+DZ1*DZ2*ZK1)                              
      XMAT(I,2) = COEFF*(DX1*DX3*XK1+DY1*DY3*YK1+DZ1*DZ3*ZK1)                                   
      XMAT(I,3) = COEFF*(DX1*DX4*XK1+DY1*DY4*YK1+DZ1*DZ4*ZK1)                               
C
      XMAT(I,4) = COEFF*(DX2*DX1*XK2+DY2*DY1*YK2+DZ2*DZ1*ZK2)                                
      XMAT(I,5) = COEFF*(DX2*DX3*XK2+DY2*DY3*YK2+DZ2*DZ3*ZK2)                                   
      XMAT(I,6) = COEFF*(DX2*DX4*XK2+DY2*DY4*YK2+DZ2*DZ4*ZK2)                         
C
      XMAT(I,7) = COEFF*(DX3*DX2*XK3+DY3*DY2*YK3+DZ3*DZ2*ZK3)                            
      XMAT(I,8) = COEFF*(DX3*DX1*XK3+DY3*DY1*YK3+DZ3*DZ1*ZK3)                          
      XMAT(I,9) = COEFF*(DX3*DX4*XK3+DY3*DY4*YK3+DZ3*DZ4*ZK3)                              
C
      XMAT(I,10) = COEFF*(DX4*DX1*XK4+DY4*DY1*YK4+DZ4*DZ1*ZK4)                            
      XMAT(I,11) = COEFF*(DX4*DX2*XK4+DY4*DY2*YK4+DZ4*DZ2*ZK4)                           
      XMAT(I,12) = COEFF*(DX4*DX3*XK4+DY4*DY3*YK4+DZ4*DZ3*ZK4)                       
C
      XMAT(I,13) =COEFF*(DX1*DX3*XK2+DY1*DY3*YK2+DZ1*DZ3*ZK2-(DX1+DX2)*D
     &X1*XK5-(DY1+DY2)*DY1*YK5-(DZ1+DZ2)*DZ1*ZK5+(DX1+DX2)*DX3*XK6+(DY1+
     &DY2)*DY3*YK6+(DZ1+DZ2)*DZ3*ZK6) 
      XMAT(I,14) =COEFF*(DX2*DX3*XK1+DY2*DY3*YK1+DZ2*DZ3*ZK1+(DX1+DX2)*(
     &-DX2-DX4)*XK5+(DY1+DY2)*(-DY2-DY4)*YK5+(DZ1+DZ2)*(-DZ2-DZ4)*ZK5)          
      XMAT(I,15) =COEFF*(DX2*DX4*XK1+DY2*DY4*YK1+DZ2*DZ4*ZK1+(DX1+DX2)*D
     &X4*XK5+(DY1+DY2)*DY4*YK5+(DZ1+DZ2)*DZ4*ZK5-(DX1+DX2)*DX2*XK6-(DY1+
     &DY2)*DY2*YK6-(DZ1+DZ2)*DZ2*ZK6) 
      XMAT(I,16) =COEFF*(DX1*DX4*XK2+DY1*DY4*YK2+DZ1*DZ4*ZK2+(DX1+DX2)*(
     &-DX1-DX3)*XK6+(DY1+DY2)*(-DY1-DY3)*YK6+(DZ1+DZ2)*(-DZ1-DZ3)*ZK6)
C
      XMAT(I,17) =COEFF*(DX2*DX1*XK3+DY2*DY1*YK3+DZ2*DZ1*ZK3-DX1*(-DX2-D
     &X4)*XK5-DY1*(-DY2-DY4)*YK5-DZ1*(-DZ2-DZ4)*ZK5+DX2*(-DX2-DX4)*XK7+D
     &Y2*(-DY2-DY4)*YK7+DZ2*(-DZ2-DZ4)*ZK7)     
      XMAT(I,18) =COEFF*(-DX1*DX4*XK5-DY1*DY4*YK5-DZ1*DZ4*ZK5-DX3*DX2*XK
     &6-DY3*DY2*YK6-DZ3*DZ2*ZK6-DX2*DX3*XK7-DY2*DY3*YK7-DZ2*DZ3*ZK7-DX4*
     &DX1*XK8-DY4*DY1*YK8-DZ4*DZ1*ZK8)   
      XMAT(I,19) =COEFF*(DX3*DX4*XK2+DY3*DY4*YK2+DZ3*DZ4*ZK2+DX3*(-DX1-D
     &X3)*XK6+DY3*(-DY1-DY3)*YK6+DZ3*(-DZ1-DZ3)*ZK6-DX4*(-DX1-DX3)*XK8-D
     &Y4*(-DY1-DY3)*YK8-DZ4*(-DZ1-DZ3)*ZK8)  
      XMAT(I,20) = COEFF*(DX2*DX4*XK3+DY2*DY4*YK3+DZ2*DZ4*ZK3+DX2*(DX3+D
     &X4)*XK7+DY2*(DY3+DY4)*YK7+DZ2*(DZ3+DZ4)*ZK7-DX4*(DX3+DX4)*XK8-DY4*
     &(DY3+DY4)*YK8-DZ4*(DZ3+DZ4)*ZK8)  
C
      XMAT(I,21) =COEFF*(DX3*DX4*XK1+DY3*DY4*YK1+DZ3*DZ4*ZK1+(-DX2-DX4)*
     &DX4*XK5+(-DY2-DY4)*DY4*YK5+(-DZ2-DZ4)*DZ4*ZK5-(-DX2-DX4)*DX3*XK7-(
     &-DY2-DY4)*DY3*YK7-(-DZ2-DZ4)*DZ3*ZK7)  
      XMAT(I,22) = COEFF*(DX1*DX4*XK3+DY1*DY4*YK3+DZ1*DZ4*ZK3+(-DX2-DX4)
     &*(DX3+DX4)*XK7+(-DY2-DY4)*(DY3+DY4)*YK7+(-DZ2-DZ4)*(DZ3+DZ4)*ZK7)                
C
      XMAT(I,23) =COEFF*(DX1*DX2*XK4+DY1*DY2*YK4+DZ1*DZ2*ZK4-DX2*(-DX1-D
     &X3)*XK6-DY2*(-DY1-DY3)*YK6-DZ2*(-DZ1-DZ3)*ZK6+DX1*(-DX1-DX3)*XK8+D
     &Y1*(-DY1-DY3)*YK8+DZ1*(-DZ1-DZ3)*ZK8)     
      XMAT(I,24) = COEFF*(DX1*DX3*XK4+DY1*DY3*YK4+DZ1*DZ3*ZK4-DX3*(DX3+D
     &X4)*XK7-DY3*(DY3+DY4)*YK7-DZ3*(DZ3+DZ4)*ZK7+DX1*(DX3+DX4)*XK8+DY1*
     &(DY3+DY4)*YK8+DZ1*(DZ3+DZ4)*ZK8)
C
      XMAT(I,25) = COEFF*(DX2*DX3*XK4+DY2*DY3*YK4+DZ2*DZ3*ZK4+(-DX1-DX3)
     &*(DX3+DX4)*XK8+(-DY1-DY3)*(DY3+DY4)*YK8+(-DZ1-DZ3)*(DZ3+DZ4)*ZK8)   
C
C                                                                         
  200    CONTINUE
C
C
C
      ENDIF                 
C
C-------
C FORMAT
C-------
C
      END

