C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=POSNBR,SSI=0
C
                        SUBROUTINE POSNBR
C                       *****************
C
     * ( CHAINE,IDEB,IFIN,NBB,LCH )
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   DETERMINER LA POSITION (debut,fin et longeur)           *
C              D'UN NOMBRE (entier ou reeel) DANS UNE CHAINE           *
C                                                                      *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! CHAINE !   A  ! D  ! CHAINE DS LAQUELLE ON EFFECTUE LA RECHERCHE !
C   !  IDEB  !   E  ! R  ! POSITION DU DEBUT DU 1ER REEL               !
C   !  IFIN  !   E  ! R  ! POSITION DE FINUDU DERNIER REEL             !
C   !   LCH  !   E  ! R  ! LONGUEUR DE LA CHAINE CONTENANT LES NB REELS!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
C
C**********************************************************************
C
C..Variables externes
      CHARACTER CHAINE*(*)
      INTEGER IDEB,IFIN,LCH,NBB
C
C..Variables internes
      CHARACTER CC
      INTEGER I
      LOGICAL LENT
C
C**********************************************************************
C
C
      I = 1
      IDEB = 0
      IFIN = 0 
      LCH  = 0
      NBB  = 0
      LENT = .FALSE.
C
C
   10 CONTINUE
C
      READ(CHAINE(I:I),1000,ERR=99,END=99) CC
      IF (.NOT.LENT .AND. CHAINE (I:I) .EQ. ' ' ) THEN
         NBB = NBB + 1
      ELSEIF (.NOT.LENT .AND. CHAINE (I:I) .NE. ' ' ) THEN
         IDEB = I
         LENT = .TRUE.
      ELSEIF ( LENT .AND. CHAINE (I:I) .EQ. ' ' ) THEN
         LENT = .FALSE.
         IFIN = I-1
         LCH = IFIN - IDEB + 1
         RETURN
      ENDIF
C
      I = I+1
      GOTO 10
C
C   
   99 CONTINUE
      IFIN = I-1
      LCH = IFIN - IDEB + 1
C
C--------
C FORMATS
C--------
 1000 FORMAT(A1)
C----
C FIN
C----
C
      RETURN
      END
