C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                        SUBROUTINE WIEBEL
C                       *****************
C
C      -----
     * (V,W)
C      -----
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            CALCUL DES PONDERATIONS DE WIEBELT                        *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
C***********************************************************************
C
C.. Variables externes
      DOUBLE PRECISION V,W
C
C.. Variables internes
      INTEGER M
      DOUBLE PRECISION PI4,Z0,Z1,Z2,Z4,Z6,Z8,V2,V4
C
C***********************************************************************
C
      DATA PI4 / .153989717364E+00 /
      DATA  Z0 / .333333343267E+00 /
      DATA  Z1 / .125000000000E+00 /
      DATA  Z2 / .166666675359E-01 /
      DATA  Z4 / .198412701138E-03 /
      DATA  Z6 / .367430925508E-05 /
      DATA  Z8 / .751563220547E-07 /
C
C
      IF (V .GE. 2.) THEN
         W = 0
         DO 100 M=1,5
           W = W + EXP(-M*V)/(M*M*M*M) * (((M*V+3)*M*V+6)*M*V+6)
  100    CONTINUE
         W = W * PI4
      ELSE
         V2 = V*V
         V4 = V2*V2
         W = Z0 - Z1*V + Z2*V2 - Z4*V2*V2 + Z6*V4*V2 - Z8*V4*V4
         W = 1. - PI4*V2*V*W
      ENDIF
C

C--------
C FORMATS
C-------- 
C
C
C----
C FIN
C----
      END


