/*
    Copyright (C) 2001-2002  bjk <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <paths.h>
#include "common.h"

#define CTIME 0
#define ATIME 1

static char *mailstat(INFO *info, int actime)
{
    char filename[FILENAME_MAX];
    char *tmp = NULL;
    struct stat mystat;

    filename[0] = 0;

    snprintf(filename, sizeof(filename), "%s/%s", _PATH_MAILDIR,
	    info->passwd->pw_name);

    if (stat(filename, &mystat) != 0) 
	return UNKNOWN;

    if (mystat.st_size == 0)
	return NONE;

    if (actime == CTIME) 
	tmp = stamp(mystat.st_ctime, tf);
    else
	tmp = stamp(mystat.st_atime, tf);

    return tmp;
}

static void aliases(INFO *info)
{
    char buf[LINE_MAX], *t;
    static int firstrun;

    if (!aliasfp && firstrun)
	return;

    if (!aliasfp) {
	firstrun = 1;

	if ((aliasfp = fopen(ALIAS_FILE, "r")) == NULL) {
            strncpy(info->mail->aliases, UNKNOWN, 
		    sizeof(info->mail->aliases));

	    return;
	}
    }

    if (!aliasfp) {
        strncpy(info->mail->aliases, UNKNOWN, sizeof(info->mail->aliases));
	return;
    }
    else 
	rewind(aliasfp);

    while ((t = fgets(buf, sizeof(buf), aliasfp)) != NULL) {
	char *last, *name, *tmp;

	if (buf[0] == '\n' || buf[0] == '#')
	    continue;

	if ((name = strtok_r(buf, ":", &last)) == NULL)
	    continue;

	if (strncmp(info->passwd->pw_name, name, strlen(info->passwd->pw_name))
	       	== 0) {
	    while ((tmp = strtok(last, ",")) != NULL) {
	        tmp = stripstr(tmp, " \n\t"); 
		
		strncat(info->mail->aliases, tmp,  
			sizeof(info->mail->aliases));
		strncat(info->mail->aliases, ",",  
			sizeof(info->mail->aliases));

		last = NULL;
		free(tmp);
	    }

	    continue;
	}

	while ((tmp = strtok(last, ",")) != NULL) {
	    tmp = stripstr(tmp, " \n\t"); 

	    if (strncmp(info->passwd->pw_name, tmp,
			strlen(info->passwd->pw_name)) == 0) {
		strncat(info->mail->aliases, name,  
			sizeof(info->mail->aliases));
		strncat(info->mail->aliases, ",",  
			sizeof(info->mail->aliases));
	    }

	    last = NULL;
	    free(tmp);
	}
    }

    if (info->mail->aliases[0] == 0)
	strncpy(info->mail->aliases, NONE, sizeof(info->mail->aliases));
    else
	info->mail->aliases[strlen(info->mail->aliases) - 1] = 0;

    return;
}

static char *foldersize(INFO *info)
{
    char filename[FILENAME_MAX];
    struct stat mystat;

    filename[0] = 0;

    snprintf(filename, sizeof(filename), "%s/%s", _PATH_MAILDIR, 
	    info->passwd->pw_name);

    if (stat(filename, &mystat) == -1)
	return UNKNOWN;
    else if(mystat.st_size == 0)
	return NONE;

    return itoa(mystat.st_size);
}

static char *forwardaddr(INFO *info)
{
    FILE *fp;
    char *str, tmp[sizeof(info->mail->forward)], filename[FILENAME_MAX];
    char buf[LINE_MAX], *t;
    int n = 0;
    struct stat mystat;

    snprintf(filename, sizeof(filename), "%s/.forward", info->passwd->pw_dir);
    
    if (stat(filename, &mystat) != 0) {
	if (errno == ENOENT)
	    return NONE;
	else
	    return UNKNOWN;
    }

    if (mystat.st_size == 0)
	return NONE;

    if ((fp = fopen(filename, "r")) == NULL) 
	return UNKNOWN;

    tmp[0] = 0;
    str = NULL;

    while ((t = fgets(buf, sizeof(buf), fp)) != NULL) {
	char *line;

	if (buf[0] == '\n')
	    continue;

	if (n)
	    strncat(tmp, ",", sizeof(tmp));

	line = stripstr(buf, "\n");
	strncat(tmp, line, sizeof(tmp));

	n++;
	free(line);
    }

    fclose(fp);
    str = tmp;

    return str;
}

void mailinfo(INFO *info, const char *arg)
{
    int i;

    if ((info->mail = (MAIL *) malloc(sizeof(MAIL))) == NULL) {
	perror("malloc");
	exit(errno);
    }

    bzero(info->mail, sizeof(MAIL));

    for (i = 0; i < ARRAYCNT(optspec); i++) {
	if (optspec[i] == 0)
	    break;

	switch (optspec[i]) {
	    case 'o':
		strncat(info->mail->forward, forwardaddr(info),
			sizeof(info->mail->forward));
		break;
	    case 'z':
		strncpy(info->mail->foldersize, foldersize(info), 
			sizeof(info->mail->foldersize));
		break;
	    case 'r':
		strncpy(info->mail->lastread, mailstat(info, ATIME),
			sizeof(info->mail->lastread));
		break;
	    case 'w':
		strncpy(info->mail->newstamp, mailstat(info, CTIME),
			sizeof(info->mail->newstamp));
		break;
	    case 'a':
		aliases(info);
		break;
	    default:
		break;
	}
    }

    return;
}
