/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Quartic;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class QuadricObject
extends ConstructionObject
implements PointonObject,
MoveableObject {
    PointObject[] P;
    static Count N = new Count();
    double[] X;
    public static String[] Tags = new String[]{"x^2", "y^2", "x", "y", "xy"};
    double[] xd;
    double[] yd;
    double x1;
    double y1;

    public QuadricObject(Construction construction, PointObject[] pointObjectArray) {
        super(construction);
        this.P = pointObjectArray;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Quadric";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        try {
            String[] stringArray = new String[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                stringArray[i] = this.P[i].getName();
            }
            this.setText(QuadricObject.textAny(Zirkel.name("text.quadric"), stringArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validate() {
        int n;
        int n2;
        int n3;
        double d2;
        int n4;
        for (int i = 0; i < this.P.length; ++i) {
            if (this.P[i].valid()) continue;
            this.Valid = false;
            return;
        }
        this.Valid = true;
        double[][] dArray = new double[5][6];
        for (n4 = 0; n4 < 5; ++n4) {
            int n5;
            double d3 = this.P[n4].getX();
            d2 = this.P[n4].getY();
            dArray[n4][0] = d3 * d3;
            dArray[n4][1] = d2 * d2;
            dArray[n4][2] = d3;
            dArray[n4][3] = d2;
            dArray[n4][4] = d3 * d2;
            dArray[n4][5] = 1.0;
            double d4 = 0.0;
            for (n5 = 0; n5 < 6; ++n5) {
                d4 += dArray[n4][n5] * dArray[n4][n5];
            }
            d4 = Math.sqrt(d4);
            n5 = 0;
            while (n5 < 6) {
                double[] dArray2 = dArray[n4];
                int n6 = n5++;
                dArray2[n6] = dArray2[n6] / d4;
            }
        }
        n4 = 0;
        int[] nArray = new int[6];
        for (n3 = 0; n3 < 6; ++n3) {
            if (n4 >= 5) {
                nArray[n3] = -1;
                continue;
            }
            d2 = Math.abs(dArray[n4][n3]);
            int n7 = n4;
            for (n2 = n4 + 1; n2 < 5; ++n2) {
                double d5 = Math.abs(dArray[n2][n3]);
                if (!(d5 > d2)) continue;
                d2 = d5;
                n7 = n2;
            }
            if (d2 > 1.0E-13) {
                if (n7 != n4) {
                    double[] dArray3 = dArray[n7];
                    dArray[n7] = dArray[n4];
                    dArray[n4] = dArray3;
                }
                for (n2 = n4 + 1; n2 < 5; ++n2) {
                    double d6 = dArray[n2][n3] / dArray[n4][n3];
                    for (int i = n3 + 1; i < 6; ++i) {
                        double[] dArray4 = dArray[n2];
                        int n8 = i;
                        dArray4[n8] = dArray4[n8] - d6 * dArray[n4][i];
                    }
                }
                nArray[n3] = n4++;
                continue;
            }
            nArray[n3] = -1;
        }
        this.X = new double[6];
        for (n3 = 5; n3 >= 0; --n3) {
            if (nArray[n3] < 0) {
                this.X[n3] = 1.0;
                continue;
            }
            d2 = 0.0;
            int n9 = nArray[n3];
            for (n2 = n3 + 1; n2 < 6; ++n2) {
                d2 += dArray[n9][n2] * this.X[n2];
            }
            this.X[n3] = -d2 / dArray[n9][n3];
        }
        double d7 = 0.0;
        for (n = 0; n <= 5; ++n) {
            d7 += Math.abs(this.X[n]);
        }
        if (d7 < 1.0E-10) {
            this.Valid = false;
        }
        n = 0;
        while (n <= 5) {
            int n10 = n++;
            this.X[n10] = this.X[n10] / d7;
        }
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        int n;
        int n2;
        double d2;
        double d3;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        myGraphics.setColor(this);
        double d4 = zirkelCanvas.maxX();
        double d5 = zirkelCanvas.dx(1);
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 20;
        int n6 = 20;
        PolygonDrawer polygonDrawer = new PolygonDrawer(myGraphics, this);
        for (d3 = d2 = zirkelCanvas.minX(); d3 <= d4; d3 += d5) {
            try {
                double d6 = this.computeLower(d3);
                n2 = (int)zirkelCanvas.col(d3);
                n = (int)zirkelCanvas.row(d6);
                if (bl) {
                    polygonDrawer.drawTo(n2, n);
                    if (!bl2 && n4 - n > n2 - n3 && zirkelCanvas.isInside(d3, d6)) {
                        n5 = n2;
                        n6 = n;
                        bl2 = true;
                    }
                } else {
                    polygonDrawer.startPolygon(n2, n);
                }
                n3 = n2;
                n4 = n;
                bl = true;
                continue;
            }
            catch (RuntimeException runtimeException) {
                bl = false;
            }
        }
        polygonDrawer.finishPolygon();
        bl = false;
        for (d3 = d2 - 2.0 * d5; d3 <= d4 + 2.0 * d5; d3 += d5) {
            try {
                double d7 = this.computeUpper(d3);
                n2 = (int)zirkelCanvas.col(d3);
                n = (int)zirkelCanvas.row(d7);
                if (bl) {
                    polygonDrawer.drawTo(n2, n);
                    if (!bl2 && n4 - n > n2 - n3 && zirkelCanvas.isInside(d3, d7)) {
                        n5 = n2;
                        n6 = n;
                        bl2 = true;
                    }
                } else {
                    try {
                        double d8 = this.computeLower(d3);
                        if (d3 >= d2 - d5 && d3 <= d4 + d5) {
                            myGraphics.drawLine(n2, zirkelCanvas.row(d8), n2, n, this);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    polygonDrawer.startPolygon(n2, n);
                }
                n3 = n2;
                n4 = n;
                bl = true;
                continue;
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    try {
                        double d9 = this.computeLower(d3 - d5);
                        if (d3 - d5 >= d2 - d5 && d3 - d5 <= d4 + d5) {
                            myGraphics.drawLine(n3, zirkelCanvas.row(d9), n3, n4, this);
                        }
                    }
                    catch (RuntimeException runtimeException2) {
                        // empty catch block
                    }
                }
                bl = false;
            }
        }
        polygonDrawer.finishPolygon();
        String string = this.getDisplayText();
        if (!string.equals("")) {
            myGraphics.setLabelColor(this);
            this.setFont(myGraphics);
            this.DisplaysText = true;
            this.TX1 = (double)n5 + zirkelCanvas.col(this.XcOffset) - zirkelCanvas.col(0.0);
            this.TY1 = (double)n6 + zirkelCanvas.row(this.YcOffset) - zirkelCanvas.row(0.0);
            this.drawLabel(myGraphics, string);
        }
    }

    public String getDisplayValue() {
        String string = "";
        for (int i = 0; i < 5; ++i) {
            string = string + this.helpDisplayValue(i == 0, -this.X[i], Tags[i]);
        }
        return string + "=" + this.roundDisplay(this.X[5]);
    }

    public String getEquation() {
        return this.getDisplayValue();
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        double d2;
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        int n3 = (int)zirkelCanvas.selectionSize();
        double d3 = zirkelCanvas.maxX();
        double d4 = zirkelCanvas.dx(1);
        for (double d5 = d2 = zirkelCanvas.minX(); d5 <= d3; d5 += d4) {
            double d6;
            double d7;
            double d8;
            try {
                d8 = this.computeUpper(d5);
                d7 = zirkelCanvas.col(d5);
                d6 = zirkelCanvas.row(d8);
                if (Math.abs((double)n - d7) <= (double)(n3 * 3 / 2) && Math.abs((double)n2 - d6) <= (double)(n3 * 3 / 2)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                d8 = this.computeLower(d5);
                d7 = zirkelCanvas.col(d5);
                d6 = zirkelCanvas.row(d8);
                if (!(Math.abs((double)n - d7) <= (double)(n3 * 3 / 2)) || !(Math.abs((double)n2 - d6) <= (double)(n3 * 3 / 2))) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        ObjectEditDialog objectEditDialog = new ObjectEditDialog(zirkelCanvas.getFrame(), "", this);
        objectEditDialog.setVisible(true);
        zirkelCanvas.repaint();
        if (objectEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    double computeUpper(double d2) {
        if (Math.abs(this.X[1]) > 1.0E-13) {
            double d3 = (this.X[3] + d2 * this.X[4]) / this.X[1];
            double d4 = (this.X[0] * d2 * d2 + this.X[2] * d2 + this.X[5]) / this.X[1];
            double d5 = d3 * d3 / 4.0 - d4;
            if (d5 < 0.0) {
                throw new RuntimeException("");
            }
            return -d3 / 2.0 + Math.sqrt(d5);
        }
        return -(this.X[0] * d2 * d2 + this.X[2] * d2 + this.X[5]) / (this.X[3] + this.X[4] * d2);
    }

    double computeLower(double d2) {
        if (Math.abs(this.X[1]) > 1.0E-13) {
            double d3 = (this.X[3] + d2 * this.X[4]) / this.X[1];
            double d4 = (this.X[0] * d2 * d2 + this.X[2] * d2 + this.X[5]) / this.X[1];
            double d5 = d3 * d3 / 4.0 - d4;
            if (d5 < 0.0) {
                throw new RuntimeException("");
            }
            return -d3 / 2.0 - Math.sqrt(d5);
        }
        throw new RuntimeException("");
    }

    public void printArgs(XmlWriter xmlWriter) {
        for (int i = 0; i < this.P.length; ++i) {
            xmlWriter.printArg("point" + (i + 1), this.P[i].getName());
        }
    }

    public Enumeration depending() {
        DL.reset();
        for (int i = 0; i < this.P.length; ++i) {
            DL.add(this.P[i]);
        }
        return DL.elements();
    }

    public void translate() {
        for (int i = 0; i < this.P.length; ++i) {
            this.P[i] = (PointObject)this.P[i].getTranslation();
        }
    }

    public ConstructionObject copy() {
        try {
            QuadricObject quadricObject = (QuadricObject)this.clone();
            this.setTranslation(quadricObject);
            quadricObject.P = new PointObject[this.P.length];
            for (int i = 0; i < this.P.length; ++i) {
                quadricObject.P[i] = this.P[i];
            }
            quadricObject.translateConditionals();
            quadricObject.translate();
            quadricObject.setName();
            quadricObject.updateText();
            quadricObject.setBreak(false);
            quadricObject.setTarget(false);
            return quadricObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return false;
    }

    public boolean equals(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof QuadricObject) || !constructionObject.valid()) {
            return false;
        }
        try {
            for (int i = 0; i < 6; ++i) {
                if (this.equals(this.X[i], ((QuadricObject)constructionObject).X[i])) continue;
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    public boolean hasUnit() {
        return false;
    }

    public void project(PointObject pointObject) {
        double d2;
        double d3 = this.X[0];
        double d4 = this.X[1];
        double d5 = this.X[2];
        double d6 = this.X[3];
        double d7 = this.X[4];
        double d8 = this.X[5];
        double d9 = pointObject.getX();
        if (Math.abs(d3 * d9 * d9 + d4 * (d2 = pointObject.getY()) * d2 + d5 * d9 + d6 * d2 + d7 * d9 * d2 + d8) < 1.0E-13) {
            return;
        }
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        dArray[0] = d3 * d7 * d7 * d6 * d6 - 4.0 * d3 * d4 * d4 * d5 * d5 + 4.0 * d3 * d7 * d6 * d4 * d5 - 4.0 * d4 * d3 * d3 * d6 * d6 + d4 * d5 * d5 * d7 * d7 - d5 * Math.pow(d7, 3.0) * d6 + d8 * Math.pow(d7, 4.0) - 8.0 * d8 * d7 * d7 * d4 * d3 + 16.0 * d8 * d4 * d4 * d3 * d3;
        dArray[1] = 8.0 * d4 * d4 * d5 * d5 + 8.0 * d3 * d3 * d6 * d6 - 8.0 * d7 * d6 * d4 * d5 - 8.0 * d3 * d6 * d5 * d7 + 8.0 * d8 * d7 * d7 * d4 + 8.0 * d3 * d4 * d5 * d5 + 8.0 * d4 * d3 * d6 * d6 + 8.0 * d8 * d7 * d7 * d3 - 32.0 * d8 * d4 * d4 * d3 - 32.0 * d8 * d4 * d3 * d3;
        dArray[2] = 12.0 * d7 * d6 * d5 + 16.0 * d8 * d4 * d4 - 4.0 * d4 * d6 * d6 - 8.0 * d8 * d7 * d7 + 4.0 * d7 * d7 * d6 * d2 + 16.0 * d4 * d4 * d9 * d5 - 16.0 * d4 * d5 * d5 - 16.0 * d3 * d6 * d6 - 4.0 * d3 * d5 * d5 + 16.0 * d8 * d3 * d3 + 16.0 * d3 * d3 * d6 * d2 + 4.0 * d9 * d7 * d7 * d5 - 8.0 * d7 * d6 * d4 * d9 - 8.0 * d7 * d2 * d4 * d5 - 8.0 * d3 * d6 * d9 * d7 - 8.0 * d3 * d2 * d5 * d7 + 16.0 * d3 * d4 * d4 * d9 * d9 - 4.0 * d3 * d7 * d7 * d2 * d2 + 16.0 * d4 * d3 * d3 * d2 * d2 - 4.0 * d4 * d9 * d9 * d7 * d7 + 4.0 * Math.pow(d7, 3.0) * d2 * d9 + 64.0 * d8 * d4 * d3 - 16.0 * d3 * d4 * d9 * d7 * d2;
        dArray[3] = -32.0 * d8 * d4 + 8.0 * d6 * d6 + 8.0 * d5 * d5 + 16.0 * d7 * d6 * d9 + 8.0 * d7 * d7 * d2 * d2 + 8.0 * d9 * d9 * d7 * d7 - 32.0 * d8 * d3 - 32.0 * d4 * d9 * d5 + 16.0 * d7 * d2 * d5 - 32.0 * d3 * d6 * d2 - 32.0 * d3 * d4 * d9 * d9 - 32.0 * d4 * d3 * d2 * d2;
        dArray[4] = 16.0 * d4 * d2 * d2 + 16.0 * d6 * d2 + 16.0 * d5 * d9 + 16.0 * d9 * d7 * d2 + 16.0 * d8 + 16.0 * d3 * d9 * d9;
        int n = Quartic.solve(dArray, dArray2);
        double d10 = 1.0E30;
        double d11 = d9;
        double d12 = d2;
        for (int i = 0; i < n; ++i) {
            double d13 = dArray2[i];
            double d14 = -(-d7 * d6 + 4.0 * d4 * d13 * d9 - 2.0 * d7 * d13 * d2 - 4.0 * d13 * d13 * d9 + 2.0 * d4 * d5 - 2.0 * d13 * d5) / (-d7 * d7 + 4.0 * d4 * d3 - 4.0 * d4 * d13 - 4.0 * d13 * d3 + 4.0 * d13 * d13);
            double d15 = -(2.0 * d3 * d6 + 4.0 * d3 * d13 * d2 - 2.0 * d13 * d6 - 4.0 * d13 * d13 * d2 - 2.0 * d13 * d9 * d7 - d5 * d7) / (-d7 * d7 + 4.0 * d4 * d3 - 4.0 * d4 * d13 - 4.0 * d13 * d3 + 4.0 * d13 * d13);
            double d16 = (d14 - d9) * (d14 - d9) + (d15 - d2) * (d15 - d2);
            if (!(d16 < d10)) continue;
            d10 = d16;
            d11 = d14;
            d12 = d15;
        }
        pointObject.move(d11, d12);
    }

    public void project(PointObject pointObject, double d2) {
        this.project(pointObject);
    }

    public void dragTo(double d2, double d3) {
        for (int i = 0; i < 5; ++i) {
            this.P[i].move(this.xd[i] + (d2 - this.x1), this.yd[i] + (d3 - this.y1));
        }
    }

    public void move(double d2, double d3) {
    }

    public boolean moveable() {
        for (int i = 0; i < 5; ++i) {
            if (this.P[i].moveable()) continue;
            return false;
        }
        return true;
    }

    public void startDrag(double d2, double d3) {
        if (this.xd == null) {
            this.xd = new double[5];
            this.yd = new double[5];
        }
        for (int i = 0; i < 5; ++i) {
            this.xd[i] = this.P[i].getX();
            this.yd[i] = this.P[i].getY();
        }
        this.x1 = d2;
        this.y1 = d3;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        if (this.moveable()) {
            for (int i = 0; i < 5; ++i) {
                this.P[i].snap(zirkelCanvas);
            }
        }
    }

    public boolean canInteresectWith(ConstructionObject constructionObject) {
        return true;
    }
}

