/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XMLNodeTraverser {
    private NamedNodeMap attrs;

    public void traverse(Node node) throws BadXMLException {
        if (node instanceof Element) {
            this.attrs = ((Element)node).getAttributes();
            this.handleElementAttributes(this.attrs);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.handleSubNode(node2, node2.getNodeName());
        }
        this.attrs = null;
    }

    protected void handleSubNode(Node node, String string) throws BadXMLException {
        short s2 = node.getNodeType();
        switch (s2) {
            case 1: {
                this.handleElement((Element)node, string);
                break;
            }
            case 3: {
                this.handleTextNode((Text)node, string);
                break;
            }
            default: {
                this.handleOtherNode(node, string);
            }
        }
    }

    protected void handleElementAttributes(NamedNodeMap namedNodeMap) throws BadXMLException {
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Attr attr = (Attr)namedNodeMap.item(i2);
            this.handleAttributeNode(attr, attr.getName(), attr.getValue());
        }
    }

    protected void handleElement(Element element, String string) throws BadXMLException {
        throw new BadXMLException("Unhandled Element node " + element);
    }

    protected void handleTextNode(Text text, String string) throws BadXMLException {
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws BadXMLException {
        throw new BadXMLException("Unhandled Attribute node " + attr);
    }

    protected void handleOtherNode(Node node, String string) throws BadXMLException {
        throw new BadXMLException("Unhandled Other node " + node + " type=" + node.getNodeType());
    }

    public int toInt(String string) throws BadXMLException {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad integer value " + string);
        }
    }

    public String getAttributeValue(String string) {
        if (this.attrs == null) {
            return null;
        }
        Node node = this.attrs.getNamedItem(string);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public boolean toBoolean(String string) throws BadXMLException {
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new BadXMLException("Bad boolean value " + string);
    }

    public double toDouble(String string) throws BadXMLException {
        try {
            return new Double(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad double value " + string);
        }
    }

    public static class BadXMLException
    extends Exception {
        private static final long serialVersionUID = 68032324630130555L;

        public BadXMLException() {
        }

        public BadXMLException(String string) {
            super(string);
        }
    }
}

