/* fontreq.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fontreq.cc,v 1.16 2005/08/17 06:29:36 ralf Exp $ */

#include "fontreq.h"
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/button.h>
#include <aguix/text.h>
#include <aguix/message.h>
#include <aguix/stringgadget.h>
#include <aguix/fieldlistview.h>
#include "worker_locale.h"
#include <aguix/util.h>
#include <aguix/request.h>

FontRequester::FontRequester(AGUIX *parent)
{
  int nr_of_fonts=sizeof(use_fonts)/sizeof(struct request_fonts);
  struct request_fonts *font1;
  int i;
  
  aguix=parent;
  fontlist=new List();
  for(i=0;i<nr_of_fonts;i++) {
    font1=(struct request_fonts*)_allocsafe(sizeof(struct request_fonts));
    font1->name=dupstring(use_fonts[i].name);
    font1->type=use_fonts[i].type;
    font1->xname=dupstring(use_fonts[i].xname);
    font1->size=use_fonts[i].size;
    fontlist->addElement(font1);
  }
}

FontRequester::~FontRequester()
{
  struct request_fonts *font1;
  font1=(struct request_fonts*)fontlist->getFirstElement();
  while(font1!=NULL) {
    _freesafe(font1->name);
    _freesafe(font1->xname);
    _freesafe(font1);
    fontlist->removeFirstElement();
    font1=(struct request_fonts*)fontlist->getFirstElement();
  }
  delete fontlist;
}

int FontRequester::request(char *xname,char**return_xname)
{
  char *rstr;
  int act_font=0,act_fontsize=0;
  struct request_fonts *font1;
  int id;
  char buffer[ 4 + A_BYTESFORNUMBER( int ) + 1 ];
  int i;
  int trow, trow2;
  Requester *req;
  int nr_of_sfonts=sizeof(use_fonts)/sizeof(struct request_fonts);
  int ni,nj;
  char *buttonstr;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;

  win = new AWindow( aguix, 10, 10, 10, 10, 0, catalog.getLocale( 204 ) );
  win->create();

  ac1 = win->setContainer( new AContainer( win, 1, 6 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 380 ), 1 ), 0, 0, cincwnr );

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );

  lv = (FieldListView*)ac1_1->add( new FieldListView( aguix,
						      0,
						      0,
						      aguix->getTextWidth( " " ) * 30,
						      aguix->getCharHeight() * 10,
						      0 ), 0, 0, cmin );
  lv2 = (FieldListView*)ac1_1->add( new FieldListView( aguix,
						       0,
						       0,
						       aguix->getTextWidth( " " ) * 6,
						       aguix->getCharHeight() * 10,
						       1 ), 1, 0, cmin );

  etext = (Text*)ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 382 ), 1 ), 0, 2, cincwnr );

  ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 3 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( 5 );
  ac1_2->setBorderWidth( 0 );

  ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 383 ), 1 ), 0, 0, cfix );
  ftext = (Text*)ac1_2->add( new Text( aguix, 0, 0, "", 1 ), 1, 0, cincwnr );

  xb = (Button*)ac1->add( new Button( aguix, 0, 0, catalog.getLocale( 381 ), 1, 0, 0 ), 0, 4, cincw );

  AContainer *ac1_3 = ac1->add( new AContainer( win, 2, 1 ), 0, 5 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( -1 );
  ac1_3->setBorderWidth( 0 );
  okb =(Button*)ac1_3->add( new Button( aguix,
					0,
					0,
					catalog.getLocale( 11 ),
					1,
					0,
					0 ), 0, 0, cfix );
  cb = (Button*)ac1_3->add( new Button( aguix,
					0,
					0,
					catalog.getLocale( 8 ),
					1,
					0,
					0 ), 1, 0, cfix );
  
  lv->setHBarState(2);
  lv->setVBarState(2);
  lv2->setHBarState(2);
  lv2->setVBarState(2);

  if(aguix->getFont(xname)!=NULL) {
    // search for existing entry
    if(findfont(xname,&ni,&nj)==0) {
      act_font=ni;
      act_fontsize=nj;
    } else {
      // add new font
      sprintf(buffer,"font%d",fontlist->size()-nr_of_sfonts+1);
      font1=(struct request_fonts*)_allocsafe(sizeof(struct request_fonts));
      font1->name=dupstring(buffer);
      font1->type=request_fonts::FIXED;
      font1->xname=dupstring(xname);
      font1->size=-1;
      fontlist->addElement(font1);
      act_font=fontlist->size()-1;
      act_fontsize=0;
    }
  }

  id=fontlist->initEnum();
  font1=(struct request_fonts*)fontlist->getFirstElement(id);
  i=0;
  while(font1!=NULL) {
    trow = lv->addRow();
    lv->setText( trow, 0, font1->name );
    lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    if(i==act_font) {
      lv->setActiveRow( trow );
      showsizes(i);
      if ( lv2->isValidRow( act_fontsize ) == true ) {
        lv2->setActiveRow( act_fontsize );
      }
    }    
    font1=(struct request_fonts*)fontlist->getNextElement(id);
    i++;
  }
  fontlist->closeEnum(id);

  okb->takeFocus();
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();

  updatefont();
  lv->showActive();
  lv2->showActive();
  lv->redraw();
  lv2->redraw();

  req=new Requester(aguix);

  AGMessage *msg;
  int endmode=-1,pos;
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_FIELDLV_ONESELECT:
        case AG_FIELDLV_MULTISELECT:
          if ( msg->fieldlv.lv == lv ) {
            trow = lv->getActiveRow();
            if ( lv->isValidRow( trow ) == true ) {
              showsizes( trow );
              updatefont();
            }
          } else if ( msg->fieldlv.lv == lv2 ) {
            updatefont();
          }
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
	    endmode=0;
          } else if(msg->button.button==cb) {
            endmode=1;
          } else if(msg->button.button==xb) {
            buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                        strlen(catalog.getLocale(8))+1);
            sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                      catalog.getLocale(8));
            if(req->string_request(catalog.getLocale(123),catalog.getLocale(381),"",buttonstr,&rstr)==0) {
              if(aguix->getFont(rstr)!=NULL) {
                // search for existing entry
                if(findfont(rstr,&ni,&nj)==0) {
                  trow = ni;
                  if ( lv->isValidRow( trow ) == true ) {
                    lv->setActiveRow( trow );
                    showsizes(ni);
                    trow2 = nj;
                    if ( lv2->isValidRow( trow2 ) == true ) {
                      lv2->setActiveRow( trow2 );
                      updatefont();
                    }
                  }
                  _freesafe(rstr);
                } else {
                  // add new font

                  sprintf(buffer,"font%d",fontlist->size()-nr_of_sfonts+1);
                  font1=(struct request_fonts*)_allocsafe(sizeof(struct request_fonts));
                  font1->name=dupstring(buffer);
                  font1->type=request_fonts::FIXED;
                  font1->xname=rstr;
                  font1->size=-1;
                  fontlist->addElement(font1);

                  trow = lv->addRow();
                  lv->setText( trow, 0, font1->name );
                  lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
                  lv->setActiveRow( trow );
                  showsizes(fontlist->size()-1);
                  updatefont();
                }
              } else {
                req->request(catalog.getLocale(124),catalog.getLocale(365),catalog.getLocale(11));
                _freesafe(rstr);
              }
            } else _freesafe(rstr);
            _freesafe(buttonstr);
          }
          break;
	case AG_KEYPRESSED:
	  if ( win->isParent( msg->key.window, false ) == true ) {
	    // key release only accept when not first key we get
	    // means a key is pressed when we started and if we use this
	    // key it could confuse the user
	    switch(msg->key.key) {
	      case XK_KP_Enter:
	      case XK_Return:
                if ( cb->getHasFocus() == false ) {
    	          endmode=0;
                }
		break;
	      case XK_Escape:
	        endmode=1;
		break;
	    }
	  }
	  break;
      }
      aguix->ReplyMessage(msg);
    }
  }

  if(endmode==0) {
    endmode=1;
    trow = lv->getActiveRow();
    if ( lv->isValidRow( trow ) == true ) {
      pos = trow;
      font1=(struct request_fonts*)fontlist->getElementAt(pos);
      if(font1!=NULL) {  
        if(font1->type==request_fonts::FIXED) {
          endmode=0;
          if(return_xname!=NULL) {
            *return_xname=dupstring(font1->xname);
          }
        } else {
          trow = lv2->getActiveRow();
          if ( lv2->isValidRow( trow ) == true ) nj = trow;
          else nj=0;
          if(return_xname!=NULL) {
            rstr = (char*)_allocsafe( strlen( font1->xname ) + A_BYTESFORNUMBER( int ) + 1 );
            sprintf(rstr,font1->xname,getsize(pos,nj));
            *return_xname=rstr;
          }
          endmode=0;
        }
      }
    }
  }

  delete win;
  
  delete req;
  
  return endmode;
}

void FontRequester::showsizes(int i)
{
  int trow, frow = -1;
  char buffer[ A_BYTESFORNUMBER( int ) + 1 ];
  int j,oj;
  struct request_fonts *font1;

  font1=(struct request_fonts*)fontlist->getElementAt(i);
  if(font1!=NULL) {  
    if(font1->type==request_fonts::FIXED) {
      lv2->setSize(1);
      sprintf(buffer,"%d",font1->size);
      lv2->setText( 0, 0, buffer );
      lv2->setPreColors( 0, FieldListView::PRECOLOR_ONLYACTIVE );
      lv2->setActiveRow( 0 );
    } else {
      trow = lv2->getActiveRow();
      if ( lv2->isValidRow( trow ) == true ) oj = trow;
      else oj=0;
      lv2->setSize( FONTREQ_STEPS );
      for(j=0;j<FONTREQ_STEPS;j++) {
        sprintf(buffer,"%d",getsize(i,j));
        lv2->setText( j, 0, buffer );
        lv2->setPreColors( j, FieldListView::PRECOLOR_ONLYACTIVE );
        
        if(j==0) frow = j;
        else if(j==oj) frow = j;
      }
      if ( lv2->isValidRow( frow ) == true ) lv2->setActiveRow( frow );
    }
  }
  lv2->redraw();
}

void FontRequester::updatefont()
{
  int trow;
  int i,j;
  char *tstr,*buffer;
  struct request_fonts *font1;
  
  trow = lv->getActiveRow();
  if ( lv->isValidRow( trow ) == true ) {
    i = trow;
    trow = lv2->getActiveRow();
    if ( lv2->isValidRow( trow ) == true ) {
      j = trow;

      font1=(struct request_fonts*)fontlist->getElementAt(i);
      if(font1!=NULL) {  
        tstr=font1->xname;
        if(font1->type==request_fonts::SCALEABLE) {
          buffer = (char*)_allocsafe( strlen( tstr ) + A_BYTESFORNUMBER( int ) + 1 );
          sprintf(buffer,tstr,getsize(i,j));
          etext->setFont(buffer);
          etext->redraw();
          ftext->setText(buffer);
          _freesafe(buffer);
        } else {
          etext->setFont(tstr);
          etext->redraw();
          ftext->setText(tstr);
        }
	ac1->setMinHeight( etext->getHeight(), 0, 2 );
	ac1->setMaxHeight( etext->getHeight(), 0, 2 );
	ac1->setMinWidth( etext->getWidth(), 0, 2 );
	ac1_2->readLimits();
	win->contMaximize( true );
      }
    }
  }
  lv->redraw();
}

int FontRequester::getsize(int i,int j)
{
  return FONTREQ_MINSIZE+FONTREQ_STEPSIZE*j;
}

int FontRequester::findfont(const char *xn,int *return_i, int *return_j)
{
  struct request_fonts *font1;
  int id;
  char *tstr,*buffer;
  bool found=false;
  int i=0,j=0;
  
  id=fontlist->initEnum();
  
  font1=(struct request_fonts*)fontlist->getFirstElement(id);
  i=0;
  while(font1!=NULL) {  
    tstr=font1->xname;
    if(font1->type==request_fonts::SCALEABLE) {
      buffer = (char*)_allocsafe( strlen( tstr ) + A_BYTESFORNUMBER( int ) + 1 );

      for(j=0;j<FONTREQ_STEPS;j++) {
        sprintf(buffer,tstr,getsize(i,j));
        if(strcmp(buffer,xn)==0) {
          found=true;
          break;
        }
      }

      _freesafe(buffer);
      if(found==true) break;
    } else {
      if(strcmp(tstr,xn)==0) {
        found=true;
        j=0;
        break;
      }
    }
    font1=(struct request_fonts*)fontlist->getNextElement(id);
    i++;
  }
  fontlist->closeEnum(id);
  if(found==true) {
    *return_i=i;
    *return_j=j;
    return 0;
  } else return -1;
}

