/****************************************************************************
** $Id: qt/examples/application/application.h   2.2.4   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <qmainwindow.h>
#include <qstringlist.h>

class QMultiLineEdit;
class QScrollView;
class QToolBar;
class QPopupMenu;
class Render2D;
class ChemData;
class Clipboard;
class QComboBox;
class QPushButton;
class QToolButton;

class ApplicationWindow: public QMainWindow
{
    Q_OBJECT
public:
    ApplicationWindow(Clipboard *);
    ~ApplicationWindow();
    QString ConvertToMolfile(QString);
    void ConvertFromMolfile(QString, QString);
    
protected:
    void closeEvent( QCloseEvent* );

public slots:
    void newDoc();
    void load();
    void load( QString );
    void save();
    void saveAs();
    void savePicture();
    void PageSetup();
    void print();
    void MakeRingDialog();
    void MakeNetDialog();
    void ShowFixedDialog();
    void Cut();
    void Copy();
    void Paste();
    void Undo();
    void Clear();
    void SelectAll();
    void ShowTextButtons(QFont);
    void HideTextButtons();
    void SetStatusBar(QString);
    void SetFont(int);
    void SetColor(int);
    void NewColor();
    void BackgroundColor();
    void SetThick(int);
    void FromRingMenu(int);
    void FromNewRingMenu(int); // in application_ring.cpp
    void FromRingToolbar(QString);
    void FromSymbolMenu(int);
    void FromArrowMenu(int);
    void FromCurveArrowMenu(int);
    void FromBracketMenu(int);
    void FlipH();
    void FlipV();
    void Rotate90();
    void Rotate180();
    void Rotate270();
    void setFixed_arrow();
    void setFixed_bond();
    void CalcEA();
    void CalcEF();
    void CalcMW();
    void Calc13CNMR();
    void Calc1HNMR();
    void CalcIR();
    void CalcName();
    void AutoLayout();
    void DrawRegularArrow();
    void DrawSquareBracket();
    void CleanUpMolecule();
    void ToSMILES();
    void FromSMILES(); // defined in smilesdialog.cpp

    void about();
    void Manual();
    void Refs();
    void Dummy() { }

private:
    QPopupMenu *BuildRingMenu();
    QPopupMenu *BuildNewRingMenu(); // in application_ring.cpp
    QPopupMenu *BuildArrowMenu();
    QPopupMenu *BuildCurveArrowMenu();
    QPopupMenu *BuildSymbolMenu();
    QPopupMenu *BuildBracketMenu();
    QPopupMenu *format;
    QPushButton *pb1;
    int fixlen_bond, fixlen_arrow;
    Clipboard *clip;
    QPrinter *printer;
    QScrollView *sv;
    Render2D *r;
    ChemData *c;
    QToolBar *fileTools, *drawTools, *ringTools;
    QString filename;
    QToolButton *Bold, *Italic, *Underline, *superScript, *subScript;
    QComboBox *colorList, *fontList, *fontSizeList, *ltList;
    QStringList ringlist, symbollist, arrowlist, curvearrowlist, bracketlist;
    bool use_babel;  // is Babel/OpenBabel available?
};


#endif
