#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qdialog.h>
#include <qcolor.h>
#include <qfont.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qprinter.h>

#include "pagesetupdialog.h"
#include "defs.h"

PageSetupDialog::PageSetupDialog(QWidget *parent, QString name):
	QDialog(parent, name, TRUE)
{
  setCaption( tr("Page setup") );
  QLabel *l1 = new QLabel(this, "Paper size label");
  l1->setGeometry(10,10,80,30);
  l1->setText( tr("Paper size:") );
  psize = new QComboBox(false, this, "Paper size");
  psize->setGeometry(100,10,180,30);
  psize->insertItem(tr("Letter (8.5\" x 11\")"));
  psize->insertItem(tr("Legal (8.5\" x 14\")"));
  psize->insertItem(tr("A4 (210 mm x 297 mm)"));
  psize->insertItem(tr("640x480 pixels"));
  psize->insertItem(tr("800x600 pixels"));
  psize->insertItem(tr("1024x768 pixels"));
  QLabel *l2 = new QLabel(this, "Paper size label");
  l2->setGeometry(10,50,80,30);
  l2->setText( tr("Orientation:") );
  porient = new QComboBox(false, this, "Paper orientation");
  porient->setGeometry(100,50,180,30);
  porient->insertItem( tr("Portrait") );
  porient->insertItem( tr("Landscape") );
  QPushButton *ok, *dismiss;
  ok = new QPushButton(tr("OK"), this);
  ok->setGeometry(50,170,80,30);
  ok->setPalette(QPalette(lightGray));
  connect(ok, SIGNAL(clicked()), SLOT(accept()) );
  dismiss = new QPushButton(tr("Cancel"), this);
  dismiss->setGeometry(140,170,80,30);
  dismiss->setPalette(QPalette(lightGray));
  connect(dismiss, SIGNAL(clicked()), SLOT(reject()) );
}

void PageSetupDialog::setPageSize(int n)
{
  if (n == PAGE_LETTER)
    psize->setCurrentItem(0);
  if (n == PAGE_LEGAL)
    psize->setCurrentItem(1);
  if (n == PAGE_A4)
    psize->setCurrentItem(2);
  if (n == PAGE_640)
    psize->setCurrentItem(3);
  if (n == PAGE_800)
    psize->setCurrentItem(4);
  if (n == PAGE_1024)
    psize->setCurrentItem(5);
}

int PageSetupDialog::getPageSize(void)
{
  if (psize->currentItem() == 0)
    return PAGE_LETTER;
  if (psize->currentItem() == 1)
    return PAGE_LEGAL;
  if (psize->currentItem() == 2)
    return PAGE_A4;
  if (psize->currentItem() == 3)
    return PAGE_640;
  if (psize->currentItem() == 4)
    return PAGE_800;
  if (psize->currentItem() == 5)
    return PAGE_1024;
  return PAGE_LETTER;
}

void PageSetupDialog::setOrientation(int n)
{
  if (n == PAGE_PORTRAIT)
    porient->setCurrentItem(0);
  if (n == PAGE_LANDSCAPE)
    porient->setCurrentItem(1);
}

int PageSetupDialog::getOrientation(void)
{
  if (porient->currentItem() == 0)
    return PAGE_PORTRAIT;
  if (porient->currentItem() == 1)
    return PAGE_LANDSCAPE;
  return PAGE_PORTRAIT;
}
