/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _XSUPCONFCHECK_H_
#define _XSUPCONFCHECK_H_

typedef struct conferrs {
  char *line;
  struct conferrs *next;
} cerrs;

int xsupconfcheck_init();
int xsupconfcheck_check_config(struct config_data *, cerrs **);
int xsupconfcheck_check_networks(struct config_network *, cerrs **);
int xsupconfcheck_check_eap_methods(struct config_eap_method *, char *,
				    cerrs **);
int xsupconfcheck_check_static_wep_method(struct config_static_wep *,
					  char *, cerrs **);
int xsupconfcheck_check_wpa_psk(struct config_wpa_psk *, char *, cerrs **);
int xsupconfcheck_check_eap_md5(struct config_eap_md5 *, char *, cerrs **);
int xsupconfcheck_check_eap_otp(struct config_eap_otp *, char *, cerrs **);
int xsupconfcheck_check_eap_gtc(struct config_eap_otp *, char *, cerrs **);
int xsupconfcheck_check_eap_tls(struct config_eap_tls *, char *, cerrs **);
int xsupconfcheck_check_eap_leap(struct config_eap_leap *, char *, cerrs **);
int xsupconfcheck_check_eap_mschapv2(struct config_eap_mschapv2 *, char *,
				     cerrs **);
int xsupconfcheck_check_eap_sim(struct config_eap_sim *, char *, cerrs **);
int xsupconfcheck_check_eap_aka(struct config_eap_aka *, char *, cerrs **);
int xsupconfcheck_check_eap_peap(struct config_eap_peap *, char *, cerrs **);
int xsupconfcheck_check_eap_ttls(struct config_eap_ttls *, char *, cerrs **);
int xsupconfcheck_deinit(cerrs **);

#endif
