#! /usr/bin/perl -w


# Ham Radio ituzone info module ituzones.pm by PA0R, modified by DJ1YFK

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    ituzones.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    tuzones.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 15-04-06

#####################################################
# addituzone($comment, $band)
# delituzone($comment, $band)
# checkituzone($countryindex, $band, $call)
# @count = countituzone();
#####################################################
use Switch;

{ # start block
	for ($i = 0; $i < 75; $i++) {
		$ituzones_160[$i] = 0;
		$ituzones_80[$i] = 0;
		$ituzones_40[$i] = 0;
		$ituzones_20[$i] = 0;
		$ituzones_15[$i] = 0;
		$ituzones_10[$i] = 0;
		$ituzones_all[$i] = 0;
	}

#####################################################
sub init_ituzones {
#####################################################

	for ($i = 0; $i < 75; $i++) {
		$ituzones_160[$i] = 0;
		$ituzones_80[$i] = 0;
		$ituzones_40[$i] = 0;
		$ituzones_20[$i] = 0;
		$ituzones_15[$i] = 0;
		$ituzones_10[$i] = 0;
		$ituzones_all[$i] = 0;
	}
}
#####################################################
sub addituzone {
#####################################################

	my ($comment, $band) = @_;
	my $zone = 0;

	eval {
		if ($comment =~ /^\d+/) {
			if ($comment > 0 && $comment < 76) {
				$zone = $comment;
			} else {
				$zone = 0;
			}
		}
	};
	if ($@) { $zone = 0;}
	
	switch ($band) {
		case 160 { 
			$ituzones_160[$zone]++;
			$ituzones_all[$zone]++;
			return $ituzones_160[$zone];
		}
		case 80 { 
			$ituzones_80[$zone]++;
			$ituzones_all[$zone]++;
			return $ituzones_80[$zone];
		}
		case 40 { 
			$ituzones_40[$zone]++;
			$ituzones_all[$zone]++;
			return $ituzones_40[$zone];
		}
		case 20 { 
			$ituzones_20[$zone]++;
			$ituzones_all[$zone]++;
			return $ituzones_20[$zone];
		}
		case 15 { 
			$ituzones_15[$zone]++;
			$ituzones_all[$zone]++;
			return $ituzones_15[$zone];
		}
		case 10 { 
			$ituzones_10[$zone]++;
			$ituzones_all[$zone]++;
			return $ituzones_10[$zone];
		}
	}
	
}

#####################################################
sub delituzone {
#####################################################

	my ($country, $band, $call, $comment) = @_;
	if ($comment > 0 && $comment < 41) {
		my $zone = $comment;
	} else {
		$zone = 0;
	}
	
	switch ($band) {
		case 160 { 
			$ituzones_160[$zone]--;
			$ituzones_all[$zone]--;
			return $ituzones_160[$zone];
		}
		case 80 { 
			$ituzones_80[$zone]--;
			$ituzones_all[$zone]--;
			return $ituzones_80[$zone];
		}
		case 40 { 
			$ituzones_40[$zone]--;
			$ituzones_all[$zone]--;
			return $ituzones_40[$zone];
		}
		case 20 { 
			$ituzones_20[$zone]--;
			$ituzones_all[$zone]--;
			return $ituzones_20[$zone];
		}
		case 15 { 
			$ituzones_15[$zone]--;
			$ituzones_all[$zone]--;
			return $ituzones_15[$zone];
		}
		case 10 { 
			$ituzones_10[$zone]--;
			$ituzones_all[$zone]--;
			return $ituzones_10[$zone];
		}
	}
}
#####################################################
sub viewituzone {
#####################################################
	my ($zone, $band) = @_;
	
	switch($band) {
		case "160" { return $ituzones_160[$zone] }	
		case " 80" { return $ituzones_80[$zone] }	
		case " 40" { return $ituzones_40[$zone] }	
		case " 20" { return $ituzones_20[$zone] }	
		case " 15" { return $ituzones_15[$zone] }	
		case " 10" { return $ituzones_10[$zone] }	
		case " 99" { return $ituzones_all[$zone] }
		else { return 0 }
	}
}

#####################################################
sub checkituzone {
#####################################################
	my ($country, $band, $call) = @_;
	my @info = getinfo($call);
	my $zone = $info[2];

	switch($band) {
		case "160" { return $ituzones_160[$zone] ;}	
		case " 80" { return $ituzones_80[$zone] ;}	
		case " 40" { return $ituzones_40[$zone] ;}	
		case " 20" { return $ituzones_20[$zone]; }	
		case " 15" { return $ituzones_15[$zone] ;}	
		case " 10" { return $ituzones_10[$zone] ;}	
		case  "99" { return $ituzones_all[$zone]; }
		else { return 0 ;}
	}
}

#####################################################
sub count_ituzone {
#####################################################
my $count = 0;
my @out = ();
my $val = 0;
	foreach $val (@ituzones_160) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@ituzones_80) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@ituzones_40) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@ituzones_20) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@ituzones_15) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@ituzones_10) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@ituzones_all) {
		if ($val) {$count++; }
	}
	push @out, $count;
	
	return @out;

}

} # end block
1;
