/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableSearchable
extends Searchable
implements TableModelListener,
PropertyChangeListener {
    private int[] _searchColumnIndices = new int[]{0};

    public TableSearchable(JTable jTable) {
        super(jTable);
    }

    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().addTableModelListener(this);
            this._component.addPropertyChangeListener("model", this);
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().removeTableModelListener(this);
            this._component.removePropertyChangeListener("model", this);
        }
    }

    protected void setSelectedIndex(int n, boolean bl) {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            int n2 = n;
            int n3 = this.getMainIndex();
            this.addTableSelection(jTable, n2, n3, bl);
        } else if (this.isRowSelectionAllowed(jTable)) {
            int n4 = n;
            int n5 = this.getMainIndex();
            this.addTableSelection(jTable, n4, n5, bl);
        } else {
            int n6 = n / jTable.getColumnCount();
            int n7 = n % jTable.getColumnCount();
            this.addTableSelection(jTable, n6, n7, bl);
        }
    }

    protected void addTableSelection(JTable jTable, int n, int n2, boolean bl) {
        if (!bl) {
            jTable.clearSelection();
        }
        if (n >= 0 && n2 >= 0 && n < jTable.getRowCount() && n2 < jTable.getColumnCount() && !jTable.isCellSelected(n, n2)) {
            jTable.changeSelection(n, n2, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(JTable jTable) {
        return this.getSearchColumnIndices().length == 1 && jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(JTable jTable) {
        return this.getSearchColumnIndices().length == 1 && !jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed();
    }

    protected boolean isSearchSelectedRows() {
        return this.getSearchColumnIndices().length > 1;
    }

    protected int getSelectedIndex() {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return jTable.getSelectedColumn();
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return jTable.getSelectedRow();
        }
        return jTable.getSelectedRow() * jTable.getColumnCount() + jTable.getSelectedColumn();
    }

    protected Object getElementAt(int n) {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return this.getValueAt(jTable, this.getMainIndex(), n);
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return this.getValueAt(jTable, n, this.getMainIndex());
        }
        if (this.isSearchSelectedRows()) {
            int n2 = n % jTable.getColumnCount();
            boolean bl = true;
            for (int n3 : this.getSearchColumnIndices()) {
                if (n3 != n2) continue;
                bl = false;
            }
            if (bl) {
                return null;
            }
            int n4 = n / jTable.getColumnCount();
            return this.getValueAt(jTable, n4, n2);
        }
        int n5 = n % jTable.getColumnCount();
        int n6 = n / jTable.getColumnCount();
        return this.getValueAt(jTable, n6, n5);
    }

    private Object getValueAt(JTable jTable, int n, int n2) {
        if (n >= 0 && n < jTable.getRowCount() && n2 >= 0 && n2 < jTable.getColumnCount()) {
            return jTable.getValueAt(n, n2);
        }
        return null;
    }

    protected int getElementCount() {
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return jTable.getColumnCount();
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return jTable.getRowCount();
        }
        return jTable.getColumnCount() * jTable.getRowCount();
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int[] getSearchColumnIndices() {
        return this._searchColumnIndices;
    }

    public int getMainIndex() {
        if (this._searchColumnIndices.length == 0) {
            return -1;
        }
        return this._searchColumnIndices[0];
    }

    public void setSearchColumnIndices(int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (!JideSwingUtilities.equals(nArray2 = this._searchColumnIndices, nArray, true)) {
            this._searchColumnIndices = nArray;
            this.hidePopup();
        }
    }

    public void setMainIndex(int n) {
        int[] nArray;
        int[] nArray2 = new int[]{n};
        if (n < 0) {
            nArray2 = new int[]{};
        }
        if ((nArray = this._searchColumnIndices) != nArray2) {
            this._searchColumnIndices = nArray2;
            this.hidePopup();
        }
    }

    protected boolean isFindNextKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return n == 39;
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return n == 40;
        }
        return n == 40 || n == 39;
    }

    protected boolean isFindPreviousKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        JTable jTable = (JTable)this._component;
        if (this.isColumnSelectionAllowed(jTable)) {
            return n == 37;
        }
        if (this.isRowSelectionAllowed(jTable)) {
            return n == 38;
        }
        return n == 38 || n == 37;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getOldValue()).removeTableModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getNewValue()).addTableModelListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    protected boolean isActivateKey(KeyEvent keyEvent) {
        boolean bl = this.isSelectedCellEditable();
        return !bl && super.isActivateKey(keyEvent);
    }

    protected boolean isSelectedCellEditable() {
        int n = ((JTable)this._component).getSelectedRow();
        int n2 = ((JTable)this._component).getSelectedColumn();
        return n != -1 && n2 != -1 && ((JTable)this._component).isCellEditable(n, n2);
    }
}

