/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.sam.reader;

import org.broad.igv.util.IntHashMap;

import java.util.HashMap;
import java.util.Map;

/**
 * @author jrobinso
 */
public class IntervalIndex {

    static int w0 = 10000;
    static int w1 = 100000;
    static int w2 = 1000000;

    Map<String, ChrIndex> chrIndex = new HashMap();


    /**
     * Add a single feature to the index.
     *
     * @param chr
     * @param start
     * @param end
     * @param filePosition
     * @param sizeBytes
     */
    public void add(String chr, int start, int end, long filePosition, int sizeBytes) {

        int interval = findInterval(start, end);


    }

    int findInterval(int start, int end) {

        int ts0 = (int) start / w0;
        int te0 = (int) end / w0;
        if (ts0 == te0) {
            return ts0;
        }

        int ts1 = (int) start / w1;
        int te1 = (int) end / w1;
        if (ts1 == te1) {
            return ts1;
        }

        int ts2 = (int) start / w2;
        int te2 = (int) end / w2;
        if (ts2 == te2) {
            return ts2;
        }

        return 30;

    }


    class ChrIndex {

        IntHashMap<long[]> positionMap;
        IntHashMap<int[]> sizeMap;

    }


}
