/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.track;

import java.awt.*;
import java.util.HashMap;
import java.util.Map;

/**
 * @author jrobinso
 */
public class RenderContext {

    private String genomeId;
    private String chr;
    private double startLocation;
    private double endLocation;
    private int zoom;
    private double scale;
    private Graphics2D graphics;
    private Map<Color, Graphics2D> graphicCacheByColor;
    Rectangle visibleRect;

    public RenderContext(String genomeId, String chr, double startLocation, double endLocation,
                         int zoom, double scale, Rectangle visibleRect,
                         Graphics2D graphics) {
        this.genomeId = genomeId;
        this.chr = chr;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.zoom = zoom;
        this.scale = scale;
        this.graphics = graphics;
        this.visibleRect = visibleRect;
        this.graphicCacheByColor = new HashMap();
    }

    public Graphics2D getGraphic2DForColor(Color color) {

        Graphics2D g = graphicCacheByColor.get(color);
        if (g == null) {
            g = (Graphics2D) graphics.create();
            graphicCacheByColor.put(color, g);
            g.setColor(color);
        }
        return g;
    }

    public String getChr() {
        return chr;
    }

    public double getOrigin() {
        return startLocation;
    }

    public double getEndLocation() {
        return endLocation;
    }

    public double getScale() {
        return scale;
    }

    public Rectangle getVisibleRect() {
        return visibleRect;
    }


    public Graphics2D getGraphics() {
        return graphics;
    }

    public int getZoom() {
        return zoom;
    }

    /**
     * Release graphics objects
     *
     * @throws java.lang.Throwable
     */
    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        dispose();
    }

    public void dispose() {
        for (Graphics2D g : graphicCacheByColor.values()) {
            g.dispose();
        }
        graphicCacheByColor.clear();
    }


    public String getGenomeId() {
        return genomeId;
    }

    public void setGenomeId(String genomeId) {
        this.genomeId = genomeId;
    }
}
