package org.broad.tribble.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;

/**
 * Created by IntelliJ IDEA.
 * User: jrobinso
 * Date: Nov 30, 2009
 * Time: 9:05:10 AM
 * To change this template use File | Settings | File Templates.
 */
public class SeekableStreamFactory {

    public static SeekableStream getStreamFor(String path) throws IOException {

        if (path.endsWith(".split")) {
            return new SeekableSplitStream(path);

        } else {
            return path.startsWith("http:") ?
                    new SeekableHTTPStream(new URL(path)) :
                    new SeekableFileStream(new File(path));
        }
    }

}