/*  jobname.as1
  0 \barno \nvoice   \en
  nvoice note point  spacing chord and rest
  nvoice -1 1        start beam
  nvoice -1 2        end beam
  nvoice -2 dimen    \ins
  nvoice -3 dimen    \Sk (not used)
  nvoice -4 nst@ff   \startst@ff

    jobname.as2 (i: integer, r: float)
  i%f(\barno)  flag for \firstinsert, 0/1 = no/yes
  i%f(\barno)  flag for low voice, 0/1 = no/yes
  i%v          low voice flag, if needed
  r%a          amount of \noteskip for first insert, if needed
  r%#          amount of \noteskip for chord of voice #
  r%s          amount of \noteskip at first scan of beam chords
  r%h          amount of \noteskip at second scan of beam chords
  r%#b         amount of \noteskip for beam chord of voice # */

/**********************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TRUE 1
#define FALSE 0
#define MAXINT 9999
#define MAXVOICE 4
#define MAXNOTE 50

typedef int   imatrix [MAXVOICE][MAXNOTE];
typedef float rmatrix [MAXVOICE][MAXNOTE+1];
typedef int   ivec [MAXNOTE];
typedef float rvec [MAXNOTE+1];

imatrix data,
        beam;
rmatrix insert;    /* amount of \noteskip before the chord */
ivec    lowvoice,  /* low voice flag */
        bdata;     /* base */
rvec    binsert;   /* base */
int     barnum,
        numvoice,
        check,
        finish;
FILE *fin, *fout, *flog;

int convert(int n, float p);
int readline(int *voice0, int *note0, float *point0);
void readblock(void);
float findsk(ivec index);
void combine(void);
float value(int x);
void calcsk(void);

/**********************************************************/
int main (int argc, char *argv[])
{
  char jobname[16], finname[16], foutname[16], flogname[16];

  check = FALSE;
  if (argc != 2) {printf("Usage: AUTO filename\n"); exit(3);}
  else strcpy(jobname, argv[1]);
/* strcpy(jobname, "x"); */

  strcpy(finname, jobname); strcat(finname, ".as1");
  fin = fopen(finname, "r");
  if (!fin) {printf("file %s does not exit.\n", finname); exit(3);}

  strcpy(foutname, jobname); strcat(foutname, ".as2");
  fout = fopen(foutname, "w");

  printf("autospacing: %s -> %s", finname, foutname);

  if (check) {
    strcpy(flogname, jobname); strcat(flogname, ".as3");
    flog = fopen(flogname, "w");
    printf(" (%s)", flogname);}
  printf("\n");

  finish = FALSE;
  while (!finish) {
    readblock();
    if (!finish) {combine(); calcsk();}}

  printf("completed\n");
  fclose(fin); fclose(fout);
  if (check) {fprintf(flog, "completed\n"); fclose(flog);}
  return(0);
} /* main */

/**********************************************************/
int convert(int n, float p)
{
  int x, i;

  if (n == 28) x = 64;      /* w */
  else if (n == 27) x = 32; /* h */
  else if (n == 26) x = 16; /* q */
  else if (n == 12) x = 64; /* wr */
  else if (n == 11) x = 32; /* hr */
  else if (n == 14) x = 16; /* qr */
  else if (n == 15) x = 8;  /* er */
  else if (n == 16) x = 4;  /* eer */
  else if (n == 17) x = 2;  /* eeer */
  else if (n == 18) x = 1;  /* eeeer */
  else if (n == 32) x = 8;  /* c */
  else if (n == 37) x = 8;  /* c */
  else if (n == 33) x = 4;  /* 2c */
  else if (n == 38) x = 4;  /* 2c */
  else if (n == 34) x = 2;  /* 3c */
  else if (n == 39) x = 2;  /* 3c */
  else if (n == 35) x = 1;  /* 4c */
  else if (n == 40) x = 1;  /* 4c */
  else if (n == 101) x = 8; /* b */
  else if (n == 102) x = 4; /* 2b */
  else if (n == 103) x = 2; /* 3b */
  else if (n == 104) x = 1; /* 4b */
  else {printf("Unrecognized code.\n"); exit(3);}
  i = (int) p;
  if (i == 4) {x = 3 * x; x = x / 2;}
  else if (i == 5) {x = 7 * x; x = x / 4;}
  return x;
}   /* convert */

/**********************************************************/
int readline(int *voice0, int *note0, float *point0)
{
  int done;

  if (feof(fin)) finish = done = TRUE;
  else {done = FALSE; fscanf(fin,"%d %d %f\n", voice0, note0, point0);}
  return done;
}   /* readline */

/**********************************************************/
void readblock(void)
{
  int staff, voice, note, sum, sum0, x, voice0, note0, done;
  float point0;

  for (voice = 0; voice < MAXVOICE; voice++)
  for (note = 0; note < MAXNOTE; note++)
    data[voice][note] = beam[voice][note] = insert[voice][note] = 0;

  voice = -1; sum0 = 0;
  done = readline(&voice0, &note0, &point0);

  while (!done) {
    voice++;
    if (voice >= MAXVOICE) {printf("MAXVOICE exceeded.\n"); exit(3);}
    note = -1; sum = 0;

    while (voice0 == voice+1) {
      if (check)
        fprintf(flog, "readblock: %d %d %.3f -> ", voice0, note0, point0);

      if (note0 == -1) {        /* start/end of beam */
        if (point0 < 1.1) {
          beam[voice][note+1] = 1;
          if (check) fprintf(flog, "beam[%d][%d]=1\n", voice, note+1);}
        else {
          beam[voice][note] = 2;
          if (check) fprintf(flog, "beam[%d][%d]=2\n", voice, note);}}
      else if (note0 == -2) {   /* \ins */
	    insert[voice][note+1] = point0;
        if (check)
          fprintf(flog, "insert[%d][%d]=%.3f\n", voice, note+1, point0);}
      else if (note0 == -3);    /* \Sk, not used */
      else if (note0 == -4) {   /* \startst@ff */
        staff = (int) point0;
        if (check) fprintf(flog, "staff=%d\n", staff);}
      else {                   /* regular note */
        note++;
        if (note >= MAXNOTE) {printf("MAXNOTE exceeded.\n"); exit(3);}
        x = convert(note0, point0);
        data[voice][note] = x;

        sum = sum + x;
        if (check)
          fprintf(flog, "data[%d][%d]=%d sum=%d\n", voice, note, x, sum);
      } /* if (note0 = -1) */

      done = readline(&voice0, &note0, &point0);
    } /* while (voice0 == voice+1) */

    if (voice0 == 0) {
      done = TRUE;
      barnum = note0;
      if (check)
        fprintf(flog, "readblock: \\barno=%d \\nvoice=%d\n",
                      note0, (int) point0);}

    lowvoice[voice] = ((voice0 == voice+1) && ((int) point0 == staff));

    if (voice == 0) sum0 = sum;
    else if (sum0 != sum)
      printf("unequal times in \\barno %d: %d <> %d\n", barnum, sum, sum0);
  } /* while not done */

  numvoice = voice+1;
}   /* readblock */

/**********************************************************/
/* search for largest insert, zeros are ignored. */
float findsk(ivec index)
{
  float x;
  int j;

  x = -MAXINT;
  for (j = 0; j < numvoice; j++)
    if ((insert[j][index[j]] != 0) && (x < insert[j][index[j]]))
      x = insert[j][index[j]];
  if (x == -MAXINT) x = 0;
  else if (check) fprintf (flog, "findsk: %.3f\n", x);
  return x;
} /* findsk */

/**********************************************************/
/* calculate bdata and binsert */
void combine(void)
{
  int bindex, min, i, j, done;
  ivec index;
  imatrix data1;   /* copy of data */

  for (j = 0; j < MAXVOICE; j++)
  for (i = 0; i < MAXNOTE; i++) data1[j][i] = data[j][i];

  bindex = -1;
  for (j = 0; j < numvoice; j++) index[j] = 0;
  done = FALSE;
  while (!done) {
    min = MAXINT;
    for (j = 0; j < numvoice; j++)
      if ((data1[j][index[j]] > 0) && (data1[j][index[j]] < min))
        min = data1[j][index[j]];

    done = (min == MAXINT);
    if (!done) {
      bindex++;
      bdata[bindex] = min;
      binsert[bindex] = findsk(index);
      if (check)
        fprintf(flog, "combine: bdata[%d]=%d binsert[%d]=%.3f\n",
                      bindex, min, bindex, binsert[bindex]);

      for (j = 0; j < numvoice; j++)
        if (data1[j][index[j]] > 0) {
          data1[j][index[j]] = data1[j][index[j]] - min;
          if (data1[j][index[j]] == 0) index[j]++;}
    } /* if not done */
  } /* while */

  binsert[bindex+1] = findsk(index);

  if (check) {
    fprintf(flog, "combine: bindex=%d\n", bindex);
    for (i = 0; i <= bindex; i++) fprintf(flog, "%5d", bdata[i]);
    fprintf(flog, "\n");
    for (i = 0; i <= bindex; i++) fprintf(flog, "%5.2f", binsert[i]);
    fprintf(flog, "%5.2f\n", binsert[bindex+1]);}

}   /* combine */

/**********************************************************/
float value(int x)
{
  if (x == 1)  return 1;         /* cccc */
  else if (x == 2)  return 1;    /* ccc */
  else if (x == 3)  return 1;    /* ccc. */
  else if (x == 4)  return 1;    /* cc */
  else if (x == 6)  return 1;    /* cc. */
  else if (x == 8)  return 1.5;  /* c */
  else if (x == 12) return 2.;   /* c. */
  else if (x == 16) return 2.5;  /* q */
  else if (x == 24) return 3.00; /* q. */
  else if (x == 32) return 3.75; /* h */
  else if (x == 48) return 4.50; /* h. */
  else if (x == 64) return 5.5;  /* w */
  else if (x == 96) return 6.5;  /* w. */
  else {printf("Unrecognized value %d",x); exit(3);}
} /* value */

/**********************************************************/
void calcsk(void)
{
  int i, j, k, bnote, ib, x, sum, flaginsert, flaglowvoice, done, flagbeam;
  float sk, sk1;
  rvec  buffer; /* store \noteskip for beam notes */

  flagbeam = FALSE;

  flaginsert = (binsert[0] != 0);
  fprintf(fout, "%d%%f%d\n", flaginsert, barnum);

  flaglowvoice = FALSE;
  for (j = 0; j < numvoice; j++) if (lowvoice[j]) flaglowvoice = TRUE;
  fprintf(fout, "%d%%f%d\n", flaglowvoice, barnum);

  for (j = 0; j < numvoice; j++) {
    if (binsert[0] != 0) fprintf(fout, "%.3f%%a\n", binsert[0]);
    if (flaglowvoice == 1) fprintf(fout, "%d%%v\n", lowvoice[j]);

    i = ib = -1;
    done = FALSE;
    while (!done) {
      i++;
      if (data[j][i] == 0) done = TRUE;

      if (!done) {
        x = data[j][i];
        sk = sum = 0;
        if (check) fprintf(flog, "calcsk: data[%d][%d] -> ", j, i);

        while (sum < x) {
          ib++;
          sum = sum + bdata[ib];
          sk1 = value(bdata[ib]) + binsert[ib+1];
          sk = sk + sk1;
          if (check) fprintf(flog, "[%d]%.3f", ib, sk1);}
        if (check) fprintf(flog, "=%.3f\n", sk);

        if (beam[j][i] == 1) {
          flagbeam = TRUE; bnote = -1;
          if (check) fprintf(flog, "calcsk: start beam\n");}

        if (flagbeam) {bnote++; buffer[bnote] = sk;}
        else fprintf(fout,"%.3f%%%d\n", sk, j+1);

        if (beam[j][i] == 2) {
          if (check)
            fprintf(flog, "calcsk: end beam, bnote=%d\n", bnote);
          for (k = 0; k < bnote; k++)
            fprintf(fout, "%.3f%%s\n", buffer[k]);
          for (k = 0; k < bnote; k++)
            fprintf(fout, "%.3f%%h\n", buffer[k]);
          for (k = 0; k < bnote+1; k++)
            fprintf(fout, "%.3f%%%db\n", buffer[k], j+1);
          flagbeam = FALSE;
          bnote = -1;}
      } /* if (!done) */
    } /* while (!done) */
  } /* for j */
} /* calcsk */
