/*
 * RTLinux Hello World example
 *
 * Written by Michael Barabanov (baraban@fsmlabs.com)
 * Copyright (C) 1999-2000 Finite State Machine Labs Inc
 * Released under the terms of the GPL Version 2
 *
 */

#include <rtl_sync.h>
#include <rtl.h>
#include <time.h>
#include <pthread.h>

#include <rtl_debug.h>

pthread_t thread = 0;
pthread_t thread2 = 0;

void * start_routine(void *arg)
{
	int i;
	struct sched_param p;

	volatile pthread_t self;
	self = pthread_self();

	p . sched_priority = 1;
	pthread_setschedparam (pthread_self(), SCHED_FIFO, &p);

	pthread_make_periodic_np (pthread_self(), gethrtime(), 500000000);

	if (((int) arg) == 1) {
		breakpoint();
	}

	for (i = 0; i < 20; i ++) {
		pthread_wait_np ();
		rtl_printf("I'm here; my arg is %x\n", (unsigned) arg);
	}
	return 0;
}

int init_module(void)
{
	pthread_create (&thread, NULL, start_routine, (void *) 1);
	return pthread_create (&thread2, NULL, start_routine, (void *) 2);
}

void cleanup_module(void)
{
	pthread_cancel (thread);
	pthread_join (thread, NULL);

	pthread_delete_np (thread2);
}
