/**
 * chro.mono: A very circular color puzzle game
 * https://thp.io/2013/chromono/
 * Copyright (C) 2013-2021 Thomas Perl <m@thp.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 **/


uniform float time;
uniform sampler2D sampler;

varying vec2 pos;
varying vec2 tex;

void main(void)
{
    float intensity = 0.6;

    // Add randomness
    float random_color = texture2D(sampler, mod(tex, vec2(1.0))).r;
    intensity += 0.06 * random_color;

    // Add vignette effect
    float hvignette = smoothstep(2.5, 0.5, abs(pos.x));
    float vvignette = smoothstep(2.4, 0.5, abs(pos.y));
    intensity *= hvignette * vvignette;

    // Add highlight effect
    float highlight = smoothstep(1.0, 0.0, distance(pos, vec2(-0.2, -0.3)));
    intensity += highlight * 0.2;

    gl_FragColor = vec4(intensity, intensity, intensity, 1.0);
}

