# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Debusine command line interface, setup command."""

from debusine.client.commands.base import Command


class Setup(Command):
    """Guided setup of debusine-client."""

    def run(self) -> None:
        """Run the command."""
        from debusine.client.setup import setup_server

        setup_server(
            config_file_path=self.args.config_file,
            server=self.args.server,
            scope=self.args.scope,
        )
