"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RRCurveToHVVHCurve = void 0;
const operator_1 = require("../../../interp/operator");
const draw_call_1 = require("../draw-call");
const general_1 = require("./general");
class RRCurveToHVVHCurve extends general_1.DrawCallOptimizationPass {
    *doFlush(st) {
        yield st;
    }
    fetchIncomingArgOp(dc) {
        const [dx1, dy1, dx2, dy2, dx3, dy3] = dc.args;
        if (dc.operator !== operator_1.CharStringOperator.RRCurveTo)
            return null;
        if ((0, general_1.argIsZero)(dx1)) {
            return {
                op: operator_1.CharStringOperator.VHCurveTo,
                args: [dy1, dx2, dy2, dx3, ...((0, general_1.argIsZero)(dy3) ? [] : [dy3])]
            };
        }
        else if ((0, general_1.argIsZero)(dy1)) {
            return {
                op: operator_1.CharStringOperator.HVCurveTo,
                args: [dx1, dx2, dy2, dy3, ...((0, general_1.argIsZero)(dx3) ? [] : [dx3])]
            };
        }
        else {
            return null;
        }
    }
    tryUpdateState(st, dc) {
        const iao = this.fetchIncomingArgOp(dc);
        if (!iao)
            return null;
        const lastIsY = (st.operator === operator_1.CharStringOperator.HVCurveTo) === st.args.length % 8 >= 4;
        const lastTangentIsDiagonal = st.args.length % 2;
        if (lastTangentIsDiagonal)
            return null;
        const limits = this.ctx.getLimits();
        const canMerge = lastIsY !== (iao.op === operator_1.CharStringOperator.HVCurveTo);
        if (canMerge) {
            const merged = new draw_call_1.CffDrawCall(st.ivd, [...st.args, ...iao.args], st.operator);
            if (merged.stackRidge < limits.maxStack && merged.stackRise < limits.maxStack) {
                return merged;
            }
            else {
                return null;
            }
        }
        else {
            return null;
        }
    }
    tryInitState(dc) {
        const iao = this.fetchIncomingArgOp(dc);
        if (!iao)
            return null;
        else
            return new draw_call_1.CffDrawCall(dc.ivd, iao.args, iao.op);
    }
}
exports.RRCurveToHVVHCurve = RRCurveToHVVHCurve;
//# sourceMappingURL=hvvh-curveto.js.map