"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WriteTtfGlyphs = exports.ReadTtfGlyphs = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ImpLib = require("@ot-builder/common-impl");
const errors_1 = require("@ot-builder/errors");
const io_bin_ttf_1 = require("@ot-builder/io-bin-ttf");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
exports.ReadTtfGlyphs = {
    readGlyphs(sfnt, cfg, gOrd, ctx) {
        const bLoca = sfnt.tables.get(io_bin_ttf_1.Loca.Tag);
        const bGlyf = sfnt.tables.get(io_bin_ttf_1.Glyf.Tag);
        if (!bLoca)
            throw errors_1.Errors.MissingKeyTable(io_bin_ttf_1.Loca.Tag);
        if (!bGlyf)
            throw errors_1.Errors.MissingKeyTable(io_bin_ttf_1.Glyf.Tag);
        const loca = new bin_util_1.BinaryView(bLoca).next(io_bin_ttf_1.Loca.Io, ctx.head, ctx.maxp);
        const glyf = new bin_util_1.BinaryView(bGlyf).next(io_bin_ttf_1.Glyf.Read, loca, gOrd, ctx.coStat);
        const bGvar = sfnt.tables.get(io_bin_ttf_1.Gvar.Tag);
        if (ctx.designSpace && bGvar) {
            const gvarIgnore = {
                horizontalMetric: ctx.hMetricVariable,
                verticalMetric: ctx.vMetricVariable
            };
            const gvar = new bin_util_1.BinaryView(bGvar).next(io_bin_ttf_1.Gvar.Read, gOrd, cfg, gvarIgnore, ctx.designSpace);
        }
        (0, io_bin_ttf_1.rectifyGlyphOrder)(gOrd);
        // Co-glyphs
        const cog = {};
        const bFpgm = sfnt.tables.get(ot_glyphs_1.Fpgm.Tag);
        if (bFpgm)
            cog.fpgm = new bin_util_1.BinaryView(bFpgm).next(io_bin_ttf_1.FpgmIo);
        const bPrep = sfnt.tables.get(ot_glyphs_1.Prep.Tag);
        if (bPrep)
            cog.prep = new bin_util_1.BinaryView(bPrep).next(io_bin_ttf_1.PrepIo);
        const bCvt = sfnt.tables.get(ot_glyphs_1.Cvt.Tag);
        if (bCvt) {
            cog.cvt = new bin_util_1.BinaryView(bCvt).next(io_bin_ttf_1.CvtIo);
            const bCvar = sfnt.tables.get(ot_glyphs_1.Cvt.TagVar);
            if (ctx.designSpace && bCvar) {
                new bin_util_1.BinaryView(bCvar).next(io_bin_ttf_1.CvarIo, cog.cvt, ctx.designSpace);
            }
        }
        return cog;
    }
};
exports.WriteTtfGlyphs = {
    writeMetricVariance: true,
    writeGlyphs(sfnt, cfg, coGlyphs, gOrd, ctx) {
        if (ctx.designSpace && coGlyphs.cvt) {
            const afEmpty = new ImpLib.State(false);
            const bCvar = bin_util_1.Frag.packFrom(io_bin_ttf_1.CvarIo, coGlyphs.cvt, ctx.designSpace, afEmpty);
            if (!afEmpty.get())
                sfnt.add(ot_glyphs_1.Cvt.TagVar, bCvar);
        }
        if (coGlyphs.cvt)
            sfnt.add(ot_glyphs_1.Cvt.Tag, bin_util_1.Frag.packFrom(io_bin_ttf_1.CvtIo, coGlyphs.cvt));
        if (coGlyphs.fpgm)
            sfnt.add(ot_glyphs_1.Fpgm.Tag, bin_util_1.Frag.packFrom(io_bin_ttf_1.FpgmIo, coGlyphs.fpgm));
        if (coGlyphs.prep)
            sfnt.add(ot_glyphs_1.Prep.Tag, bin_util_1.Frag.packFrom(io_bin_ttf_1.PrepIo, coGlyphs.prep));
        if (ctx.designSpace) {
            const afEmpty = new ImpLib.State(false);
            const bGvar = bin_util_1.Frag.packFrom(io_bin_ttf_1.Gvar.Write, gOrd, cfg, ctx.designSpace, afEmpty);
            if (!afEmpty.get())
                sfnt.add(io_bin_ttf_1.Gvar.Tag, bGvar);
        }
        const loca1 = { glyphOffsets: [] };
        const bufGlyf = bin_util_1.Frag.packFrom(io_bin_ttf_1.Glyf.Write, gOrd, loca1, ctx.stat, ctx.extraInfoSink);
        sfnt.add(io_bin_ttf_1.Glyf.Tag, bufGlyf);
        const bufLoca = bin_util_1.Frag.packFrom(io_bin_ttf_1.Loca.Io, loca1, ctx.head);
        sfnt.add(io_bin_ttf_1.Loca.Tag, bufLoca);
    }
};
//# sourceMappingURL=index.js.map