//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorsimple8000series_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/VolumesListByVolumeContainer.json
func ExampleVolumesClient_NewListByVolumeContainerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVolumesClient().NewListByVolumeContainerPager("Device05ForSDKTest", "volumeContainerForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VolumeList = armstorsimple8000series.VolumeList{
		// 	Value: []*armstorsimple8000series.Volume{
		// 		{
		// 			Name: to.Ptr("Clonedvolume1"),
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/Clonedvolume1"),
		// 			Kind: to.Ptr("Series8000"),
		// 			Properties: &armstorsimple8000series.VolumeProperties{
		// 				AccessControlRecordIDs: []*string{
		// 					to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
		// 					BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusDisabled),
		// 					MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusDisabled),
		// 					OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
		// 					SizeInBytes: to.Ptr[int64](10737418240),
		// 					VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest"),
		// 					VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOnline),
		// 					VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("volume1"),
		// 				Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
		// 				ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/volume1"),
		// 				Kind: to.Ptr("Series8000"),
		// 				Properties: &armstorsimple8000series.VolumeProperties{
		// 					AccessControlRecordIDs: []*string{
		// 						to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
		// 						BackupPolicyIDs: []*string{
		// 							to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicyForSDKTest1032280949")},
		// 							BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusDisabled),
		// 							MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusEnabled),
		// 							OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
		// 							SizeInBytes: to.Ptr[int64](10737418240),
		// 							VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest"),
		// 							VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOnline),
		// 							VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("volume2"),
		// 						Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
		// 						ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/volume2"),
		// 						Kind: to.Ptr("Series8000"),
		// 						Properties: &armstorsimple8000series.VolumeProperties{
		// 							AccessControlRecordIDs: []*string{
		// 								to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR1"),
		// 								to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
		// 								BackupPolicyIDs: []*string{
		// 									to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicyForSDKTest1032280949")},
		// 									BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusDisabled),
		// 									MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusEnabled),
		// 									OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
		// 									SizeInBytes: to.Ptr[int64](16106127360),
		// 									VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest"),
		// 									VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOnline),
		// 									VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 								},
		// 						}},
		// 					}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/VolumesGet.json
func ExampleVolumesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVolumesClient().Get(ctx, "Device05ForSDKTest", "VolumeContainerForSDKTest", "Volume1ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Volume = armstorsimple8000series.Volume{
	// 	Name: to.Ptr("Volume1ForSDKTest"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/VolumeContainerForSDKTest/volumes/Volume1ForSDKTest"),
	// 	Kind: to.Ptr("Series8000"),
	// 	Properties: &armstorsimple8000series.VolumeProperties{
	// 		AccessControlRecordIDs: []*string{
	// 			to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
	// 			BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusDisabled),
	// 			MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusEnabled),
	// 			OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
	// 			SizeInBytes: to.Ptr[int64](5368709120),
	// 			VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/VolumeContainerForSDKTest"),
	// 			VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOffline),
	// 			VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/VolumesCreateOrUpdate.json
func ExampleVolumesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVolumesClient().BeginCreateOrUpdate(ctx, "Device05ForSDKTest", "VolumeContainerForSDKTest", "Volume1ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", armstorsimple8000series.Volume{
		Properties: &armstorsimple8000series.VolumeProperties{
			AccessControlRecordIDs: []*string{
				to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
			MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusEnabled),
			SizeInBytes:      to.Ptr[int64](5368709120),
			VolumeStatus:     to.Ptr(armstorsimple8000series.VolumeStatusOffline),
			VolumeType:       to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Volume = armstorsimple8000series.Volume{
	// 	Name: to.Ptr("Volume1ForSDKTest"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/VolumeContainerForSDKTest/volumes/Volume1ForSDKTest"),
	// 	Kind: to.Ptr("Series8000"),
	// 	Properties: &armstorsimple8000series.VolumeProperties{
	// 		AccessControlRecordIDs: []*string{
	// 			to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
	// 			BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusDisabled),
	// 			MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusEnabled),
	// 			OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
	// 			SizeInBytes: to.Ptr[int64](5368709120),
	// 			VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/VolumeContainerForSDKTest"),
	// 			VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOffline),
	// 			VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/VolumesDelete.json
func ExampleVolumesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVolumesClient().BeginDelete(ctx, "Device05ForSDKTest", "VolumeContainerForSDKTest", "Volume1ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/VolumesListMetrics.json
func ExampleVolumesClient_NewListMetricsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVolumesClient().NewListMetricsPager("Device05ForSDKTest", "vcForOdataFilterTest", "CloneVolForSDKTest890836587", "ResourceGroupForSDKTest", "ManagerForSDKTest1", "name/value%20eq%20'PrimaryStorageTieredUsed'%20and%20timeGrain%20eq%20'PT1H'%20and%20startTime%20ge%20'2017-06-17T18:30:00Z'%20and%20endTime%20le%20'2017-06-21T18:30:00Z'%20and%20category%20eq%20'CapacityUtilization'", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricList = armstorsimple8000series.MetricList{
		// 	Value: []*armstorsimple8000series.Metrics{
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Tiered Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageTieredUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metrics"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-21T18:30:00.000Z"); return t}()),
		// 			PrimaryAggregation: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-17T18:30:00.000Z"); return t}()),
		// 			TimeGrain: to.Ptr("01:00:00"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 			Values: []*armstorsimple8000series.MetricData{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/VolumesListMetricDefinition.json
func ExampleVolumesClient_NewListMetricDefinitionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVolumesClient().NewListMetricDefinitionPager("Device05ForSDKTest", "vcForOdataFilterTest", "CloneVolForSDKTest890836587", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionList = armstorsimple8000series.MetricDefinitionList{
		// 	Value: []*armstorsimple8000series.MetricDefinition{
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Tiered Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageTieredUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Locally Pinned Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageLocallyPinnedUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read I/O Operations/s"),
		// 				Value: to.Ptr("InitiatorToDeviceReadOperations"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write I/O Operations/s"),
		// 				Value: to.Ptr("InitiatorToDeviceWriteOperations"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read Bytes/s"),
		// 				Value: to.Ptr("InitiatorToDeviceReadBytes"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write Bytes/s"),
		// 				Value: to.Ptr("InitiatorToDeviceWriteBytes"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read Latency"),
		// 				Value: to.Ptr("InitiatorToDeviceReadLatency"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitSeconds),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write Latency"),
		// 				Value: to.Ptr("InitiatorToDeviceWriteLatency"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitSeconds),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Outstanding I/O"),
		// 				Value: to.Ptr("InitiatorToDeviceOutStandingIO"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Volume"),
		// 					Value: to.Ptr("CloneVolForSDKTest890836587"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/CloneVolForSDKTest890836587"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/VolumesListByDevice.json
func ExampleVolumesClient_NewListByDevicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVolumesClient().NewListByDevicePager("Device05ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VolumeList = armstorsimple8000series.VolumeList{
		// 	Value: []*armstorsimple8000series.Volume{
		// 		{
		// 			Name: to.Ptr("Clonedvolume1"),
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/Clonedvolume1"),
		// 			Kind: to.Ptr("Series8000"),
		// 			Properties: &armstorsimple8000series.VolumeProperties{
		// 				AccessControlRecordIDs: []*string{
		// 					to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
		// 					BackupPolicyIDs: []*string{
		// 						to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicy01ForSDKTest")},
		// 						BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusEnabled),
		// 						MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusDisabled),
		// 						OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
		// 						SizeInBytes: to.Ptr[int64](10737418240),
		// 						VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest"),
		// 						VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOnline),
		// 						VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("volume1"),
		// 					Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
		// 					ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/volume1"),
		// 					Kind: to.Ptr("Series8000"),
		// 					Properties: &armstorsimple8000series.VolumeProperties{
		// 						AccessControlRecordIDs: []*string{
		// 							to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
		// 							BackupPolicyIDs: []*string{
		// 								to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicyForSDKTest1032280949"),
		// 								to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicy01ForSDKTest")},
		// 								BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusEnabled),
		// 								MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusEnabled),
		// 								OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
		// 								SizeInBytes: to.Ptr[int64](10737418240),
		// 								VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest"),
		// 								VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOnline),
		// 								VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 							},
		// 						},
		// 						{
		// 							Name: to.Ptr("volume2"),
		// 							Type: to.Ptr("Microsoft.StorSimple/managers/devices/volumeContainers/volumes"),
		// 							ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest/volumes/volume2"),
		// 							Kind: to.Ptr("Series8000"),
		// 							Properties: &armstorsimple8000series.VolumeProperties{
		// 								AccessControlRecordIDs: []*string{
		// 									to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR1"),
		// 									to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/accessControlRecords/ACR2")},
		// 									BackupPolicyIDs: []*string{
		// 										to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicyForSDKTest1032280949")},
		// 										BackupStatus: to.Ptr(armstorsimple8000series.BackupStatusDisabled),
		// 										MonitoringStatus: to.Ptr(armstorsimple8000series.MonitoringStatusEnabled),
		// 										OperationStatus: to.Ptr(armstorsimple8000series.OperationStatusNone),
		// 										SizeInBytes: to.Ptr[int64](16106127360),
		// 										VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/volumeContainerForSDKTest"),
		// 										VolumeStatus: to.Ptr(armstorsimple8000series.VolumeStatusOnline),
		// 										VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 									},
		// 							}},
		// 						}
	}
}
