/*
 *  $Id: xyzize.c 28821 2025-11-06 16:00:41Z yeti-dn $
 *  Copyright (C) 2016 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gwy.h>

#define RUN_MODES GWY_RUN_IMMEDIATE

static gboolean module_register(void);
static void     module_main    (GwyFile *data,
                                GwyRunModeFlags mode);

static GwyModuleInfo module_info = {
    GWY_MODULE_ABI_VERSION,
    &module_register,
    N_("Converts data fields to XYZ data."),
    "Yeti <yeti@gwyddion.net>",
    "1.2",
    "David Nečas (Yeti)",
    "2016",
};

GWY_MODULE_QUERY2(module_info, xyzize)

static gboolean
module_register(void)
{
    gwy_process_func_register("xyzize",
                              module_main,
                              N_("/_Basic Operations/_XYZize"),
                              GWY_ICON_XYZIZE,
                              RUN_MODES,
                              GWY_MENU_FLAG_IMAGE,
                              N_("Convert to XYZ data"));

    return TRUE;
}

static void
module_main(GwyFile *data, GwyRunModeFlags mode)
{
    GwyField *dfield = NULL;

    g_return_if_fail(mode & RUN_MODES);
    gwy_data_browser_get_current(GWY_APP_FIELD, &dfield, 0);
    GwySurface *surface = gwy_surface_new();
    gwy_surface_set_from_field(surface, dfield);
    gint newid = gwy_file_add_xyz(data, surface);
    gwy_file_set_visible(data, GWY_FILE_XYZ, newid, TRUE);
    g_object_unref(surface);
    gwy_log_add_full(data, GWY_FILE_XYZ, -1, newid, "proc::xyzize", NULL);
}

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
