# Third-party applications

This page lists some the applications that are known to use ITK.

Please, [add your own project](../README.md) details if your
application uses ITK in some way (whether built in or by plugin).

### Applications

- [**Analyze**](https://analyzedirect.com/) software from
  Mayo Clinic BIR.
- [**BioImage Suite**](https://bioimagesuiteweb.github.io/webapp/) integrated image
  analysis software suite developed at Yale University.
- [**BioimageXD**](https://www.bioimagexd.net/) is a free open-source
  software package for analyzing, processing and visualizing
  multi-dimensional microscopy images.
- [**MedINRIA**](https://med.inria.fr/) is a multi-platform medical
  image processing and visualization software developed within the
  Asclepios research project, at INRIA Sophia-Antipolis.
- [**Osirix**](https://www.osirix-viewer.com/) open-source medical
  imaging navigation and visualization tool for DICOM data.
- [**Seg3D**](https://www.sci.utah.edu/cibc-software/seg3d.html) is a
  volume segmentation and processing tool developed by the NIH Center
  for Integrative Biomedical Computing at the University of Utah
  Scientific Computing and Imaging (SCI) Institute.
- [**3D Slicer**](https://www.slicer.org/) is a free, open-source
  software for visualization, processing, segmentation, registration,
  and analysis of medical, biomedical, and other 3D images and meshes;
  and planning and navigating image-guided procedures.
- [**ITK-SNAP**](http://www.itksnap.org/pmwiki/pmwiki.php) is a free,
  open-source, multi-platform software application used to segment
  structures in 3D and 4D biomedical images.
- [**VAA3D**](https://home.penglab.com/proj/vaa3d/home/index.html)
  open-source, multi-dimensional data visualization and analysis.
- [**VolView**](https://volview.kitware.com/) is an open-source
   radiological viewer developed for clinical professionals.
- [**VV**](https://www.creatis.insa-lyon.fr/rio/vv) is an open-source
  and cross platform image viewer, designed for fast and simple
  visualization of spatio-temporal images: 2D, 2D+t, 3D and 3D+t (or
  4D) images.

### Visual/dataflow programming {#visualdataflow_programming}

- [**DeVIDE**](https://graphics.tudelft.nl/devide/) is the Delft
  Visualization Development Environment, a cross-platform software
  framework that provides infrastructure for the rapid creation,
  testing and application of modular image processing and
  visualisation algorithm implementations.
- [**MeVisLab**](https://www.mevislab.de/) is a modular framework
  for image processing research and development with a special
  focus on medical imaging.
- [**SCIRun**](https://www.sci.utah.edu/cibc-software/scirun.html) is a
  Problem Solving Environment (PSE), for modeling, simulation and
  visualization of scientific problems.
- [**Voreen**](https://www.uni-muenster.de/Voreen/) is an open-source
  rapid application development framework for the interactive
  visualization and analysis of multi-modal volumetric data sets.

### Frameworks

- [**Elastix**](https://elastix.lumc.nl/) is a toolbox for rigid and
  nonrigid registration of images.
- [**GIMIAS**](https://link.springer.com/chapter/10.1007/978-3-642-01932-6_45) was
  an open-source framework for efficient development of research tools
  and clinical prototypes.
- [**MARVIN**](https://www.sciencedirect.com/science/article/abs/pii/S0169260708000965)
  was a C++ application framework for rapid and simple development of medical
  applications, part of [NCCR "Co-Me - Computer Aided and Image Guided Medical Interventions"](https://www.snf.ch/en/9ihBpawyw4Fro4Y9/page/researchinFocus/nccr/nccr-co-me/).
- [**MITK**](https://www.mitk.org/wiki/The_Medical_Imaging_Interaction_Toolkit_(MITK))
  is a free open-source software for the development of interactive
  medical image processing software.
- [**Orfeo Toolbox**](https://www.orfeo-toolbox.org/) is an open-source
  project for state-of-the-art remote sensing.

### Other utilities and helpers

ITK's features are available to MATLAB without requiring building the
sources, as all the functionality is expsed through ITK's Python
packages and remote module Python packages.

Currently maintained command line tools and wrappers around ITK
include:

- The [c3d command line tools](http://www.itksnap.org/pmwiki/pmwiki.php?n=Documentation.CommandLine)
  developed in the context of ITK-SNAP.
- The CLI applications maintained in the [ITKTubeTK project](https://github.com/InsightSoftwareConsortium/ITKTubeTK).
