ITK 5.3.0 Release Notes: 3D Slicer Python Packages
===================================================

We are exceedingly pleased to announce the [Insight Toolkit (ITK)](https://itk.org) 5.3.0 is available for download! :tada: :santa: :gift: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration in a spatially-oriented architecture.

🔦 Highlights
-------------

ITK 5.3 is a feature release that

- [accelerates performance](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc01)
- provides [new segmentation, shape analysis, and registration algorithms](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc02)
- [improves documentation](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc03)
- adds Python-driven [distributed computing support](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc04)
- adds [3D Slicer](https://slicer.org) Python package support
- and many more improvements

ITK 5.3.0 highlights `itk` Python package support in [3D Slicer](https://slicer.org). Binary macOS, Linux, and Windows `itk-*` Python packages can be installed directly into Slicer's Python runtime using [standard Slicer mechanisms](https://slicer.readthedocs.io/en/latest/developer_guide/script_repository/gui.html#install-a-python-package). Python packages from the main repository can be installed along with [wheels built from Remote Modules](https://pypi.org/search/?q=itk-&o=). Slicer module development is supported by `itk`'s Python [compatibility with NumPy](https://itkpythonpackage.readthedocs.io/en/master/Quick_start_guide.html#itk-and-numpy) and [compatibility with VTK](https://itkpythonpackage.readthedocs.io/en/master/Quick_start_guide.html#itk-and-vtk).

![](https://i.imgur.com/CqN33m3.png)

![](https://i.imgur.com/E7QvIiI.png)

![](https://i.imgur.com/cNmcm05.png)


*Alignment of primate skulls with [SlicerMorph](https://slicermorph.github.io/) through ITK and ITK remote module Python packages. Registration of the skulls facilicates shape-based quantification of the morphological characteristics of specimens and related species.*

ITK 5.3.0 also includes Python dictionary conversions functions, `itk.dict_from_image`, `itk.image_from_dict`, `itk.dict_from_mesh`, `itk.mesh_from_dict`, and `itk.dict_from_transform`, `itk.transform_from_dict`.  Major improvements were made to the generation of Python interface, `*.pyi` files. Additional remote modules we contributed to support point set registration, [ITKFPFH](https://github.com/InsightSoftwareConsortium/ITKFPFH) computes feature points that could be used to obtain salient points while performing registration of two point clouds, and [ITKRANSAC](https://github.com/InsightSoftwareConsortium/ITKRANSAC) performs feature-based point cloud registration with the Random Sample Consensus (RANSAC) algorithm. A [new GitHub Action](https://github.com/InsightSoftwareConsortium/ITKRemoteModuleBuildTestPackageAction) was created to faciliate testing, packaging, and maintenance of remote modules. The Action includes recent developments to support the creation of 3.11 Python packages, ARM and GPGPU-capable Python packages.


💾 Download
---------------------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```sh
pip install --upgrade itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.3.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/InsightSoftwareGuide-Book1-5.3.0.pdf)
- [InsightSoftwareGuide-Book2-5.3.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/InsightSoftwareGuide-Book2-5.3.0.pdf)

**Library Sources**

- [InsightToolkit-5.3.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/InsightToolkit-5.3.0.tar.gz)
- [InsightToolkit-5.3.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/InsightToolkit-5.3.0.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.3.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/InsightData-5.3.0.tar.gz)
- [InsightData-5.3.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/InsightData-5.3.0.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3.0/SHA512SUMS)

✨ Features
------------

### Python

- Python packages now include oneTBB support for improved performance
- Following CPython's deprecation schedule, Python 3.6 is no longer supported
- Python packages added for Python 3.10, 3.11
- Initial Python wrapping is available for the Video modules
- `TransformToDisplacementField` is now available in Python
- Pythonic IO functions `itk.imread` understands `pathlib.Path`'s
- New `repr` for `itk.Matrix`
- `np.asarray` works on `itk.Matrix`
- `DCMTKImageIO` wrapping addressed
- `GradientDifferenceImageToImageMetric` wrapped
- `SynImageRegistrationMethod`, `BSplineSynImageRegistrationMethod` wrapped
- `ConjugateGradientLineSearchOptimizerv4` wrapped
- Wrap `ImageRegistrationMethodv4` for `itk.Mesh`
- Wrap `PointSetToPointSetMetric`, `PointSetToPointSetRegistrationMethod`
- Wrap `ANTSNeighborhoodCorrelationImageToImageMetricv4`
- Nearly all registration v4 classes are now wrapped
- `VectorImage` input for `DisplacementFieldTransform`
- Python wrapping for spatial orientation functionality
- PyImageFilter wrapped for additional types, supports pipeline functionality
- NumPy array interfaces for `itk.PointSet`, `itk.Mesh`
- manylinux_2_28 and manylinux2014 wheels are provided for x86_64, manylinux_2_28 for aarch64
- Dask support for `itk.Image`, `itk.PointSet`, `itk.Mesh`, `itk.Transform`
- Linux x86_x64 binary Python packages are available for older and newer C++ standard libraries ABI's
- Wrap `itk.PointsLocator`
- `MetaDataObject` wrapping for `itk.Matrix`
- Generation of Python interface, `*.pyi` files
- Python dictionary conversion functions: `itk.dict_from_image`, `itk.image_from_dict`, `itk.dict_from_mesh`, `itk.mesh_from_dict`, `itk.dict_from_transform`, `itk.transform_from_dict`.


### C++

- C++14 is now required
- The minimum CMake version required is now 3.16.3
- New functions: `MakePoint`, `MakeVector`, `MakeIndex`, `MakeSize`.
- Targets in Visual Studio and other IDE's are now organize hierachically by ITK Group and Module
- Most of `itk::mpl` meta-programming functions replaced by C++14 equivalents
- Performance accelerations for b-spline interpolation, Mattes mutual information metric computation
- Improved modern C++ adoption, e.g. additional adoption of `constexpr`, `auto`
- `itk::ReadMesh`, `itk::WriteMesh` simple reader functions available, similar to `itk::ReadImage`, `itk::WriteImage`
- FFT backends are now registered through the object factory mechanism
- `cbegin()` and `cend()` member functions to `Index`, `Offset`, `Size`
- Add `itk::MakeFilled<TContainer>(value)`
- `itk::ConvertNumberToString<TValue>(val)` convenience function
- `itk::bit_cast<TDestination>(source)` function
- `itk::PolyLineCell`
- `InputSpaceName` and `OutputSpaceName` support for `itk::Transform`
- `qfac`, `qt_xyz` added to Nifti metadata
- `LZW` compression support
- Support requested output region in FFT filters
- New `itkBooleanMacro` for boolean ivar
- Improved support for large Nifti files
- Mimic C++20 `std::make_unique_for_overwrite` for dynamic arrays
- Add DataObject::UpdateSource() alternative to GetSource()->Update()
- Support `itk::Similarity3DTransform` in `itk::LandmarkBasedTransformInitializer`
- Many code coverage improvements

### New filters

- `itk::TransformGeometryImageFilter`: applies a rigid transform to an `Image`'s metadata.
- 1D FFT classes
    - Interface classes for forward, inverse transformations
    - Vnl implementations
    - FFTW implementations
- `itk::TriangleMeshCurvatureCalculator` - Gaussian curvature calculator for `itk::Mesh`
- `FFTDiscreteGaussianImageFilter` -- discrete gaussian filters via FFTs

### Remote module updates

New remote modules:

- [HASI](https://github.com/KitwareMedical/HASI): High-Throughput Applications for Skeletal Imaging
- [ITKGrowCut](https://github.com/InsightSoftwareConsortium/ITKGrowCut): segments a 3D image from user-provided foreground and background seeds
- [ITKMeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData): Convert an ITK Mesh to a simple data structure compatible with vtkPolyData
- [ITKCudaCommon](https://github.com/SimonRit/ITKCudaCommon): Framework for processing images with CUDA
- [itk-wasm WebAssemblyInterface](https://github.com/InsightSoftwareConsortium/itk-wasm): Build WebAssembly processing pipelines to native executables and support ITK WebAssembly file formats
- [ITKCleaver](https://github.com/SCIInstitute/ITKCleaver): Multimaterial tetrahedral meshing.
- [ITKIOMeshSWC](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC): Read meshes from SWC files, a format for representing neuron morphology.
- [ITKFPFH](https://github.com/InsightSoftwareConsortium/ITKFPFH): Compute feature points that could be used to obtain salient points while performing registration of two point clouds.
- [ITKRANSAC](https://github.com/InsightSoftwareConsortium/ITKRANSAC): Feature-based point cloud registration with the Random Sample Consensus (RANSAC) algorithm.

Updated remote modules: [AdaptiveDenoising](https://github.com/ntustison/ITKAdaptiveDenoising.git), [AnalyzeObjectLabelMap](https://github.com/InsightSoftwareConsortium/itkAnalyzeObjectMap.git), [AnisotropicDiffusionLBR](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR.git), [BSplineGradient](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient.git), [BioCell](https://github.com/InsightSoftwareConsortium/ITKBioCell.git), [BoneEnhancement](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement.git), [BoneMorphometry](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry.git), [Cuberille](https://github.com/InsightSoftwareConsortium/ITKCuberille.git), [NeuralNetworks](https://github.com/InsightSoftwareConsortium/ITKNeuralNetworks.git), [FPFH](https://github.com/InsightSoftwareConsortium/ITKFPFH.git), [FixedPointInverseDisplacementField](https://github.com/InsightSoftwareConsortium/ITKFixedPointInverseDisplacementField.git), [GenericLabelInterpolator](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator.git), [GrowCut](https://github.com/InsightSoftwareConsortium/ITKGrowCut.git), [HASI](https://github.com/KitwareMedical/HASI.git), [HigherOrderAccurateGradient](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient.git), [IOFDF](https://github.com/InsightSoftwareConsortium/ITKIOFDF.git), [IOMeshSTL](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL.git), [IOOpenSlide](https://github.com/InsightSoftwareConsortium/ITKIOOpenSlide.git), [IOScanco](https://github.com/KitwareMedical/ITKIOScanco.git), [IOTransformDCMTK](https://github.com/InsightSoftwareConsortium/ITKIOTransformDCMTK.git), [IsotropicWavelets](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets.git), [LabelErodeDilate](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate.git), [LesionSizingToolkit](https://github.com/InsightSoftwareConsortium/LesionSizingToolkit.git), [MGHIO](https://github.com/InsightSoftwareConsortium/itkMGHImageIO.git), [MeshNoise](https://github.com/InsightSoftwareConsortium/ITKMeshNoise.git), [MeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData.git), [MinimalPathExtraction](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction.git), [Montage](https://github.com/InsightSoftwareConsortium/ITKMontage.git), [MorphologicalContourInterpolation](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation.git), [MultipleImageIterator](https://github.com/KitwareMedical/MultipleImageIterator.git), [ParabolicMorphology](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology.git), [PerformanceBenchmarking](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking.git), [PhaseSymmetry](https://github.com/KitwareMedical/ITKPhaseSymmetry.git), [PolarTransform](https://github.com/InsightSoftwareConsortium/ITKPolarTransform.git), [PrincipalComponentsAnalysis](https://github.com/InsightSoftwareConsortium/ITKPrincipalComponentsAnalysis.git), [RLEImage](https://github.com/KitwareMedical/ITKRLEImage.git), [RTK](https://github.com/RTKConsortium/RTK.git), [SCIFIO](https://github.com/scifio/scifio-imageio.git), [Shape](https://github.com/SlicerSALT/ITKShape.git), [SimpleITKFilters](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters.git), [SkullStrip](https://github.com/InsightSoftwareConsortium/ITKSkullStrip.git), [SmoothingRecursiveYvvGaussianFilter](https://github.com/Inria-Asclepios/SmoothingRecursiveYvvGaussianFilter), [SplitComponents](https://github.com/InsightSoftwareConsortium/ITKSplitComponents.git), [Strain](https://github.com/KitwareMedical/ITKStrain.git), [SubdivisionQuadEdgeMeshFilter](https://github.com/InsightSoftwareConsortium/itkSubdivisionQuadEdgeMeshFilter), [TextureFeatures](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures.git), [Thickness3D](https://github.com/InsightSoftwareConsortium/ITKThickness3D.git), [TotalVariation](https://github.com/InsightSoftwareConsortium/ITKTotalVariation.git), [TubeTK](https://github.com/InsightSoftwareConsortium/ITKTubeTK.git), [TwoProjectionRegistration](https://github.com/InsightSoftwareConsortium/ITKTwoProjectionRegistration.git), [Ultrasound](https://github.com/KitwareMedical/ITKUltrasound.git), [VariationalRegistration](https://github.com/InsightSoftwareConsortium/ITKVariationalRegistration.git), and [WebAssemblyInterface](https://github.com/InsightSoftwareConsortium/itk-wasm.git).


### Third party library updates

- dcmtk
- double-conversion
- eigen
- expat
- fftw
- gdcm
- googletest
- hdf5
- kwsys
- kwiml
- minc
- metaio
- niftilib
- vxl
- zlib migrated to zlib-ng

🙏 Congratulations
------------------------

Congratulations and **thank you** to everyone who contributed to this release.

Of the *90 authors* who contributed since v5.2.0, we would like to specially recognize the new contributors:

*Michael Kuczynski, Tim Evain, Tomoyuki SADAKANE, Mario Emmenlauer, Andreas Gravgaard Andersen, Ebrahim Ebrahim, josempozo, Wenqi Li, Genevieve Buckley, Oleksandr Zavalistyi, Jose Tascon, Pranjal Sahu, ambrozicc1, Vagrant Cascadian, MrTzschr, Philip Cook, Tihomir Heidelberg, Jason Rudy, Kian Weimer, z0gSh1u, Darren Thompson, Darren, Jose M Pozo, Paul Elliott, Gabriele Belotti, Rafael Palomar, Fernando Hueso-González, Mark Asselin, mrhardisty, Laryssa Abdala, Roland Bruggmann, Natalie Johnston, ferdymercury, Shreeraj Jadhav, luz paz, Mikhail Polkovnikov, Chris Harris, Matt Cieslak, Alex, Imko Schumacher, Joey Cho, Butui Hu, Shengpeng YU, Alexy Pellegrini, and Stefan Dinkelacker.*

🗣️ What's Next
-----------------------------------

Major improvements to the toolkit in this release led to an extended release timeline as refinements were made in testing. For 5.4.0, we plan to return to our regular biannual release cadence. For 5.4, anticipated improvements include enhancements to GPU Python packages, Python packaging improvements via [scikit-build](https://scikit-build.org), improved [MONAI](https://monai.io/) support, and [WebAssembly support](https://wasm.itk.org). A few patch releases are expected before 5.4.0.

Discuss your experiences at [discourse.itk.org](https://discourse.itk.org) or [forum.image.sc](https://forum.image.sc). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium). Contribute donations through [NumFOCUS](https://numfocus.org) on [our Open Collective page](https://opencollective.com/itk). For commercial support, reach out to [Kitware](https://www.kitware.com/support).

**Enjoy ITK!**

ITK Changes Since v5.3rc04
---------------------------------------------

### Alex (1):

#### Bug Fixes

- GitHub Workflows security hardening ([357282c0d8](https://github.com/InsightSoftwareConsortium/ITK/commit/357282c0d8))


### Brad King (2):

#### Enhancements

- Update double-conversion import script to record prior import ([864cd366ce](https://github.com/InsightSoftwareConsortium/ITK/commit/864cd366ce))
- Update double-conversion import script to get latest version ([0315c6c77a](https://github.com/InsightSoftwareConsortium/ITK/commit/0315c6c77a))


### Bradley Lowekamp (10):

#### Enhancements

- Adding GTest for LabelOverlapMeasuresImageFilter ([01bdd3170a](https://github.com/InsightSoftwareConsortium/ITK/commit/01bdd3170a))
- Update LabelOverlapMeasures to use dynamic threading ([19fab83d67](https://github.com/InsightSoftwareConsortium/ITK/commit/19fab83d67))
- Use ImageSink for LabelOverlapMeasures base class ([8d8a7050df](https://github.com/InsightSoftwareConsortium/ITK/commit/8d8a7050df))
- Enable HDF5_ENABLE_THREADSAFE ([8c49c10b50](https://github.com/InsightSoftwareConsortium/ITK/commit/8c49c10b50))

#### Performance Improvements

- improve map usage and increment prefix ([777e66d459](https://github.com/InsightSoftwareConsortium/ITK/commit/777e66d459))

#### Platform Fixes

- Fix comparison of integer expressions of different signedness ([a7c26b586f](https://github.com/InsightSoftwareConsortium/ITK/commit/a7c26b586f))

#### Bug Fixes

- Use named inputs for LabelOverlapMeasuresImageFilter ([83480a0aa3](https://github.com/InsightSoftwareConsortium/ITK/commit/83480a0aa3))
- Update LabelOverlapMeasures internal class ([9e90993c9f](https://github.com/InsightSoftwareConsortium/ITK/commit/9e90993c9f))
- initialize image buffer in Nifti direction test ([88e1100ce2](https://github.com/InsightSoftwareConsortium/ITK/commit/88e1100ce2))
- Fix OutputWindow thread-safety GetInstance ([7a121ac7b6](https://github.com/InsightSoftwareConsortium/ITK/commit/7a121ac7b6))


### Butui Hu (1):

#### Platform Fixes

- use sysconfig.get_path as PEP 632 deprecate distutils module ([28325d921a](https://github.com/InsightSoftwareConsortium/ITK/commit/28325d921a))


### Dave Chen (1):

#### Documentation Updates

- Fixed Midas Journal link to use HTTPS ([b41733e624](https://github.com/InsightSoftwareConsortium/ITK/commit/b41733e624))


### Dženan Zukić (14):

#### Enhancements

- Add more symbols to HDF5 name mangling ([bd7fdd6097](https://github.com/InsightSoftwareConsortium/ITK/commit/bd7fdd6097))
- Refactor UpdateDoubleConversionFromGoogle.sh ([bb5795e09f](https://github.com/InsightSoftwareConsortium/ITK/commit/bb5795e09f))
- Enable building HL library for the bundled HDF5 ([ad9d33bd4e](https://github.com/InsightSoftwareConsortium/ITK/commit/ad9d33bd4e))
- Update remote modules using the script ([1546a4c2ec](https://github.com/InsightSoftwareConsortium/ITK/commit/1546a4c2ec))
- Add a test for different spacing in NIFTI's qform and sform ([7e125c66e3](https://github.com/InsightSoftwareConsortium/ITK/commit/7e125c66e3))
- Prepare for name mangling update of HDF5_HL library ([b0aa2fbdf4](https://github.com/InsightSoftwareConsortium/ITK/commit/b0aa2fbdf4))

#### Platform Fixes

- Previous commit was pushed erroneously ([8a904b1e5a](https://github.com/InsightSoftwareConsortium/ITK/commit/8a904b1e5a))
- Set CMake Policy 135 to NEW to suppress warnings in CMake 3.24 ([e3d6c94eb9](https://github.com/InsightSoftwareConsortium/ITK/commit/e3d6c94eb9))
- WindowedSincInterpolate OffsetTable return type [VS2017 fix] ([05adf2d1f6](https://github.com/InsightSoftwareConsortium/ITK/commit/05adf2d1f6))
- Fix build with ITK_USE_SYSTEM_HDF5=ON ([d93d987a60](https://github.com/InsightSoftwareConsortium/ITK/commit/d93d987a60))
- Update name mangling of HDF5_HL library ([0827484a43](https://github.com/InsightSoftwareConsortium/ITK/commit/0827484a43))

#### Bug Fixes

- use DICOM for reading directories only if imageio is not specified ([55bdee957f](https://github.com/InsightSoftwareConsortium/ITK/commit/55bdee957f))

#### Style Changes

- Make NIFTI test CMakeLists.txt more readable ([62eb5ca265](https://github.com/InsightSoftwareConsortium/ITK/commit/62eb5ca265))
- Sort the mangling defines in HDF5 as a single group ([b0ed109002](https://github.com/InsightSoftwareConsortium/ITK/commit/b0ed109002))


### Google double-conversion Maintainers (3):

#### Miscellaneous Changes

- DoubleConversion 2017-03-06 (4abe3267) ([25368a25b8](https://github.com/InsightSoftwareConsortium/ITK/commit/25368a25b8))
- DoubleConversion 2020-12-17 (0d3733a4) ([8f0ef9b9c2](https://github.com/InsightSoftwareConsortium/ITK/commit/8f0ef9b9c2))
- DoubleConversion 2022-07-07 (af09fd65) ([7f9a214d3e](https://github.com/InsightSoftwareConsortium/ITK/commit/7f9a214d3e))


### GoogleTest Upstream (1):

#### Miscellaneous Changes

- GoogleTest 2022-06-27 (58d77fa8) ([5a8e439610](https://github.com/InsightSoftwareConsortium/ITK/commit/5a8e439610))


### Hans J. Johnson (34):

#### Enhancements

- Force test failure on bad file writing ([554e45bd6a](https://github.com/InsightSoftwareConsortium/ITK/commit/554e45bd6a))
- Isolate img that is being corrupted. ([6a5a715931](https://github.com/InsightSoftwareConsortium/ITK/commit/6a5a715931))
- Run script for Python3 find_package upgrade ([55c7b7f380](https://github.com/InsightSoftwareConsortium/ITK/commit/55c7b7f380))
- Huge file needed for zlib library ([124dc8d798](https://github.com/InsightSoftwareConsortium/ITK/commit/124dc8d798))
- Remove duplicate class VersorRigid3DTransformOptimizer ([c5dafc7423](https://github.com/InsightSoftwareConsortium/ITK/commit/c5dafc7423))
- Add check if optimizer supports scales ([1fefa3f2a0](https://github.com/InsightSoftwareConsortium/ITK/commit/1fefa3f2a0))
- Improve diagnostic reporting for tests ([82665b23b4](https://github.com/InsightSoftwareConsortium/ITK/commit/82665b23b4))
- Convert unspecified exceptions to itk ([fcf8b39ac8](https://github.com/InsightSoftwareConsortium/ITK/commit/fcf8b39ac8))
- Consolidate resetting IO object for reuse ([bbddf47502](https://github.com/InsightSoftwareConsortium/ITK/commit/bbddf47502))
- Add script for Python3 find_package upgrade ([bfa85dd547](https://github.com/InsightSoftwareConsortium/ITK/commit/bfa85dd547))
- Specify minimum allowed python version ([211c66d197](https://github.com/InsightSoftwareConsortium/ITK/commit/211c66d197))
- Provide install of itk-stub pyi files ([0af0a247b1](https://github.com/InsightSoftwareConsortium/ITK/commit/0af0a247b1))
- Add typehints to python wheel packages ([d7bb212223](https://github.com/InsightSoftwareConsortium/ITK/commit/d7bb212223))

#### Documentation Updates

- Fix Exception message suggestion ([cb4f17f51e](https://github.com/InsightSoftwareConsortium/ITK/commit/cb4f17f51e))
- Remove outdated migration information ([1608256c5a](https://github.com/InsightSoftwareConsortium/ITK/commit/1608256c5a))

#### Platform Fixes

- Remove deprecated uses of vxl for LEGACY ITK ([fee75ae5ae](https://github.com/InsightSoftwareConsortium/ITK/commit/fee75ae5ae))
- Allow changing CMAKE_INSTALL_LIBDIR ([380a469634](https://github.com/InsightSoftwareConsortium/ITK/commit/380a469634))
- Allow install lib directory name changes ([5b09d54666](https://github.com/InsightSoftwareConsortium/ITK/commit/5b09d54666))
- Missing "\ingroup ITKMesh" doxygen setting ([bdf5dca346](https://github.com/InsightSoftwareConsortium/ITK/commit/bdf5dca346))
- Suppress uninitialed variable warning ([a1cf161dad](https://github.com/InsightSoftwareConsortium/ITK/commit/a1cf161dad))
- ITK_WRAP_PYTHON_VERSION is used for remote modules ([278129bd7d](https://github.com/InsightSoftwareConsortium/ITK/commit/278129bd7d))


#### Bug Fixes

- Provide itk::Exception for invalid NIFTI write ([63590b85bb](https://github.com/InsightSoftwareConsortium/ITK/commit/63590b85bb))
- Incorrect comparison of nifti header matricies ([93cbef03f4](https://github.com/InsightSoftwareConsortium/ITK/commit/93cbef03f4))
- DTITubeSpatialObjectTest was not run ([00c0901899](https://github.com/InsightSoftwareConsortium/ITK/commit/00c0901899))
- Fix unstable mathematical computations ([c09a43905e](https://github.com/InsightSoftwareConsortium/ITK/commit/c09a43905e))
- Avoid dangerous use of putenv ([9309d06b73](https://github.com/InsightSoftwareConsortium/ITK/commit/9309d06b73))
- A temporary work-around for HDF5 testing ([2ddf42785b](https://github.com/InsightSoftwareConsortium/ITK/commit/2ddf42785b))
- _Python3_EXECUTABLE -> _specified_Python3_EXECUTABLE ([4a019c5e74](https://github.com/InsightSoftwareConsortium/ITK/commit/4a019c5e74))

#### Style Changes

- Place large block of common code in single file ([1c26fcd25f](https://github.com/InsightSoftwareConsortium/ITK/commit/1c26fcd25f))
- Consolidate duplicated code ([6b039200cb](https://github.com/InsightSoftwareConsortium/ITK/commit/6b039200cb))
- [Versor|VersorRigid3D]TransformOptimizer same ([c461bdd9f8](https://github.com/InsightSoftwareConsortium/ITK/commit/c461bdd9f8))
- Simplify local variable compuations ([682ad7c9ec](https://github.com/InsightSoftwareConsortium/ITK/commit/682ad7c9ec))
- Fix test debugging statement format. ([494771b5fc](https://github.com/InsightSoftwareConsortium/ITK/commit/494771b5fc))
- Make Python3_ROOT_DIR user-visible ([73ddcf5a82](https://github.com/InsightSoftwareConsortium/ITK/commit/73ddcf5a82))


### Hastings Greer (2):

#### Documentation Updates

- warning for calling GetImageViewFromArray on non-contiguous array ([cd9cf8d20b](https://github.com/InsightSoftwareConsortium/ITK/commit/cd9cf8d20b))
- add need_contiguous to GetImageViewFromArray docstring ([b07aaff1ff](https://github.com/InsightSoftwareConsortium/ITK/commit/b07aaff1ff))


### Jean-Christophe Fillion-Robin (1):

#### Platform Fixes

- Ensure client project can find externally build ITK module ([b9b622db64](https://github.com/InsightSoftwareConsortium/ITK/commit/b9b622db64))


### Joey Cho (1):

#### Enhancements

- Improve LabelOverlapMeasuresImageFilter ([1f7f46be40](https://github.com/InsightSoftwareConsortium/ITK/commit/1f7f46be40))


### Jon Haitz Legarreta Gorroño (89):

#### Enhancements

- Switch Azure Pipelines macOS environment version ([b1e080ddf8](https://github.com/InsightSoftwareConsortium/ITK/commit/b1e080ddf8))
- Switch Azure Pipelines Linux environment version ([2c8be6920f](https://github.com/InsightSoftwareConsortium/ITK/commit/2c8be6920f))
- Add `itkBooleanMacro` for boolean ivar ([16d7523829](https://github.com/InsightSoftwareConsortium/ITK/commit/16d7523829))
- Increase coverage for miscellaneous classes ([b248e0da54](https://github.com/InsightSoftwareConsortium/ITK/commit/b248e0da54))
- Add `itkBooleanMacro` for boolean ivar ([a2fa9deeb2](https://github.com/InsightSoftwareConsortium/ITK/commit/a2fa9deeb2))
- Increase coverage for miscellaneous classes ([669a39ca85](https://github.com/InsightSoftwareConsortium/ITK/commit/669a39ca85))
- Increase `itk::UniformRandomSpatialNeighborSubsampler` coverage ([3c6de8f009](https://github.com/InsightSoftwareConsortium/ITK/commit/3c6de8f009))
- Increase `itk::STAPLEImageFilter` coverage ([aa76dfb7d7](https://github.com/InsightSoftwareConsortium/ITK/commit/aa76dfb7d7))
- Add `FastMarchingImageToNodePairContainerAdaptor` getter methods ([071ceacb06](https://github.com/InsightSoftwareConsortium/ITK/commit/071ceacb06))
- Increase `itk::RegularStepGradientDescentOptimizerv4` coverage ([59e7d01dec](https://github.com/InsightSoftwareConsortium/ITK/commit/59e7d01dec))
- Increase coverage for `itk::ImageRegistrationMethodv4` ([a639acc22c](https://github.com/InsightSoftwareConsortium/ITK/commit/a639acc22c))
- Increase `itk::MultiLabelSTAPLEImageFilter` coverage ([fcfa0c6498](https://github.com/InsightSoftwareConsortium/ITK/commit/fcfa0c6498))
- Use `itkPrintSelfObjectMacro` to print objects that can be null ([1802f39a89](https://github.com/InsightSoftwareConsortium/ITK/commit/1802f39a89))
- Test `itk::ImageFileReader` image IO to requested region mismatch ([182764b9a9](https://github.com/InsightSoftwareConsortium/ITK/commit/182764b9a9))
- Use `itkPrintSelfObjectMacro` to print objects that can be null ([a0ba000906](https://github.com/InsightSoftwareConsortium/ITK/commit/a0ba000906))
- Fix the `Documentation` PR title identification ([7539b50a4d](https://github.com/InsightSoftwareConsortium/ITK/commit/7539b50a4d))
- Clamp `STAPLEImageFilter` maximum iterations ([a7546b667d](https://github.com/InsightSoftwareConsortium/ITK/commit/a7546b667d))
- Add a test to check reading large `NIfTI` image subregions ([f423f2d7c7](https://github.com/InsightSoftwareConsortium/ITK/commit/f423f2d7c7))
- Pin Python version in non-Python Azure pipelines ([154831a4ba](https://github.com/InsightSoftwareConsortium/ITK/commit/154831a4ba))
- Increase coverage for `itk::SobelOperator` ([c86fd7896d](https://github.com/InsightSoftwareConsortium/ITK/commit/c86fd7896d))
- Increase coverage for `itk::RoundImageFilter` ([056fee3d93](https://github.com/InsightSoftwareConsortium/ITK/commit/056fee3d93))
- Increase coverage for `itk::RandomImageSource` ([84fc5bea3a](https://github.com/InsightSoftwareConsortium/ITK/commit/84fc5bea3a))
- Increase coverage for miscellaneous classes ([dca4a36dde](https://github.com/InsightSoftwareConsortium/ITK/commit/dca4a36dde))

#### Documentation Updates

- Remove wrong class names from test documentation ([683097dc88](https://github.com/InsightSoftwareConsortium/ITK/commit/683097dc88))
- Fix spelling mistake in printed message ([afbfcb5b54](https://github.com/InsightSoftwareConsortium/ITK/commit/afbfcb5b54))
- Fix typos and grammar ([fb0a377f05](https://github.com/InsightSoftwareConsortium/ITK/commit/fb0a377f05))
- Conform to ITK SW Guidelines in comments ([1800d81600](https://github.com/InsightSoftwareConsortium/ITK/commit/1800d81600))
- Document methods in header file ([283028c35e](https://github.com/InsightSoftwareConsortium/ITK/commit/283028c35e))
- Fix argument names in method Doxygen documentation ([56de405a05](https://github.com/InsightSoftwareConsortium/ITK/commit/56de405a05))
- Fix unexpected token in class documentation ([14e53cbd90](https://github.com/InsightSoftwareConsortium/ITK/commit/14e53cbd90))
- Fix Doxygen automatic link to member function ([8a6eb3db3e](https://github.com/InsightSoftwareConsortium/ITK/commit/8a6eb3db3e))
- Fix `itk::MRASlabIdentifier` class documentation list syntax ([68979a9537](https://github.com/InsightSoftwareConsortium/ITK/commit/68979a9537))
- Fix links to ITK Sphinx examples in class documentation ([29eff36450](https://github.com/InsightSoftwareConsortium/ITK/commit/29eff36450))
- Remove Sphinx link to non-existing example ([a6ee7854c2](https://github.com/InsightSoftwareConsortium/ITK/commit/a6ee7854c2))
- Provide a name for the `FitSplineIntoPointSet` Sphinx example ([4aeb73776b](https://github.com/InsightSoftwareConsortium/ITK/commit/4aeb73776b))
- Improve Sphinx example displayed names ([cbbb1b0409](https://github.com/InsightSoftwareConsortium/ITK/commit/cbbb1b0409))
- Use Doxygen automatic class links in module descriptions ([c139163661](https://github.com/InsightSoftwareConsortium/ITK/commit/c139163661))
- Fix NRRD links in module descriptions ([e99bebe942](https://github.com/InsightSoftwareConsortium/ITK/commit/e99bebe942))
- Fix typos and improve wording in module descriptions ([604237d0fa](https://github.com/InsightSoftwareConsortium/ITK/commit/604237d0fa))
- Fix miscellaneous Doxygen warnings ([92ae16f315](https://github.com/InsightSoftwareConsortium/ITK/commit/92ae16f315))
- Make Doxygen class command indent consistent ([87a66198e1](https://github.com/InsightSoftwareConsortium/ITK/commit/87a66198e1))
- Link groups in Doxygen in module description ([a0d0b4caa9](https://github.com/InsightSoftwareConsortium/ITK/commit/a0d0b4caa9))
- Use Doxygen syntax to create automatic links to members ([3025d8365f](https://github.com/InsightSoftwareConsortium/ITK/commit/3025d8365f))
- Fix typos in `StreamingImageIOBase` class documentation ([32d3cb6599](https://github.com/InsightSoftwareConsortium/ITK/commit/32d3cb6599))
- Fix ITK class namespace spelling in `Core` group description ([1e003467e2](https://github.com/InsightSoftwareConsortium/ITK/commit/1e003467e2))
- Escape Doxygen `\ref` command in module description ([f8cd1766a2](https://github.com/InsightSoftwareConsortium/ITK/commit/f8cd1766a2))
- Triple escape Doxygen `\ref` command in module description ([bf6d071798](https://github.com/InsightSoftwareConsortium/ITK/commit/bf6d071798))
- Fix module names in module description ref links ([d297464766](https://github.com/InsightSoftwareConsortium/ITK/commit/d297464766))
- Link groups in Doxygen in module description ([67d453892c](https://github.com/InsightSoftwareConsortium/ITK/commit/67d453892c))
- Remove redundant wording in module description linking ([8e34f1078e](https://github.com/InsightSoftwareConsortium/ITK/commit/8e34f1078e))
- Fix `CONTRIBUTING` file link in binary data upload file ([460e3b6614](https://github.com/InsightSoftwareConsortium/ITK/commit/460e3b6614))
- Document the wrapping modules' extraction/archived timestamp flags ([dbdae2499f](https://github.com/InsightSoftwareConsortium/ITK/commit/dbdae2499f))

#### Platform Fixes

- Remove duplicate include file ([8cb9b2c989](https://github.com/InsightSoftwareConsortium/ITK/commit/8cb9b2c989))
- Fix uninitialized vector warnings ([d81a02cc23](https://github.com/InsightSoftwareConsortium/ITK/commit/d81a02cc23))
- Fix missing initialization braces warnings ([abf5fa1052](https://github.com/InsightSoftwareConsortium/ITK/commit/abf5fa1052))
- Set `DOWNLOAD_EXTRACT_TIMESTAMP` to `TRUE` in wrapping modules ([0bfebf5d63](https://github.com/InsightSoftwareConsortium/ITK/commit/0bfebf5d63))
- Set `DOWNLOAD_EXTRACT_TIMESTAMP` to `TRUE` for Windows wrapping ([b50e4f4d8e](https://github.com/InsightSoftwareConsortium/ITK/commit/b50e4f4d8e))

#### Bug Fixes

- Fix Superclass name in RTTI macro ([4f382711dd](https://github.com/InsightSoftwareConsortium/ITK/commit/4f382711dd))
- Fix variable typo `MultiphaseDenseFiniteDifferenceImageFilter` test ([68fea25cfc](https://github.com/InsightSoftwareConsortium/ITK/commit/68fea25cfc))
- Set the maximum number of iterations to a non-zero value in test ([b64bc4f4d6](https://github.com/InsightSoftwareConsortium/ITK/commit/b64bc4f4d6))
- Fix `itk::STAPLEImageFilter` test argument order ([5b5d85e4fa](https://github.com/InsightSoftwareConsortium/ITK/commit/5b5d85e4fa))
- Use unique names for `itk::SobelOperator` test output files ([54f4306f9a](https://github.com/InsightSoftwareConsortium/ITK/commit/54f4306f9a))

#### Style Changes

- Improve the ivar printing in `PrintSelf` method ([33c7d9ebac](https://github.com/InsightSoftwareConsortium/ITK/commit/33c7d9ebac))
- Prefer using `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([a5af03b2d2](https://github.com/InsightSoftwareConsortium/ITK/commit/a5af03b2d2))
- Conform to ITK style in variable naming in tests ([5f00847859](https://github.com/InsightSoftwareConsortium/ITK/commit/5f00847859))
- Conform to ITK style guidelines in test ending message ([bb2143e86d](https://github.com/InsightSoftwareConsortium/ITK/commit/bb2143e86d))
- Improve the first interaction message style ([a260272186](https://github.com/InsightSoftwareConsortium/ITK/commit/a260272186))
- Use the superclass name in itkTypeMacro ([a00fd6a0e2](https://github.com/InsightSoftwareConsortium/ITK/commit/a00fd6a0e2))
- Conform to ITK style in variable naming in tests ([2127b6dbae](https://github.com/InsightSoftwareConsortium/ITK/commit/2127b6dbae))
- Prefer using exception checking macros in tests ([5f737c0573](https://github.com/InsightSoftwareConsortium/ITK/commit/5f737c0573))
- Conform to ITK style guidelines in test ending message ([b7a2c16f71](https://github.com/InsightSoftwareConsortium/ITK/commit/b7a2c16f71))
- Remove unnecessary test printed message ([b9ee374e27](https://github.com/InsightSoftwareConsortium/ITK/commit/b9ee374e27))
- Improve `itkUniformRandomSpatialNeighborSubsamplerTest` style ([f90dd218d8](https://github.com/InsightSoftwareConsortium/ITK/commit/f90dd218d8))
- Make flow control variables have a local scope ([4d0d13726d](https://github.com/InsightSoftwareConsortium/ITK/commit/4d0d13726d))
- Conform to ITK style in variable naming in tests ([02bff35aae](https://github.com/InsightSoftwareConsortium/ITK/commit/02bff35aae))
- Declare variables closer to where they are instantiated ([e99228e93d](https://github.com/InsightSoftwareConsortium/ITK/commit/e99228e93d))
- Use `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([22802d3016](https://github.com/InsightSoftwareConsortium/ITK/commit/22802d3016))
- Use the superclass name in itkTypeMacro ([12dffb3cc8](https://github.com/InsightSoftwareConsortium/ITK/commit/12dffb3cc8))
- Conform to ITK style guidelines in test ending message ([4725ccdbef](https://github.com/InsightSoftwareConsortium/ITK/commit/4725ccdbef))
- Remove unnecessary message in argumentless test ([040db7be3f](https://github.com/InsightSoftwareConsortium/ITK/commit/040db7be3f))
- Use `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([f0d3d80883](https://github.com/InsightSoftwareConsortium/ITK/commit/f0d3d80883))
- Conform to ITK style guidelines in test ending message ([abc7e3a35d](https://github.com/InsightSoftwareConsortium/ITK/commit/abc7e3a35d))
- Use `ITK_TRY_EXPECT_NO_EXCEPTION` macro in tests ([7ff28bac5c](https://github.com/InsightSoftwareConsortium/ITK/commit/7ff28bac5c))
- Improve style in `itkMultiLabelSTAPLEImageFilterTest` file ([852d4e4e78](https://github.com/InsightSoftwareConsortium/ITK/commit/852d4e4e78))
- Remove unnecessary empty comment blocks ([3b88398b83](https://github.com/InsightSoftwareConsortium/ITK/commit/3b88398b83))
- Prefer using the `ITK_TRY_EXPECT` macros in tests ([66a9a27bb0](https://github.com/InsightSoftwareConsortium/ITK/commit/66a9a27bb0))
- Increase test argument check and ending message consistency ([1b285b5c6d](https://github.com/InsightSoftwareConsortium/ITK/commit/1b285b5c6d))
- Improve style in `PrintSelf` methods ([925ddc5b67](https://github.com/InsightSoftwareConsortium/ITK/commit/925ddc5b67))
- Break `ImageCompare` module test command into multiple lines ([12d13f6b05](https://github.com/InsightSoftwareConsortium/ITK/commit/12d13f6b05))


### Lee Newberg (2):

#### Style Changes

- Method local variables should not have `m_` prefix ([4b5842f718](https://github.com/InsightSoftwareConsortium/ITK/commit/4b5842f718))
- Change Over/UnderFlow to Over/Underflow ([d6203c25c6](https://github.com/InsightSoftwareConsortium/ITK/commit/d6203c25c6))


### Matt Cieslak (1):

#### Bug Fixes

- add SetNumberOfWorkUnits to SetMaximumNumberOfWorkUnits ([bbf14ddfb6](https://github.com/InsightSoftwareConsortium/ITK/commit/bbf14ddfb6))


### Matt McCormick (21):

#### Enhancements

- ST, IT, OT for SizeValueType, IdentifierType, OffsetType ([6a9aca9906](https://github.com/InsightSoftwareConsortium/ITK/commit/6a9aca9906))
- Test reading ANTs Nifti displacement field metadata ([4e17965f68](https://github.com/InsightSoftwareConsortium/ITK/commit/4e17965f68))
- Propagate needs_contiguous option, docs up from PyBuffer ([27d3ee80a1](https://github.com/InsightSoftwareConsortium/ITK/commit/27d3ee80a1))
- Testing data content links for 5.3.0 ([09ecfb271e](https://github.com/InsightSoftwareConsortium/ITK/commit/09ecfb271e))

#### Documentation Updates

- Add First Interaction GitHub Action ([4401132667](https://github.com/InsightSoftwareConsortium/ITK/commit/4401132667))
- Update Sphinx example URL in README ([cb2ff13ba0](https://github.com/InsightSoftwareConsortium/ITK/commit/cb2ff13ba0))
- Update donation link to Open Collective ([dd76293b05](https://github.com/InsightSoftwareConsortium/ITK/commit/dd76293b05))
- sudo required in ARM wheel builds ([eda4ac9f7d](https://github.com/InsightSoftwareConsortium/ITK/commit/eda4ac9f7d))
- Update .zenodo for 5.3.0 ([4b29d81dcd](https://github.com/InsightSoftwareConsortium/ITK/commit/4b29d81dcd))

#### Platform Fixes

- PointsLocator wrapping on Windows ([1481c1e7dc](https://github.com/InsightSoftwareConsortium/ITK/commit/1481c1e7dc))
- Add -fno-sized-deallocation for GCC 12 ([58ce6e84f2](https://github.com/InsightSoftwareConsortium/ITK/commit/58ce6e84f2))
- ARM Eigen copying an object of non-trivial type ([ed5447249a](https://github.com/InsightSoftwareConsortium/ITK/commit/ed5447249a))
- Do not depend on castxml target when using system version ([b35271d809](https://github.com/InsightSoftwareConsortium/ITK/commit/b35271d809))
- Add includes for uint32_t in wrapping ([fc1f6cc6f3](https://github.com/InsightSoftwareConsortium/ITK/commit/fc1f6cc6f3))
- Bump CastXML for Linux ARM build ([438938a911](https://github.com/InsightSoftwareConsortium/ITK/commit/438938a911))

#### Bug Fixes

- Use absolute module path PyCapsule_Import ([835dc01388](https://github.com/InsightSoftwareConsortium/ITK/commit/835dc01388))
- PointLocator wrapping should not wrap superclasses ([c273a5383a](https://github.com/InsightSoftwareConsortium/ITK/commit/c273a5383a))
- itkPointsLocatorTest.py supports Windows, multiple PointsLocator types ([72cea5f942](https://github.com/InsightSoftwareConsortium/ITK/commit/72cea5f942))
- Add permissions to apply clang format action ([dd7ffaa836](https://github.com/InsightSoftwareConsortium/ITK/commit/dd7ffaa836))
- Add GitHub Action permissions for the labeller ([b3d153d8f2](https://github.com/InsightSoftwareConsortium/ITK/commit/b3d153d8f2))
- Add type specification for imread image series ([a41bd60dfd](https://github.com/InsightSoftwareConsortium/ITK/commit/a41bd60dfd))


### Mihail Isakov (8):

#### Enhancements

- allow Nifti with wrong scales in sform ([927eb2684c](https://github.com/InsightSoftwareConsortium/ITK/commit/927eb2684c))
- less memory pressure in itkNiftiLargeImageRegionReadTest ([55dad2bce9](https://github.com/InsightSoftwareConsortium/ITK/commit/55dad2bce9))

#### Documentation Updates

- updated comment for ITK_FUTURE_LEGACY_REMOVE ([37e46fd675](https://github.com/InsightSoftwareConsortium/ITK/commit/37e46fd675))

#### Bug Fixes

- fixed memory leak in Nifti IO ([87f8716216](https://github.com/InsightSoftwareConsortium/ITK/commit/87f8716216))
- fixed memory leaks in MINC IO ([c5bc6a6540](https://github.com/InsightSoftwareConsortium/ITK/commit/c5bc6a6540))
- fixed issue with DCMTK build ([a3bc04f8d4](https://github.com/InsightSoftwareConsortium/ITK/commit/a3bc04f8d4))
- fixed memory leak in itkMeshTest ([4b0fd6bd77](https://github.com/InsightSoftwareConsortium/ITK/commit/4b0fd6bd77))

#### Style Changes

- removed duplicated messages ([88120e674c](https://github.com/InsightSoftwareConsortium/ITK/commit/88120e674c))


### NIFTI Upstream (5):

#### Miscellaneous Changes

- nifti 2022-07-27 (3aa22540) ([af2ec74484](https://github.com/InsightSoftwareConsortium/ITK/commit/af2ec74484))
- nifti 2022-08-02 (11eb262d) ([4384cbdf78](https://github.com/InsightSoftwareConsortium/ITK/commit/4384cbdf78))
- nifti 2022-08-03 (3146cac8) ([ea5c7406ed](https://github.com/InsightSoftwareConsortium/ITK/commit/ea5c7406ed))
- nifti 2022-09-19 (8f7ecce7) ([3f05c5003c](https://github.com/InsightSoftwareConsortium/ITK/commit/3f05c5003c))
- nifti 2022-11-22 (b2826a48) ([08343ec82a](https://github.com/InsightSoftwareConsortium/ITK/commit/08343ec82a))


### Nick Tustison (2):

#### Performance Improvements

- Remove unnecessary computations and parallelize function. ([0ceb091d00](https://github.com/InsightSoftwareConsortium/ITK/commit/0ceb091d00))

#### Bug Fixes

- Copy input data instead of overwriting. ([128dd8a8e9](https://github.com/InsightSoftwareConsortium/ITK/commit/128dd8a8e9))


### Niels Dekker (82):

#### Enhancements

- Add VTKPolyDataMeshIO GTest tests, testing lossless write and read ([2568e727a8](https://github.com/InsightSoftwareConsortium/ITK/commit/2568e727a8))
- Support reading a mesh of non-3D points from a .vtk PolyData file ([236f378258](https://github.com/InsightSoftwareConsortium/ITK/commit/236f378258))
- Mimic C++20 `std::make_unique_for_overwrite` for dynamic arrays ([01e02019ab](https://github.com/InsightSoftwareConsortium/ITK/commit/01e02019ab))
- Add DataObject::UpdateSource() alternative to GetSource()->Update() ([11dac9e29e](https://github.com/InsightSoftwareConsortium/ITK/commit/11dac9e29e))
- Add `ChangeInformationImageFilter.CheckNew` GTest unit test ([e59f4eca80](https://github.com/InsightSoftwareConsortium/ITK/commit/e59f4eca80))

#### Performance Improvements

- `VectorNeighborhoodInnerProduct` pixel retrieval out of inner loop ([eb4c9b6d09](https://github.com/InsightSoftwareConsortium/ITK/commit/eb4c9b6d09))
- Use smaller (16x16) images in KullbackLeibler metric test ([dd0e02a803](https://github.com/InsightSoftwareConsortium/ITK/commit/dd0e02a803))

#### Platform Fixes

- Work around GCC <= 9.1 "error: invalid application of ‘sizeof’..." ([d7c0128e99](https://github.com/InsightSoftwareConsortium/ITK/commit/d7c0128e99))
- Fix typo (compile error) in `PhilipsRECImageIO` constructor ([8ad7354671](https://github.com/InsightSoftwareConsortium/ITK/commit/8ad7354671))

#### Bug Fixes

- VTKPolyDataMeshIO should not hang on inf and NaN in ASCII .vtk file ([678b97eaeb](https://github.com/InsightSoftwareConsortium/ITK/commit/678b97eaeb))
- `Object::InvokeEvent` should not use a dangling Observer pointer ([a687010b81](https://github.com/InsightSoftwareConsortium/ITK/commit/a687010b81))
- ImageIORegion::IsInside should return false for a zero-sized region ([20b0e6dea1](https://github.com/InsightSoftwareConsortium/ITK/commit/20b0e6dea1))
- Remove unintended `<<` concatenation of literal words in messages ([ab62a8eef4](https://github.com/InsightSoftwareConsortium/ITK/commit/ab62a8eef4))
- Remove unintended `<<` concatenation of literals in test output ([49150c8a70](https://github.com/InsightSoftwareConsortium/ITK/commit/49150c8a70))

#### Style Changes

- Replace postfix with prefix increment, decrement (`++`, `--`) ([ec510c1749](https://github.com/InsightSoftwareConsortium/ITK/commit/ec510c1749))
- Replace both occurrences of `(&e)->Print(os)` with `e.Print(os)` ([65215a42dc](https://github.com/InsightSoftwareConsortium/ITK/commit/65215a42dc))
- Replace all occurrences in tests of `(&x)->Print` with `x.Print` ([8f5c337311](https://github.com/InsightSoftwareConsortium/ITK/commit/8f5c337311))
- Rethrow caught exceptions just by `throw;` without argument ([15fb8f24a9](https://github.com/InsightSoftwareConsortium/ITK/commit/15fb8f24a9))
- Replace `(*p).member` with `p->member` in library code ([d90e635bc0](https://github.com/InsightSoftwareConsortium/ITK/commit/d90e635bc0))
- Replace `(*p).member` with `p->member` in unit tests ([8aa5bd49d6](https://github.com/InsightSoftwareConsortium/ITK/commit/8aa5bd49d6))
- Clean up code by ReadPointsUsingMeshIO(), ReadCellsUsingMeshIO() ([b963ba8727](https://github.com/InsightSoftwareConsortium/ITK/commit/b963ba8727))
- Declare Ellipsoid SpatialFunction orientations as a fixed matrix ([8fa2e4f688](https://github.com/InsightSoftwareConsortium/ITK/commit/8fa2e4f688))
- Use `unique_ptr` for `OrthogonalSwath2DPathFilter` data members ([7c4dae88ac](https://github.com/InsightSoftwareConsortium/ITK/commit/7c4dae88ac))
- Declare WindowedSincInterpolateImageFunction data as fixed arrays ([bd8c09f8f0](https://github.com/InsightSoftwareConsortium/ITK/commit/bd8c09f8f0))
- Declare `NormalVariateGenerator::m_Vec1` as fixed array ([d1a76b9f2f](https://github.com/InsightSoftwareConsortium/ITK/commit/d1a76b9f2f))
- Use unique_ptr to avoid the same delete[] on multiple exit paths ([8454e9da2d](https://github.com/InsightSoftwareConsortium/ITK/commit/8454e9da2d))
- Replace pointers initialized by `new T[N]` with fixed arrays ([2135376686](https://github.com/InsightSoftwareConsortium/ITK/commit/2135376686))
- Replace pointers initialized by `new T[N]` with arrays, in tests ([6f002ed216](https://github.com/InsightSoftwareConsortium/ITK/commit/6f002ed216))
- Replace `new T[n]` with `make_unique_for_overwrite` in cxx files ([15d09d6c75](https://github.com/InsightSoftwareConsortium/ITK/commit/15d09d6c75))
- More make_unique_for_overwrite, less delete[], on local variables ([a9bd57036c](https://github.com/InsightSoftwareConsortium/ITK/commit/a9bd57036c))
- Make unique_ptr by make_unique_for_overwrite, instead of new T[] ([7211d4a62b](https://github.com/InsightSoftwareConsortium/ITK/commit/7211d4a62b))
- Let Operator Fill allocate temp_slice on the stack, without `new` ([994bd46796](https://github.com/InsightSoftwareConsortium/ITK/commit/994bd46796))
- Use unique_ptr and make_unique_for_overwrite in Review module ([5eb451f080](https://github.com/InsightSoftwareConsortium/ITK/commit/5eb451f080))
- PointSet, LevelSetBase call Superclass::UpdateOutputInformation() ([35ab868b92](https://github.com/InsightSoftwareConsortium/ITK/commit/35ab868b92))
- `UpdateOutputInformation()` should call `GetSource()` just once ([0b47b7bf95](https://github.com/InsightSoftwareConsortium/ITK/commit/0b47b7bf95))
- Call DataObject::UpdateSource(), avoid calling GetSource() twice ([d701a0aa12](https://github.com/InsightSoftwareConsortium/ITK/commit/d701a0aa12))
- Allocate local variables (cells) Mesh on the stack, without `new` ([8e8dce1322](https://github.com/InsightSoftwareConsortium/ITK/commit/8e8dce1322))
- Allocate `Directory::m_Internal` without `new` ([3cdfee3924](https://github.com/InsightSoftwareConsortium/ITK/commit/3cdfee3924))
- Declare `RGBGibbsPriorFilter` data members as `unique_ptr<T[]>` ([bb7d2f29b3](https://github.com/InsightSoftwareConsortium/ITK/commit/bb7d2f29b3))
- Declare `ImageGaussianModelEstimator::m_Covariance` as unique_ptr ([b03347bcdc](https://github.com/InsightSoftwareConsortium/ITK/commit/b03347bcdc))
- Remove `mutable` from private "per thread" pointers of metrics ([aeab4be102](https://github.com/InsightSoftwareConsortium/ITK/commit/aeab4be102))
- Declare metric "per thread" data members as `unique_ptr<T[]>` ([2f2b29cbbe](https://github.com/InsightSoftwareConsortium/ITK/commit/2f2b29cbbe))
- Remove unreachable code from GE5ImageIO `if (buffer == nullptr)` ([d00471049c](https://github.com/InsightSoftwareConsortium/ITK/commit/d00471049c))
- Declare local `buffer` in `GE5ImageIO::ReadHeader` as unique_ptr ([e2b7445fc9](https://github.com/InsightSoftwareConsortium/ITK/commit/e2b7445fc9))
- Declare local GEImageHeader pointers in GE5ImageIO as unique_ptr ([833f29f8bc](https://github.com/InsightSoftwareConsortium/ITK/commit/833f29f8bc))
- Remove `const` overload of `SubjectImplementation::AddObserver` ([ebddf08ba0](https://github.com/InsightSoftwareConsortium/ITK/commit/ebddf08ba0))
- Declare two private data members of `itk::Object` as unique_ptr ([5daed92e4c](https://github.com/InsightSoftwareConsortium/ITK/commit/5daed92e4c))
- Declare `Observer::m_Event` (from `itk::Object`) as unique_ptr ([d0a39d3dda](https://github.com/InsightSoftwareConsortium/ITK/commit/d0a39d3dda))
- Declare observers of `itk::Object` as list of Observer objects ([171fb2ba33](https://github.com/InsightSoftwareConsortium/ITK/commit/171fb2ba33))
- Declare `ObjectFactoryBase::m_OverrideMap` as unique_ptr ([f02dafa5ce](https://github.com/InsightSoftwareConsortium/ITK/commit/f02dafa5ce))
- Remove pointer indirection from lists of ObjectFactoryBasePrivate ([48d0cb0eed](https://github.com/InsightSoftwareConsortium/ITK/commit/48d0cb0eed))
- Declare lambda's created for Singleton `const`, but non-static ([2d19f26bb7](https://github.com/InsightSoftwareConsortium/ITK/commit/2d19f26bb7))
- Move `Observer` class from "itkObject.cxx" into unnamed namespace ([1f3ec8ce4b](https://github.com/InsightSoftwareConsortium/ITK/commit/1f3ec8ce4b))
- Make `SubjectImplementation` a private nested type of itk::Object ([4c0526e4ab](https://github.com/InsightSoftwareConsortium/ITK/commit/4c0526e4ab))
- Make protected `Object::SubjectImplementation` members private ([2a18aab80d](https://github.com/InsightSoftwareConsortium/ITK/commit/2a18aab80d))
- Do "const" iteration over Object::SubjectImplementation observers ([090cb2335a](https://github.com/InsightSoftwareConsortium/ITK/commit/090cb2335a))
- Remove space between class and member names (follow-up) ([2b1b5312fa](https://github.com/InsightSoftwareConsortium/ITK/commit/2b1b5312fa))
- Declare `m_VnlOptimizer` from Optimizers as unique_ptr ([7357008cbc](https://github.com/InsightSoftwareConsortium/ITK/commit/7357008cbc))
- Make OverRideMap, ObjectFactoryBasePrivate private nested classes ([b85b88b67d](https://github.com/InsightSoftwareConsortium/ITK/commit/b85b88b67d))
- Remove const_cast, make `Object::m_SubjectImplementation` mutable ([f2783a9aa0](https://github.com/InsightSoftwareConsortium/ITK/commit/f2783a9aa0))
- Remove unused local `tempVec` from `ImageKmeansModelEstimator` ([6e6bb618fd](https://github.com/InsightSoftwareConsortium/ITK/commit/6e6bb618fd))
- Remove unused local `dist` from `RGBGibbsPriorFilter` ([9550497884](https://github.com/InsightSoftwareConsortium/ITK/commit/9550497884))
- Use `std::make_unique<T[]>` to zero-initialize the elements ([f4f126dce9](https://github.com/InsightSoftwareConsortium/ITK/commit/f4f126dce9))
- Declare local `value` in `BMPImageIO::Read` as unique_ptr<char[]> ([d666520f6f](https://github.com/InsightSoftwareConsortium/ITK/commit/d666520f6f))
- Declare BlockMatchingImageFilter data members as unique_ptr<T[]> ([64a5cd83aa](https://github.com/InsightSoftwareConsortium/ITK/commit/64a5cd83aa))
- Rename nested ObjectFactoryBase type OverRideMap to `OverrideMap` ([05accd95f4](https://github.com/InsightSoftwareConsortium/ITK/commit/05accd95f4))
- Remove duplicate `#include "itkMath.h"` statements ([cb460fabe0](https://github.com/InsightSoftwareConsortium/ITK/commit/cb460fabe0))
- Remove duplicate #include "itkNeighborhoodIterator.h" statements ([81351faa69](https://github.com/InsightSoftwareConsortium/ITK/commit/81351faa69))
- Remove duplicate `#include` statements from tests ([16527c1dd2](https://github.com/InsightSoftwareConsortium/ITK/commit/16527c1dd2))
- Remove obsolete uncaught_exception() call from `~LightObject()` ([da1229dc1b](https://github.com/InsightSoftwareConsortium/ITK/commit/da1229dc1b))
- Replace `reset(new T[n])` with make_unique_for_overwrite<T[]>(n) ([9df8f74c66](https://github.com/InsightSoftwareConsortium/ITK/commit/9df8f74c66))
- Remove new, do make_unique_for_overwrite in NeighborhoodAllocator ([3c8ff8b183](https://github.com/InsightSoftwareConsortium/ITK/commit/3c8ff8b183))
- Use `{}` as `MeasurementVectorTraits::IsResizable` argument ([be8cb4233b](https://github.com/InsightSoftwareConsortium/ITK/commit/be8cb4233b))
- Initialize sum by {} in VectorNeighborhoodInnerProduct operator() ([9214ea0723](https://github.com/InsightSoftwareConsortium/ITK/commit/9214ea0723))
- Use `{}` instead of dummy as `NumericTraits::GetLength` argument ([fa7d8dd922](https://github.com/InsightSoftwareConsortium/ITK/commit/fa7d8dd922))
- Remove backslash + indent from literals, to avoid unwanted spaces ([69151c3a1c](https://github.com/InsightSoftwareConsortium/ITK/commit/69151c3a1c))
- Remove backslash (continuation character) from string literals ([d0abdffe0a](https://github.com/InsightSoftwareConsortium/ITK/commit/d0abdffe0a))
- Remove backslash + indent from literals in tests ([e46ceafbcf](https://github.com/InsightSoftwareConsortium/ITK/commit/e46ceafbcf))
- Remove backslash from string literal in ResampleImageFilter test ([3d7fa29cfe](https://github.com/InsightSoftwareConsortium/ITK/commit/3d7fa29cfe))
- Remove backslash + indent from literal BSplineDecomposition test ([9e7547f558](https://github.com/InsightSoftwareConsortium/ITK/commit/9e7547f558))
- Default `ChangeInformationImageFilter()` default-constructor ([5e726de408](https://github.com/InsightSoftwareConsortium/ITK/commit/5e726de408))
- Remove obsolete `__GNUC__` macro checks for GCC version 4 ([ce57f309f4](https://github.com/InsightSoftwareConsortium/ITK/commit/ce57f309f4))


### Pranjal Sahu (15):

#### Enhancements

- Adding Python wrapping for itkPointsLocator ([a4002b1653](https://github.com/InsightSoftwareConsortium/ITK/commit/a4002b1653))
- Adding Python test for itkPointsLocator ([ba3c191806](https://github.com/InsightSoftwareConsortium/ITK/commit/ba3c191806))
- Add distances of returned ids in PointsLocator ([7782feb6c8](https://github.com/InsightSoftwareConsortium/ITK/commit/7782feb6c8))
- Add test for itkPointsLocator with distances ([b9005b83b3](https://github.com/InsightSoftwareConsortium/ITK/commit/b9005b83b3))
- Add float combinations for vnl_matrix_fixed Python wrap ([8c0d0e6247](https://github.com/InsightSoftwareConsortium/ITK/commit/8c0d0e6247))
- Add test for vnl_matrix_fixed Python wrap ([17f5ece6c9](https://github.com/InsightSoftwareConsortium/ITK/commit/17f5ece6c9))
- Add MetaDataObject wrapping with Matrix ([7d6212d05d](https://github.com/InsightSoftwareConsortium/ITK/commit/7d6212d05d))
- Add Similarity3DTransform in itkLandmarkBasedTransformInitializer ([c91edeb015](https://github.com/InsightSoftwareConsortium/ITK/commit/c91edeb015))
- Add Similarity3DTransform itkLandmarkBasedTransformInitializer test ([9a30b70cf5](https://github.com/InsightSoftwareConsortium/ITK/commit/9a30b70cf5))
- Add new test for LINE and POLY_LINE cell ([6b15885397](https://github.com/InsightSoftwareConsortium/ITK/commit/6b15885397))
- Add itk.Point wrapping for dimension 6 ([b6dd03d6b0](https://github.com/InsightSoftwareConsortium/ITK/commit/b6dd03d6b0))
- Add FPFH as remote module ([c1e0d4b4ab](https://github.com/InsightSoftwareConsortium/ITK/commit/c1e0d4b4ab))
- Add RANSAC as ITK remote module ([8b0da2093e](https://github.com/InsightSoftwareConsortium/ITK/commit/8b0da2093e))
- Add DistanceThreshold parameter in EuclideanDistance Metricv4 ([c510229a64](https://github.com/InsightSoftwareConsortium/ITK/commit/c510229a64))

#### Bug Fixes

- Fix for wrong cell type when LINE and POLY_LINE present ([b96dac635f](https://github.com/InsightSoftwareConsortium/ITK/commit/b96dac635f))


### Richard Beare (5):

#### Performance Improvements

- Using stl stable_sort instead of a custom class and sort ([ee355d7023](https://github.com/InsightSoftwareConsortium/ITK/commit/ee355d7023))

#### Documentation Updates

- Consolidated documentation between parent and child classes ([0210da1936](https://github.com/InsightSoftwareConsortium/ITK/commit/0210da1936))

#### Style Changes

- Removing sections of the code relating to an old paper ([a0d4b97d3b](https://github.com/InsightSoftwareConsortium/ITK/commit/a0d4b97d3b))
- Removed redundant PAMI macro ([e8025ad0ed](https://github.com/InsightSoftwareConsortium/ITK/commit/e8025ad0ed))
- removing commented code and fixing grammar in documentation ([c1839700a9](https://github.com/InsightSoftwareConsortium/ITK/commit/c1839700a9))


### Sean McBride (1):

#### Style Changes

- Removed (commented) workaround for fixed libMINC upstream issue ([f3dcd512dc](https://github.com/InsightSoftwareConsortium/ITK/commit/f3dcd512dc))


### Simon Rit (1):

#### Enhancements

- Upgrade RTK and CudaCommon with new RTKConsortium repository ([a75529e95d](https://github.com/InsightSoftwareConsortium/ITK/commit/a75529e95d))


### Stefan Dinkelacker (1):

#### Platform Fixes

- Change IOComponentType to IOComponentEnum ([abc6a272cd](https://github.com/InsightSoftwareConsortium/ITK/commit/abc6a272cd))


### Stephen R. Aylward (4):

#### Enhancements

- Bump MinimalPathExtraction module to v1.2.2 (#3535) ([021bd10b57](https://github.com/InsightSoftwareConsortium/ITK/commit/021bd10b57))
- Bump TubeTK to v1.3.1 (#3537) ([9ed9070c74](https://github.com/InsightSoftwareConsortium/ITK/commit/9ed9070c74))
- Bump TubeTK and MinimalPathExtraction for v5.3rc04.post2 wheels (#3543) ([4896f87004](https://github.com/InsightSoftwareConsortium/ITK/commit/4896f87004))
- Bump TubeTK to v1.3.3 ([1eeb258d1c](https://github.com/InsightSoftwareConsortium/ITK/commit/1eeb258d1c))


### Tom Birdsong (1):

#### Documentation Updates

- Clarify Python release documentation ([153b5513ef](https://github.com/InsightSoftwareConsortium/ITK/commit/153b5513ef))


### Vladimir S. FONOV (1):

#### Miscellaneous Changes

- MINC 2022-10-25 (d2a17b7a) ([8a13bf6376](https://github.com/InsightSoftwareConsortium/ITK/commit/8a13bf6376))


### Ziv Yaniv (1):

#### Enhancements

- Issue warning when NIFTI IO coerces matrix to orthonormal ([1a1a8cc024](https://github.com/InsightSoftwareConsortium/ITK/commit/1a1a8cc024))


### Zlib-ng Upstream (2):

#### Miscellaneous Changes

- zlib-ng 2022-08-17 (89763032) ([7b40b99d1b](https://github.com/InsightSoftwareConsortium/ITK/commit/7b40b99d1b))
- zlib-ng 2022-11-01 (b3dcf11b) ([2a1b999f20](https://github.com/InsightSoftwareConsortium/ITK/commit/2a1b999f20))


### luz paz (7):

#### Documentation Updates

- Fix typos in documentation ([dfaf9941c8](https://github.com/InsightSoftwareConsortium/ITK/commit/dfaf9941c8))
- Fix typos in Wrapping/ subdirectory ([a8ca2578c5](https://github.com/InsightSoftwareConsortium/ITK/commit/a8ca2578c5))
- Fix typos in Modules/Core subdirectory ([d8063f38ee](https://github.com/InsightSoftwareConsortium/ITK/commit/d8063f38ee))
- Fix typos in Modules/Remote subdirectory ([8a20220230](https://github.com/InsightSoftwareConsortium/ITK/commit/8a20220230))
- Fix typos in various subdirectories ([d12f14e105](https://github.com/InsightSoftwareConsortium/ITK/commit/d12f14e105))
- Fix typos in Modules/Numerics ([38395a0fa0](https://github.com/InsightSoftwareConsortium/ITK/commit/38395a0fa0))
- fix typos in Modules/Filtering ([eede9c9f79](https://github.com/InsightSoftwareConsortium/ITK/commit/eede9c9f79))




ITK Sphinx Examples Changes Since v5.3rc04
---------------------------------------------

### Dženan Zukić (1):

#### Platform Fixes

- Remove duplicate image declaration and read ([2638e5cd](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/2638e5cd))


### Jon Haitz Legarreta Gorroño (3):

#### Enhancements

- Switch Github Actions Linux environment ([e1c3d118](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e1c3d118))
- Switch Github Actions macOS environment ([ffdabca2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ffdabca2))
- Fix the `Documentation` PR title identification ([a9d3b224](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a9d3b224))


### Matt McCormick (16):

#### Enhancements

- Update to ITK 5.3 RC 4 ([183fd56b](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/183fd56b))
- Bump CI itk-git-tag to v5.3rc04 ([7c195971](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7c195971))
- Migrate data to IPFS ([13700c88](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/13700c88))
- Bump ITK version to 5.3.0 ([4078f3fb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4078f3fb))
- Add "Edit this page" links ([875c43bd](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/875c43bd))

#### Documentation Updates

- Document IPFS data upload ([c01950f9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c01950f9))
- Update README required CMake version ([c46ff9b9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c46ff9b9))
- Add GitHub repository icon link ([c7fda565](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c7fda565))

#### Platform Fixes

- Update itkwidgets to pre-release version ([d2f5264d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d2f5264d))
- Remove Superbuild zlib ([56fcffdf](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/56fcffdf))
- Enable IPython.sphinxext.ipython_console_highlighting ([a428ef2c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a428ef2c))
- Bump CI images to latest versions ([c0c0fc3d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c0c0fc3d))
- Address ITK Windows warnings ([d68014af](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d68014af))
- Fix traitlets version to 5.6.0 ([33888c1d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/33888c1d))

#### Bug Fixes

- Bump srvaroa/labeler to v0.9 ([57a8dea5](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/57a8dea5))
- Download HTML tarballs from GitHub Releases ([ec4ead33](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ec4ead33))


### Niels Dekker (1):

#### Enhancements

- Add example, "Generate the Offsets of a Shaped Image Neighborhood" ([06cc158e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/06cc158e))


### Tom Birdsong (1):

#### Enhancements

- Update CMake to decouple archives from example builds (#399) ([4ffdcb93](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4ffdcb93))




ITK Software Guide Changes Since v5.3rc04
---------------------------------------------

### Jon Haitz Legarreta Gorroño (2):

#### Enhancements

- Switch Github Actions Linux environment ([ac80720](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/ac80720))
- Fix the `Documentation` PR title identification ([51b0eb0](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/51b0eb0))


### Matt McCormick (2):

#### Enhancements

- Bump ITK version to v5.3rc04 ([9a94dc7](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/9a94dc7))
- Bump ITK to 5.3.0 ([83a3e23](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/83a3e23))




Remote Module Changes Since v5.3rc04
---------------------------------------------

## AdaptiveDenoising:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([e1aeec2](https://github.com/ntustison/ITKAdaptiveDenoising/commit/e1aeec2))



## AnalyzeObjectLabelMap:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([13cbb7b](https://github.com/InsightSoftwareConsortium/itkAnalyzeObjectMap/commit/13cbb7b))



## AnisotropicDiffusionLBR:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([d46aab0](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/d46aab0))



## BSplineGradient:
### Tom Birdsong (6):

#### Enhancements

- Bump ITK to v5.3rc04 ([38af7b6](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/38af7b6))
- Bump ITK and replace http with https using script ([b2ea685](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/b2ea685))
- Refactor to depend on ITKMeshToPolyData ([bd26924](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/bd26924))
- Bump ITK to v5.3rc04 ([78b467d](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/78b467d))
- Bump ITK to v5.3rc04.post2 ([fdb2aa1](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/fdb2aa1))

#### Style Changes

- Update template parameter names for KWStyle ([f98ff9d](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/f98ff9d))



## BioCell:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([496b322](https://github.com/InsightSoftwareConsortium/ITKBioCell/commit/496b322))



## BoneEnhancement:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([658b9cb](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/658b9cb))



## BoneMorphometry:
### Dženan Zukić (1):

#### Documentation Updates

- Fix misspelling ration -> ratio ([07c5330](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/07c5330))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([5ddee82](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/5ddee82))



## Cleaver:
### Matt McCormick (4):

#### Enhancements

- Bump package version to 1.2.0 ([bde5da1](https://github.com/SCIInstitute/ITKCleaver/commit/bde5da1))

#### Documentation Updates

- Improve tagline description ([91dcaca](https://github.com/SCIInstitute/ITKCleaver/commit/91dcaca))
- Add Zenodo DOI badge ([a50cb45](https://github.com/SCIInstitute/ITKCleaver/commit/a50cb45))
- Add Citation File Format (CFF) file ([9867c15](https://github.com/SCIInstitute/ITKCleaver/commit/9867c15))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([4dbfa49](https://github.com/SCIInstitute/ITKCleaver/commit/4dbfa49))



## Cuberille:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([3e04917](https://github.com/InsightSoftwareConsortium/ITKCuberille/commit/3e04917))



## CudaCommon:
### Alexy Pellegrini (3):

#### Enhancements

- Replace deprecated PUBLIC_LINK with PUBLIC ([1520198](https://github.com/RTKConsortium/ITKCudaCommon/commit/1520198))
- Add python wrapping for CudaCommon ([095abb2](https://github.com/RTKConsortium/ITKCudaCommon/commit/095abb2))
- Remove unneeded types from wrapping ([3531dd0](https://github.com/RTKConsortium/ITKCudaCommon/commit/3531dd0))


### Simon Rit (9):

#### Enhancements

- add CI for Windows and Linux CUDA packages ([2c5b730](https://github.com/RTKConsortium/ITKCudaCommon/commit/2c5b730))
- Update GitHub actions for ITK 5.3 RC 4 ([19db3a3](https://github.com/RTKConsortium/ITKCudaCommon/commit/19db3a3))
- Define CUDACOMMON_CUDA_VERSION for wheel names and verify it ([4b157fa](https://github.com/RTKConsortium/ITKCudaCommon/commit/4b157fa))
- Bump CMake to v3.22.2 and Ninja to 1.10.2 ([de2796e](https://github.com/RTKConsortium/ITKCudaCommon/commit/de2796e))
- Reduce downloads in self-hosted Github runners ([58ffcd1](https://github.com/RTKConsortium/ITKCudaCommon/commit/58ffcd1))

#### Documentation Updates

- Update GitHub links to the new RTKConsortium repository ([57296fc](https://github.com/RTKConsortium/ITKCudaCommon/commit/57296fc))

#### Platform Fixes

- use ITK's module mechanisme for EXPORT macros ([097151f](https://github.com/RTKConsortium/ITKCudaCommon/commit/097151f))
- add missing export for Windows DLL ([afd01f3](https://github.com/RTKConsortium/ITKCudaCommon/commit/afd01f3))
- Remove Cuda libraries from the Windows Python package ([4e89624](https://github.com/RTKConsortium/ITKCudaCommon/commit/4e89624))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([18ef765](https://github.com/RTKConsortium/ITKCudaCommon/commit/18ef765))



## NeuralNetworks:



## FPFH:



## FixedPointInverseDisplacementField:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([e38e8a3](https://github.com/InsightSoftwareConsortium/ITKFixedPointInverseDisplacementField/commit/e38e8a3))



## GenericLabelInterpolator:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([2f37681](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/2f37681))



## GrowCut:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([21d982a](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/21d982a))



## HASI:
### Tom Birdsong (2):

#### Enhancements

- Bump ITK and change http to https ([d844cad](https://github.com/KitwareMedical/HASI/commit/d844cad))

#### Bug Fixes

- TBB path fix for Linux CI ([e6d1f5a](https://github.com/KitwareMedical/HASI/commit/e6d1f5a))



## HigherOrderAccurateGradient:
### Tom Birdsong (5):

#### Enhancements

- Bump ITK version ([e13b416](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/e13b416))
- Bump ITK and replace http with https using script ([0539382](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/0539382))
- Bump to ITK v5.3rc04 ([d3278b1](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/d3278b1))
- Bump ITK to v5.3rc04.post2 ([4316ada](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/4316ada))

#### Miscellaneous Changes

- Bump to v1.1.2 ([d707496](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/d707496))



## IOFDF:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([7969587](https://github.com/InsightSoftwareConsortium/ITKIOFDF/commit/7969587))



## IOMeshSTL:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https ([7647736](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL/commit/7647736))



## IOMeshSWC:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([212b367](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC/commit/212b367))



## IOOpenSlide:



## IOScanco:
### Tom Birdsong (2):

#### Enhancements

- Bump ITK and change http to https ([8338b08](https://github.com/KitwareMedical/ITKIOScanco/commit/8338b08))

#### Miscellaneous Changes

- Bump version in setup.py ([ed97d30](https://github.com/KitwareMedical/ITKIOScanco/commit/ed97d30))



## IOTransformDCMTK:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([e97e0e8](https://github.com/InsightSoftwareConsortium/ITKIOTransformDCMTK/commit/e97e0e8))



## IsotropicWavelets:
### Dženan Zukić (1):

#### Enhancements

- Update required CMake version ([d163f14](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/d163f14))


### Pablo Hernandez-Cerdan (4):

#### Enhancements

- Use std::enable_if instead of itk::EnableIf ([0a15890](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/0a15890))

#### Platform Fixes

- Style, change template variable name ([8f81db4](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/8f81db4))
- Fix warnings unused type and unreachable value ([2b0463e](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/2b0463e))
- Fix wrapping for FrequencyFunction ([b63d8d5](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/b63d8d5))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([f2eb399](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/f2eb399))



## LabelErodeDilate:
### Dženan Zukić (1):

#### Enhancements

- Bump version number to 1.2.0 and required ITK version to 5.3rc4 ([af2525c](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/af2525c))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([f427170](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/f427170))



## LesionSizingToolkit:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([58b95e8](https://github.com/InsightSoftwareConsortium/LesionSizingToolkit/commit/58b95e8))



## MGHIO:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([4b2e7bd](https://github.com/InsightSoftwareConsortium/itkMGHImageIO/commit/4b2e7bd))



## MeshNoise:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([a01fae4](https://github.com/InsightSoftwareConsortium/ITKMeshNoise/commit/a01fae4))



## MeshToPolyData:
### Tom Birdsong (4):

#### Enhancements

- Bump ITK and replace http with https using script ([f7e56d9](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/f7e56d9))
- Bump ITK version to v5.3rc04 ([8d3b273](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/8d3b273))
- Bump ITK to v5.3rc04.post2 ([166e7d7](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/166e7d7))

#### Miscellaneous Changes

- Bump version in setup.py ([669009f](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/669009f))



## MinimalPathExtraction:
### Stephen R. Aylward (3):

#### Enhancements

- Bump ITK to v5.3rc04(.post2) (#93) ([444fc74](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/444fc74))
- Bump github action to use ITK wheel v5.3rc04.post2 ([7be9988](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/7be9988))

#### Bug Fixes

- It is .post2, not -post2, for ITK 5.3 rc4 in setup.py (#94) ([59931ed](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/59931ed))



## Montage:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([21f8eb9](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/21f8eb9))



## MorphologicalContourInterpolation:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK version and apply http to https reformatting ([dbe1d9e](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/dbe1d9e))



## MultipleImageIterator:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([046e70f](https://github.com/KitwareMedical/MultipleImageIterator/commit/046e70f))



## ParabolicMorphology:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([2c6aa18](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/2c6aa18))



## PerformanceBenchmarking:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([950921a](https://github.com/InsightSoftwareConsortium/ITKPerformanceBenchmarking/commit/950921a))



## PhaseSymmetry:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([4d9cba2](https://github.com/KitwareMedical/ITKPhaseSymmetry/commit/4d9cba2))



## PolarTransform:



## PrincipalComponentsAnalysis:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([2f8d8bf](https://github.com/InsightSoftwareConsortium/ITKPrincipalComponentsAnalysis/commit/2f8d8bf))



## RANSAC:



## RLEImage:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([0c79719](https://github.com/KitwareMedical/ITKRLEImage/commit/0c79719))



## RTK:
### Mikhail Polkovnikov (3):

#### Enhancements

- Calculate parallel geometry parameters from projection matrix ([8df460e4](https://github.com/RTKConsortium/RTK/commit/8df460e4))

#### Documentation Updates

- Better description for the addProjection method for a parallel geometry ([6a1a8047](https://github.com/RTKConsortium/RTK/commit/6a1a8047))

#### Style Changes

- use itk::Math::abs instead of fabs ([9f910c8a](https://github.com/RTKConsortium/RTK/commit/9f910c8a))


### Shengpeng YU (1):

#### Bug Fixes

- Activate displaced detector padding in iterative FDK ([38af2e4d](https://github.com/RTKConsortium/RTK/commit/38af2e4d))


### Simon Rit (19):

#### Enhancements

- Add self-hosted CI for Windows python package with Cuda ([0751c885](https://github.com/RTKConsortium/RTK/commit/0751c885))
- Wait for Cuda packages to publish artifacts ([e2ff4ce5](https://github.com/RTKConsortium/RTK/commit/e2ff4ce5))
- Update GitHub actions for ITK 5.3 RC 4 ([92cf0def](https://github.com/RTKConsortium/RTK/commit/92cf0def))
- Define RTK_CUDA_VERSION for wheel names and verify it in RTK ([21dd15e1](https://github.com/RTKConsortium/RTK/commit/21dd15e1))
- Add Python wrapping of DrawQuadricImageFilter ([10429e5c](https://github.com/RTKConsortium/RTK/commit/10429e5c))
- Update GitHub actions for compatibility with ITK v5.3rc04.post4 ([7cda37ac](https://github.com/RTKConsortium/RTK/commit/7cda37ac))

#### Documentation Updates

- Changed radART to medPhoton in RTK consortium ([5daf3f54](https://github.com/RTKConsortium/RTK/commit/5daf3f54))
- Installation instructions for the CUDA-compatible Python package ([cbebbade](https://github.com/RTKConsortium/RTK/commit/cbebbade))
- Added Release.md which descries how to prepare a release ([9fde849a](https://github.com/RTKConsortium/RTK/commit/9fde849a))
- Update GitHub links to the new RTKConsortium repository ([e92b1edb](https://github.com/RTKConsortium/RTK/commit/e92b1edb))

#### Platform Fixes

- Allow install lib directory name changes ([55aa84bf](https://github.com/RTKConsortium/RTK/commit/55aa84bf))
- Select first wrapping directory of the NumPy bridge ([f4c5e2c8](https://github.com/RTKConsortium/RTK/commit/f4c5e2c8))
- Remove Cuda libraries from the Windows python package ([4e68af80](https://github.com/RTKConsortium/RTK/commit/4e68af80))

#### Bug Fixes

- Lower tolerance on VerifyAngles in ThreeDCircularProjectionGeometry ([f867f624](https://github.com/RTKConsortium/RTK/commit/f867f624))
- fix manylinux 2.28 tar file ([94be5b7c](https://github.com/RTKConsortium/RTK/commit/94be5b7c))
- fix ITK git tag for CI with itk-5.3rc4.post3 ([38f68e0c](https://github.com/RTKConsortium/RTK/commit/38f68e0c))

#### Miscellaneous Changes

- Release of RTK v2.4.0 ([8d962668](https://github.com/RTKConsortium/RTK/commit/8d962668))
- Update GitHub actions for ITK v5.3rc04.post3 ([d941e958](https://github.com/RTKConsortium/RTK/commit/d941e958))
- Release of RTK v2.4.1 ([3f0aa314](https://github.com/RTKConsortium/RTK/commit/3f0aa314))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([86d1e83d](https://github.com/RTKConsortium/RTK/commit/86d1e83d))



## SCIFIO:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and replace http with https using script ([1054ece](https://github.com/scifio/scifio-imageio/commit/1054ece))



## Shape:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([1fdb3ed](https://github.com/SlicerSALT/ITKShape/commit/1fdb3ed))



## SimpleITKFilters:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([877b9be](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/877b9be))



## SkullStrip:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([da5821a](https://github.com/InsightSoftwareConsortium/ITKSkullStrip/commit/da5821a))



## SplitComponents:
### Matt McCormick (1):

#### Enhancements

- Support building manylinux2014 wheels ([991b795](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/991b795))


### Tom Birdsong (4):

#### Enhancements

- Bump ITK and change http to https ([64137c3](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/64137c3))
- Bump ITK to v5.3rc04.post1 ([6593513](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/6593513))
- Bump ITK to v5.3rc04.post2 ([fb875a5](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/fb875a5))

#### Platform Fixes

- Bump to minimum CMake 3.16.3 ([5c07777](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/5c07777))



## Strain:
### Matt McCormick (3):

#### Enhancements

- Build against ITK 5.3-RC3 ([a5b9a2a](https://github.com/KitwareMedical/ITKStrain/commit/a5b9a2a))
- Build against pre-ITK 5.3RC4 ([85dcfe0](https://github.com/KitwareMedical/ITKStrain/commit/85dcfe0))
- Bump Python package version to 0.3.6 ([95698c3](https://github.com/KitwareMedical/ITKStrain/commit/95698c3))


### Tom Birdsong (3):

#### Enhancements

- Bump ITK and change http to https ([69cca73](https://github.com/KitwareMedical/ITKStrain/commit/69cca73))
- Bump ITK to v5.3rc04 ([77cd077](https://github.com/KitwareMedical/ITKStrain/commit/77cd077))
- Bump ITK to v5.3rc04.post2 ([9e76c98](https://github.com/KitwareMedical/ITKStrain/commit/9e76c98))



## SubdivisionQuadEdgeMeshFilter:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([6e30c49](https://github.com/InsightSoftwareConsortium/itkSubdivisionQuadEdgeMeshFilter/commit/6e30c49))



## TextureFeatures:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([b75d9da](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/b75d9da))



## Thickness3D:
### Tom Birdsong (2):

#### Enhancements

- Bump ITK and change http to https ([62172a7](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/62172a7))

#### Style Changes

- KWStyle empty lines fixup ([cc8c960](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/cc8c960))



## TotalVariation:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([1dda823](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/1dda823))



## TwoProjectionRegistration:
### Tom Birdsong (2):

#### Enhancements

- Bump ITK and change http to https ([fee9b31](https://github.com/InsightSoftwareConsortium/ITKTwoProjectionRegistration/commit/fee9b31))

#### Style Changes

- Resolve KWStyle whitespace errors ([d462945](https://github.com/InsightSoftwareConsortium/ITKTwoProjectionRegistration/commit/d462945))



## Ultrasound:
### Tom Birdsong (13):

#### Enhancements

- Register default curvilinear FFT factory overrides ([c20ea95](https://github.com/KitwareMedical/ITKUltrasound/commit/c20ea95))
- Bump to 0.5.4 ([f8d31b5](https://github.com/KitwareMedical/ITKUltrasound/commit/f8d31b5))
- Bump ITK version in CI ([cabf862](https://github.com/KitwareMedical/ITKUltrasound/commit/cabf862))
- Bump ITK and restyle with https ([8b17b31](https://github.com/KitwareMedical/ITKUltrasound/commit/8b17b31))
- Bump ITKUltrasound to 0.5.5 ([ea1d5e3](https://github.com/KitwareMedical/ITKUltrasound/commit/ea1d5e3))
- Remove PR notebook checks ([b20cd45](https://github.com/KitwareMedical/ITKUltrasound/commit/b20cd45))
- Add ITKMeshToPolyData dependency from ITKBSplineGradient ([71a26cd](https://github.com/KitwareMedical/ITKUltrasound/commit/71a26cd))
- Bump ITK to v5.3rc04 ([2b04293](https://github.com/KitwareMedical/ITKUltrasound/commit/2b04293))
- Bump ITK to v5.3rc04.post2 ([1095f0f](https://github.com/KitwareMedical/ITKUltrasound/commit/1095f0f))

#### Platform Fixes

- Resolve build failures in `itk-stub-files` ([a99ac00](https://github.com/KitwareMedical/ITKUltrasound/commit/a99ac00))

#### Bug Fixes

- Resolve curvilinear image template method wrapping conflicts ([629076d](https://github.com/KitwareMedical/ITKUltrasound/commit/629076d))
- Resolve Python module load warnings ([5ba9c46](https://github.com/KitwareMedical/ITKUltrasound/commit/5ba9c46))

#### Style Changes

- Resolve KWStyle failure in license URL ([58e4bcc](https://github.com/KitwareMedical/ITKUltrasound/commit/58e4bcc))



## VariationalRegistration:
### Tom Birdsong (1):

#### Enhancements

- Bump ITK and change http to https ([7634013](https://github.com/InsightSoftwareConsortium/ITKVariationalRegistration/commit/7634013))



## VkFFTBackend:
### Tom Birdsong (9):

#### Enhancements

- Add VkMultiResolutionPyramidImageFilter ([59418aa](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/59418aa))
- Add example demonstration multiresolution pyramid speedup ([00d4e98](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/00d4e98))
- Add `itk::VkDiscreteGaussianImageFilter` ([277b50b](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/277b50b))
- Bump GPU CI ITK git tag ([b96b631](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/b96b631))
- Package for Python 3.10 on Linux ([df7759b](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/df7759b))
- Add convolution scale metric comparison notebook ([9f4720c](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/9f4720c))
- Bump ITK version and apply https styling ([ebbeea3](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/ebbeea3))

#### Miscellaneous Changes

- Bump to version v0.1.5 ([ce73508](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/ce73508))
- Bump to version v0.1.6 ([4e12c46](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/4e12c46))



## WebAssemblyInterface:
### Chris Harris (3):

#### Miscellaneous Changes

- fix(readDICOMTags): Allow webWorker to be null ([9e5b2427](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9e5b2427))
- fix(worker): Ensure worker promises are reused ([6075dd29](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6075dd29))
- fix(docs): Fix typo ([dd9d18df](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/dd9d18df))


### Forrest (3):

#### Miscellaneous Changes

- revert(#584): undo commit with invalid message ([1dabba94](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1dabba94))
- chore(github): add commitlint to github actions ([6c047b3b](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6c047b3b))
- chore(commitlint): allow upper-case subject ([0388e607](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/0388e607))


### Forrest Li (2):

#### Miscellaneous Changes

- chore: publish io packages ([d70d7b31](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/d70d7b31))
- chore: generate a CHANGELOG.md ([6841f7b1](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6841f7b1))


### Matt McCormick (53):

#### Miscellaneous Changes

- feat(Docker): Bump ITK to 2022-05-07 master ([8968c6a1](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/8968c6a1))
- feat(itk-wasm-cli): Update default Docker image for ([7b7575d3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/7b7575d3))
- doc(CFF): Initial addition ([5721858d](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/5721858d))
- feat(itkwasm): Initial package, Image, ImageType ([59563355](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/59563355))
- feat(itkwasm): Mesh, MeshType ([b2164f36](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/b2164f36))
- feat(itkwasm): Add PointSet, PointSetType ([7113730e](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/7113730e))
- test(Mesh): Expected default name is `mesh` ([bb88b037](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/bb88b037))
- test(ImageTest): Default name is `image` ([bd8c46ea](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/bd8c46ea))
- ci(PythonWASM): Add GitHub Action testing ([1fe7d1a8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1fe7d1a8))
- doc(README): Add Python WASM CI badge ([f5a423a2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f5a423a2))
- build(Docker): Add IOMeshSWC remote module support ([82587720](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/82587720))
- feat(itk-wasm-cli): Update default Docker image for IOMeshSWC ([0103696a](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/0103696a))
- doc(MeshFormats): Add SWC ([846037c8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/846037c8))
- test(Data): Add test SWC file ([023da103](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/023da103))
- feat(extensionToMeshIO): Add SWC support ([ca5e7ff5](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/ca5e7ff5))
- feat(IOMeshSWC): Add ReadMesh WriteMesh WASM modules ([e881b771](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e881b771))
- feat(version): Bump itkConfig version to 1.0.0-b.14 ([988bec10](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/988bec10))
- feat(Docker): Update WASI, Emscripten toolchains for LLVM 14 ([1dc34433](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1dc34433))
- feat(itk-wasm-cli): Update default Docker image for LLVM 14 ([4728065e](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/4728065e))
- feat(version): Bump version to 1.0.0-b.15 ([c37bbd64](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c37bbd64))
- fix(loadImageIOPipelineModule): Continue when an exception occurs ([bedc594a](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/bedc594a))
- feat(itk-wasm-cli): Update default Docker image for 1.0.0-b.15 ([6ce30d03](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6ce30d03))
- feat(version): Bump version to 1.0.0-b.15 ([97291e74](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/97291e74))
- build(Webpack): Fix UMD config and add dev-server support ([4ded52af](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/4ded52af))
- test(Cypress): Execution support ([c68276b3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c68276b3))
- ci(Cypress): GitHub Actions testing ([c1c1104d](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c1c1104d))
- test(DefaultCommand): fix cypress chrome / firefox invocation ([9dd99106](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9dd99106))
- fix(Pipeline): always use terminal colors with WASI ([05b74bba](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/05b74bba))
- fix(UMDExample): revert change to script path ([1ce564f1](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1ce564f1))
- test(UMDExample): upgrade to Cypress 10 ([313566a7](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/313566a7))
- ci(UMDExample): update for Cypress 10 ([12928f9c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/12928f9c))
- docs(Windows): recommend WSL 2 ([9305dac3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9305dac3))
- build(ITK): Bump to 2022-07-02 master ([6165bc0d](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6165bc0d))
- build(CLI11): bump version to address recursize meson test symlink ([9c12ab79](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9c12ab79))
- test(Node.jsExample): bump to itk-wasm 1.0.0-b.17 ([4849073b](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/4849073b))
- build(Docker): update dockcross for Apple Silicon builds ([c7063ed8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c7063ed8))
- feat(itk-wasm-cli): update default Docker image for 1.0.0-b.18 ([f99c8e08](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f99c8e08))
- feat(version): bump version to 1.0.0-b.18 ([e37e225b](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e37e225b))
- fix(Python): add name entry to Python itkwasm Image ([cf086002](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/cf086002))
- test(ViteExample): bump to Cypress 10 ([5db507f1](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/5db507f1))
- test(ViteExample): bump to 1.0.0-b.18 ([50e77b13](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/50e77b13))
- ci(ViteExample): update for Cypress Action 4 ([445c3879](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/445c3879))
- test(WebpackExample): bump itk-wasm to 1.0.0.-b.18 ([8996acb8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/8996acb8))
- test(WebpackExample): bump cypress to 10.3.0 ([5895d151](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/5895d151))
- build(itk-wasm): bump for itk-5.3rc4.post1 ([8dde82ea](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/8dde82ea))
- ci(TestingData): Update IPFS configuration ([b9481cd0](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/b9481cd0))
- docs(HelloPipeline): Initial addition ([d8c89b5b](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/d8c89b5b))
- docs(InputsOutputs): Initial addition ([321c3397](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/321c3397))
- style(createWebWorkerPromise): Apply prettier ([7f8a36f5](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/7f8a36f5))
- chore(Dependencies): Bump Cypress to 10.6.0 ([deea581e](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/deea581e))
- ci(Cypress): Constrain Node version to 18.2 ([56cd0710](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/56cd0710))
- feat(itk-wasm-cli): Update default Docker image for DCMTK support ([9fa8bd99](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9fa8bd99))
- ci(Examples): More consistent job names ([35878273](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/35878273))


### Shreeraj Jadhav (3):

#### Enhancements

- return sorted file list when reading DICOM series ([59c2b624](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/59c2b624))

#### Miscellaneous Changes

- feat(ReadImageDICOM): Return sorted file list when reading DICOM series ([164bf8ba](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/164bf8ba))
- feat(dcmtk): add ITKDCMTK to image-io pipelines ([820bccc1](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/820bccc1))


### Tom Birdsong (1):

#### Enhancements

- Update http to https links ([d8cd5227](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/d8cd5227))
