# Building and running (using clickable)

Building and running the Lomiri Clock App is quite simple. You will require
[Clickable](https://clickable-ut.dev/en/latest/). To run on the desktop:

   $ cd <clock-app code directory>
   $ clickable --desktop

To install and run on the device:

   $ cd <clock-app code directory>
   $ clickable --arch=armhf clean build build-click install launch

# Submitting a patch upstream

If you want to submit a bug fix you can do so by forking the GitLab repository
implementing the fixes and running to see if it resolved the issue.
We also ask that you run Unit tests to check if anything regressed due to the
bug fix.

If the tests fail, you will have to fix them before your bug fix can be
approved and merged. If the tests pass then commit and push your
code to your repository and that please file a
[merge request](https://gitlab.com/ubports/development/apps/lomiri-clock-app/-/merge_requests).

# Running Tests

Please check README-Autopilot.md and README-Unittest.md on how to run the
tests.  They are quite explanatory and will help you get started.

# Code Style

We are trying to use a common code style throughout the code base to maintain
uniformity and improve code clarity. Listed below are the code styles guides
that will be followed based on the language used.

* QML        - http://qt-project.org/doc/qt-5/qml-codingconventions.html 
* JS, C++    - https://google.github.io/styleguide/cppguide.html
* Python     - Code should follow PEP8 and Flake regulations

Note: In the QML code convention, ignore the Javascript code section guidelines.
So the sections that should be taken into account in the QML conventions are QML
Object Declarations, Grouped Properties and Lists.

# LXD required packages

If your using git as source control than open a shell in the container and run:

    $ apt install git
