/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.IToolService;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.Tools;
import com.sourceforge.knecs.notification.ris.JMSRISService;
import com.sourceforge.knecs.util.CMCSProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JMSRISToolService
extends JMSRISService
implements IToolService {
    private static String CLASSNAME = "com.sourceforge.knecs.dsm.resourceobject.Tools";
    private static Vector mClassNames = new Vector();

    public JMSRISToolService(String serviceURL) {
        super(serviceURL, mClassNames);
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        String tools = props.getProperty("tools");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "/" + tools + "%");
        return ret;
    }

    public Tools[] getTools() throws IOException {
        Collection objects = this.getAllResourceObjects(CLASSNAME);
        Iterator it = objects.iterator();
        Tools[] ret = new Tools[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Tools)it.next();
        }
        return ret;
    }

    public int removeTools(String owner) throws IOException {
        return this.removeResourceObjectsByOwner(owner, CLASSNAME);
    }

    public Tools[] getTools(String owner) throws IOException {
        Collection objects = this.getResourceObjectsByOwner(owner, CLASSNAME);
        Iterator it = objects.iterator();
        Tools[] ret = new Tools[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Tools)it.next();
        }
        return ret;
    }

    public Tools getTool(String id) throws IOException {
        return (Tools)this.getResourceObjectById(id, CLASSNAME);
    }

    public void addTool(Tools data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save Tool " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteTool(Tools data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove Tool " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    static {
        mClassNames.add(CLASSNAME);
    }
}

