# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservicefleet import ContainerServiceFleetMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceFleetMgmtUpdateRunsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceFleetMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_runs_get(self, resource_group):
        response = self.client.update_runs.get(
            resource_group_name=resource_group.name,
            fleet_name="str",
            update_run_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_runs_begin_create_or_update(self, resource_group):
        response = self.client.update_runs.begin_create_or_update(
            resource_group_name=resource_group.name,
            fleet_name="str",
            update_run_name="str",
            resource={
                "eTag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "managedClusterUpdate": {
                        "upgrade": {"type": "str", "kubernetesVersion": "str"},
                        "nodeImageSelection": {"type": "str", "customNodeImageVersions": [{"version": "str"}]},
                    },
                    "autoUpgradeProfileId": "str",
                    "provisioningState": "str",
                    "status": {
                        "nodeImageSelection": {"selectedNodeImageVersions": [{"version": "str"}]},
                        "stages": [
                            {
                                "afterGates": [
                                    {
                                        "displayName": "str",
                                        "gateId": "str",
                                        "status": {
                                            "completedTime": "2020-02-20 00:00:00",
                                            "error": {
                                                "additionalInfo": [{"info": {}, "type": "str"}],
                                                "code": "str",
                                                "details": [...],
                                                "message": "str",
                                                "target": "str",
                                            },
                                            "startTime": "2020-02-20 00:00:00",
                                            "state": "str",
                                        },
                                    }
                                ],
                                "afterStageWaitStatus": {
                                    "status": {
                                        "completedTime": "2020-02-20 00:00:00",
                                        "error": {
                                            "additionalInfo": [{"info": {}, "type": "str"}],
                                            "code": "str",
                                            "details": [...],
                                            "message": "str",
                                            "target": "str",
                                        },
                                        "startTime": "2020-02-20 00:00:00",
                                        "state": "str",
                                    },
                                    "waitDurationInSeconds": 0,
                                },
                                "beforeGates": [
                                    {
                                        "displayName": "str",
                                        "gateId": "str",
                                        "status": {
                                            "completedTime": "2020-02-20 00:00:00",
                                            "error": {
                                                "additionalInfo": [{"info": {}, "type": "str"}],
                                                "code": "str",
                                                "details": [...],
                                                "message": "str",
                                                "target": "str",
                                            },
                                            "startTime": "2020-02-20 00:00:00",
                                            "state": "str",
                                        },
                                    }
                                ],
                                "groups": [
                                    {
                                        "afterGates": [
                                            {
                                                "displayName": "str",
                                                "gateId": "str",
                                                "status": {
                                                    "completedTime": "2020-02-20 00:00:00",
                                                    "error": {
                                                        "additionalInfo": [{"info": {}, "type": "str"}],
                                                        "code": "str",
                                                        "details": [...],
                                                        "message": "str",
                                                        "target": "str",
                                                    },
                                                    "startTime": "2020-02-20 00:00:00",
                                                    "state": "str",
                                                },
                                            }
                                        ],
                                        "beforeGates": [
                                            {
                                                "displayName": "str",
                                                "gateId": "str",
                                                "status": {
                                                    "completedTime": "2020-02-20 00:00:00",
                                                    "error": {
                                                        "additionalInfo": [{"info": {}, "type": "str"}],
                                                        "code": "str",
                                                        "details": [...],
                                                        "message": "str",
                                                        "target": "str",
                                                    },
                                                    "startTime": "2020-02-20 00:00:00",
                                                    "state": "str",
                                                },
                                            }
                                        ],
                                        "members": [
                                            {
                                                "clusterResourceId": "str",
                                                "message": "str",
                                                "name": "str",
                                                "operationId": "str",
                                                "status": {
                                                    "completedTime": "2020-02-20 00:00:00",
                                                    "error": {
                                                        "additionalInfo": [{"info": {}, "type": "str"}],
                                                        "code": "str",
                                                        "details": [...],
                                                        "message": "str",
                                                        "target": "str",
                                                    },
                                                    "startTime": "2020-02-20 00:00:00",
                                                    "state": "str",
                                                },
                                            }
                                        ],
                                        "name": "str",
                                        "status": {
                                            "completedTime": "2020-02-20 00:00:00",
                                            "error": {
                                                "additionalInfo": [{"info": {}, "type": "str"}],
                                                "code": "str",
                                                "details": [...],
                                                "message": "str",
                                                "target": "str",
                                            },
                                            "startTime": "2020-02-20 00:00:00",
                                            "state": "str",
                                        },
                                    }
                                ],
                                "name": "str",
                                "status": {
                                    "completedTime": "2020-02-20 00:00:00",
                                    "error": {
                                        "additionalInfo": [{"info": {}, "type": "str"}],
                                        "code": "str",
                                        "details": [...],
                                        "message": "str",
                                        "target": "str",
                                    },
                                    "startTime": "2020-02-20 00:00:00",
                                    "state": "str",
                                },
                            }
                        ],
                        "status": {
                            "completedTime": "2020-02-20 00:00:00",
                            "error": {
                                "additionalInfo": [{"info": {}, "type": "str"}],
                                "code": "str",
                                "details": [...],
                                "message": "str",
                                "target": "str",
                            },
                            "startTime": "2020-02-20 00:00:00",
                            "state": "str",
                        },
                    },
                    "strategy": {
                        "stages": [
                            {
                                "name": "str",
                                "afterGates": [{"type": "str", "displayName": "str"}],
                                "afterStageWaitInSeconds": 0,
                                "beforeGates": [{"type": "str", "displayName": "str"}],
                                "groups": [
                                    {
                                        "name": "str",
                                        "afterGates": [{"type": "str", "displayName": "str"}],
                                        "beforeGates": [{"type": "str", "displayName": "str"}],
                                    }
                                ],
                            }
                        ]
                    },
                    "updateStrategyId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_runs_begin_delete(self, resource_group):
        response = self.client.update_runs.begin_delete(
            resource_group_name=resource_group.name,
            fleet_name="str",
            update_run_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_runs_list_by_fleet(self, resource_group):
        response = self.client.update_runs.list_by_fleet(
            resource_group_name=resource_group.name,
            fleet_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_runs_begin_start(self, resource_group):
        response = self.client.update_runs.begin_start(
            resource_group_name=resource_group.name,
            fleet_name="str",
            update_run_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_runs_begin_stop(self, resource_group):
        response = self.client.update_runs.begin_stop(
            resource_group_name=resource_group.name,
            fleet_name="str",
            update_run_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_runs_begin_skip(self, resource_group):
        response = self.client.update_runs.begin_skip(
            resource_group_name=resource_group.name,
            fleet_name="str",
            update_run_name="str",
            body={"targets": [{"name": "str", "type": "str"}]},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
