% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchArg.R
\name{matchArg}
\alias{matchArg}
\title{Partial Argument Matching}
\usage{
matchArg(x, choices, several.ok = FALSE, .var.name = vname(x), add = NULL)
}
\arguments{
\item{x}{[\code{character}]\cr
User provided argument to match.}

\item{choices}{[\code{character}]\cr
Candidates to match \code{x} with.}

\item{several.ok}{[\code{logical(1)}]\cr
If \code{TRUE}, multiple matches are allowed, cf. \code{\link[base]{match.arg}}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in error messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}
}
\value{
Subset of \code{choices}.
}
\description{
This is an extensions to \code{\link[base]{match.arg}} with support for \code{\link{AssertCollection}}.
The behavior is very similar to \code{\link[base]{match.arg}}, except that \code{NULL} is not
a valid value for \code{x}.
}
\examples{
matchArg("k", choices = c("kendall", "pearson"))
}
