use crate::parse::common::HafasCommon;
use crate::parse::leg::HafasLegJny;
use crate::ParseResult;
use crate::Profile;
use crate::StationBoardResponse;
use crate::TariffClass;
use serde::Deserialize;

#[derive(Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct HafasStationBoardResponse {
    jny_l: Vec<HafasLegJny>,
    common: HafasCommon,
}

pub(crate) fn default_parse_station_board_response<P: Profile + ?Sized>(
    profile: &P,
    data: HafasStationBoardResponse,
) -> ParseResult<StationBoardResponse> {
    let HafasStationBoardResponse { jny_l, common } = data;
    let common_data = profile.parse_common(common, TariffClass::Second)?;

    Ok(StationBoardResponse {
        legs: jny_l
            .into_iter()
            .map(|x| profile.parse_leg_jny(x, &common_data))
            .collect::<ParseResult<_>>()?,
    })
}
