#[tokio::main]
async fn main() -> udisks2::Result<()> {
    let client = udisks2::Client::new().await.unwrap();
    let block = client
        .object("/org/freedesktop/UDisks2/block_devices/loop0") // has no Drive (the Drive property is '/')
        .unwrap()
        .block()
        .await
        .expect("can not create BlockProxy for loop0 block");

    assert!(block.drive().await.unwrap().as_ref() == "/");

    client
        .drive_for_block(&block)
        .await
        .expect("can not create Drive for loop0 block");
    Ok(())
}
