# 2025-06-24 Triage Log

A week dominated by the landing of a large patch implementing [RFC#3729](https://github.com/rust-lang/rfcs/pull/3729) which unfortunately introduced rather sizeable performance regressions (avg of ~1% instruction count on 111 primary benchmarks). This was deemed worth it so that the patch could land and performance could be won back in follow up PRs.

Triage done by **@rylev**.
Revision range: [45acf54e..42245d34](https://perf.rust-lang.org/?start=45acf54eea118ed27927282b5e0bfdcd80b7987c&end=42245d34d22ade32b3f276dcf74deb826841594c&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.2%, 9.1%]    | 123   |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.1%, 4.6%]    | 86    |
| Improvements ✅ <br /> (primary)   | -3.8% | [-7.3%, -0.3%]  | 2     |
| Improvements ✅ <br /> (secondary) | -2.3% | [-18.5%, -0.2%] | 44    |
| All ❌✅ (primary)                 | 1.0%  | [-7.3%, 9.1%]   | 125   |


2 Regressions, 4 Improvements, 10 Mixed; 7 of them in rollups
40 artifact comparisons made in total

#### Regressions

Sized Hierarchy: Part I [#137944](https://github.com/rust-lang/rust/pull/137944) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=55d436467c351b56253deeba209ae2553d1c243f&end=86d0aef80403f095d8bbabf44d9fdecfcd45f076&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.3%  | [0.1%, 9.9%]   | 111   |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 2.9%]   | 101   |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.7%, -0.7%] | 1     |
| All ❌✅ (primary)                 | 1.3%  | [0.1%, 9.9%]   | 111   |
- As noted in [this summary comment](https://github.com/rust-lang/rust/pull/137944#issuecomment-2912207485), the performance regression is expected and will be addressed in follow ups. 


Rewrite `inline` attribute parser to use new infrastructure and improve diagnostics for all parsed attributes [#138165](https://github.com/rust-lang/rust/pull/138165) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=27733d46d79f4eb92e240fbba502c43022665735&end=1bb335244c311a07cee165c28c553c869e6f64a9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.8%]   | 12    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 0.8%]   | 21    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [-0.2%, 0.8%]  | 14    |
- Perf addressed in a follow up: https://github.com/rust-lang/rust/pull/142777


#### Improvements

[perf] Cache the canonical *instantiation* of param-envs [#142316](https://github.com/rust-lang/rust/pull/142316) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3b97f1308ff72016a4aaa93fbe6d09d4d6427815&end=9c4ff566babe632af5e30281a822d1ae9972873b&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.7%, 0.7%]    | 1     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.6%]  | 12    |
| Improvements ✅ <br /> (secondary) | -5.0% | [-20.3%, -0.6%] | 15    |
| All ❌✅ (primary)                 | -0.7% | [-0.9%, -0.6%]  | 12    |


forward the bootstrap `runner` to `run-make` [#141856](https://github.com/rust-lang/rust/pull/141856) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fa2f3552dae918294c8572b2a07fed2746722dd3&end=8051f012658fde822bfc661b52e90950b411e5c9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.8% | [-2.8%, -2.8%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.8% | [-2.8%, -2.8%] | 1     |


Rollup of 10 pull requests [#142878](https://github.com/rust-lang/rust/pull/142878) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2ec7532eed172e79800d28f087727c4b048badd&end=111e9bc64bbdce14122e3676978f2ceefa5bff1a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [1.1%, 1.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [1.1%, 1.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.3%] | 13    |
| All ❌✅ (primary)                 | -0.1% | [-0.5%, 1.1%]  | 12    |


Let String pass #[track_caller] to its Vec calls [#142728](https://github.com/rust-lang/rust/pull/142728) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=be19eda0dc4c22c5cf5f1b48fd163acf9bd4b0a6&end=8387d61a6ec05faee58f7cfb9c10799285067934&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |


#### Mixed

Change __rust_no_alloc_shim_is_unstable to be a function [#141061](https://github.com/rust-lang/rust/pull/141061) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1bb335244c311a07cee165c28c553c869e6f64a9&end=6f935a044d1ddeb6160494a6320d008d7c311aef&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.5%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.5%, -0.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.8% | [-3.1%, -0.3%] | 7     |
| All ❌✅ (primary)                 | 0.1%  | [-0.5%, 0.5%]  | 4     |
- The performance changes are more or less a wash so I don't think it necessitates any investigation.


Rollup of 6 pull requests [#142689](https://github.com/rust-lang/rust/pull/142689) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c68340350c78eea402c4a85f8d9c1b7d3d607635&end=044514eb26511d2d8aa999fdf27e85df6beb6576&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 11    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.4%, 0.4%]  | 5     |
- Primary regressions seem to be blips returning back to their previous state on the next perf run.


Rollup of 7 pull requests [#142697](https://github.com/rust-lang/rust/pull/142697) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d1d8e386c5e84c4ba857f56c3291f73c27e2d62a&end=8a65ee08296b36342bf7c3cdc15312ccbc357227&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.2%] | 3     |
- Too small of a perf regression (in only secondary benchmarks) to warrant an investigation


 Allow storing `format_args!()` in variable [#140748](https://github.com/rust-lang/rust/pull/140748) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8de4c7234dd9b97c9d76b58671343fdbbc9a433e&end=255aa220821c05c3eac7605fce4ea1c9ab2cbdb4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 24    |
| Regressions ❌ <br /> (secondary)  | 1.6%  | [0.3%, 4.7%]   | 12    |
| Improvements ✅ <br /> (primary)   | -3.7% | [-7.1%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-7.1%, 1.0%]  | 26    |
- Asked the author for ideas on causes after failing to find them in my own investigation.


Rollup of 9 pull requests [#142794](https://github.com/rust-lang/rust/pull/142794) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5526a2f47cd676ceeedc08cf71ae75ce2e9284ae&end=15c701fbc995eb6c5b3a86021c18185f8eee020d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.9%  | [2.9%, 2.9%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 1.2%]   | 10    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.4%  | [-0.2%, 2.9%]  | 5     |
- Caused by https://github.com/rust-lang/rust/pull/142713
- Author is looking into possible fixes.


Rollup of 8 pull requests [#142814](https://github.com/rust-lang/rust/pull/142814) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=15c701fbc995eb6c5b3a86021c18185f8eee020d&end=df4ad9e28b9fb973e244ebc65a8167a261b8f45e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.4%, 1.0%]   | 7     |
| Improvements ✅ <br /> (primary)   | -1.4% | [-2.8%, -0.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.4%, -0.3%] | 24    |
| All ❌✅ (primary)                 | -1.4% | [-2.8%, -0.1%] | 2     |
- The regressions all seem to be noise.


Rollup of 3 pull requests [#142826](https://github.com/rust-lang/rust/pull/142826) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6d0c9e2a1c80e350c50f5fb9338ea9e585ec603b&end=ea34650916887b5075812d0f11c1d3209e7f94ab&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.4%, 0.3%]  | 3     |
- Change overall is near a wash, and the regressions are small enough that I don't think it's worth investigating the performance change here deeply.


Only traverse reachable blocks in JumpThreading. [#142546](https://github.com/rust-lang/rust/pull/142546) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ea34650916887b5075812d0f11c1d3209e7f94ab&end=d4e1159b8c97478778b09a4cc1c7adce5653b8bf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.6%  | [0.3%, 2.9%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 1.6%  | [0.3%, 2.9%]   | 2     |
- The regression in Clap is just noise and the other regression was seen before in a perf run and deemed acceptable by @compiler-errors.


Skip no-op drop glue [#142508](https://github.com/rust-lang/rust/pull/142508) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=111e9bc64bbdce14122e3676978f2ceefa5bff1a&end=be19eda0dc4c22c5cf5f1b48fd163acf9bd4b0a6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7%  | [0.4%, 3.0%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 4     |
| Improvements ✅ <br /> (secondary) | -1.8% | [-3.1%, -0.4%] | 6     |
| All ❌✅ (primary)                 | 0.3%  | [-0.4%, 3.0%]  | 6     |
- Regression in clap is noise and the rest of the changes balance out.


Rollup of 5 pull requests [#142906](https://github.com/rust-lang/rust/pull/142906) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ae2fc9722f08ef131407c1dc8057768868f65e8e&end=42245d34d22ade32b3f276dcf74deb826841594c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.3%]   | 3     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 4     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 1     |
- Regression is small enough that it's not worth investigating IMO

