---
myst:
  html_meta:
    keywords: LaTeX, programmation, syntaxe, boucles, répéter une commande, 
              appliquer une commande à un ensemble, liste de commandes
---

# Comment répéter une action pour chaque élément d'un ensemble ?

:::{todo} Ajouter des exemples
:::

Comme expliqué en réponse à la question 
"[](/2_programmation/syntaxe/repeter_une_commande_n_fois)", TeX n'est pas vraiment 
conçu pour les opérations de programmation "ordinaire". On doit ainsi recourir 
à des astuces pour effectuer la tâche apparemment simple de répéter une opération. 
Cette réponse propose des solutions pour répéter une opération pour chaque élément
d'un ensemble donné d'objets.


## Avec l'extension <ctanpkg:etoolbox>

L'extension <ctanpkg:etoolbox> permet d'itérer sur une liste d'éléments séparés
par des virgules, grâce à ses commandes `\docsvlist` et `\forcsvlist` 
(dans les noms de ces commandes, `csv` veut dire *comma separated values*) ; 
elles sont bien décrites dans la [documentation de l'extension](texdoc:etoolbox). 


## Avec l'extension <ctanpkg:datatool>

L'extension <ctanpkg:datatool> gère des "bases de données" (d'après les termes 
de [sa propre documentation](texdoc:datatool)) et vous pouvez itérer sur les entrées 
d'une telle base de données à l'aide de la commande `\DTLforeach`.


## Avec l'extension <ctanpkg:forarray>

L'extension <ctanpkg:forarray> définit ses propres structures de liste (`list`)
et de tableau (`array`), ainsi que les commandes `\ForEach` et `\ForArray` 
qui permettent d'exécuter une commande pour chaque élément d'une liste 
ou d'un tableau, respectivement.


## Avec l'extension <ctanpkg:dowith>

L'extension <ctanpkg:dowith> définit une paire de macros `\DoWith` et `\StopDoing` 
qui applique la commande fournie en premier argument à chaque item passé ensuite 
entre elles; un exemple trivial d'utilisation pourrait être :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{dowith}

  \newcommand{\chaine}[1]{\textbf{#1-}}

\begin{document}
  \DoWith\chaine a{BBB}c\StopDoing
\end{document}
```

Ainsi, les commandes ont trouvé 3 "items", dont un entouré d'accolades. De fait, 
la seule contrainte est que toutes les commandes à l'intérieur de la structure 
doivent être "développables" (ce qui signifie, par exemple, que vous ne pouvez pas 
utiliser de commandes avec des arguments optionnels).


## Avec l'extension <ctanpkg:commado>

Du même développeur que <ctanpkg:dowith>, il y a aussi l'extension <ctanpkg:commado>, 
qui fournit les commandes `\DoWithCSL` (appliquer une commande à chaque élément 
d'une liste séparée par des virgules (CSL pour \[*comma-separated list*\]) 
et `\DoWithBasesExts` (appliquer une commande à chacun des fichiers d'un ensemble, 
définis par un nom de base et un suffixe \[*extension*\]). L'utilisation 
de ces commandes `\DoWith*` est également développable (si la commande appliquée 
aux éléments de la liste est elle-même développable).


:::{sources}
[Repeating something for each 'thing' in a set](faquk:FAQ-repeat-set)
:::