---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices
---

# Comment modifier la police des numéros de paragraphe ?

Pour modifier la police des numéros de paragraphe, il faut redéfinir `\@seccntformat`.
En voici un exemple où la commande est redéfinie en cours de document : 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\section{En voici, un exemple !}

% Code de modification 
\makeatletter
\renewcommand\@seccntformat[1]%
{\textsf{\@nameuse{the#1}\quad}}
\makeatother

\section{En deux parties, en prime !}
\end{document}
```
