---
myst:
  substitutions:
    directive: "{term}`directive <Directive>`"
    dek: "Donald Ervin Knuth"
---
# Antisèche Markdown

::::{danger}
La présente page est un travail en cours !
::::

```{warning}
La présente page n'est pas détaillée. Il en existe une [version développée](syntax).
```

## Mise en forme de texte basique

### Gras

```{example}
**gras**
```

### Italique

```{example}
*italique*
```

### À chasse fixe

```{example}
`à chasse fixe`
```

### Combinaison

```{example}
***`combinaison`***
```

### Indice et exposant

```{example}
{sub}`indices` et {sup}`exposants`
```

### Rature

```{example}
~~rature~~
```

### Paragraphes

```{example}
Un paragraphe.

Un autre paragraphe.
```

## Liste

### Non ordonnée

```{example}
- Un premier élément.
- Un deuxième élément.
  - Un premier sous-élément.
- Un troisième élément.
```

### Ordonnée

```{example}
1. Le premier élément.
2. Le deuxième élément.
   1. Un premier sous-élément.
3. Un troisième élément.
```

### De description

```{example}

:Objet 1: Description 1
:Objet 2: Description 2
:Objet 3: Description 3 très longue, très longue, très longue, très longue, très
  longue, très longue, très longue, très longue, très longue, très longue, très
  longue, très longue, très longue.

  Éventuellement sur plusieurs paragraphes et contenant par exemple des listes :

  - Le premier élément.
  - Le second élément.
  - Le autre élément.
```

### De définition

:::{example}
Terme 1
: Définition

Terme 2
: Définition plus longue

  Avec plusieurs paragraphes

  - Et des items de listes
:::

## Structuration

### Rubriques

```md
# Titre de niveau 1
Du texte.

## Titre de niveau 2
Essai.
```

### Coupures thématiques

```{raw} latex
\def\faqGUTtransition{\bigskip\hrule\bigskip}
```

```{example}
Avant une coupure thématique.

***

Après une coupure thématique.
```

```{raw} latex
\def\faqGUTtransition{\par}
```

::::{only} latex
:::{warning}

   Dans la version PDF de cette FAQ, pour des raisons techniques les coupures
   thématiques ont été configurées pour ne rien faire.  L'exemple ci-dessus
   est l'exception qui confirme la règle, juste pour montrer le comportement
   par défaut (y-compris pour le format de sortie PDF) dans d'autres documents
   utilisant le système de production [Sphinx][sphinx] à partir de sources
   [MyST-Parser][mystparser].

   [sphinx]: https://www.sphinx-doc.org
   [mystparser]: https://myst-parser.readthedocs.io/en/latest/

:::
::::

## Blocs de code informatique

````text
```
Ceci est un bloc de code avec des caractères spéciaux :
- # ^ <-- > % *coucou*
```
````

### Blocs de codes LaTeX compilables et éditables

````{example}
```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
```
````

````{example}
```
%!TEX engine=lualatex
\documentclass{article}
\begin{document}
$\pi=\directlua{tex.sprint(math.pi)}$
\end{document}
```
````

Différents "préambules" commençant par "%!TEX" sont mis à disposition 
par [`latexcgi`](https://davidcarlisle.github.io/latexcgi/), 
ces derniers permettant de choisir le moteur de compilation 
ou d'activer différentes fonctionnalités (glossaires, index,
affichages de certains fichiers).

````{example}
```
\color{red}%
Pas de préambule, pas d'environnement \verb|document|.
```
````

### Blocs de codes LaTeX *non* compilables et *non* éditables

L'exemple précédent a illustré la capacité de
[`latexcgi`](https://davidcarlisle.github.io/latexcgi/) à compléter
automatiquement des fragments de code LaTeX.  La version
PDF de cette FAQ ne dispose pas de cette capacité et vérifie donc que
``\documentclass`` fasse partie du code avant de tenter une compilation.
Il faut donc marquer spécialement par ``{noedit}`` en particulier
les blocs de code incomplets mais comportant un ``\documentclass``.


````{example}
```{noedit}
\documentclass[french]{article}
```
````

### Blocs de codes autres

````{example}
```python
from a import b
c = "string"
```
````

````{example}
```text
This is pdfTeX, Version 3.141592653-2.6-1.40.25 (TeX Live 2023) (preloaded format=pdflatex)
 restricted \write18 enabled.
**
```
````

:::{example}
`` `Coucou !` ``

````text
```
Coucou !
```
````
:::


### Numérotation et mise en évidence des lignes

:::{example}
```{noedit}
:emphasize-lines : 1,6
:lineno-start : 1

\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
```
:::

### Légendes

:::{example}
```{noedit}
:caption: Ceci est une légende
:emphasize-lines : 1,6
:lineno-start : 1

\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
```
:::


## Extraits de code informatique

:::{example}
- Pas coloré syntaxiquement : `\documentclass{article}` ;
- Coloré syntaxiquement : `\documentclass{article}`{l=latex}.
:::

## Éléments de code variables

| Système d'exploitation | Raccourci pour `⟨`   | Raccourci pour `⟩`   |
|------------------------|----------------------|----------------------|
| GNU/Linux              | Ctrl + Shift + u27e8 | Ctrl + Shift + u27e9 |
| macOS                  | ⌥ + 27e8             | ⌥ + 27e9             |
| Windows                | Alt + 10216          | Alt + 10217          |

:::{example}
```{noedit}
\documentclass{⟨classe LaTeX⟩}
```
:::

## Références croisées

### Cibles
#### Cibles explicites
```markdown
(identifiant-rubrique)=
### Rubrique

{#identifiant-paragraphe}
Ceci est un paragraphe, avec un identifiant.

Ceci est une [« étendue » avec un identifiant]{#identifiant-etendue}.

- [Lien vers la rubrique](#identifiant-rubrique).
- [Lien vers le paragraphe](#identifiant-paragraphe).
- [Lien vers l’« étendue »](#identifiant-etendue).
```

(antiseche/cibles implicites)=
#### Cibles implicites

```{example}
On peut faire référence à la [rubrique courante](#cibles-implicites).
```

### Liens

::::{danger}
La présente rubrique "Liens" est un travail en cours !
::::

#### [URL] "nues"

```{example}
- https://www.gutenberg-asso.fr
- www.gutenberg-asso.fr
- ftp://mirrors.ircam.fr/pub/CTAN/
- faq@gutenberg-asso.fr
```

#### [URI] entourés de `<` et `>`
  ```{example}
  - <ctanpkg:tabularray>
  - [](ctanpkg:tabularray)
  - [le package `tabularray`](ctanpkg:tabularray)
  ```

#### Liens en ligne

```{example}
- [GUTenberg](https://gutenberg-asso.fr/)
- [GUTenberg](https://gutenberg-asso.fr/ "Association GUTenberg*)
```
#### Liens de référence

```{example}
- [Réseau complet d'archives TeX][ctan].
- [*Comprehensive TeX Archive Network*][ctan].
- [CTAN].

[ctan]: https://www.ctan.org/
```

<!-- :::{seealso} -->
<!-- Cf. la [spécification CommonMark](https://spec.commonmark.org/0.30/#links). -->
<!-- ::: -->

#### Résolution de la destination par défaut

La destination d'un lien peut être une cible :

- soit **externe**, telle qu'une [URL] vers un autre site web ;
- soit **interne**, telle qu'un fichier, une rubrique ou une figure du même projet.

Par défaut, MyST résout les destinations des liens selon les règles suivantes :

1. Les destinations commençant par un schéma (par exemple `xxx:`) seront traitées selon ce schéma :
   1. Les destinations commençant par `project:` seront traitées comme des
      références internes au projet.
   2. Les destinations commençant par `path:` seront traitées comme des fichiers téléchargeables
   3. Les liens automatiques ou les destinations commençant par `http:`, `https:`, `ftp:`, ou `mailto:` seront traités comme des liens externes [URL].
2. Les destinations qui pointent vers un chemin d'accès à un fichier local sont traitées comme des liens vers ce fichier.
   1. Si la destination est un chemin relatif, elle est résolue par rapport au fichier actuel.
   2. Si la destination est un chemin absolu (commence par `/`), elle est résolue par rapport à la racine du projet (c'est-à-dire le répertoire source).
   3. Si ce chemin se rapporte à un autre document du projet (par exemple un fichier `.md` ou `.rst`), il renvoie à la première rubrique de ce document.
   4. Les liens vers les documents du projet peuvent également inclure [un identifiant de fragment]{#cibles-explicites} un identifiant de fragment `#`, pour renvoyer à une rubrique spécifique de ce document.
   5. Si le chemin d'accès est un fichier non source (par exemple un fichier `.png` ou `.pdf`), le lien renverra au fichier lui-même, par exemple pour le télécharger.
3. Les destinations commençant par `#` seront traitées comme des références
   internes avec recherche des cibles selon l'odre suivant :
   1. cibles explicites dans le fichier en cours ;
   2. cibles implicites dans le fichier en cours ;
   3. cibles explicites dans l'ensemble du projet.

   Les cibles non trouvées font l'objet d'avertissements lors de la compilation
   et leurs destinations sont laissées en tant que liens externes.

#### URL propres à cette FAQ personnalisées

La syntaxe des liens récurrents de la présente FAQ est simplifiée.

https://ctan.org/pkg/⟨package⟩ :
: Raccourci :
  ```{example}
  - <ctanpkg:tabularray>
  - [](ctanpkg:tabularray)
  - [le package `tabularray`](ctanpkg:tabularray)
  ```

https://texdoc.net/pkg/⟨package⟩ :
: Raccourci :
  ```{example}
  - <texdoc:tabularray>
  - [](texdoc:tabularray)
  - [la documentation du package `tabularray`](texdoc:tabularray)
  ```

https://texfaq.org/⟨FAQ⟩ :
: Raccourci :
  ```{example}
  [*Getting started*](faquk:FAQ-startup)
  ```

https://fr.wikipedia.org/wiki/Donald_Knuth :
: Raccourci :
  ```{example}
  [Donald Ervin Knuth](wpfr:Donald_Knuth)
  ```

https://en.wikipedia.org/wiki/Donald_Knuth :
: Raccourci :
  ```{example}
  [Donald Ervin Knuth](wp:Donald_Knuth)
  ```

https://isbndb.com/book/⟨ISBN⟩
: Raccourci :
  ```{example}
  [*The LaTeX Companion*](isbn:978-0-13-816648-9)
  ```

https://doi.org/⟨DOI⟩
: Raccourci :
  ```{example}
  [La fonte de ce numéro : *Infini*](doi:10.60028/lettre.vi45.8)
  ```

#### Texte du lien explicite ou implicite

Si le texte du lien est explicitement donné, par exemple `[texte](#dest)`, alors
le texte rendu sera celui-là.  Ce texte peut contenir des balises en ligne
imbriquées, comme `[*accentuation*](#syntaxe/accentuation)`{l=md}.

Si aucun texte n'est donné ou s'il s'agit d'un lien automatique, par exemple
`[](#dest)` ou `<projet:#dest>`, MyST tentera de résoudre un texte implicite.
Par exemple, si la destination est un titre, le texte du titre sera utilisé
comme texte du lien, ou si la destination est une figure ou un tableau, la
légende sera utilisée comme texte du lien.  Dans le cas contraire, le texte du
lien sera la destination elle-même.

#### Lien vers les pages internes de la FAQ

:::{important}
Pour créer un lien vers une page de la FAQ, on pourra utiliser le mécanisme de [liens automatiques](#liens-automatiques)
vers le fichier Markdown cible.
:::

Par exemple, si on veut mettre un lien vers la page
</1_generalites/bases/comment_faire_ses_premiers_pas.md> dont le fichier
source Markdown se trouve, par rapport au dossier "racine" du projet,
à l’emplacement `1_generalites/bases/comment_faire_ses_premiers_pas.md`de
l’arborescence de la FAQ, il suffira d’écrire le code suivant:

:::{example}
[](/1_generalites/bases/comment_faire_ses_premiers_pas.md)
:::

:::{important}
Notez :
 - le `/` avant `1_generalites` ;
 - l'affichage automatique du titre de la page visée.
:::

::::{tip} Si la cible n'est pas un [fragment](#cibles-explicites) (une
rubrique autre que le titre) d'une page, on peut omettre l'extension `.md`.

:::{todo} Ces exemples sont à revoir.
```{example}
Ainsi, le lien :
1. [](/1_generalites/bases/comment_faire_ses_premiers_pas.md) est valide ;
2. [](/1_generalites/bases/comment_faire_ses_premiers_pas) est valide ;
3. [](/1_generalites/bases/comment_faire_ses_premiers_pas.md#avec-un-outil-dédié) est valide ;
4. `[](/1_generalites/bases/comment_faire_ses_premiers_pas#avec-un-outil-dédié)` **ne serait pas** valide.
```
:::
::::

#### Exemples

##### Liens automatiques

```{example}
URL externe
: <https://example.com> ou https://example.com

Référence cible interne
: <project:#syntaxe/référencement>

Référence à un fichier interne
: <project:/index.md>

Référence à une rubrique de fichier interne
: <project:/index.md#les-questions>

Fichier téléchargeable
: <path:/_static/images/learnlatex.pdf>
```

##### Liens en ligne avec texte implicite

```{example}
URL externe
: [](https://example.com)

Référence cible interne
: [](syntaxe/référencement)

Référence à un fichier interne
: [](/index.md)

Référence à une rubrique de fichier interne
: [](/index.md#les-questions)

Fichier téléchargeable
: [](/_static/images/learnlatex.pdf)
```

##### Liens en ligne avec texte explicite

```{example}
URL externe
: [Texte explicite](https://example.com)

Référence cible interne
: [Texte explicite](syntaxe/référencement)

Référence à un fichier interne
: [Texte explicite](/index.md)

Référence à une rubrique de fichier interne
: [Texte explicite](/index.md#les-questions)

Fichier téléchargeable
: [Texte explicite](/_static/images/learnlatex.pdf)
```


## Admonitions

```{only} latex
Dans ce PDF, les admonitions ont été pour certaines configurées
pour un rendu particulier qui diffère du rendu par défaut.  Voir
la [documentation de Sphinx](https://www.sphinx-doc.org/en/master/latex.html#the-sphinxsetup-configuration-setting),
pour comment ceci est réalisé.
```

```{gut-admonitions} attention, caution, danger, error, hint, important, note, seealso, tip, warning
```

::::{example}
```{tip}
:name: label-astuce

Bla bla (astuce référençable).
```

[Référence à mon astuce](#label-astuce).
::::

::::{example}
```{admonition} Titre d'admonition personnalisé
:class: tip

Bla bla.
```
::::

::::{example}
```{todo}
Bla bla.
```
::::

````md
```{sources}
- Bla bla.
- Ble ble.
```
````

::::{example}
```{tip}
:class: dropdown

Bla bla.
```
::::

::::::{example}

::::{tab-set}

:::{tab-item} Onglet 1
Contenu 1
:::

:::{tab-item} Onglet 2
Contenu 2
:::

::::

::::::


::::{example}
:::{card} Titre de la "carte"
En-tête
^^^
Contenu de la "carte"
+++
Pied de page
:::
::::


:::::{example}
::::{grid} 3
:::{grid-item-card}  Titre 1
A
:::
:::{grid-item-card}  Titre 2
B
:::
:::{grid-item-card}  Titre 3
C
:::
::::
:::::

::::{danger}
La suite de cette page n'a pas été travaillée !
::::

## Tableaux
### Syntaxe Markdown

Pour construire un tableau, on utilise la [syntaxe Markdown standard adaptée
à Github](https://github.github.com/gfm/#tables-extension-) :

- dans chaque colonne, les lignes en-têtes de colonnes sont à séparer des lignes
  ordinaires par au moins trois tirets (`---`) ;
- les colonnes sont séparées par des caractères "*pipe*" (`|`) ;
- chaque extrémité de la ligne doit également être un  caractères "*pipe*".

:::{example}
| Entête 1    | Entête 2    |
|-------------|-------------|
| Cellule 1-1 | Cellule 1-2 |
| Cellule 2-1 | Cellule 2-2 |
:::

Les cellules d'une colonne peuvent être alignées à l'aide du caractère `:` :

:::{example}
 | Gauche | Centre | Droite |
 |:-------|:------:|-------:|
 | a      | b      |      c |
:::

:::{note}
L'alignement à droite des colonnes de tableaux est manifestement non
fonctionnel. Cela a été
[signalé](https://github.com/executablebooks/MyST-Parser/issues/808).
:::



### Tableau avec légendes

La  `table` peut être utilisée pour créer un tableau avec une légende :

::::{example}
:::{table} Légende du tableau
:widths: auto
:align: center

| Entête 1    | Entête 2    |
|-------------|-------------|
| Cellule 1-1 | Cellule 1-2 |
| Cellule 2-1 | Cellule 2-2 |
:::
::::

Les options suivantes sont reconnues :

:::{admonition} Liste des options du tableau
:class: hint

`align` : `left`, `center`, ou `right`
: Alignement horizontal du tableau.

`width` : `⟨longueur⟩` ou ⟨pourcentage⟩`
: La largeur du tableau à la `⟨longueur⟩` spécifiée ou au `⟨pourcentage⟩` de la
  largeur de la ligne (même unités et principe qu'avec LaTeX).
: S'il est omis, le moteur de rendu détermine la largeur du tableau en fonction de son contenu ou de la largeur des colonnes.

`widths` : `auto`, `grid`, ou une liste d’⟨entiers⟩
: Définit explicitement la largeur des colonnes. Spécifie les largeurs relatives si elle est utilisée avec l'option `width`.
: `auto` délègue la détermination de la largeur des colonnes au moteur de rendu du backend.
: `grid` détermine la largeur des colonnes à partir de la largeur des colonnes d'entrée (en caractères).

:::

<!-- Markdown propose une syntaxe simple pour créer des tableaux. -->
<!--  -->
<!-- |   |   |   | -->
<!-- |---|---|---| -->
<!-- |   |   |   | -->
<!-- |   |   |   | -->
<!-- |   |   |   | -->
<!--  -->
<!--  -->
<!-- Titre 1         Titre 2                                                 Titre 3 -->
<!--   --------------- ------------------------------------------------------- --------------- -->
<!--   Ligne 1 Col 1   Ligne 1 Col 2                                           Ligne 1 Col 3 -->
<!--   Ligne 2 Col 1   colonnes fusionnées (notez la double barre verticale) -->
<!--   Ligne 3 Col 1   Ligne 2 Col 2                                           Ligne 2 Col 3 -->
<!--  -->
<!-- Les lignes de tableau doivent commencer et se terminer avec une *barre -->
<!-- verticale* `|` pour des lignes normales ou avec un -->
<!-- `^` pour les titres. -->
<!--  -->
<!-- ```{example} -->
<!-- ^ Titre 1         ^ Titre 2           ^ Titre 3                            ^ -->
<!-- | Ligne 1 Col 1   | Ligne 1 Col 2     | Ligne 1 Col 3                      | -->
<!-- | Ligne 2 Col 1   | colonnes fusionnées (notez la double barre verticale) || -->
<!-- | Ligne 3 Col 1   | Ligne 2 Col 2     | Ligne 2 Col 3                      | -->
<!-- ``` -->
<!--  -->
<!-- Pour fusionner des cellules horizontalement, videz simplement -->
<!-- complètement la cellule suivante comme il est montré ci-dessus. -->
<!-- Assurez-vous d'avoir toujours le même nombre de séparateurs de cellules -->
<!-- ! -->
<!--  -->
<!-- Les titres de tableau verticaux sont également possibles. -->
<!--  -->
<!--   --------- -------------------------- --------------- -->
<!--             Titre 1                    Titre 2 -->
<!--   Titre 3   Ligne 1 Col 2              Ligne 1 Col 3 -->
<!--   Titre 4   pas de fusion cette fois -->
<!--   Titre 5   Ligne 2 Col 2              Ligne 2 Col 3 -->
<!--   --------- -------------------------- --------------- -->
<!--  -->
<!-- Comme vous pouvez le constater, c'est le séparateur ('\|' ou '\^') -->
<!-- précédant une cellule qui détermine le format : -->
<!--  -->
<!-- ```{example} -->
<!-- |              ^ Titre 1                  ^ Titre 2          ^ -->
<!-- ^ Titre 3      | Ligne 1 Col 2            | Ligne 1 Col 3    | -->
<!-- ^ Titre 4      | pas de fusion cette fois |                  | -->
<!-- ^ Titre 5      | Ligne 2 Col 2            | Ligne 2 Col 3    | -->
<!-- ``` -->
<!--  -->
<!-- Vous pouvez fusionner des cellules verticalement en ajoutant ::: dans -->
<!-- les cellules sous celles avec laquelle elles doivent fusionner. :!: -->
<!-- Cette fonctionnalité n'est disponible que pour les versions supérieures -->
<!-- à 2009-02-14b -->
<!--  -->
<!--   Titre 1         Titre 2                      Titre 3 -->
<!--   --------------- ---------------------------- --------------- -->
<!--   Ligne 1 Col 1   Cette cellule s'étend\\\\   Ligne 1 Col 3 -->
<!--                   verticalement -->
<!--   Ligne 2 Col 1 :::                          Ligne 2 Col 3 -->
<!--   Ligne 3 Col 1 :::                          Ligne 3 Col 3 -->
<!--  -->
<!-- Ces cellules ne doivent rien contenir d'autre que l'indicateur de -->
<!-- fusion vertical. -->
<!--  -->
<!-- ```{example} -->
<!-- ^ Titre 1       ^ Titre 2                                  ^ Titre 3       ^ -->
<!-- | Ligne 1 Col 1 |  Cette cellule s'étend\\ verticalement   | Ligne 1 Col 3 | -->
<!-- | Ligne 2 Col 1 | :::                                      | Ligne 2 Col 3 | -->
<!-- | Ligne 3 Col 1 | :::                                      | Ligne 3 Col 3 | -->
<!-- ``` -->
<!--  -->
<!-- Vous pouvez également aligner les contenus du tableau (uniquement -->
<!-- horizontalement). Ajoutez simplement au moins deux espaces à -->
<!-- l'extrémité opposée de le texte : ajoutez deux espaces sur la gauche -->
<!-- pour aligner à droite, deux espaces sur la droite pour aligner à gauche -->
<!-- et deux espaces au moins à chaque extrémité pour centrer le texte. -->
<!--  -->
<!--   Tableau avec alignement -->
<!--   ------------------------- -------------- -------------- -->
<!--   droite                    centré         gauche -->
<!--   gauche                    droite         centré -->
<!--   xxxxxxxxxxxx              xxxxxxxxxxxx   xxxxxxxxxxxx -->
<!--  -->
<!-- Voici à quoi ça ressemble dans le code source : -->
<!--  -->
<!-- ```{example} -->
<!-- ^          Tableau avec alignement         ^^^ -->
<!-- |        droite|    centré    |gauche        | -->
<!-- |gauche        |        droite|    centré    | -->
<!-- | xxxxxxxxxxxx | xxxxxxxxxxxx | xxxxxxxxxxxx | -->
<!-- ``` -->

:::{danger}
- La documentation qui suit est un reste de celle de la syntaxe DokuWiki (plus
  utilisée dans cette FAQ LaTeX nouvelle) et n'a pas encore été migrée vers
  celle de la syntaxe Markdown.
- La documentation qui précède est un travail en cours.
:::

## Images et figures

Markdown (sauce MyST) permet d’inclure des images et des figures dans les
documents, ainsi que d’y faire référence facilement.

### Images en ligne

La syntaxe Markdown standard est la suivante.

:::::{tab-set}

::::{tab-item} Markdown
```{example}
![logofaq](/_static/logoFAQ-light-theme.*)
```
::::

::::{tab-item} LaTeX
```{noedit}
\includegraphics{/_static/logoFAQ-light-theme}
```
::::
:::::

### Figures

Pour créer une **figure**, utilisez la {{ directive }} `figure` :

::::::{tab-set}

:::::{tab-item} Markdown
::::{example}
```{figure} /_static/logoFAQ-light-theme.*
:width: 50%
:alt: Logo FAQ GUTenberg
:name: logo
:align: center
Ceci est la légende (facultative) de la figure. Il s'agit d'un simple paragraphe.
```
::::
:::::

:::::{tab-item} LaTeX
```{noedit}
\begin{figure}
  \centering
  \includegraphics[width=.5\linewidth]{/_static/logoFAQ-light-theme}
  \caption{Ceci est la légende (facultative) de la figure. Il s'agit d'un simple paragraphe.}
  \label{logo}
\end{figure}
```
:::::
::::::

De nombreuses options permettent de modifier une telle figure :

:::{admonition} Options des blocs images
:class: tip

`alt` : `⟨texte⟩`
: Texte alternatif : une courte description de l’image, nottament pour les personnes malvoyantes.

`height` : `⟨longueur⟩`
: Hauteur désirée pour l’image.

`width` : `⟨longueur⟩` ou `⟨pourcentage⟩` de la largeur de la ligne courante
: Largeur désirée pour l’image.

<!-- `figwidth` : `image`, une `⟨longueur⟩` ou un `⟨pourcentage⟩` de la largeur de la ligne actuelle -->
<!-- : Largeur de la figure.  Si la valeur est `image`, la largeur de l'image est utilisée.  est utilisée.  Sinon, la valeur est interprétée comme une longueur ou un pourcentage de la largeur de la ligne courante. -->

`scale` : `⟨pourcentage entier⟩`, compris entre 0 et 100 (le symbole `%` est optionel)
: Le facteur d’échelle uniforme pour l’image. La valeur par défaut est de `100%` (pas de facteur d’échelle).

`align` : `top`, `middle`, `bottom`, `left`, `center`, ou `right`
: Les valeurs :
  - `top`, `middle`, et `bottom` contrôlent  l’alignement vertical de l’image.
  - `left`, `center`, et `right` contrôlent l’alignement horizontale de l’image, et autorise l’image à flotter et à ce que le texte _coule_ autour d’elle.

`target` : `⟨[URI] ou référence⟩`
: Fait de l'image un hyperlien clicable envoyant au lien souhaité.

`name`
: Label en vue de référence croisée.
:::


:::::{seealso}

Il est également de créer des figures qui utilisent la syntaxe Markdown native
pour les images.

::::{tab-set}

:::{tab-item} Markdown
```{example}
![Notre logo](/_static/logoFAQ-light-theme.*){width=200px align=right}

Ceci est une légende en *Markdown*. Remarquez comment le texte coule autour de
l'image (option `align=right`).

Lorem ipsum dolor sit amet, consectetur
adipiscing elit. Sed non risus. Suspendisse lectus tortor, dignissim sit amet,
adipiscing nec, ultricies sed, dolor. Cras elementum ultrices diam. Maecenas
ligula massa, varius a, semper congue, euismod non, mi. Proin porttitor, orci
nec nonummy molestie, enim est eleifend mi, non fermentum diam nisl sit amet
erat. Duis semper. Duis arcu massa, scelerisque vitae, consequat in, pretium a,
enim. Pellentesque congue. Ut in risus volutpat libero pharetra tempor.
```
:::

:::{tab-item} LaTeX
```{noedit}

\documentclass{article}
\usepackage[T1]{fontenc}
\usepackage{lmodern}
\usepackage{graphicx}
\usepackage{wrapfig2}
\begin{document}
\begin{wrapfigure}{r}{50mm}
  \centering
  \includegraphics[width=3cm]{example-image}
\end{wrapfigure}
Ceci est une légende en \textbf{\emph{Markdown}}. Remarquez comment le texte
coule autour de l'image (option \texttt{align=right}).

Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non risus.
Suspendisse lectus tortor, dignissim sit amet, adipiscing nec, ultricies sed,
dolor. Cras elementum ultrices diam. Maecenas ligula massa, varius a, semper
congue, euismod non, mi. Proin porttitor, orci nec nonummy molestie, enim est
eleifend mi, non fermentum diam nisl sit amet erat.  Duis semper. Duis arcu
massa, scelerisque vitae, consequat in, pretium a, enim. Pellentesque congue. Ut
in risus volutpat libero pharetra tempor.
\end{document}
```
:::
::::
:::::

<!-- ## Figures avec plusieurs images -->
<!--  -->
<!-- Voir l'extension [sphinx-subfigure](https://sphinx-subfigure.readthedocs.io) pour créer des figures avec plusieurs images. -->


## Commentaires

Vous pouvez ajouter des commentaires (autrement dit, comme en LaTeX, des
portions du fichier source n'apparaissant pas dans la page HTML générée). Pour
ce faire, deux méthodes :

1. placer le caractère `%` au début d'une ligne à commenter ;
2. recourir à la syntaxe HTML (`<!-- Ceci est un commentaire -->`)


Par exemple, ce qui suit ne figurera pas dans le document final :

::::{tab-set}

:::{tab-item} Markdown
```{example}
% Un commentaire...

<!-- et un autre commentaire. -->
```
:::

:::{tab-item} LaTeX
```{noedit}
% Un commentaire...

% et un autre commentaire.
```
:::
::::

::::{admonition} Les commentaires sont divisés en paragraphes
:class: warning dropdown

Les commentaires étant une entité au niveau du bloc, ils terminent le bloc
précédent. Cela signifie que, contrairement à ce qu'on observe avec LaTeX, les
lignes suivantes entameront un nouveau paragraphe :

:::{example}
une ligne
% un commentaire
une autre ligne
:::

::::

## Notes de bas de page

Les notes de bas de page utilisent la [spécification pandoc](https://pandoc.org/MANUAL.html#footnotes).
Leurs labels **commencent par `^`** et peuvent être n'importe quelle chaîne alphanumérique (sans espace), sans tenir compte des majuscules et des minuscules.

- Si le label est un entier, le libellé affiché est cet entier (numérotation manuelle).
- Sinon, les libellés affichés sont numérotés automatiquement dans l'ordre dans
  lequel les notes sont référencées, indépendamment des labels numérotés manuellement.

Les notes de bas de page sont rassemblées et affichées en bas de page (dans l'ordre où elles sont référencées).
Les notes de bas de page non référencées ne sont pas affichées.

::::{tab-set}

:::{tab-item} Markdown
```{example}
- Voici une note de bas de page numérotée manuellement[^3].
- Voici un renvoi à une note de bas de page automatiquement numérotée[^maref].

[^maref]: Il s'agit d'une définition de note de bas de page auto-numérotée.
[^3]: Il s'agit d'une définition de note de bas de page numérotée manuellement.
```
:::

:::{tab-item} LaTeX
```{noedit}
\begin{itemize}
\item Voici une note de bas de page numérotée manuellement%
  \footnotemark[3]%
  \footnotetext[3]{Il s'agit d'une définition de note de bas de page numérotée
    manuellement.}.
\item Voici un renvoi à une note de bas de page automatiquement
  numérotée\footnote{Il s'agit d'une définition de note de bas de page
    auto-numérotée.}.
\end{itemize}
```
:::
::::

Tout texte suivant une définition de note de bas de page, *indenté de
quatre espaces ou plus*, est également inclus dans la définition de la note de
bas de page.

:::{example}
Une définition de note de bas de page sur plusieurs lignes[^malongueref].

[^malongueref]: Il s'agit de la _**définition de la note de bas de page**_.

    Elle se poursuit pour toutes les lignes indentées

    - même pour les autres éléments du bloc

    Plus toutes les lignes précédentes non indentées,
qui ne sont pas séparées par une ligne vide

Ceci ne fait pas partie de la note de bas de page.
:::

```{important}
À l'intérieur des s, bien que les notes de bas de page puissent sans
problème être  *référencées* (par exemple[^maref]), il est recommandé de ne pas les
*définir*, à moins qu'elles ne soient référencées qu'à l'intérieur de cette même
 : en effet, sinon, il se peut qu'elles ne soient *référençables qu'à
l'intérieur* de cette  particulière.
```

## Conversions textuelles

Markdown peut convertir certains caractères ou chaînes de caractère
prédéfinis en image, autre texte, ou HTML.

1. Les guillemets standards (*doublequotes*) sont automatiquement convertis en
leurs variantes ouvrante/fermante (conformes à la typographie française) :
    - `"guillemets doubles"` : "guillemets doubles" ;
    - `'guillemets simples'` : 'guillemets simples'.
    -
2. Certains textes typographiques et ligatures communs sont également automatiquement
convertis :

| Texte source   | Texte converti |
|----------------|----------------|
| `(c)`, `(C)`   | (c)            |
| `(tm)`, `(TM)` | (tm)           |
| `(r)`, `(R)`   | (r)            |
| `+-`           | +-             |
| `...`          | ...            |
| `?....`        | ?....          |
| `!....`        | !....          |
| `????????`     | ????????       |
| `!!!!!`        | !!!!!          |
| `,,,`          | ,,,            |
| `--`           | --             |
| `---`          | ---            |


## Citations

Parfois vous souhaitez marquer du texte afin de montrer que c'est une
réponse ou un commentaire. Vous pouvez utiliser la syntaxe suivante :

```{example}
Je pense que nous devrions le faire.
> Non nous ne devrions pas.
>> Eh bien, je pense que si.
> Vraiment ?
>> Oui !
>>> Alors faisons-le !
```

<!-- ## Agrégation de fils RSS/ATOM -->
<!--  -->
<!-- :::{todo} -->
<!-- Cf. . -->
<!-- ::: -->


## Mots clés

Afin qu'elles soient bien indexées par les moteurs de recherche, les pages de la
FAQ peuvent être enrichies de métadonnées, notamment de mots clés. Cela se fait
au moyen de quelques lignes de code <wpfr:YAML> (dont il n'est pas nécessaire de
maîtriser la syntaxe), à placer obligatoirement en préambule (au début) du
fichier source Markdown entre paire de triples tirets (`---`). Ainsi le fichier
source de la page
[](/3_composition/texte/renvois/references_croisees_entre_documents)
commence-t-il par :

::::{tab-set}

:::{tab-item} Markdown
```yaml
---
myst:
  html_meta:
    keywords: LaTeX,renvois,labels,références
---
```
:::

:::{tab-item} LaTeX
```{noedit}
\usepackage{hyperref}
\hypersetup{
  pdfkeywords={LaTeX,renvois,labels,références},
}
```
:::
::::

## Substitutions

Il est possible de faire usage de substitutions, à la manière des macros
personnelles sous LaTeX. Elles se définissent dans le préambule `YAML` d'un
fichier source au moyen de paires clés/valeurs imbriquées dans la clé
`substitutions`. Ainsi, on pourrait définir la substitution `dek` pour "Donald
Ervin Knuth" qu'on emploierait ensuite dans le fichier Markdown au moyen de
`{{dek}}` :

::::{tab-set}

:::{tab-item} Markdown
```yaml
---
myst:
  substitutions:
    dek: "Donald Ervin Knuth"
---
```
```{example}
À l’origine, {{dek}} a développé TeX (en `WEB`) notamment pour réaliser de beaux
documents et écrire des formules mathématiques.
```
:::

:::{tab-item} LaTeX
```{noedit}
\newcommand{\dek}{Donald Ervin Knuth}
À l’origine, \dek{} a développé \TeX{} (en \texttt{WEB}) notamment pour réaliser
de beaux documents et écrire des formules mathématiques.
```
:::
::::

:::{note} Les substitutions définies dans le préambule `YAML` d'un fichier
source Markdown sont locales à ce fichier. Il est également possible de définir
des substitutions globales à toute la FAQ ; pour l'instant, aucune n'a été ainsi
définie mais, si le besoin s'en fait sentir, n'hésitez pas à nous le signaler
sur [liste dédiée à la FAQ](mailto:faq@gutenberg-asso.fr) ou en ouvrant un
"ticket" [ici](https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut/-/issues/new) et nous
ferons le nécessaire.
:::

## Logos TeX, LaTeX, etc.

Les logos tels que "TeX" et "LaTeX" sont mis en forme sans peine puisqu'il
suffit de les saisir tels quels : ils sont "logoifiés" automatiquement au cours
de la compilation de la FAQ. Leur liste exhaustive est la suivante :

| Code        | Résultat  |
|-------------|-----------|
| `(La)TeX`   | (La)TeX   |
| `AmS-LaTeX` | AmS-LaTeX |
| `AmS-TeX`   | AmS-TeX   |
| `AmSLaTeX`  | AmSLaTeX  |
| `AmSTeX`    | AmSTeX    |
| `BibTeX`    | BibTeX    |
| `eTeX`      | eTeX      |
| `e-TeX`     | e-TeX     |
| `LaTeX`     | LaTeX     |
| `LaTeX(2e)` | LaTeX(2e) |
| `LaTeX2e`   | LaTeX2e   |
| `LaTeXe`    | LaTeXe    |
| `LuaLaTeX`  | LuaLaTeX  |
| `LuaTeX`    | LuaTeX    |
| `LyX`       | LyX       |
| `Metafont`  | Metafont  |
| `Metapost`  | Metapost  |
| `PiCTeX`    | PiCTeX    |
| `SliTeX`    | SliTeX    |
| `teTeX`     | teTeX     |
| `TeX`       | TeX       |
| `TeXLaTeX`  | TeXLaTeX  |
| `Xe(La)TeX` | Xe(La)TeX |
| `XeLaTeX`   | XeLaTeX   |
| `XeTeX`     | XeTeX     |

## Canevas

Lorsque vous créerez de nouvelles pages pour partager votre expérience avec
LaTeX, vous pourrez vous aider du canevas suivant.

```md
---
myst:
  html_meta:
    keywords: ⟨mot clé 1⟩, ⟨mot clé 2⟩
---
# ⟨Question⟩ ?

⟨Réponse(s)⟩

:::{sources}
Source(s)
:::
```

[^1]: Ceci est une note de pied de page

[^2]: Si les proportions de l'image ne sont pas respectées, celle-ci
    sera découpée avant redimensionnement selon les nouvelles
    proportions

[uri]: https://fr.wikipedia.org/wiki/Uniform_Resource_Identifier
[url]: https://fr.wikipedia.org/wiki/Uniform_Resource_Locator


























































<!-- | Syntaxe                                           | Résultat                            |                                                           | -->
<!-- |---------------------------------------------------|-------------------------------------|-----------------------------------------------------------| -->
<!-- | **FORMATAGE**                                     |                                     |                                                           | -->
<!-- | `**gras**`                                        | **gras**                            |                                                           | -->
<!-- | `*italique*`                                      | *italique*                          |                                                           | -->
<!-- | `` `monospace` ``                                 | `monospace`                         |                                                           | -->
<!-- | `` ***`tout ensemble`*** ``                       | ***`tout ensemble`***               |                                                           | -->
<!-- | `` {sup}`exposants `` et `` {sub}`indices` ``     | {sup}`exposants` et  {sub}`indices` |                                                           | -->
<!-- | `~~texte supprimé~~`                              | ~~texte supprimé~~                  |                                                           | -->
<!-- | **LIENS**                                         |                                     |                                                           | -->
<!-- | `[http://www.google.com                           | Google]]`                           | [Google](http://www.google.com)                           | -->
<!-- | `[mailto:foo@exemple.com                          | M. Foo]]`                           | [M. Foo](file:///mailto/foo@exemple.com)                  | -->
<!-- | `[wiki:Syntax                                     | Aller à la page de syntaxe]]`       | [Aller à la page de syntaxe](file:///wiki/Syntax)         | -->
<!-- | `[wiki:Syntax#anchor                              | Lien vers une ancre]]`              | [Lien vers une ancre](file:///wiki/Syntax#anchor)         | -->
<!-- | `[wp>interwiki                                    | Lien Interwiki]]`                   | [Lien Interwiki](https://en.wikipedia.org/wiki/interwiki) | -->
<!-- | **IMAGES**                                        |                                     |                                                           | -->
<!-- | `{{wiki:dokuwiki-128.png}}`                       | ![](file:///wiki/dokuwiki-128.png)  |                                                           | -->
<!-- | `[[http://www.dokuwiki.org                        | {{wiki:dokuwiki-128.png}}]]`        | [\[\[/wiki/dokuwiki-128.png](http://www.dokuwiki.org)\]\] | -->
<!-- | `{{wiki:dokuwiki-128.png                          | Avec titre}}`                       | ![](file:///wiki/dokuwiki-128.png)                        | -->
<!-- | **AUTRES**                                        |                                     |                                                           | -->
<!-- | `Lorem ipsum((Ceci est une note de bas de page))` | Lorem ipsum[^1]                     |                                                           | -->
<!--  -->
<!-- [^1]: Ceci est une note de bas de page -->
