// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * A type capable of looking up a property value from a string name.
 *
 * See the [Rust documentation for `PropertyParser`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParser.html) for more information.
 *
 * See the [Rust documentation for `PropertyParserBorrowed`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParserBorrowed.html) for more information.
 *
 * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParser.html#method.new) for more information.
 */


export class PropertyValueNameToEnumMapper {
    get ffiValue(): pointer;


    /**
     * Get the property value matching the given name, using strict matching
     *
     * Returns -1 if the name is unknown for this property
     *
     * See the [Rust documentation for `get_strict`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParserBorrowed.html#method.get_strict) for more information.
     */
    getStrict(name: string): number;

    /**
     * Get the property value matching the given name, using loose matching
     *
     * Returns -1 if the name is unknown for this property
     *
     * See the [Rust documentation for `get_loose`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParserBorrowed.html#method.get_loose) for more information.
     */
    getLoose(name: string): number;

    /**
     * Create a name-to-enum mapper for the `General_Category` property, using compiled data.
     *
     * See the [Rust documentation for `GeneralCategory`](https://docs.rs/icu/latest/icu/properties/props/enum.GeneralCategory.html) for more information.
     */
    static createGeneralCategory(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `General_Category` property, using a particular data source.
     *
     * See the [Rust documentation for `GeneralCategory`](https://docs.rs/icu/latest/icu/properties/props/enum.GeneralCategory.html) for more information.
     */
    static createGeneralCategoryWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Hangul_Syllable_Type` property, using compiled data.
     *
     * See the [Rust documentation for `HangulSyllableType`](https://docs.rs/icu/latest/icu/properties/props/struct.HangulSyllableType.html) for more information.
     */
    static createHangulSyllableType(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Hangul_Syllable_Type` property, using a particular data source.
     *
     * See the [Rust documentation for `HangulSyllableType`](https://docs.rs/icu/latest/icu/properties/props/struct.HangulSyllableType.html) for more information.
     */
    static createHangulSyllableTypeWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `East_Asian_Width` property, using compiled data.
     *
     * See the [Rust documentation for `EastAsianWidth`](https://docs.rs/icu/latest/icu/properties/props/struct.EastAsianWidth.html) for more information.
     */
    static createEastAsianWidth(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `East_Asian_Width` property, using a particular data source.
     *
     * See the [Rust documentation for `EastAsianWidth`](https://docs.rs/icu/latest/icu/properties/props/struct.EastAsianWidth.html) for more information.
     */
    static createEastAsianWidthWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Bidi_Class` property, using compiled data.
     *
     * See the [Rust documentation for `BidiClass`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html) for more information.
     */
    static createBidiClass(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Bidi_Class` property, using a particular data source.
     *
     * See the [Rust documentation for `BidiClass`](https://docs.rs/icu/latest/icu/properties/props/struct.BidiClass.html) for more information.
     */
    static createBidiClassWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Indic_Syllabic_Category` property, using compiled data.
     *
     * See the [Rust documentation for `IndicSyllabicCategory`](https://docs.rs/icu/latest/icu/properties/props/struct.IndicSyllabicCategory.html) for more information.
     */
    static createIndicSyllabicCategory(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Indic_Syllabic_Category` property, using a particular data source.
     *
     * See the [Rust documentation for `IndicSyllabicCategory`](https://docs.rs/icu/latest/icu/properties/props/struct.IndicSyllabicCategory.html) for more information.
     */
    static createIndicSyllabicCategoryWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Line_Break` property, using compiled data.
     *
     * See the [Rust documentation for `LineBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.LineBreak.html) for more information.
     */
    static createLineBreak(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Line_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `LineBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.LineBreak.html) for more information.
     */
    static createLineBreakWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Grapheme_Cluster_Break` property, using compiled data.
     *
     * See the [Rust documentation for `GraphemeClusterBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.GraphemeClusterBreak.html) for more information.
     */
    static createGraphemeClusterBreak(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Grapheme_Cluster_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `GraphemeClusterBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.GraphemeClusterBreak.html) for more information.
     */
    static createGraphemeClusterBreakWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Word_Break` property, using compiled data.
     *
     * See the [Rust documentation for `WordBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.WordBreak.html) for more information.
     */
    static createWordBreak(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Word_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `WordBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.WordBreak.html) for more information.
     */
    static createWordBreakWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Sentence_Break` property, using compiled data.
     *
     * See the [Rust documentation for `SentenceBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.SentenceBreak.html) for more information.
     */
    static createSentenceBreak(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Sentence_Break` property, using a particular data source.
     *
     * See the [Rust documentation for `SentenceBreak`](https://docs.rs/icu/latest/icu/properties/props/struct.SentenceBreak.html) for more information.
     */
    static createSentenceBreakWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Script` property, using compiled data.
     *
     * See the [Rust documentation for `Script`](https://docs.rs/icu/latest/icu/properties/props/struct.Script.html) for more information.
     */
    static createScript(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Script` property, using a particular data source.
     *
     * See the [Rust documentation for `Script`](https://docs.rs/icu/latest/icu/properties/props/struct.Script.html) for more information.
     */
    static createScriptWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Vertical_Orientation` property, using compiled data.
     *
     * See the [Rust documentation for `VerticalOrientation`](https://docs.rs/icu/latest/icu/properties/props/struct.VerticalOrientation.html) for more information.
     */
    static createVerticalOrientation(): PropertyValueNameToEnumMapper;

    /**
     * Create a name-to-enum mapper for the `Vertical_Orientation` property, using a particular data source.
     *
     * See the [Rust documentation for `VerticalOrientation`](https://docs.rs/icu/latest/icu/properties/props/struct.VerticalOrientation.html) for more information.
     */
    static createVerticalOrientationWithProvider(provider: DataProvider): PropertyValueNameToEnumMapper;
}