#!/bin/sh
#
# Startup script for Apache Tomcat with systemd
#

set -e

# Load the service settings
. /etc/default/tomcat11

# Find the Java runtime and set JAVA_HOME
. /usr/libexec/tomcat11/tomcat-locate-java.sh

# Set the JSP compiler if configured in the /etc/default/tomcat11 file
[ -n "$JSP_COMPILER" ] && JAVA_OPTS="$JAVA_OPTS -Dbuild.compiler=\"$JSP_COMPILER\""

export JAVA_OPTS


# Start Tomcat
cd $CATALINA_BASE && exec $CATALINA_HOME/bin/catalina.sh run
