// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSUBL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SSUBL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_ssubl_4S[] = {
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffcd4c, 0xffffddde, 0xffffd558,
  0xffffcd4b, 0xffffab2a, 0xffffb336, 0xffffd557,
  0xffffab29, 0xffff8082, 0xffffb335, 0xffffd556,
  0xffff8081, 0xffff8081, 0xffffb334, 0x00005555,
  0xffff8080, 0xffff8080, 0x00003333, 0x00005554,
  0xffff807f, 0x0000007f, 0x00003332, 0x00005553,
  0x0000007e, 0x0000007e, 0x00003331, 0x00005545,
  0x0000007d, 0x0000007d, 0x00003323, 0x000054d8,
  0x0000007c, 0x0000006f, 0x000032b6, 0x000054d7,
  0x0000006e, 0x00000002, 0x000032b5, 0x000054d6,
  0x00000001, 0x00000001, 0x000032b4, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffcd4c, 0xffffddde, 0xffffd558,
  0xffffcd4b, 0xffffab2a, 0xffffb336, 0xffffd557,
  0xffffab29, 0xffff8082, 0xffffb335, 0xffffd556,
  0xffff8081, 0xffff8081, 0xffffb334, 0x0000d555,
  0xffff8080, 0xffff8080, 0x0000b333, 0x0000d554,
  0xffff807f, 0x0000807f, 0x0000b332, 0x0000aaab,
  0x0000807e, 0x0000807e, 0x00008889, 0x00008889,
  0x0000807d, 0x000055d5, 0x00006667, 0x000055d5,
  0x000055d4, 0x000033b3, 0x000033b3, 0x000055d4,
  0x000033b2, 0x000000ff, 0x000033b2, 0x000055d3,
  0x000000fe, 0x000000fe, 0x000033b1, 0x000055d2,
  0x000000fe, 0x000033b1, 0x000055d2, 0x0000800d,
  0x000000fd, 0x000033b0, 0x00005565, 0x00008000,
  0x000000fc, 0x00003343, 0x00005558, 0x00007fff,
  0x0000008f, 0x00003336, 0x00005557, 0x00007ffe,
  0x00000082, 0x00003335, 0x00005556, 0x00007ffd,
  0x00000081, 0x00003334, 0x00005555, 0x00007ffc,
  0x00000080, 0x00003333, 0x00005554, 0x00007ffb,
  0x0000007f, 0x00003332, 0x00005553, 0x00007fed,
  0x0000007e, 0x00003331, 0x00005545, 0x00007f80,
  0x0000007d, 0x00003323, 0x000054d8, 0x00007f7f,
  0x0000006f, 0x000032b6, 0x000054d7, 0x00007f7e,
  0x00000002, 0x000032b5, 0x000054d6, 0x00004cca,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcd4c, 0xffffddde, 0xffffd558, 0xffffffff,
  0xffffab2a, 0xffffb336, 0xffffd557, 0xfffffffe,
  0xffff8082, 0xffffb335, 0xffffd556, 0x0000fffd,
  0xffff8081, 0xffffb334, 0x0000d555, 0x0000fffc,
  0xffff8080, 0x0000b333, 0x0000d554, 0x0000d553,
  0x0000807f, 0x0000b332, 0x0000aaab, 0x0000b331,
  0x0000807e, 0x00008889, 0x00008889, 0x0000807d,
  0x000055d5, 0x00006667, 0x000055d5, 0x0000807c,
  0x000033b3, 0x000033b3, 0x000055d4, 0x0000807b,
  0x000000ff, 0x000033b2, 0x000055d3, 0x0000807a,
  0x000033b2, 0x000055d3, 0x0000807a, 0x0000800e,
  0x000033b1, 0x000055d2, 0x0000800d, 0x00008001,
  0x000033b0, 0x00005565, 0x00008000, 0x00008000,
  0x00003343, 0x00005558, 0x00007fff, 0x00007fff,
  0x00003336, 0x00005557, 0x00007ffe, 0x00007ffe,
  0x00003335, 0x00005556, 0x00007ffd, 0x00007ffd,
  0x00003334, 0x00005555, 0x00007ffc, 0x00007ffc,
  0x00003333, 0x00005554, 0x00007ffb, 0x00007fee,
  0x00003332, 0x00005553, 0x00007fed, 0x00007f81,
  0x00003331, 0x00005545, 0x00007f80, 0x00007f80,
  0x00003323, 0x000054d8, 0x00007f7f, 0x00007f7f,
  0x000032b6, 0x000054d7, 0x00007f7e, 0x00004ccb,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffddde, 0xffffd558, 0xffffffff, 0xffffffff,
  0xffffb336, 0xffffd557, 0xfffffffe, 0x0000fffe,
  0xffffb335, 0xffffd556, 0x0000fffd, 0x0000fffd,
  0xffffb334, 0x0000d555, 0x0000fffc, 0x0000d554,
  0x0000b333, 0x0000d554, 0x0000d553, 0x0000b332,
  0x0000b332, 0x0000aaab, 0x0000b331, 0x0000807e,
  0x00008889, 0x00008889, 0x0000807d, 0x0000807d,
  0x00006667, 0x000055d5, 0x0000807c, 0x0000807c,
  0x000033b3, 0x000055d4, 0x0000807b, 0x0000807b,
  0x000055d4, 0x0000807b, 0x0000807b, 0x0000800f,
  0x000055d3, 0x0000807a, 0x0000800e, 0x00008002,
  0x000055d2, 0x0000800d, 0x00008001, 0x00008001,
  0x00005565, 0x00008000, 0x00008000, 0x00008000,
  0x00005558, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00005557, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00005556, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00005555, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x00005554, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x00005553, 0x00007fed, 0x00007f81, 0x00007f81,
  0x00005545, 0x00007f80, 0x00007f80, 0x00007f80,
  0x000054d8, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffd558, 0xffffffff, 0xffffffff, 0x0000ffff,
  0xffffd557, 0xfffffffe, 0x0000fffe, 0x0000fffe,
  0xffffd556, 0x0000fffd, 0x0000fffd, 0x0000d555,
  0x0000d555, 0x0000fffc, 0x0000d554, 0x0000b333,
  0x0000d554, 0x0000d553, 0x0000b332, 0x0000807f,
  0x0000aaab, 0x0000b331, 0x0000807e, 0x0000807e,
  0x00008889, 0x0000807d, 0x0000807d, 0x0000807d,
  0x000055d5, 0x0000807c, 0x0000807c, 0x0000807c,
  0x0000807c, 0x0000807c, 0x0000807c, 0x00000010,
  0x0000807b, 0x0000807b, 0x0000800f, 0x00000003,
  0x0000807a, 0x0000800e, 0x00008002, 0x00000002,
  0x0000800d, 0x00008001, 0x00008001, 0x00000001,
  0x00008000, 0x00008000, 0x00008000, 0x00000000,
  0x00007fff, 0x00007fff, 0x00007fff, 0xffffffff,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0xfffffffe,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0xfffffff0,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0xffffff83,
  0x00007ffb, 0x00007fee, 0x00007f82, 0xffffff82,
  0x00007fed, 0x00007f81, 0x00007f81, 0xffffff81,
  0x00007f80, 0x00007f80, 0x00007f80, 0xffffcccd,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0xffffaaab,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0xffff8003,
  0x00004cca, 0x00002aa9, 0x00000002, 0xffff8002,
  0x00002aa8, 0x00000001, 0x00000001, 0xffff8001,
  0x00000000, 0x00000000, 0x00000000, 0x00008000,
  0xffffffff, 0xffffffff, 0x0000ffff, 0x00007fff,
  0xfffffffe, 0x0000fffe, 0x0000fffe, 0x00005556,
  0x0000fffd, 0x0000fffd, 0x0000d555, 0x00003334,
  0x0000fffc, 0x0000d554, 0x0000b333, 0x00000080,
  0x0000d553, 0x0000b332, 0x0000807f, 0x0000007f,
  0x0000b331, 0x0000807e, 0x0000807e, 0x0000007e,
  0x0000807d, 0x0000807d, 0x0000807d, 0x0000007d,
  0x0000807d, 0x0000807d, 0x0000007d, 0x00000011,
  0x0000807c, 0x0000807c, 0x00000010, 0x00000004,
  0x0000807b, 0x0000800f, 0x00000003, 0x00000003,
  0x0000800e, 0x00008002, 0x00000002, 0x00000002,
  0x00008001, 0x00008001, 0x00000001, 0x00000001,
  0x00008000, 0x00008000, 0x00000000, 0x00000000,
  0x00007fff, 0x00007fff, 0xffffffff, 0xffffffff,
  0x00007ffe, 0x00007ffe, 0xfffffffe, 0xfffffff1,
  0x00007ffd, 0x00007ffd, 0xfffffff0, 0xffffff84,
  0x00007ffc, 0x00007fef, 0xffffff83, 0xffffff83,
  0x00007fee, 0x00007f82, 0xffffff82, 0xffffff82,
  0x00007f81, 0x00007f81, 0xffffff81, 0xffffccce,
  0x00007f80, 0x00007f80, 0xffffcccd, 0xffffaaac,
  0x00007f7f, 0x00004ccc, 0xffffaaab, 0xffff8004,
  0x00004ccb, 0x00002aaa, 0xffff8003, 0xffff8003,
  0x00002aa9, 0x00000002, 0xffff8002, 0xffff8002,
  0x00000001, 0x00000001, 0xffff8001, 0x00008001,
  0x00000000, 0x00000000, 0x00008000, 0x00008000,
  0xffffffff, 0x0000ffff, 0x00007fff, 0x00005557,
  0x0000fffe, 0x0000fffe, 0x00005556, 0x00003335,
  0x0000fffd, 0x0000d555, 0x00003334, 0x00000081,
  0x0000d554, 0x0000b333, 0x00000080, 0x00000080,
  0x0000b332, 0x0000807f, 0x0000007f, 0x0000007f,
  0x0000807e, 0x0000807e, 0x0000007e, 0x0000007e,
  0x0000807e, 0x0000007e, 0x0000007e, 0x00000012,
  0x0000807d, 0x0000007d, 0x00000011, 0x00000005,
  0x0000807c, 0x00000010, 0x00000004, 0x00000004,
  0x0000800f, 0x00000003, 0x00000003, 0x00000003,
  0x00008002, 0x00000002, 0x00000002, 0x00000002,
  0x00008001, 0x00000001, 0x00000001, 0x00000001,
  0x00008000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0xffffffff, 0xffffffff, 0xfffffff2,
  0x00007ffe, 0xfffffffe, 0xfffffff1, 0xffffff85,
  0x00007ffd, 0xfffffff0, 0xffffff84, 0xffffff84,
  0x00007fef, 0xffffff83, 0xffffff83, 0xffffff83,
  0x00007f82, 0xffffff82, 0xffffff82, 0xffffcccf,
  0x00007f81, 0xffffff81, 0xffffccce, 0xffffaaad,
  0x00007f80, 0xffffcccd, 0xffffaaac, 0xffff8005,
  0x00004ccc, 0xffffaaab, 0xffff8004, 0xffff8004,
  0x00002aaa, 0xffff8003, 0xffff8003, 0xffff8003,
  0x00000002, 0xffff8002, 0xffff8002, 0x00008002,
  0x00000001, 0xffff8001, 0x00008001, 0x00008001,
  0x00000000, 0x00008000, 0x00008000, 0x00005558,
  0x0000ffff, 0x00007fff, 0x00005557, 0x00003336,
  0x0000fffe, 0x00005556, 0x00003335, 0x00000082,
  0x0000d555, 0x00003334, 0x00000081, 0x00000081,
  0x0000b333, 0x00000080, 0x00000080, 0x00000080,
  0x0000807f, 0x0000007f, 0x0000007f, 0x0000007f,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000020,
  0x0000007e, 0x0000007e, 0x00000012, 0x00000013,
  0x0000007d, 0x00000011, 0x00000005, 0x00000012,
  0x00000010, 0x00000004, 0x00000004, 0x00000011,
  0x00000003, 0x00000003, 0x00000003, 0x00000010,
  0x00000002, 0x00000002, 0x00000002, 0x0000000f,
  0x00000001, 0x00000001, 0x00000001, 0x0000000e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffff93,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffff92,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffff91,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffccdd,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaabb,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8013,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8012,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8011,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00008010,
  0xffff8002, 0xffff8002, 0x00008002, 0x0000800f,
  0xffff8001, 0x00008001, 0x00008001, 0x00005566,
  0x00008000, 0x00008000, 0x00005558, 0x00003344,
  0x00007fff, 0x00005557, 0x00003336, 0x00000090,
  0x00005556, 0x00003335, 0x00000082, 0x0000008f,
  0x00003334, 0x00000081, 0x00000081, 0x0000008e,
  0x00000080, 0x00000080, 0x00000080, 0x0000008d,
  0x00000080, 0x00000080, 0x0000008d, 0x0000008d,
  0x0000007f, 0x0000007f, 0x00000020, 0x00000080,
  0x0000007e, 0x00000012, 0x00000013, 0x0000007f,
  0x00000011, 0x00000005, 0x00000012, 0x0000007e,
  0x00000004, 0x00000004, 0x00000011, 0x0000007d,
  0x00000003, 0x00000003, 0x00000010, 0x0000007c,
  0x00000002, 0x00000002, 0x0000000f, 0x0000007b,
  0x00000001, 0x00000001, 0x0000000e, 0x0000006d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xfffffff2, 0xffffff93, 0xffffffff,
  0xfffffff1, 0xffffff85, 0xffffff92, 0xfffffffe,
  0xffffff84, 0xffffff84, 0xffffff91, 0xffffcd4a,
  0xffffff83, 0xffffff83, 0xffffccdd, 0xffffab28,
  0xffffff82, 0xffffcccf, 0xffffaabb, 0xffff8080,
  0xffffccce, 0xffffaaad, 0xffff8013, 0xffff807f,
  0xffffaaac, 0xffff8005, 0xffff8012, 0xffff807e,
  0xffff8004, 0xffff8004, 0xffff8011, 0x0000807d,
  0xffff8003, 0xffff8003, 0x00008010, 0x0000807c,
  0xffff8002, 0x00008002, 0x0000800f, 0x000055d3,
  0x00008001, 0x00008001, 0x00005566, 0x000033b1,
  0x00008000, 0x00005558, 0x00003344, 0x000000fd,
  0x00005557, 0x00003336, 0x00000090, 0x000000fc,
  0x00003335, 0x00000082, 0x0000008f, 0x000000fb,
  0x00000081, 0x00000081, 0x0000008e, 0x000000fa,
  0x00000081, 0x0000008e, 0x000000fa, 0x0000008e,
  0x00000080, 0x0000008d, 0x0000008d, 0x00000081,
  0x0000007f, 0x00000020, 0x00000080, 0x00000080,
  0x00000012, 0x00000013, 0x0000007f, 0x0000007f,
  0x00000005, 0x00000012, 0x0000007e, 0x0000007e,
  0x00000004, 0x00000011, 0x0000007d, 0x0000007d,
  0x00000003, 0x00000010, 0x0000007c, 0x0000007c,
  0x00000002, 0x0000000f, 0x0000007b, 0x0000006e,
  0x00000001, 0x0000000e, 0x0000006d, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xfffffff2, 0xffffff93, 0xffffffff, 0xffffffff,
  0xffffff85, 0xffffff92, 0xfffffffe, 0xffffcd4b,
  0xffffff84, 0xffffff91, 0xffffcd4a, 0xffffab29,
  0xffffff83, 0xffffccdd, 0xffffab28, 0xffff8081,
  0xffffcccf, 0xffffaabb, 0xffff8080, 0xffff8080,
  0xffffaaad, 0xffff8013, 0xffff807f, 0xffff807f,
  0xffff8005, 0xffff8012, 0xffff807e, 0x0000807e,
  0xffff8004, 0xffff8011, 0x0000807d, 0x0000807d,
  0xffff8003, 0x00008010, 0x0000807c, 0x000055d4,
  0x00008002, 0x0000800f, 0x000055d3, 0x000033b2,
  0x00008001, 0x00005566, 0x000033b1, 0x000000fe,
  0x00005558, 0x00003344, 0x000000fd, 0x000000fd,
  0x00003336, 0x00000090, 0x000000fc, 0x000000fc,
  0x00000082, 0x0000008f, 0x000000fb, 0x000000fb,
  0x0000008f, 0x000000fb, 0x000000fb, 0x0000008f,
  0x0000008e, 0x000000fa, 0x0000008e, 0x00000082,
  0x0000008d, 0x0000008d, 0x00000081, 0x00000081,
  0x00000020, 0x00000080, 0x00000080, 0x00000080,
  0x00000013, 0x0000007f, 0x0000007f, 0x0000007f,
  0x00000012, 0x0000007e, 0x0000007e, 0x0000007e,
  0x00000011, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000010, 0x0000007c, 0x0000007c, 0x0000006f,
  0x0000000f, 0x0000007b, 0x0000006e, 0x00000002,
  0x0000000e, 0x0000006d, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff93, 0xffffffff, 0xffffffff, 0xffffcd4c,
  0xffffff92, 0xfffffffe, 0xffffcd4b, 0xffffab2a,
  0xffffff91, 0xffffcd4a, 0xffffab29, 0xffff8082,
  0xffffccdd, 0xffffab28, 0xffff8081, 0xffff8081,
  0xffffaabb, 0xffff8080, 0xffff8080, 0xffff8080,
  0xffff8013, 0xffff807f, 0xffff807f, 0x0000807f,
  0xffff8012, 0xffff807e, 0x0000807e, 0x0000807e,
  0xffff8011, 0x0000807d, 0x0000807d, 0x000055d5,
  0x00008010, 0x0000807c, 0x000055d4, 0x000033b3,
  0x0000800f, 0x000055d3, 0x000033b2, 0x000000ff,
  0x00005566, 0x000033b1, 0x000000fe, 0x000000fe,
  0x00003344, 0x000000fd, 0x000000fd, 0x000000fd,
  0x00000090, 0x000000fc, 0x000000fc, 0x000000fc,
  0x000000fc, 0x000000fc, 0x000000fc, 0x00003343,
  0x000000fb, 0x000000fb, 0x0000008f, 0x00003336,
  0x000000fa, 0x0000008e, 0x00000082, 0x00003335,
  0x0000008d, 0x00000081, 0x00000081, 0x00003334,
  0x00000080, 0x00000080, 0x00000080, 0x00003333,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00003332,
  0x0000007e, 0x0000007e, 0x0000007e, 0x00003331,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00003323,
  0x0000007c, 0x0000007c, 0x0000006f, 0x000032b6,
  0x0000007b, 0x0000006e, 0x00000002, 0x000032b5,
  0x0000006d, 0x00000001, 0x00000001, 0x000032b4,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffcd4c, 0xffffddde,
  0xfffffffe, 0xffffcd4b, 0xffffab2a, 0xffffb336,
  0xffffcd4a, 0xffffab29, 0xffff8082, 0xffffb335,
  0xffffab28, 0xffff8081, 0xffff8081, 0xffffb334,
  0xffff8080, 0xffff8080, 0xffff8080, 0x0000b333,
  0xffff807f, 0xffff807f, 0x0000807f, 0x0000b332,
  0xffff807e, 0x0000807e, 0x0000807e, 0x00008889,
  0x0000807d, 0x0000807d, 0x000055d5, 0x00006667,
  0x0000807c, 0x000055d4, 0x000033b3, 0x000033b3,
  0x000055d3, 0x000033b2, 0x000000ff, 0x000033b2,
  0x000033b1, 0x000000fe, 0x000000fe, 0x000033b1,
  0x000000fd, 0x000000fd, 0x000000fd, 0x000033b0,
  0x000000fd, 0x000000fd, 0x000033b0, 0x00005565,
  0x000000fc, 0x000000fc, 0x00003343, 0x00005558,
  0x000000fb, 0x0000008f, 0x00003336, 0x00005557,
  0x0000008e, 0x00000082, 0x00003335, 0x00005556,
  0x00000081, 0x00000081, 0x00003334, 0x00005555,
  0x00000080, 0x00000080, 0x00003333, 0x00005554,
  0x0000007f, 0x0000007f, 0x00003332, 0x00005553,
  0x0000007e, 0x0000007e, 0x00003331, 0x00005545,
  0x0000007d, 0x0000007d, 0x00003323, 0x000054d8,
  0x0000007c, 0x0000006f, 0x000032b6, 0x000054d7,
  0x0000006e, 0x00000002, 0x000032b5, 0x000054d6,
  0x00000001, 0x00000001, 0x000032b4, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffcd4c, 0xffffddde, 0xffffd558,
  0xffffcd4b, 0xffffab2a, 0xffffb336, 0xffffd557,
  0xffffab29, 0xffff8082, 0xffffb335, 0xffffd556,
  0xffff8081, 0xffff8081, 0xffffb334, 0x0000d555,
  0xffff8080, 0xffff8080, 0x0000b333, 0x0000d554,
  0xffff807f, 0x0000807f, 0x0000b332, 0x0000aaab,
  0x0000807e, 0x0000807e, 0x00008889, 0x00008889,
  0x0000807d, 0x000055d5, 0x00006667, 0x000055d5,
  0x000055d4, 0x000033b3, 0x000033b3, 0x000055d4,
  0x000033b2, 0x000000ff, 0x000033b2, 0x000055d3,
  0x000000fe, 0x000000fe, 0x000033b1, 0x000055d2,
  0x000000fe, 0x000033b1, 0x000055d2, 0x0000800d,
  0x000000fd, 0x000033b0, 0x00005565, 0x00008000,
  0x000000fc, 0x00003343, 0x00005558, 0x00007fff,
  0x0000008f, 0x00003336, 0x00005557, 0x00007ffe,
  0x00000082, 0x00003335, 0x00005556, 0x00007ffd,
  0x00000081, 0x00003334, 0x00005555, 0x00007ffc,
  0x00000080, 0x00003333, 0x00005554, 0x00007ffb,
  0x0000007f, 0x00003332, 0x00005553, 0x00007fed,
  0x0000007e, 0x00003331, 0x00005545, 0x00007f80,
  0x0000007d, 0x00003323, 0x000054d8, 0x00007f7f,
  0x0000006f, 0x000032b6, 0x000054d7, 0x00007f7e,
  0x00000002, 0x000032b5, 0x000054d6, 0x00004cca,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcd4c, 0xffffddde, 0xffffd558, 0xffffffff,
  0xffffab2a, 0xffffb336, 0xffffd557, 0xfffffffe,
  0xffff8082, 0xffffb335, 0xffffd556, 0x0000fffd,
  0xffff8081, 0xffffb334, 0x0000d555, 0x0000fffc,
  0xffff8080, 0x0000b333, 0x0000d554, 0x0000d553,
  0x0000807f, 0x0000b332, 0x0000aaab, 0x0000b331,
  0x0000807e, 0x00008889, 0x00008889, 0x0000807d,
  0x000055d5, 0x00006667, 0x000055d5, 0x0000807c,
  0x000033b3, 0x000033b3, 0x000055d4, 0x0000807b,
  0x000000ff, 0x000033b2, 0x000055d3, 0x0000807a,
  0x000033b2, 0x000055d3, 0x0000807a, 0x0000800e,
  0x000033b1, 0x000055d2, 0x0000800d, 0x00008001,
  0x000033b0, 0x00005565, 0x00008000, 0x00008000,
  0x00003343, 0x00005558, 0x00007fff, 0x00007fff,
  0x00003336, 0x00005557, 0x00007ffe, 0x00007ffe,
  0x00003335, 0x00005556, 0x00007ffd, 0x00007ffd,
  0x00003334, 0x00005555, 0x00007ffc, 0x00007ffc,
  0x00003333, 0x00005554, 0x00007ffb, 0x00007fee,
  0x00003332, 0x00005553, 0x00007fed, 0x00007f81,
  0x00003331, 0x00005545, 0x00007f80, 0x00007f80,
  0x00003323, 0x000054d8, 0x00007f7f, 0x00007f7f,
  0x000032b6, 0x000054d7, 0x00007f7e, 0x00004ccb,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffddde, 0xffffd558, 0xffffffff, 0xffffffff,
  0xffffb336, 0xffffd557, 0xfffffffe, 0x0000fffe,
  0xffffb335, 0xffffd556, 0x0000fffd, 0x0000fffd,
  0xffffb334, 0x0000d555, 0x0000fffc, 0x0000d554,
  0x0000b333, 0x0000d554, 0x0000d553, 0x0000b332,
  0x0000b332, 0x0000aaab, 0x0000b331, 0x0000807e,
  0x00008889, 0x00008889, 0x0000807d, 0x0000807d,
  0x00006667, 0x000055d5, 0x0000807c, 0x0000807c,
  0x000033b3, 0x000055d4, 0x0000807b, 0x0000807b,
  0x000055d4, 0x0000807b, 0x0000807b, 0x0000800f,
  0x000055d3, 0x0000807a, 0x0000800e, 0x00008002,
  0x000055d2, 0x0000800d, 0x00008001, 0x00008001,
  0x00005565, 0x00008000, 0x00008000, 0x00008000,
  0x00005558, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00005557, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00005556, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00005555, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x00005554, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x00005553, 0x00007fed, 0x00007f81, 0x00007f81,
  0x00005545, 0x00007f80, 0x00007f80, 0x00007f80,
  0x000054d8, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffd558, 0xffffffff, 0xffffffff, 0x0000ffff,
  0xffffd557, 0xfffffffe, 0x0000fffe, 0x0000fffe,
  0xffffd556, 0x0000fffd, 0x0000fffd, 0x0000d555,
  0x0000d555, 0x0000fffc, 0x0000d554, 0x0000b333,
  0x0000d554, 0x0000d553, 0x0000b332, 0x0000807f,
  0x0000aaab, 0x0000b331, 0x0000807e, 0x0000807e,
  0x00008889, 0x0000807d, 0x0000807d, 0x0000807d,
  0x000055d5, 0x0000807c, 0x0000807c, 0x0000807c,
  0x0000807c, 0x0000807c, 0x0000807c, 0xffff8010,
  0x0000807b, 0x0000807b, 0x0000800f, 0xffff8003,
  0x0000807a, 0x0000800e, 0x00008002, 0xffff8002,
  0x0000800d, 0x00008001, 0x00008001, 0xffff8001,
  0x00008000, 0x00008000, 0x00008000, 0xffff8000,
  0x00007fff, 0x00007fff, 0x00007fff, 0xffff7fff,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0xffff7ffe,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0xffff7ff0,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0xffff7f83,
  0x00007ffb, 0x00007fee, 0x00007f82, 0xffff7f82,
  0x00007fed, 0x00007f81, 0x00007f81, 0xffff7f81,
  0x00007f80, 0x00007f80, 0x00007f80, 0xffff4ccd,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0xffff2aab,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0xffff0003,
  0x00004cca, 0x00002aa9, 0x00000002, 0xffff0002,
  0x00002aa8, 0x00000001, 0x00000001, 0xffff0001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0x0000ffff, 0xffffffff,
  0xfffffffe, 0x0000fffe, 0x0000fffe, 0xffffd556,
  0x0000fffd, 0x0000fffd, 0x0000d555, 0xffffb334,
  0x0000fffc, 0x0000d554, 0x0000b333, 0xffff8080,
  0x0000d553, 0x0000b332, 0x0000807f, 0xffff807f,
  0x0000b331, 0x0000807e, 0x0000807e, 0xffff807e,
  0x0000807d, 0x0000807d, 0x0000807d, 0xffff807d,
  0x0000807d, 0x0000807d, 0xffff807d, 0xffff8011,
  0x0000807c, 0x0000807c, 0xffff8010, 0xffff8004,
  0x0000807b, 0x0000800f, 0xffff8003, 0xffff8003,
  0x0000800e, 0x00008002, 0xffff8002, 0xffff8002,
  0x00008001, 0x00008001, 0xffff8001, 0xffff8001,
  0x00008000, 0x00008000, 0xffff8000, 0xffff8000,
  0x00007fff, 0x00007fff, 0xffff7fff, 0xffff7fff,
  0x00007ffe, 0x00007ffe, 0xffff7ffe, 0xffff7ff1,
  0x00007ffd, 0x00007ffd, 0xffff7ff0, 0xffff7f84,
  0x00007ffc, 0x00007fef, 0xffff7f83, 0xffff7f83,
  0x00007fee, 0x00007f82, 0xffff7f82, 0xffff7f82,
  0x00007f81, 0x00007f81, 0xffff7f81, 0xffff4cce,
  0x00007f80, 0x00007f80, 0xffff4ccd, 0xffff2aac,
  0x00007f7f, 0x00004ccc, 0xffff2aab, 0xffff0004,
  0x00004ccb, 0x00002aaa, 0xffff0003, 0xffff0003,
  0x00002aa9, 0x00000002, 0xffff0002, 0xffff0002,
  0x00000001, 0x00000001, 0xffff0001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0x0000ffff, 0xffffffff, 0xffffd557,
  0x0000fffe, 0x0000fffe, 0xffffd556, 0xffffb335,
  0x0000fffd, 0x0000d555, 0xffffb334, 0xffff8081,
  0x0000d554, 0x0000b333, 0xffff8080, 0xffff8080,
  0x0000b332, 0x0000807f, 0xffff807f, 0xffff807f,
  0x0000807e, 0x0000807e, 0xffff807e, 0xffff807e,
  0x0000807e, 0xffff807e, 0xffff807e, 0xffffaaba,
  0x0000807d, 0xffff807d, 0xffff8011, 0xffffaaad,
  0x0000807c, 0xffff8010, 0xffff8004, 0xffffaaac,
  0x0000800f, 0xffff8003, 0xffff8003, 0xffffaaab,
  0x00008002, 0xffff8002, 0xffff8002, 0xffffaaaa,
  0x00008001, 0xffff8001, 0xffff8001, 0xffffaaa9,
  0x00008000, 0xffff8000, 0xffff8000, 0xffffaaa8,
  0x00007fff, 0xffff7fff, 0xffff7fff, 0xffffaa9a,
  0x00007ffe, 0xffff7ffe, 0xffff7ff1, 0xffffaa2d,
  0x00007ffd, 0xffff7ff0, 0xffff7f84, 0xffffaa2c,
  0x00007fef, 0xffff7f83, 0xffff7f83, 0xffffaa2b,
  0x00007f82, 0xffff7f82, 0xffff7f82, 0xffff7777,
  0x00007f81, 0xffff7f81, 0xffff4cce, 0xffff5555,
  0x00007f80, 0xffff4ccd, 0xffff2aac, 0xffff2aad,
  0x00004ccc, 0xffff2aab, 0xffff0004, 0xffff2aac,
  0x00002aaa, 0xffff0003, 0xffff0003, 0xffff2aab,
  0x00000002, 0xffff0002, 0xffff0002, 0x00002aaa,
  0x00000001, 0xffff0001, 0x00000001, 0x00002aa9,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000ffff, 0xffffffff, 0xffffd557, 0xffffddde,
  0x0000fffe, 0xffffd556, 0xffffb335, 0xffffab2a,
  0x0000d555, 0xffffb334, 0xffff8081, 0xffffab29,
  0x0000b333, 0xffff8080, 0xffff8080, 0xffffab28,
  0x0000807f, 0xffff807f, 0xffff807f, 0xffffab27,
  0xffff807f, 0xffff807f, 0xffffab27, 0xffffccdc,
  0xffff807e, 0xffff807e, 0xffffaaba, 0xffffcccf,
  0xffff807d, 0xffff8011, 0xffffaaad, 0xffffccce,
  0xffff8010, 0xffff8004, 0xffffaaac, 0xffffcccd,
  0xffff8003, 0xffff8003, 0xffffaaab, 0xffffcccc,
  0xffff8002, 0xffff8002, 0xffffaaaa, 0xffffcccb,
  0xffff8001, 0xffff8001, 0xffffaaa9, 0xffffccca,
  0xffff8000, 0xffff8000, 0xffffaaa8, 0xffffccbc,
  0xffff7fff, 0xffff7fff, 0xffffaa9a, 0xffffcc4f,
  0xffff7ffe, 0xffff7ff1, 0xffffaa2d, 0xffffcc4e,
  0xffff7ff0, 0xffff7f84, 0xffffaa2c, 0xffffcc4d,
  0xffff7f83, 0xffff7f83, 0xffffaa2b, 0xffff9999,
  0xffff7f82, 0xffff7f82, 0xffff7777, 0xffff7777,
  0xffff7f81, 0xffff4cce, 0xffff5555, 0xffff4ccf,
  0xffff4ccd, 0xffff2aac, 0xffff2aad, 0xffff4cce,
  0xffff2aab, 0xffff0004, 0xffff2aac, 0xffff4ccd,
  0xffff0003, 0xffff0003, 0xffff2aab, 0x00004ccc,
  0xffff0002, 0xffff0002, 0x00002aaa, 0x00004ccb,
  0xffff0001, 0x00000001, 0x00002aa9, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffd557, 0xffffddde, 0xffffcd4c,
  0xffffd556, 0xffffb335, 0xffffab2a, 0xffffcd4b,
  0xffffb334, 0xffff8081, 0xffffab29, 0xffffcd4a,
  0xffff8080, 0xffff8080, 0xffffab28, 0xffffcd49,
  0xffff8080, 0xffffab28, 0xffffcd49, 0xffffff90,
  0xffff807f, 0xffffab27, 0xffffccdc, 0xffffff83,
  0xffff807e, 0xffffaaba, 0xffffcccf, 0xffffff82,
  0xffff8011, 0xffffaaad, 0xffffccce, 0xffffff81,
  0xffff8004, 0xffffaaac, 0xffffcccd, 0xffffff80,
  0xffff8003, 0xffffaaab, 0xffffcccc, 0xffffff7f,
  0xffff8002, 0xffffaaaa, 0xffffcccb, 0xffffff7e,
  0xffff8001, 0xffffaaa9, 0xffffccca, 0xffffff70,
  0xffff8000, 0xffffaaa8, 0xffffccbc, 0xffffff03,
  0xffff7fff, 0xffffaa9a, 0xffffcc4f, 0xffffff02,
  0xffff7ff1, 0xffffaa2d, 0xffffcc4e, 0xffffff01,
  0xffff7f84, 0xffffaa2c, 0xffffcc4d, 0xffffcc4d,
  0xffff7f83, 0xffffaa2b, 0xffff9999, 0xffffaa2b,
  0xffff7f82, 0xffff7777, 0xffff7777, 0xffff7f83,
  0xffff4cce, 0xffff5555, 0xffff4ccf, 0xffff7f82,
  0xffff2aac, 0xffff2aad, 0xffff4cce, 0xffff7f81,
  0xffff0004, 0xffff2aac, 0xffff4ccd, 0x00007f80,
  0xffff0003, 0xffff2aab, 0x00004ccc, 0x00007f7f,
  0xffff0002, 0x00002aaa, 0x00004ccb, 0x000054d6,
  0x00000001, 0x00002aa9, 0x00002222, 0x000032b4,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffd557, 0xffffddde, 0xffffcd4c, 0xffffffff,
  0xffffb335, 0xffffab2a, 0xffffcd4b, 0xfffffffe,
  0xffff8081, 0xffffab29, 0xffffcd4a, 0xfffffffd,
  0xffffab29, 0xffffcd4a, 0xfffffffd, 0xffffff91,
  0xffffab28, 0xffffcd49, 0xffffff90, 0xffffff84,
  0xffffab27, 0xffffccdc, 0xffffff83, 0xffffff83,
  0xffffaaba, 0xffffcccf, 0xffffff82, 0xffffff82,
  0xffffaaad, 0xffffccce, 0xffffff81, 0xffffff81,
  0xffffaaac, 0xffffcccd, 0xffffff80, 0xffffff80,
  0xffffaaab, 0xffffcccc, 0xffffff7f, 0xffffff7f,
  0xffffaaaa, 0xffffcccb, 0xffffff7e, 0xffffff71,
  0xffffaaa9, 0xffffccca, 0xffffff70, 0xffffff04,
  0xffffaaa8, 0xffffccbc, 0xffffff03, 0xffffff03,
  0xffffaa9a, 0xffffcc4f, 0xffffff02, 0xffffff02,
  0xffffaa2d, 0xffffcc4e, 0xffffff01, 0xffffcc4e,
  0xffffaa2c, 0xffffcc4d, 0xffffcc4d, 0xffffaa2c,
  0xffffaa2b, 0xffff9999, 0xffffaa2b, 0xffff7f84,
  0xffff7777, 0xffff7777, 0xffff7f83, 0xffff7f83,
  0xffff5555, 0xffff4ccf, 0xffff7f82, 0xffff7f82,
  0xffff2aad, 0xffff4cce, 0xffff7f81, 0x00007f81,
  0xffff2aac, 0xffff4ccd, 0x00007f80, 0x00007f80,
  0xffff2aab, 0x00004ccc, 0x00007f7f, 0x000054d7,
  0x00002aaa, 0x00004ccb, 0x000054d6, 0x000032b5,
  0x00002aa9, 0x00002222, 0x000032b4, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffddde, 0xffffcd4c, 0xffffffff, 0xffffffff,
  0xffffab2a, 0xffffcd4b, 0xfffffffe, 0xfffffffe,
  0xffffcd4b, 0xfffffffe, 0xfffffffe, 0xffffff92,
  0xffffcd4a, 0xfffffffd, 0xffffff91, 0xffffff85,
  0xffffcd49, 0xffffff90, 0xffffff84, 0xffffff84,
  0xffffccdc, 0xffffff83, 0xffffff83, 0xffffff83,
  0xffffcccf, 0xffffff82, 0xffffff82, 0xffffff82,
  0xffffccce, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffffcccd, 0xffffff80, 0xffffff80, 0xffffff80,
  0xffffcccc, 0xffffff7f, 0xffffff7f, 0xffffff72,
  0xffffcccb, 0xffffff7e, 0xffffff71, 0xffffff05,
  0xffffccca, 0xffffff70, 0xffffff04, 0xffffff04,
  0xffffccbc, 0xffffff03, 0xffffff03, 0xffffff03,
  0xffffcc4f, 0xffffff02, 0xffffff02, 0xffffcc4f,
  0xffffcc4e, 0xffffff01, 0xffffcc4e, 0xffffaa2d,
  0xffffcc4d, 0xffffcc4d, 0xffffaa2c, 0xffff7f85,
  0xffff9999, 0xffffaa2b, 0xffff7f84, 0xffff7f84,
  0xffff7777, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xffff4ccf, 0xffff7f82, 0xffff7f82, 0x00007f82,
  0xffff4cce, 0xffff7f81, 0x00007f81, 0x00007f81,
  0xffff4ccd, 0x00007f80, 0x00007f80, 0x000054d8,
  0x00004ccc, 0x00007f7f, 0x000054d7, 0x000032b6,
  0x00004ccb, 0x000054d6, 0x000032b5, 0x00000002,
  0x00002222, 0x000032b4, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffcd4c, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffff93,
  0xfffffffe, 0xfffffffe, 0xffffff92, 0xffffff86,
  0xfffffffd, 0xffffff91, 0xffffff85, 0xffffff85,
  0xffffff90, 0xffffff84, 0xffffff84, 0xffffff84,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffff83,
  0xffffff82, 0xffffff82, 0xffffff82, 0xffffff82,
  0xffffff81, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffffff80, 0xffffff80, 0xffffff80, 0xffffff73,
  0xffffff7f, 0xffffff7f, 0xffffff72, 0xffffff06,
  0xffffff7e, 0xffffff71, 0xffffff05, 0xffffff05,
  0xffffff70, 0xffffff04, 0xffffff04, 0xffffff04,
  0xffffff03, 0xffffff03, 0xffffff03, 0xffffcc50,
  0xffffff02, 0xffffff02, 0xffffcc4f, 0xffffaa2e,
  0xffffff01, 0xffffcc4e, 0xffffaa2d, 0xffff7f86,
  0xffffcc4d, 0xffffaa2c, 0xffff7f85, 0xffff7f85,
  0xffffaa2b, 0xffff7f84, 0xffff7f84, 0xffff7f84,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0x00007f83,
  0xffff7f82, 0xffff7f82, 0x00007f82, 0x00007f82,
  0xffff7f81, 0x00007f81, 0x00007f81, 0x000054d9,
  0x00007f80, 0x00007f80, 0x000054d8, 0x000032b7,
  0x00007f7f, 0x000054d7, 0x000032b6, 0x00000003,
  0x000054d6, 0x000032b5, 0x00000002, 0x00000002,
  0x000032b4, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_ssubl_4S = 576;

#endif  // VIXL_SIM_SSUBL_4S_TRACE_AARCH64_H_
