/*

  VSEARCH: a versatile open source tool for metagenomics

  Copyright (C) 2014-2026, Torbjorn Rognes, Frederic Mahe and Tomas Flouri
  All rights reserved.

  Contact: Torbjorn Rognes <torognes@ifi.uio.no>,
  Department of Informatics, University of Oslo,
  PO Box 1080 Blindern, NO-0316 Oslo, Norway

  This software is dual-licensed and available under a choice
  of one of two licenses, either under the terms of the GNU
  General Public License version 3 or the BSD 2-Clause License.


  GNU General Public License version 3

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  The BSD 2-Clause License

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*/

#include <cstdio>  // std::FILE
#include <cstdint>  // uint64_t


auto fastq_open_rest(fastx_handle input_handle) -> void;
auto fastq_open(const char * filename) -> fastx_handle;
auto fastq_close(fastx_handle input_handle) -> void;
auto fastq_next(fastx_handle input_handle,
                bool truncateatspace,
                const unsigned char * char_mapping) -> bool;
auto fastq_get_position(fastx_handle input_handle) -> uint64_t;
auto fastq_get_size(fastx_handle input_handle) -> uint64_t;
auto fastq_get_lineno(fastx_handle input_handle) -> uint64_t;
auto fastq_get_seqno(fastx_handle input_handle) -> uint64_t;
auto fastq_get_header(fastx_handle input_handle) -> char const *;
auto fastq_get_sequence(fastx_handle input_handle) -> char const *;
auto fastq_get_quality(fastx_handle input_handle) -> char const *;
auto fastq_get_abundance(fastx_handle input_handle) -> int64_t;
auto fastq_get_abundance_and_presence(fastx_handle input_handle) -> int64_t;
auto fastq_get_header_length(fastx_handle input_handle) -> uint64_t;
auto fastq_get_sequence_length(fastx_handle input_handle) -> uint64_t;
auto fastq_get_quality_length(fastx_handle input_handle) -> uint64_t;

auto fastq_print(std::FILE * output_handle, char const * header, char const * sequence, char const * quality) -> void;

auto fastq_print_general(std::FILE * output_handle,
                         char const * seq,
                         int len,
                         char const * header,
                         int header_len,
                         char const * quality,
                         int abundance,
                         int ordinal,
                         double expected_error) -> void;
